/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jp.ossc.nimbus.beans.MethodEditor;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService;
import jp.ossc.nimbus.service.proxy.RemoteServerInvoker;
import jp.ossc.nimbus.service.proxy.RemoteServiceServerServiceMBean;
import jp.ossc.nimbus.service.repository.Repository;

public class RemoteServiceServerService
extends ServiceBase
implements RemoteServiceServerServiceMBean {
    private static final long serialVersionUID = -1165545167180777753L;
    private ServiceName remoteServiceName;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private MethodReflectionCallInvokerService defaultInvoker;
    private ServiceName interceptorChainFactoryServiceName;
    private InterceptorChainFactory interceptorChainFactory;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String jndiName;
    private int rmiPort;

    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    public ServiceName getInterceptorChainListServiceName() {
        return this.interceptorChainListServiceName;
    }

    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    public ServiceName getInvokerServiceName() {
        return this.invokerServiceName;
    }

    public void setInterceptorChainFactoryServiceName(ServiceName name) {
        this.interceptorChainFactoryServiceName = name;
    }

    public ServiceName getInterceptorChainFactoryServiceName() {
        return this.interceptorChainFactoryServiceName;
    }

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public void startService() throws Exception {
        if (this.interceptorChainFactoryServiceName != null) {
            this.interceptorChainFactory = (InterceptorChainFactory)ServiceManagerFactory.getServiceObject(this.interceptorChainFactoryServiceName);
        } else if (this.getInvokerServiceName() == null) {
            if (this.defaultInvoker == null) {
                this.defaultInvoker = new MethodReflectionCallInvokerService();
                this.defaultInvoker.create();
                this.defaultInvoker.start();
            } else {
                this.defaultInvoker.start();
            }
        } else {
            Invoker invoker = (Invoker)ServiceManagerFactory.getServiceObject(this.getInvokerServiceName());
            this.defaultInvoker = null;
        }
        if (this.jndiRepositoryServiceName == null) {
            throw new IllegalArgumentException("jndiRepositoryServiceName must be specified.");
        }
        if (this.jndiName == null && this.remoteServiceName == null) {
            throw new IllegalArgumentException("jndiName or remoteServiceName must be specified.");
        }
        if (this.jndiName == null) {
            this.jndiName = this.remoteServiceName.getServiceManagerName() + '/' + this.remoteServiceName.getServiceName();
        }
        this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        if (!this.jndiRepository.register(this.jndiName, this.interceptorChainFactory == null ? new RemoteServerInvokerImpl(this.interceptorChainListServiceName, this.invokerServiceName, this.defaultInvoker, this.remoteServiceName, this.rmiPort) : new RemoteServerInvokerImpl(this.interceptorChainFactory, this.remoteServiceName, this.rmiPort))) {
            throw new Exception("Could not register in jndiRepository.");
        }
    }

    public void stopService() throws Exception {
        if (this.defaultInvoker != null) {
            this.defaultInvoker.stop();
        }
        this.jndiRepository.unregister(this.jndiName);
    }

    public void destroyService() throws Exception {
        if (this.defaultInvoker != null) {
            this.defaultInvoker.destroy();
            this.defaultInvoker = null;
        }
    }

    public static class RemoteServerInvokerImpl
    extends UnicastRemoteObject
    implements RemoteServerInvoker {
        private static final long serialVersionUID = -2397154705661936441L;
        private final ServiceName interceptorChainListServiceName;
        private final ServiceName invokerServiceName;
        private final Invoker defaultInvoker;
        private final ServiceName remoteServiceName;
        private final InterceptorChainFactory interceptorChainFactory;

        public RemoteServerInvokerImpl(InterceptorChainFactory interceptorChainFactory, ServiceName remoteServiceName, int port) throws RemoteException {
            super(port);
            this.interceptorChainListServiceName = null;
            this.invokerServiceName = null;
            this.defaultInvoker = null;
            this.interceptorChainFactory = interceptorChainFactory;
            this.remoteServiceName = remoteServiceName;
        }

        public RemoteServerInvokerImpl(ServiceName interceptorChainListServiceName, ServiceName invokerServiceName, Invoker defaultInvoker, ServiceName remoteServiceName, int port) throws RemoteException {
            super(port);
            this.interceptorChainListServiceName = interceptorChainListServiceName;
            this.invokerServiceName = invokerServiceName;
            this.defaultInvoker = defaultInvoker;
            this.remoteServiceName = remoteServiceName;
            this.interceptorChainFactory = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(InvocationContext context) throws Exception {
            Object target;
            InterceptorChain chain = null;
            if (this.interceptorChainFactory == null) {
                chain = new DefaultInterceptorChain(this.interceptorChainListServiceName, this.invokerServiceName);
                if (this.invokerServiceName == null && this.defaultInvoker != null) {
                    ((DefaultInterceptorChain)chain).setInvoker(this.defaultInvoker);
                }
            } else {
                Method method;
                StringBuffer key = new StringBuffer();
                target = context.getTargetObject();
                if (target != null) {
                    key.append(target);
                }
                if (context instanceof MethodInvocationContext && (method = ((MethodInvocationContext)context).getTargetMethod()) != null) {
                    MethodEditor editor = new MethodEditor();
                    editor.setValue(method);
                    key.append(':').append(editor.getAsText());
                }
                chain = this.interceptorChainFactory.getInterceptorChain(key.length() == 0 ? null : key.toString());
            }
            ServiceName serviceName = null;
            if (context.getTargetObject() != null && context.getTargetObject() instanceof ServiceName) {
                serviceName = (ServiceName)context.getTargetObject();
                if (this.remoteServiceName != null && !this.remoteServiceName.equals(serviceName)) {
                    throw new IllegalAccessException(serviceName + " don't be allowed access.");
                }
            } else {
                serviceName = this.remoteServiceName;
            }
            if (serviceName != null) {
                context.setTargetObject(ServiceManagerFactory.getServiceObject(serviceName));
                try {
                    chain.setCurrentInterceptorIndex(-1);
                    target = chain.invokeNext(context);
                    return target;
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Object var5_7 = null;
                    return var5_7;
                }
                finally {
                    chain.setCurrentInterceptorIndex(-1);
                }
            }
            throw new ServiceNotFoundException(null);
        }

        public boolean isAlive(ServiceName name) {
            ServiceName serviceName = this.remoteServiceName;
            if (name != null) {
                if (this.remoteServiceName != null && !this.remoteServiceName.equals(name)) {
                    return false;
                }
                serviceName = name;
            }
            if (serviceName == null) {
                return true;
            }
            try {
                Service service = ServiceManagerFactory.getService(serviceName);
                return service != null && service.getState() == 3;
            }
            catch (ServiceNotFoundException e) {
                return false;
            }
        }
    }
}

