/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.scheduler2.DatabaseConditionScheduleMakerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;

public class DatabaseConditionScheduleMakerService
extends DefaultScheduleMakerService
implements DatabaseConditionScheduleMakerServiceMBean {
    private static final long serialVersionUID = -5158949647626532438L;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected String query;
    protected String dateFormat;

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.query == null) {
            throw new IllegalArgumentException("Query is null.");
        }
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    /*
     * Loose catch block
     */
    protected boolean isNecessaryMake(Date date, ScheduleMaster master) throws ScheduleMakeException {
        boolean result;
        block33: {
            SQLException e32;
            ResultSet rs;
            PreparedStatement st;
            Connection con;
            block31: {
                block30: {
                    con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e2) {
                        throw new ScheduleMakeException(e2);
                    }
                    result = false;
                    st = null;
                    rs = null;
                    st = con.prepareStatement(this.query);
                    ParameterMetaData paramData = st.getParameterMetaData();
                    if (paramData == null) {
                        if (this.dateFormat == null) {
                            st.setDate(1, new java.sql.Date(date.getTime()));
                        } else {
                            st.setString(1, new SimpleDateFormat(this.dateFormat).format(date));
                        }
                    } else {
                        for (int i = 0; i < paramData.getParameterCount(); ++i) {
                            if (this.dateFormat == null) {
                                st.setDate(i + 1, new java.sql.Date(date.getTime()));
                                continue;
                            }
                            st.setString(i + 1, new SimpleDateFormat(this.dateFormat).format(date));
                        }
                    }
                    rs = st.executeQuery();
                    if (!rs.next()) {
                        throw new ScheduleMakeException("Size of ResultSet is 0.");
                    }
                    Object ret = rs.getObject(1);
                    if (rs.wasNull()) {
                        throw new ScheduleMakeException("Result value is null.");
                    }
                    if (ret instanceof Boolean) {
                        result = (Boolean)ret;
                        break block30;
                    }
                    if (ret instanceof Number) {
                        result = ((Number)ret).intValue() != 0;
                        break block30;
                    }
                    result = !"0".equals(ret.toString());
                }
                Object var10_12 = null;
                if (st == null) break block31;
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block33;
            {
                catch (SQLException e4) {
                    throw new ScheduleMakeException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var10_13 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }
}

