/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.crypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jp.ossc.nimbus.util.crypt.FalsifiedParameterException;
import jp.ossc.nimbus.util.crypt.OverLimitExpiresException;
import jp.ossc.nimbus.util.crypt.UnexpectedCryptException;

public class CryptParameters {
    public static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyyMMddHHmmssSSSz";
    public static final String DEFAULT_ENCODING = "ISO_8859-1";
    public static final String DEFAULT_TRANSFORMATION = "DES/CBC/PKCS5Padding";
    public static final String DEFAULT_SECRET_KEY_ALGORITHM = "DES";
    public static final int DEFAULT_INITIAL_VECTOR_LENGTH = 8;
    public static final String DEFAULT_HASH_ALGORITHM = "MD5";
    public static final String DATE_KEY = CryptParameters.class.getName().replaceAll("\\.", "/") + "/DATE";
    private String encoding = "ISO_8859-1";
    private String transformation = "DES/CBC/PKCS5Padding";
    private int ivLength = 8;
    private String cryptProviderName;
    private Provider cryptProvider;
    private Key secretKey;
    private String hashAlgorithm = "MD5";
    private String hashProviderName;
    private Provider hashProvider;
    private String hashKey;
    private String dateFormat = "yyyyMMddHHmmssSSSz";
    private final SecureRandom random = new SecureRandom();

    public CryptParameters(byte[] key) throws InvalidKeyException {
        this(key, null);
    }

    public CryptParameters(String storePath, String storeType, String storeProviderName, String storePassword, String alias, String password) throws IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this(storePath, storeType, storeProviderName, storePassword, alias, password, null);
    }

    public CryptParameters(String storePath, String storeType, Provider storeProvider, String storePassword, String alias, String password) throws IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this(storePath, storeType, storeProvider, storePassword, alias, password, null);
    }

    public CryptParameters(Key key) throws InvalidKeyException {
        this(key, null);
    }

    public CryptParameters(byte[] key, String hashKey) throws InvalidKeyException {
        this(new SecretKeySpec(key, DEFAULT_SECRET_KEY_ALGORITHM), hashKey);
    }

    public CryptParameters(String storePath, String storeType, String storeProviderName, String storePassword, String alias, String password, String hashKey) throws IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        Key key = this.loadKey(storePath, storeType, storeProviderName, null, storePassword, alias, password);
        try {
            this.init(key, DEFAULT_TRANSFORMATION, 8, null, null, hashKey);
        }
        catch (NoSuchProviderException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new UnexpectedCryptException(e);
        }
    }

    public CryptParameters(String storePath, String storeType, Provider storeProvider, String storePassword, String alias, String password, String hashKey) throws IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        Key key = this.loadKey(storePath, storeType, null, storeProvider, storePassword, alias, password);
        try {
            this.init(key, DEFAULT_TRANSFORMATION, 8, null, null, hashKey);
        }
        catch (NoSuchProviderException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new UnexpectedCryptException(e);
        }
    }

    public CryptParameters(Key key, String hashKey) throws InvalidKeyException {
        try {
            this.init(key, DEFAULT_TRANSFORMATION, 8, null, null, hashKey);
        }
        catch (NoSuchProviderException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new UnexpectedCryptException(e);
        }
    }

    public CryptParameters(byte[] key, String algorithm, String transformation, int ivLength, String provider, String hashKey) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        this.init(new SecretKeySpec(key, algorithm), transformation, ivLength, provider, null, hashKey);
    }

    public CryptParameters(byte[] key, String algorithm, String transformation, int ivLength, Provider provider, String hashKey) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        this.init(new SecretKeySpec(key, algorithm), transformation, ivLength, null, provider, hashKey);
    }

    public CryptParameters(String storePath, String storeType, String storeProviderName, String storePassword, String alias, String password, String transformation, int ivLength, String provider, String hashKey) throws IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        this.init(this.loadKey(storePath, storeType, storeProviderName, null, storePassword, alias, password), transformation, ivLength, provider, null, hashKey);
    }

    public CryptParameters(String storePath, String storeType, Provider storeProvider, String storePassword, String alias, String password, String transformation, int ivLength, Provider provider, String hashKey) throws IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        this.init(this.loadKey(storePath, storeType, null, storeProvider, storePassword, alias, password), transformation, ivLength, null, provider, hashKey);
    }

    public CryptParameters(Key key, String transformation, int ivLength, String provider, String hashKey) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        this.init(key, transformation, ivLength, provider, null, hashKey);
    }

    public CryptParameters(Key key, String transformation, int ivLength, Provider provider, String hashKey) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        this.init(key, transformation, ivLength, null, provider, hashKey);
    }

    private final Key loadKey(String storePath, String storeType, String storeProviderName, Provider storeProvider, String storePassword, String alias, String password) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        InputStream is = null;
        is = new File(storePath).exists() ? new FileInputStream(storePath) : this.getClass().getResourceAsStream(storePath);
        if (is == null) {
            throw new IOException("KeyStore is not found. path=" + storePath);
        }
        KeyStore store = null;
        store = storeProviderName != null ? KeyStore.getInstance(storeType, storeProviderName) : (storeProvider != null ? KeyStore.getInstance(storeType, storeProvider) : KeyStore.getInstance(storeType));
        store.load(is, storePassword.toCharArray());
        return store.getKey(alias, password.toCharArray());
    }

    private final void init(Key key, String transformation, int ivLength, String providerName, Provider provider, String hashKey) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        this.transformation = transformation;
        this.secretKey = key;
        this.ivLength = ivLength;
        this.cryptProviderName = providerName;
        this.cryptProvider = provider;
        Cipher c = null;
        c = this.cryptProviderName != null ? Cipher.getInstance(transformation, this.cryptProviderName) : (this.cryptProvider != null ? Cipher.getInstance(transformation, this.cryptProvider) : Cipher.getInstance(transformation));
        if (ivLength > 0) {
            IvParameterSpec iv = new IvParameterSpec(this.random.generateSeed(ivLength));
            c.init(1, this.secretKey, iv);
            byte[] encrypt = null;
            try {
                encrypt = c.doFinal("test".getBytes(this.encoding));
            }
            catch (BadPaddingException e) {
                throw new UnexpectedCryptException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new UnexpectedCryptException(e);
            }
            c.init(2, this.secretKey, iv);
            try {
                c.doFinal(encrypt);
            }
            catch (BadPaddingException e) {
                throw new UnexpectedCryptException(e);
            }
        }
        c.init(1, this.secretKey);
        byte[] encrypt = null;
        try {
            encrypt = c.doFinal("test".getBytes(this.encoding));
        }
        catch (BadPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedCryptException(e);
        }
        c.init(2, this.secretKey);
        try {
            c.doFinal(encrypt);
        }
        catch (BadPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        this.setHashKey(hashKey);
    }

    public void setDateFormat(String format) throws IllegalArgumentException {
        new SimpleDateFormat(format);
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        "".getBytes(encoding);
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public void setHashAlgorithm(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest.getInstance(algorithm);
        this.hashAlgorithm = algorithm;
        this.hashProviderName = null;
        this.hashProvider = null;
    }

    public void setHashAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest.getInstance(algorithm, provider);
        this.hashAlgorithm = algorithm;
        this.hashProviderName = provider;
        this.hashProvider = null;
    }

    public void setHashAlgorithm(String algorithm, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest.getInstance(algorithm, provider);
        this.hashAlgorithm = algorithm;
        this.hashProviderName = null;
        this.hashProvider = provider;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashKey(String key) {
        this.hashKey = key;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public Map createParametersMap() {
        LinkedHashMap params = new LinkedHashMap();
        this.createParametersMap(params);
        return params;
    }

    public Map createParametersMap(Map params) {
        params.clear();
        params.put(DATE_KEY, new SimpleDateFormat(this.dateFormat).format(new Date()));
        return params;
    }

    public String createHash(Map params) {
        return this.createHash(CryptParameters.encodeParams(params));
    }

    private String createHash(String params) {
        if (this.hashKey != null) {
            params = this.hashKey + params;
        }
        try {
            MessageDigest digest = null;
            digest = this.hashProviderName != null ? MessageDigest.getInstance(this.hashAlgorithm, this.hashProviderName) : (this.hashProvider != null ? MessageDigest.getInstance(this.hashAlgorithm, this.hashProvider) : MessageDigest.getInstance(this.hashAlgorithm));
            return CryptParameters.toHexString(digest.digest(params.getBytes(this.encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchProviderException e) {
            throw new UnexpectedCryptException(e);
        }
    }

    public String createInitialVector() {
        return CryptParameters.toHexString(this.random.generateSeed(this.ivLength));
    }

    public String encrypt(Map params) {
        return this.encrypt(null, params);
    }

    public String encrypt(String iv, Map params) {
        Cipher c = null;
        try {
            c = this.cryptProviderName != null ? Cipher.getInstance(this.transformation, this.cryptProviderName) : (this.cryptProvider != null ? Cipher.getInstance(this.transformation, this.cryptProvider) : Cipher.getInstance(this.transformation));
            if (iv == null) {
                c.init(1, this.secretKey);
            } else {
                c.init(1, this.secretKey, new IvParameterSpec(CryptParameters.toBytes(iv)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchProviderException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (InvalidKeyException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (FalsifiedParameterException e) {
            throw new UnexpectedCryptException(e);
        }
        byte[] encrypt = null;
        try {
            encrypt = c.doFinal(CryptParameters.encodeParams(params).getBytes(this.encoding));
        }
        catch (BadPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new UnexpectedCryptException(e);
        }
        return CryptParameters.toHexString(encrypt);
    }

    public Map decrypt(String params) throws FalsifiedParameterException {
        return this.decrypt(null, params, null);
    }

    public Map decrypt(String iv, String params) throws FalsifiedParameterException {
        return this.decrypt(iv, params, null);
    }

    public Map decrypt(String params, long expires) throws OverLimitExpiresException, FalsifiedParameterException {
        return this.decrypt(null, params, null, expires, false);
    }

    public Map decrypt(String iv, String params, long expires) throws OverLimitExpiresException, FalsifiedParameterException {
        return this.decrypt(iv, params, null, expires, false);
    }

    public Map decrypt(String iv, String params, String hash) throws FalsifiedParameterException {
        try {
            return this.decrypt(iv, params, hash, -1L);
        }
        catch (OverLimitExpiresException e) {
            throw new UnexpectedCryptException(e);
        }
    }

    public Map decrypt(String iv, String params, String hash, long expires) throws FalsifiedParameterException, OverLimitExpiresException {
        return this.decrypt(iv, params, hash, expires, true);
    }

    private Map decrypt(String iv, String params, String hash, long expires, boolean isAlterated) throws FalsifiedParameterException, OverLimitExpiresException {
        if (isAlterated && hash == null) {
            throw new FalsifiedParameterException();
        }
        Cipher c = null;
        try {
            c = this.cryptProviderName != null ? Cipher.getInstance(this.transformation, this.cryptProviderName) : (this.cryptProvider != null ? Cipher.getInstance(this.transformation, this.cryptProvider) : Cipher.getInstance(this.transformation));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (NoSuchProviderException e) {
            throw new UnexpectedCryptException(e);
        }
        try {
            if (iv == null) {
                c.init(2, this.secretKey);
            } else {
                c.init(2, this.secretKey, new IvParameterSpec(CryptParameters.toBytes(iv)));
            }
        }
        catch (InvalidKeyException e) {
            throw new UnexpectedCryptException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new FalsifiedParameterException(e);
        }
        byte[] decrypt = null;
        try {
            decrypt = c.doFinal(CryptParameters.toBytes(params));
        }
        catch (BadPaddingException e) {
            throw new FalsifiedParameterException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new FalsifiedParameterException(e);
        }
        String decryptStr = null;
        try {
            decryptStr = new String(decrypt, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedCryptException(e);
        }
        if (isAlterated && hash != null && !hash.equals(this.createHash(decryptStr))) {
            throw new FalsifiedParameterException();
        }
        Map result = CryptParameters.decodeParams(decryptStr);
        if (result.containsKey(DATE_KEY) && expires > 0L) {
            String dateStr = (String)result.get(DATE_KEY);
            Date date = null;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            try {
                date = format.parse(dateStr);
            }
            catch (ParseException e) {
                throw new FalsifiedParameterException(e);
            }
            if (date != null) {
                Calendar inCalendar = Calendar.getInstance();
                inCalendar.setTimeInMillis(date.getTime() + expires);
                Calendar nowCalendar = Calendar.getInstance();
                nowCalendar.setTimeInMillis(System.currentTimeMillis());
                if (nowCalendar.after(inCalendar)) {
                    throw new OverLimitExpiresException();
                }
            }
        }
        return result;
    }

    private static String encodeParams(Map params) {
        StringBuffer buf = new StringBuffer();
        Iterator keys = params.keySet().iterator();
        while (keys.hasNext()) {
            String k = keys.next().toString();
            Object val = params.get(k);
            if (val == null) continue;
            buf.append(CryptParameters.escape(k)).append('=').append(CryptParameters.escape(val.toString()));
            if (!keys.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private static String escape(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.indexOf(92) == -1 && str.indexOf(61) == -1 && str.indexOf(44) == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int max = str.length();
        block3: for (int i = 0; i < max; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ',': 
                case '=': 
                case '\\': {
                    buf.append('\\').append(c);
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private static Map decodeParams(String str) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (str == null || str.length() == 0) {
            return params;
        }
        StringBuffer buf = new StringBuffer();
        String key = null;
        boolean isEscape = false;
        int max = str.length();
        block5: for (int i = 0; i < max; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (isEscape) {
                        buf.append(c);
                        isEscape = false;
                        continue block5;
                    }
                    isEscape = true;
                    continue block5;
                }
                case '=': {
                    if (isEscape) {
                        buf.append(c);
                        isEscape = false;
                        continue block5;
                    }
                    key = buf.toString();
                    buf.setLength(0);
                    continue block5;
                }
                case ',': {
                    if (isEscape) {
                        buf.append(c);
                        isEscape = false;
                        continue block5;
                    }
                    String val = buf.toString();
                    buf.setLength(0);
                    if (key == null) continue block5;
                    params.put(key, val);
                    key = null;
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (key != null) {
            String val = buf.toString();
            params.put(key, val);
        }
        return params;
    }

    private static String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int max = bytes.length;
        for (int i = 0; i < max; ++i) {
            int intValue = bytes[i];
            String str = Integer.toHexString(intValue &= 0xFF).toUpperCase();
            if (str.length() == 1) {
                buf.append('0');
            }
            buf.append(str);
        }
        return buf.toString();
    }

    private static byte[] toBytes(String hex) throws FalsifiedParameterException {
        if (hex.length() % 2 != 0) {
            throw new FalsifiedParameterException();
        }
        byte[] bytes = new byte[hex.length() / 2];
        int max = hex.length();
        for (int i = 0; i < max; i += 2) {
            bytes[i / 2] = (byte)(Integer.parseInt(hex.substring(i, i + 2), 16) & 0xFF);
        }
        return bytes;
    }
}

