/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;

public class LongEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -7832580639766790513L;

    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(new Long(LongEditor.toLong(text, true)));
    }

    public static final long toLong(String text, boolean replace) throws NumberFormatException {
        String str = replace ? Utility.replaceSystemProperty(text) : text;
        long longValue = 0L;
        try {
            longValue = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            if ("MAX_VALUE".equals(str)) {
                longValue = Long.MAX_VALUE;
            }
            if ("MIN_VALUE".equals(str)) {
                longValue = Long.MIN_VALUE;
            }
            throw e;
        }
        return longValue;
    }

    public String getAsText() {
        Long val = (Long)this.getValue();
        return val == null ? null : val.toString();
    }
}

