/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.IfDefMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.PropertyEditorMetaData;
import org.w3c.dom.Element;

public class PropertyEditorsMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = -5406841425716158865L;
    public static final String PROPERTY_EDITORS_TAG_NAME = "property-editors";
    private final Map propertyEditors = new LinkedHashMap();
    private List ifDefMetaDataList;

    public PropertyEditorsMetaData(MetaData parent) {
        super(parent);
    }

    public String getPropertyEditor(String type) {
        PropertyEditorMetaData propData = (PropertyEditorMetaData)this.propertyEditors.get(type);
        return propData == null ? null : propData.getEditor();
    }

    public void setPropertyEditor(String type, String editor) {
        PropertyEditorMetaData propData = (PropertyEditorMetaData)this.propertyEditors.get(type);
        if (propData != null) {
            propData.setEditor(editor);
        } else {
            propData = new PropertyEditorMetaData(this);
            propData.setType(type);
            propData.setEditor(editor);
            this.propertyEditors.put(type, propData);
        }
    }

    public void removePropertyEditor(String type) {
        this.propertyEditors.remove(type);
    }

    public void clearPropertyEditors() {
        this.propertyEditors.clear();
    }

    public PropertyEditorMetaData getPropertyEditorMetaData(String type) {
        return (PropertyEditorMetaData)this.propertyEditors.get(type);
    }

    public void setPropertyEditorMetaData(PropertyEditorMetaData propEditorData) {
        this.propertyEditors.put(propEditorData.getType(), propEditorData);
    }

    public Set getPropertyEditorTypes() {
        return this.propertyEditors.keySet();
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(PROPERTY_EDITORS_TAG_NAME)) {
            throw new DeploymentException("Tag must be property-editors : " + element.getTagName());
        }
        this.importXMLInner(element, null);
        Iterator ifDefElements = PropertyEditorsMetaData.getChildrenByTagName(element, "ifdef");
        while (ifDefElements.hasNext()) {
            if (this.ifDefMetaDataList == null) {
                this.ifDefMetaDataList = new ArrayList();
            }
            IfDefMetaData ifdefData = new IfDefMetaData(this);
            ifdefData.importXML((Element)ifDefElements.next());
            this.ifDefMetaDataList.add(ifdefData);
        }
        if (this.ifDefMetaDataList == null || this.ifDefMetaDataList.size() == 0) {
            return;
        }
        int imax = this.ifDefMetaDataList.size();
        for (int i = 0; i < imax; ++i) {
            IfDefMetaData ifdefData = (IfDefMetaData)this.ifDefMetaDataList.get(i);
            Element ifDefElement = ifdefData.getElement();
            if (ifDefElement == null) continue;
            this.importXMLInner(ifDefElement, ifdefData);
            ifdefData.setElement(null);
        }
    }

    protected void importXMLInner(Element element, IfDefMetaData ifdefData) throws DeploymentException {
        boolean ifdefMatch = ifdefData == null ? true : ifdefData.isMatch();
        Iterator editorElements = PropertyEditorsMetaData.getChildrenByTagName(element, "property-editor");
        while (editorElements.hasNext()) {
            PropertyEditorMetaData propData = new PropertyEditorMetaData(this);
            if (ifdefData != null) {
                propData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(propData);
            }
            propData.importXML((Element)editorElements.next());
            if (!ifdefMatch) continue;
            this.setPropertyEditorMetaData(propData);
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append(LINE_SEPARATOR);
        buf.append('<').append(PROPERTY_EDITORS_TAG_NAME).append('>');
        buf.append(LINE_SEPARATOR);
        StringBuffer subBuf = new StringBuffer();
        Iterator propDatas = this.propertyEditors.values().iterator();
        while (propDatas.hasNext()) {
            PropertyEditorMetaData propData = (PropertyEditorMetaData)propDatas.next();
            if (propData.getIfDefMetaData() != null) continue;
            propData.toXML(subBuf);
            subBuf.append(LINE_SEPARATOR);
        }
        buf.append(this.addIndent(subBuf));
        if (this.ifDefMetaDataList != null && this.ifDefMetaDataList.size() != 0) {
            int imax = this.ifDefMetaDataList.size();
            for (int i = 0; i < imax; ++i) {
                IfDefMetaData ifdefData = (IfDefMetaData)this.ifDefMetaDataList.get(i);
                buf.append(this.addIndent(ifdefData.toXML(new StringBuffer())));
                if (i == imax - 1) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append("</").append(PROPERTY_EDITORS_TAG_NAME).append('>');
        return buf;
    }
}

