/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.CharBuffer;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class UnicodeHexBufferedReader
extends BufferedReader
implements StringConverter,
ReversibleConverter {
    public static final int UNICODE_TO_STRING = 1;
    public static final int STRING_TO_UNICODE = 2;
    private int convertType = 1;
    private ReaderWrapper readerWrapper = (ReaderWrapper)this.lock;
    static /* synthetic */ Class class$java$nio$CharBuffer;
    static /* synthetic */ Class class$java$io$Reader;

    public UnicodeHexBufferedReader() {
        super(new ReaderWrapper());
    }

    public UnicodeHexBufferedReader(Reader reader) {
        super(new ReaderWrapper(reader));
    }

    public UnicodeHexBufferedReader(Reader reader, int size) {
        super(new ReaderWrapper(reader), size);
    }

    public void setReader(Reader reader) throws IOException {
        this.readerWrapper.setReader(reader);
    }

    public String readLine() throws IOException {
        String str = super.readLine();
        if (str != null) {
            str = UnicodeHexBufferedReader.convertString(str);
        }
        return str;
    }

    public String readLineInverse() throws IOException {
        String str = super.readLine();
        if (str != null) {
            str = UnicodeHexBufferedReader.convertUnicode(str);
        }
        return str;
    }

    public static String convertUnicode(String unicodeStr) {
        String str = null;
        if (unicodeStr != null) {
            int len = unicodeStr.length();
            StringBuffer buf = new StringBuffer(len * 6);
            for (int i = 0; i < len; ++i) {
                UnicodeHexBufferedReader.convertUnicode(unicodeStr.charAt(i), buf);
            }
            str = buf.toString();
        }
        return str;
    }

    public static String convertUnicode(char unicodeChar) {
        return UnicodeHexBufferedReader.convertUnicode(unicodeChar, new StringBuffer(6)).toString();
    }

    public static StringBuffer convertUnicode(char unicodeChar, StringBuffer buf) {
        char c = unicodeChar;
        buf.append('\\');
        buf.append('u');
        int mask = 61440;
        int ret = 0;
        block18: for (int j = 0; j < 4; ++j) {
            mask = 61440 >> j * 4;
            ret = c & mask;
            switch (ret <<= j * 4) {
                case 0: {
                    buf.append('0');
                    continue block18;
                }
                case 4096: {
                    buf.append('1');
                    continue block18;
                }
                case 8192: {
                    buf.append('2');
                    continue block18;
                }
                case 12288: {
                    buf.append('3');
                    continue block18;
                }
                case 16384: {
                    buf.append('4');
                    continue block18;
                }
                case 20480: {
                    buf.append('5');
                    continue block18;
                }
                case 24576: {
                    buf.append('6');
                    continue block18;
                }
                case 28672: {
                    buf.append('7');
                    continue block18;
                }
                case 32768: {
                    buf.append('8');
                    continue block18;
                }
                case 36864: {
                    buf.append('9');
                    continue block18;
                }
                case 40960: {
                    buf.append('a');
                    continue block18;
                }
                case 45056: {
                    buf.append('b');
                    continue block18;
                }
                case 49152: {
                    buf.append('c');
                    continue block18;
                }
                case 53248: {
                    buf.append('d');
                    continue block18;
                }
                case 57344: {
                    buf.append('e');
                    continue block18;
                }
                case 61440: {
                    buf.append('f');
                    continue block18;
                }
            }
        }
        return buf;
    }

    public static String convertString(String unicodeAry) {
        String str = null;
        if (unicodeAry != null) {
            int len = unicodeAry.length();
            StringBuffer buf = new StringBuffer(len);
            int i = 0;
            while (i < len) {
                char c;
                if ((c = unicodeAry.charAt(i++)) == '\\' && len - 1 > i) {
                    if ((c = unicodeAry.charAt(i++)) == 'u') {
                        int value = 0;
                        block13: for (int j = 0; j < 4; ++j) {
                            c = unicodeAry.charAt(i++);
                            switch (c) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    value = (value << 4) + (c - 48);
                                    continue block13;
                                }
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    value = (value << 4) + 10 + (c - 97);
                                    continue block13;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': {
                                    value = (value << 4) + 10 + (c - 65);
                                    continue block13;
                                }
                                default: {
                                    throw new IllegalArgumentException("Failed to convert unicode char is " + c);
                                }
                            }
                        }
                        buf.append((char)value);
                        continue;
                    }
                    switch (c) {
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                    }
                    buf.append(c);
                    continue;
                }
                buf.append(c);
            }
            str = buf.toString();
        }
        return str;
    }

    public Object convert(Object obj) throws ConvertException {
        return this.convert(obj == null ? null : obj.toString());
    }

    public String convert(String str) throws ConvertException {
        switch (this.convertType) {
            case 2: {
                return UnicodeHexBufferedReader.convertUnicode(str);
            }
        }
        return UnicodeHexBufferedReader.convertString(str);
    }

    public void setConvertType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                this.convertType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid convert type : " + type);
            }
        }
    }

    public int getConvertType() {
        return this.convertType;
    }

    private static class ReaderWrapper
    extends Reader {
        private Reader realReader;
        private static Method READ_CHARBUFFER_METHOD = null;

        public ReaderWrapper() {
        }

        public ReaderWrapper(Reader reader) {
            this.realReader = reader;
        }

        public Reader getReader() {
            return this.realReader;
        }

        public void setReader(Reader reader) throws IOException {
            if (this.realReader != null) {
                throw new IOException("Reader is already commited.");
            }
            this.realReader = reader;
        }

        public int read(CharBuffer target) throws IOException {
            if (READ_CHARBUFFER_METHOD == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            if (this.realReader == null) {
                return -1;
            }
            try {
                return (Integer)READ_CHARBUFFER_METHOD.invoke((Object)this.realReader, target);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        public int read() throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read();
        }

        public int read(char[] cbuf) throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read(cbuf);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read(cbuf, off, len);
        }

        public long skip(long n) throws IOException {
            if (this.realReader == null) {
                return 0L;
            }
            return this.realReader.skip(n);
        }

        public boolean ready() throws IOException {
            if (this.realReader == null) {
                return false;
            }
            return this.realReader.ready();
        }

        public boolean markSupported() {
            if (this.realReader == null) {
                return false;
            }
            return this.realReader.markSupported();
        }

        public void mark(int readAheadLimit) throws IOException {
            if (this.realReader == null) {
                throw new IOException("Reader is null.");
            }
            this.realReader.mark(readAheadLimit);
        }

        public void reset() throws IOException {
            if (this.realReader != null) {
                this.realReader.reset();
            }
        }

        public void close() throws IOException {
            if (this.realReader != null) {
                this.realReader.close();
            }
        }

        static {
            try {
                READ_CHARBUFFER_METHOD = (class$java$io$Reader == null ? (class$java$io$Reader = UnicodeHexBufferedReader.class$("java.io.Reader")) : class$java$io$Reader).getMethod("read", class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = UnicodeHexBufferedReader.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

