/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.interceptor.servlet.AuthenticateStore;
import jp.ossc.nimbus.service.aop.interceptor.servlet.AuthenticateStoreException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.DatabaseAuthenticateStoreServiceMBean;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.PersistentException;
import jp.ossc.nimbus.service.connection.PersistentManager;

public class DatabaseAuthenticateStoreService
extends ServiceBase
implements AuthenticateStore,
DatabaseAuthenticateStoreServiceMBean {
    private static final long serialVersionUID = 1001424917332828547L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private ServiceName persistentManagerServiceName;
    private PersistentManager persistentManager;
    private Class authenticatedInfoClass;
    private Object authenticatedInfoTemplate;
    private String hostName;
    private String selectQueryOnCreateUser;
    private String selectQueryOnFindUser;
    private String insertQuery;
    private String updateQueryOnCreate;
    private String updateQueryOnActivate;
    private String updateQueryOnDeactivate;
    private String deleteQuery;

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    public void setAuthenticatedInfoClass(Class clazz) {
        this.authenticatedInfoClass = clazz;
    }

    public Class getAuthenticatedInfoClass() {
        return this.authenticatedInfoClass;
    }

    public void setAuthenticatedInfoTemplate(Object template) {
        this.authenticatedInfoTemplate = template;
    }

    public Object getAuthenticatedInfoTemplate() {
        return this.authenticatedInfoTemplate;
    }

    public void setHostName(String name) {
        this.hostName = name;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setSelectQueryOnCreateUser(String query) {
        this.selectQueryOnCreateUser = query;
    }

    public String getSelectQueryOnCreateUser() {
        return this.selectQueryOnCreateUser;
    }

    public void setSelectQueryOnFindUser(String query) {
        this.selectQueryOnFindUser = query;
    }

    public String getSelectQueryOnFindUser() {
        return this.selectQueryOnFindUser;
    }

    public void setInsertQuery(String query) {
        this.insertQuery = query;
    }

    public String getInsertQuery() {
        return this.insertQuery;
    }

    public void setUpdateQueryOnCreate(String query) {
        this.updateQueryOnCreate = query;
    }

    public String getUpdateQueryOnCreate() {
        return this.updateQueryOnCreate;
    }

    public void setUpdateQueryOnActivate(String query) {
        this.updateQueryOnActivate = query;
    }

    public String getUpdateQueryOnActivate() {
        return this.updateQueryOnActivate;
    }

    public void setUpdateQueryOnDeactivate(String query) {
        this.updateQueryOnDeactivate = query;
    }

    public String getUpdateQueryOnDeactivate() {
        return this.updateQueryOnDeactivate;
    }

    public void setDeleteQuery(String query) {
        this.deleteQuery = query;
    }

    public String getDeleteQuery() {
        return this.deleteQuery;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setPersistentManager(PersistentManager manager) {
        this.persistentManager = manager;
    }

    public PersistentManager getPersistentManager() {
        return this.persistentManager;
    }

    public void startService() throws Exception {
        if (this.connectionFactory == null && this.connectionFactoryServiceName == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.persistentManager == null && this.persistentManagerServiceName == null) {
            throw new IllegalArgumentException("PersistentManager is null.");
        }
        if (this.persistentManagerServiceName != null) {
            this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
        }
        if (this.hostName == null) {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
    }

    protected Object createInput(HttpServletRequest request, HttpSession session, Object auth) {
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("Timestamp", new Timestamp(System.currentTimeMillis()));
        if (session == null && request != null) {
            session = request.getSession(false);
        }
        if (session != null) {
            input.put("SessionId", session.getId());
        }
        if (this.hostName != null) {
            input.put("Host", this.hostName);
        }
        input.put("Auth", auth);
        return input;
    }

    public void create(HttpServletRequest request, Object authenticatedInfo) throws AuthenticateStoreException {
        if (this.insertQuery == null) {
            return;
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new AuthenticateStoreException(e);
        }
        try {
            List list;
            boolean isUpdate = false;
            Object input = this.createInput(request, null, authenticatedInfo);
            if (this.selectQueryOnCreateUser != null && ((list = (List)this.persistentManager.loadQuery(con, this.selectQueryOnCreateUser, input, null)).size() == 0 || list.get(0) instanceof Number && ((Number)list.get(0)).intValue() <= 0 || list.get(0) instanceof Boolean && (Boolean)list.get(0) == false || list.get(0) instanceof String && !((String)list.get(0)).equals("0"))) {
                throw new AuthenticateStoreException("Already exists." + authenticatedInfo);
            }
            if (this.selectQueryOnFindUser != null) {
                list = (List)this.persistentManager.loadQuery(con, this.selectQueryOnFindUser, input, null);
                boolean bl = isUpdate = this.updateQueryOnCreate != null && list != null && list.size() != 0;
            }
            if (isUpdate) {
                this.persistentManager.persistQuery(con, this.updateQueryOnCreate, input);
            } else {
                this.persistentManager.persistQuery(con, this.insertQuery, input);
            }
        }
        catch (PersistentException e) {
            throw new AuthenticateStoreException(e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {}
        }
    }

    public Object activate(HttpServletRequest request, Object authenticatedKey) throws AuthenticateStoreException {
        DataSet dataSet;
        if (this.selectQueryOnFindUser == null) {
            return null;
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new AuthenticateStoreException(e);
        }
        try {
            Object authenticatedInfo = null;
            if (this.selectQueryOnFindUser != null) {
                if (this.authenticatedInfoClass != null) {
                    List list = (List)this.persistentManager.loadQuery(con, this.selectQueryOnFindUser, this.createInput(request, null, authenticatedKey), this.authenticatedInfoClass);
                    if (list.size() == 0) {
                        Object var6_11 = null;
                        return var6_11;
                    }
                    authenticatedInfo = list.get(0);
                } else {
                    if (this.authenticatedInfoTemplate instanceof DataSet) {
                        authenticatedInfo = ((DataSet)this.authenticatedInfoTemplate).cloneSchema();
                    } else if (this.authenticatedInfoTemplate instanceof RecordList) {
                        authenticatedInfo = ((RecordList)this.authenticatedInfoTemplate).cloneSchema();
                    } else if (this.authenticatedInfoTemplate instanceof Record) {
                        authenticatedInfo = ((Record)this.authenticatedInfoTemplate).cloneSchema();
                    } else if (this.authenticatedInfoTemplate instanceof Cloneable) {
                        try {
                            authenticatedInfo = this.authenticatedInfoTemplate.getClass().getMethod("clone", null).invoke(this.authenticatedInfoTemplate, (Object[])null);
                        }
                        catch (NoSuchMethodException e) {
                            throw new AuthenticateStoreException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new AuthenticateStoreException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new AuthenticateStoreException(e);
                        }
                    }
                    authenticatedInfo = this.persistentManager.loadQuery(con, this.selectQueryOnFindUser, this.createInput(request, null, authenticatedKey), authenticatedInfo);
                }
            }
            if (authenticatedInfo != null && this.updateQueryOnActivate != null) {
                if (request.getSession(false) == null) {
                    request.getSession(true);
                }
                this.persistentManager.persistQuery(con, this.updateQueryOnActivate, this.createInput(request, null, authenticatedInfo));
            }
            dataSet = authenticatedInfo;
        }
        catch (PersistentException e) {
            throw new AuthenticateStoreException(e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {}
        }
        return dataSet;
    }

    public void deactivate(HttpSession session, Object authenticatedInfo) throws AuthenticateStoreException {
        if (this.updateQueryOnDeactivate == null) {
            return;
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new AuthenticateStoreException(e);
        }
        try {
            this.persistentManager.persistQuery(con, this.updateQueryOnDeactivate, this.createInput(null, session, authenticatedInfo));
        }
        catch (PersistentException e) {
            throw new AuthenticateStoreException(e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {}
        }
    }

    public void destroy(HttpServletRequest request, Object authenticatedKey) throws AuthenticateStoreException {
        if (this.deleteQuery == null) {
            return;
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new AuthenticateStoreException(e);
        }
        try {
            this.persistentManager.persistQuery(con, this.deleteQuery, this.createInput(request, null, authenticatedKey));
        }
        catch (PersistentException e) {
            throw new AuthenticateStoreException(e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {}
        }
    }
}

