/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.context.DatabaseSharedContextKeyDistributorServiceMBean;
import jp.ossc.nimbus.service.context.SharedContextKeyDistributor;

public class DatabaseSharedContextKeyDistributorService
extends ServiceBase
implements SharedContextKeyDistributor,
DatabaseSharedContextKeyDistributorServiceMBean {
    private static final long serialVersionUID = 1L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private ServiceName persistentManagerServiceName;
    private PersistentManager persistentManager;
    private String keySelectQuery;
    private Record databaseRecord;
    private String keyPropertyName;
    private Class keyClass;
    private Map keyPropertyMappings;
    private Map keyIndexMap;

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    public void setKeySelectQuery(String query) {
        this.keySelectQuery = query;
    }

    public String getKeySelectQuery() {
        return this.keySelectQuery;
    }

    public void setDatabaseRecord(Record record) {
        this.databaseRecord = record;
    }

    public Record getDatabaseRecord() {
        return this.databaseRecord;
    }

    public void setKeyPropertyName(String name) {
        this.keyPropertyName = name;
    }

    public String getKeyPropertyName() {
        return this.keyPropertyName;
    }

    public void setKeyClass(Class clazz) {
        this.keyClass = clazz;
    }

    public Class getKeyClass() {
        return this.keyClass;
    }

    public void setKeyPropertyMapping(String getProperty, String setProperty) {
        if (this.keyPropertyMappings == null) {
            this.keyPropertyMappings = new HashMap();
        }
        this.keyPropertyMappings.put(getProperty, setProperty);
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setPersistentManager(PersistentManager pm) {
        this.persistentManager = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.persistentManagerServiceName != null) {
            this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
        }
        if (this.persistentManager == null) {
            throw new IllegalArgumentException("PersistentManager is null.");
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
            RecordList keyList = null;
            if (this.databaseRecord == null) {
                if (this.keyClass == null) {
                    keyList = new RecordList();
                }
            } else {
                keyList = new RecordList(null, this.databaseRecord.getRecordSchema());
            }
            Object[] keys = null;
            if (keyList == null) {
                keys = (Object[])this.persistentManager.loadQuery(con, this.keySelectQuery, null, Array.newInstance(this.keyClass, 0).getClass());
            } else {
                this.persistentManager.loadQuery(con, this.keySelectQuery, null, keyList);
                keys = keyList.toArray();
            }
            if (keys == null || keys.length == 0) {
                throw new IllegalArgumentException("Not found key record. keySelectQuery=" + this.keySelectQuery);
            }
            HashMap<Object, Integer> tmpKeyIndexMap = new HashMap<Object, Integer>();
            if (keyList == null) {
                for (int i = 0; i < keys.length; ++i) {
                    tmpKeyIndexMap.put(keys[i], new Integer(i));
                }
            } else {
                PropertyAccess propertyAccess = new PropertyAccess();
                for (int i = 0; i < keys.length; ++i) {
                    Object key = null;
                    if (this.keyClass == null) {
                        key = propertyAccess.get(keys[i], this.keyPropertyName);
                    } else {
                        key = this.keyClass.newInstance();
                        Iterator itr = this.keyPropertyMappings.entrySet().iterator();
                        while (itr.hasNext()) {
                            Map.Entry propMapping = itr.next();
                            propertyAccess.set(key, (String)propMapping.getValue(), propertyAccess.get(keys[i], (String)propMapping.getKey()));
                        }
                    }
                    tmpKeyIndexMap.put(key, new Integer(i));
                }
            }
            this.keyIndexMap = tmpKeyIndexMap;
            Object var11_11 = null;
            if (con == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (con == null) throw throwable;
            try {
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            con.close();
            return;
        }
        catch (SQLException e) {}
    }

    public int selectDataNodeIndex(Object key, int distributedSize) {
        Integer index = (Integer)this.keyIndexMap.get(key);
        if (index == null) {
            return 0;
        }
        return Math.min(index / (this.keyIndexMap.size() / distributedSize), distributedSize - 1);
    }
}

