/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.converter;

import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.service.converter.CodeMasterConverter;
import jp.ossc.nimbus.util.converter.ConvertException;

public class RecordListCodeMasterConverter
implements CodeMasterConverter {
    protected String valueFieldName;
    protected Object notFoundObject;
    protected boolean isThrowOnNotFound;
    protected Object nullKeyObject;
    protected boolean isThrowOnNullKey;

    public void setValueFieldName(String name) {
        this.valueFieldName = name;
    }

    public String getValueFieldName() {
        return this.valueFieldName;
    }

    public void setNotFoundObject(Object obj) {
        this.notFoundObject = obj;
    }

    public Object getNotFoundObject() {
        return this.notFoundObject;
    }

    public boolean isThrowOnNotFound() {
        return this.isThrowOnNotFound;
    }

    public void setThrowOnNotFound(boolean isThrow) {
        this.isThrowOnNotFound = isThrow;
    }

    public void setNullKeyObject(Object obj) {
        this.nullKeyObject = obj;
    }

    public Object getNullKeyObject() {
        return this.nullKeyObject;
    }

    public boolean isThrowOnNullKey() {
        return this.isThrowOnNullKey;
    }

    public void setThrowOnNullKey(boolean isThrow) {
        this.isThrowOnNullKey = isThrow;
    }

    public Object convert(Object master, Object obj) throws ConvertException {
        if (!(master instanceof RecordList)) {
            throw new ConvertException("CodeMaster is not RecordList!");
        }
        RecordList recList = (RecordList)master;
        Record record = null;
        try {
            if (obj instanceof DynamicCondition) {
                DynamicCondition cnd = (DynamicCondition)obj;
                RecordList list = recList.stockSearch(cnd.conditionName);
                Iterator itr = list.iterator();
                if (itr.hasNext()) {
                    record = (Record)itr.next();
                }
            } else if (obj instanceof DynamicConditionReal) {
                DynamicConditionReal cnd = (DynamicConditionReal)obj;
                if (cnd.condition == null) {
                    throw new ConvertException("DynamicConditionReal.condition is null.");
                }
                RecordList list = recList.realSearch(cnd.condition, cnd.valueMap);
                list.sort(cnd.orderBy, cnd.isAsc);
                Iterator itr = list.iterator();
                if (itr.hasNext()) {
                    record = (Record)itr.next();
                }
            } else if (obj instanceof DynamicKey) {
                Record[] array;
                DynamicKey cnd = (DynamicKey)obj;
                Record key = null;
                if (cnd.keyMap != null) {
                    if (cnd.keyMap.size() == 0) {
                        if (this.isThrowOnNullKey) {
                            throw new ConvertException("DynamicKey.keyMap is empty.");
                        }
                        return this.nullKeyObject;
                    }
                    key = recList.createRecord();
                    Iterator entries = cnd.keyMap.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        String propName = (String)entry.getKey();
                        Object propValue = entry.getValue();
                        int index = recList.getRecordSchema().getPropertyIndex(propName);
                        if (index == -1) {
                            throw new ConvertException("Property '" + propName + "' is not found.");
                        }
                        key.setProperty(index, propValue);
                    }
                } else {
                    if (cnd.keyRecord == null) {
                        if (this.isThrowOnNullKey) {
                            throw new ConvertException("DynamicKey.keyRecord is null.");
                        }
                        return this.nullKeyObject;
                    }
                    key = cnd.keyRecord;
                }
                if ((array = recList.stockKeySearch(cnd.conditionName, key)) != null && array.length > 0) {
                    RecordList.sort(array, cnd.orderBy, cnd.isAsc);
                    record = array[0];
                }
            } else if (obj instanceof Key) {
                Key cnd = (Key)obj;
                if (cnd.key != null) {
                    PropertySchema[] schemata = recList.getRecordSchema().getPrimaryKeyPropertySchemata();
                    if (schemata == null || schemata.length != 1) {
                        throw new ConvertException("Size of primary key property not equal 1.");
                    }
                    Record key = recList.createRecord();
                    key.setProperty(schemata[0].getName(), cnd.key);
                    record = recList.primaryKeySearch(key);
                } else {
                    Record key = null;
                    if (cnd.keyMap != null) {
                        if (cnd.keyMap.size() == 0) {
                            if (this.isThrowOnNullKey) {
                                throw new ConvertException("Key.keyMap is empty.");
                            }
                            return this.nullKeyObject;
                        }
                        key = recList.createRecord();
                        Iterator entries = cnd.keyMap.entrySet().iterator();
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            String propName = (String)entry.getKey();
                            Object propValue = entry.getValue();
                            int index = recList.getRecordSchema().getPropertyIndex(propName);
                            if (index == -1) {
                                throw new ConvertException("Property '" + propName + "' is not found.");
                            }
                            key.setProperty(index, propValue);
                        }
                    } else {
                        if (cnd.keyRecord == null) {
                            if (this.isThrowOnNullKey) {
                                throw new ConvertException("Key.keyRecord is null.");
                            }
                            return this.nullKeyObject;
                        }
                        key = cnd.keyRecord;
                    }
                    record = recList.primaryKeySearch(key);
                }
            } else {
                if (obj == null) {
                    if (this.isThrowOnNullKey) {
                        throw new ConvertException("Key is null.");
                    }
                    return this.nullKeyObject;
                }
                if (obj instanceof Record) {
                    record = recList.primaryKeySearch((Record)obj);
                } else {
                    PropertySchema[] schemata = recList.getRecordSchema().getPrimaryKeyPropertySchemata();
                    if (schemata == null || schemata.length != 1) {
                        throw new ConvertException("Size of primary key property not equal 1.");
                    }
                    Record key = recList.createRecord();
                    key.setProperty(schemata[0].getName(), obj);
                    record = recList.primaryKeySearch(key);
                }
            }
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
        if (record == null) {
            if (this.isThrowOnNotFound) {
                throw new ConvertException("Record is not found. key=" + obj);
            }
            return this.notFoundObject;
        }
        return this.valueFieldName == null ? record : record.get(this.valueFieldName);
    }

    public static class Key {
        public Object key;
        public Map keyMap;
        public Record keyRecord;

        public String toString() {
            StringBuffer buf = new StringBuffer("Key{");
            buf.append("key=").append(this.key);
            buf.append(", keyMap=").append(this.keyMap);
            buf.append(", keyRecord=");
            if (this.keyRecord == null) {
                buf.append(this.keyRecord);
            } else {
                buf.append('{');
                for (int i = 0; i < this.keyRecord.size(); ++i) {
                    buf.append(this.keyRecord.getRecordSchema().getPropertyName(i)).append('=').append(this.keyRecord.getProperty(i));
                    if (i == this.keyRecord.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append('}');
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class DynamicKey {
        public String conditionName;
        public Map keyMap;
        public Record keyRecord;
        public String[] orderBy;
        public boolean[] isAsc;

        public String toString() {
            int i;
            StringBuffer buf = new StringBuffer("DynamicKey{");
            buf.append("conditionName=").append(this.conditionName);
            buf.append(", keyMap=").append(this.keyMap);
            buf.append(", keyRecord=");
            if (this.keyRecord == null) {
                buf.append(this.keyRecord);
            } else {
                buf.append('{');
                for (i = 0; i < this.keyRecord.size(); ++i) {
                    buf.append(this.keyRecord.getRecordSchema().getPropertyName(i)).append('=').append(this.keyRecord.getProperty(i));
                    if (i == this.orderBy.length - 1) continue;
                    buf.append(", ");
                }
                buf.append('}');
            }
            buf.append(", orderBy=");
            if (this.orderBy == null) {
                buf.append(this.orderBy);
            } else {
                buf.append('[');
                for (i = 0; i < this.orderBy.length; ++i) {
                    buf.append(this.orderBy[i]);
                    if (i == this.orderBy.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append(", isAsc=");
            if (this.isAsc == null) {
                buf.append(this.isAsc);
            } else {
                buf.append('[');
                for (i = 0; i < this.isAsc.length; ++i) {
                    buf.append(this.isAsc[i]);
                    if (i == this.isAsc.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class DynamicConditionReal {
        public String condition;
        public Map valueMap;
        public String[] orderBy;
        public boolean[] isAsc;

        public String toString() {
            int i;
            StringBuffer buf = new StringBuffer("DynamicConditionReal{");
            buf.append("condition=").append(this.condition);
            buf.append(", valueMap=").append(this.valueMap);
            buf.append(", orderBy=");
            if (this.orderBy == null) {
                buf.append(this.orderBy);
            } else {
                buf.append('[');
                for (i = 0; i < this.orderBy.length; ++i) {
                    buf.append(this.orderBy[i]);
                    if (i == this.orderBy.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append(", isAsc=");
            if (this.isAsc == null) {
                buf.append(this.isAsc);
            } else {
                buf.append('[');
                for (i = 0; i < this.isAsc.length; ++i) {
                    buf.append(this.isAsc[i]);
                    if (i == this.isAsc.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class DynamicCondition {
        public String conditionName;

        public String toString() {
            return "DynamicCondition{conditionName=" + this.conditionName + '}';
        }
    }
}

