/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.graph.CSVFileTimeSeriesCollectionFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetConnection;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.TimeSeriesCollectionFactoryService;

public class CSVFileTimeSeriesCollectionFactoryService
extends TimeSeriesCollectionFactoryService
implements CSVFileTimeSeriesCollectionFactoryServiceMBean {
    private static final long serialVersionUID = 62063250205247679L;
    protected Map seriesInfoMap;
    protected List dsConditionList;
    protected String dateFormatPattern;
    protected ServiceName dateFormatServiceName;
    protected boolean isTimeOnly;
    protected CSVReader csvReader;
    protected String encoding;

    public void setCSVFileInfo(String seriesName, CSVFileInfo info) {
        this.seriesInfoMap.put(seriesName, info);
    }

    public CSVFileInfo getCSVFileInfo(String seriesName) {
        return (CSVFileInfo)this.seriesInfoMap.get(seriesName);
    }

    public Map getCSVFileInfoMap() {
        return this.seriesInfoMap;
    }

    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatServiceName(ServiceName serviceName) {
        this.dateFormatServiceName = serviceName;
    }

    public ServiceName getDateFormatServiceName() {
        return this.dateFormatServiceName;
    }

    public void setTimeOnly(boolean isTimeOnly) {
        this.isTimeOnly = isTimeOnly;
    }

    public boolean isTimeOnly() {
        return this.isTimeOnly;
    }

    public void setCSVReader(CSVReader reader) {
        this.csvReader = reader;
    }

    public CSVReader getCSVReader() {
        return this.csvReader;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void addDatasetCondition(DatasetCondition dsCondition) {
        this.dsConditionList.add(dsCondition);
    }

    public DatasetCondition[] getDatasetConditions() {
        return this.dsConditionList.toArray(new DatasetCondition[this.dsConditionList.size()]);
    }

    public void createService() throws Exception {
        this.dsConditionList = new ArrayList();
        this.seriesInfoMap = new LinkedHashMap();
    }

    public void startService() throws Exception {
        if (this.seriesInfoMap.size() == 0) {
            throw new IllegalArgumentException("CSVFileInfo must be specified.");
        }
        if (this.dateFormatPattern != null) {
            new SimpleDateFormat(this.dateFormatPattern);
        }
    }

    public void destroyService() throws Exception {
        this.dsConditionList = null;
        this.seriesInfoMap = null;
    }

    protected DatasetConnection createConnection(DatasetCondition[] dsConditions) throws DatasetCreateException {
        DatasetConnection connection = new DatasetConnection(this.getName());
        Iterator itr = this.seriesInfoMap.keySet().iterator();
        while (itr.hasNext()) {
            int i;
            String series = (String)itr.next();
            CSVFileTimeSeriesCursor cursor = new CSVFileTimeSeriesCursor(series, (CSVFileInfo)this.seriesInfoMap.get(series));
            int imax = this.dsConditionList.size();
            for (i = 0; i < imax; ++i) {
                cursor.addCondition((DatasetCondition)this.dsConditionList.get(i));
            }
            if (dsConditions != null) {
                for (i = 0; i < dsConditions.length; ++i) {
                    cursor.addCondition(dsConditions[i]);
                }
            }
            cursor.execute();
            connection.addSeriesCursor(cursor);
        }
        return connection;
    }

    public static class CSVFileInfo {
        private File file;
        private String encoding;
        private int timeColumnIndex = 0;
        private boolean isTimeOnly = false;
        private String dateFormatPattern;
        private ServiceName dateFormatServiceName;
        private int valueColumnIndex = 1;
        private CSVReader reader;
        private int skipLine = 0;

        public void setFile(File f) {
            this.file = f;
        }

        public File getFile() {
            return this.file;
        }

        public void setFilePath(String path) {
            this.file = new File(path);
        }

        public void setTimeColumnIndex(int index) {
            this.timeColumnIndex = index;
        }

        public int getTimeColumnIndex() {
            return this.timeColumnIndex;
        }

        public void setTimeOnly(boolean isTimeOnly) {
            this.isTimeOnly = isTimeOnly;
        }

        public boolean isTimeOnly() {
            return this.isTimeOnly;
        }

        public void setDateFormatPattern(String pattern) {
            this.dateFormatPattern = pattern;
        }

        public String getDateFormatPattern() {
            return this.dateFormatPattern;
        }

        public void setDateFormatServiceName(ServiceName serviceName) {
            this.dateFormatServiceName = serviceName;
        }

        public ServiceName getDateFormatServiceName() {
            return this.dateFormatServiceName;
        }

        public void setValueColumnIndex(int index) {
            this.valueColumnIndex = index;
        }

        public int getValueColumnIndex() {
            return this.valueColumnIndex;
        }

        public void setCSVReader(CSVReader reader) {
            this.reader = reader;
        }

        public CSVReader getCSVReader() {
            return this.reader;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setSkipLine(int line) {
            this.skipLine = line;
        }

        public int getSkipLine() {
            return this.skipLine;
        }
    }

    protected class CSVFileTimeSeriesCursor
    extends TimeSeriesCollectionFactoryService.TimeSeriesCursor {
        protected DateFormat dateFormat;
        protected CSVFileInfo info;
        protected CSVReader.CSVIterator iterator;
        protected CSVReader.CSVElements current;
        protected FileInputStream fis;

        public CSVFileTimeSeriesCursor(String seriesName, CSVFileInfo info) throws DatasetCreateException {
            super(CSVFileTimeSeriesCollectionFactoryService.this, seriesName);
            if (info.getDateFormatServiceName() != null) {
                this.dateFormat = (DateFormat)ServiceManagerFactory.getServiceObject(info.getDateFormatServiceName());
            } else if (info.getDateFormatPattern() != null) {
                this.dateFormat = new SimpleDateFormat(info.getDateFormatPattern());
            }
            if (this.dateFormat == null) {
                if (CSVFileTimeSeriesCollectionFactoryService.this.dateFormatServiceName != null) {
                    this.dateFormat = (DateFormat)ServiceManagerFactory.getServiceObject(CSVFileTimeSeriesCollectionFactoryService.this.dateFormatServiceName);
                } else if (CSVFileTimeSeriesCollectionFactoryService.this.dateFormatPattern != null) {
                    this.dateFormat = new SimpleDateFormat(CSVFileTimeSeriesCollectionFactoryService.this.dateFormatPattern);
                }
            }
            if (this.dateFormat == null) {
                throw new DatasetCreateException("Dataset[" + CSVFileTimeSeriesCollectionFactoryService.this.dataSetName + ", " + seriesName + "] : " + "DateFormat is null.");
            }
            this.info = info;
        }

        public boolean addCondition(DatasetCondition condition) throws DatasetCreateException {
            return super.addCondition(condition);
        }

        public void execute() throws DatasetCreateException {
            try {
                CSVReader reader = null;
                reader = this.info.getCSVReader() != null ? CSVFileTimeSeriesCollectionFactoryService.this.getCSVReader().cloneReader() : (CSVFileTimeSeriesCollectionFactoryService.this.csvReader != null ? CSVFileTimeSeriesCollectionFactoryService.this.csvReader.cloneReader() : new CSVReader());
                String enc = this.info.getEncoding();
                if (enc == null) {
                    enc = CSVFileTimeSeriesCollectionFactoryService.this.encoding;
                }
                this.fis = new FileInputStream(this.info.getFile());
                InputStreamReader isr = enc == null ? new InputStreamReader(this.fis) : new InputStreamReader((InputStream)this.fis, enc);
                reader.setReader(isr);
                if (this.info.getSkipLine() > 0) {
                    reader.skipCSVLine(this.info.getSkipLine());
                }
                this.iterator = reader.iterator();
            }
            catch (IOException e) {
                throw new DatasetCreateException("Dataset[" + CSVFileTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        public boolean next() throws DatasetCreateException {
            try {
                boolean hasNext = this.iterator.hasNext();
                if (hasNext) {
                    this.current = this.iterator.nextElements();
                }
                return hasNext;
            }
            catch (IOException e) {
                throw new DatasetCreateException("Dataset[" + CSVFileTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        public Date getDate() throws DatasetCreateException {
            Date date = null;
            try {
                String dateStr = this.current.getString(this.info.getTimeColumnIndex());
                date = this.dateFormat.parse(dateStr);
                if (this.info.isTimeOnly || CSVFileTimeSeriesCollectionFactoryService.this.isTimeOnly) {
                    Calendar cal = Calendar.getInstance();
                    int year = cal.get(1);
                    int month = cal.get(2);
                    int day = cal.get(5);
                    cal.clear();
                    cal.setTime(date);
                    cal.set(1, year);
                    cal.set(2, month);
                    cal.set(5, day);
                    date = cal.getTime();
                }
            }
            catch (ParseException e) {
                throw new DatasetCreateException("Dataset[" + CSVFileTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new DatasetCreateException("Dataset[" + CSVFileTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return date;
        }

        public double getValue() throws DatasetCreateException {
            double value = Double.NaN;
            try {
                value = this.current.getDouble(this.info.getValueColumnIndex());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new DatasetCreateException("Dataset[" + CSVFileTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return value;
        }

        public boolean wasNull() throws DatasetCreateException {
            return this.current.wasNull();
        }

        public void close() {
            this.iterator = null;
            this.current = null;
            if (this.fis != null) {
                try {
                    this.fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.fis = null;
            }
            super.close();
        }
    }
}

