/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jndi;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.jndi.DummyJndiFinderServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class DummyJndiFinderService
extends ServiceBase
implements DummyJndiFinderServiceMBean,
JndiFinder {
    private static final long serialVersionUID = -6086629800301585665L;
    private Map jndiMap;
    private String jndiPrefix;
    private ServiceName jndiFinderServiceName;
    private JndiFinder realJndiFinder;

    public void setJndiMapping(String jndiName, Object obj) {
        this.jndiMap.put(jndiName, obj);
    }

    public void setJndiMappingServiceName(String jndiName, ServiceName name) {
        this.jndiMap.put(jndiName, name);
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setPrefix(String prefix) {
        this.jndiPrefix = prefix;
    }

    public String getPrefix() {
        return this.jndiPrefix;
    }

    public void createService() throws Exception {
        this.jndiMap = new HashMap();
    }

    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.realJndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
    }

    public Object lookup(String name) throws NamingException {
        String jndiName = name;
        if (this.jndiPrefix != null) {
            jndiName = name == null ? this.jndiPrefix : this.jndiPrefix + name;
        }
        if (!this.jndiMap.containsKey(jndiName)) {
            if (this.realJndiFinder != null) {
                return this.realJndiFinder.lookup(name);
            }
            throw new NameNotFoundException(jndiName);
        }
        Object result = this.jndiMap.get(jndiName);
        if (result instanceof ServiceName) {
            try {
                result = ServiceManagerFactory.getServiceObject((ServiceName)result);
            }
            catch (ServiceNotFoundException e) {
                throw new NameNotFoundException(e.toString());
            }
        }
        return result;
    }

    public Object lookup() throws NamingException {
        return this.lookup(null);
    }

    public void clearCache() {
        if (this.realJndiFinder != null) {
            this.realJndiFinder.clearCache();
        }
    }

    public void clearCache(String jndiName) {
        if (this.realJndiFinder != null) {
            this.realJndiFinder.clearCache(this.name);
        }
    }
}

