/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.JSONJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class JSONJournalEditorService
extends ServiceBase
implements JournalEditor,
JSONJournalEditorServiceMBean {
    private static final long serialVersionUID = 8863151772494235330L;
    protected static final String DEFAULT_SECRET_STRING = "******";
    protected static final String STRING_ENCLOSURE = "\"";
    protected static final String ARRAY_SEPARATOR = ",";
    protected static final String ARRAY_ENCLOSURE_START = "[";
    protected static final String ARRAY_ENCLOSURE_END = "]";
    protected static final String OBJECT_ENCLOSURE_START = "{";
    protected static final String OBJECT_ENCLOSURE_END = "}";
    protected static final String PROPERTY_SEPARATOR = ":";
    protected static final String NULL_VALUE = "null";
    protected static final String BOOLEAN_VALUE_TRUE = "true";
    protected static final String BOOLEAN_VALUE_FALSE = "false";
    protected static final char ESCAPE = '\\';
    protected static final char QUOTE = '\"';
    protected static final char BACK_SLASH = '\\';
    protected static final char SLASH = '/';
    protected static final char BACK_SPACE = '\b';
    protected static final char CHANGE_PAGE = '\f';
    protected static final char LF = '\n';
    protected static final char CR = '\r';
    protected static final char TAB = '\t';
    protected static final String ESCAPE_QUOTE = "\\\"";
    protected static final String ESCAPE_BACK_SLASH = "\\\\";
    protected static final String ESCAPE_SLASH = "\\/";
    protected static final String ESCAPE_BACK_SPACE = "\\b";
    protected static final String ESCAPE_CHANGE_PAGE = "\\f";
    protected static final String ESCAPE_LF = "\\n";
    protected static final String ESCAPE_CR = "\\r";
    protected static final String ESCAPE_TAB = "\\t";
    protected boolean isExpandArrayValue = false;
    protected int maxArraySize = -1;
    protected boolean isExpandMapValue = false;
    protected String[] secretProperties;
    protected Set secretPropertySet;
    protected String secretString = "******";
    protected String[] enabledProperties;
    protected Set enabledPropertySet;
    protected String[] disabledProperties;
    protected Set disabledPropertySet;
    protected boolean isOutputKey = true;

    public void setExpandArrayValue(boolean isExpand) {
        this.isExpandArrayValue = isExpand;
    }

    public boolean isExpandArrayValue() {
        return this.isExpandArrayValue;
    }

    public void setMaxArraySize(int max) {
        this.maxArraySize = max;
    }

    public int getMaxArraySize() {
        return this.maxArraySize;
    }

    public void setExpandMapValue(boolean isExpand) {
        this.isExpandMapValue = isExpand;
    }

    public boolean isExpandMapValue() {
        return this.isExpandMapValue;
    }

    public void setSecretProperties(String[] names) {
        this.secretProperties = names;
    }

    public String[] getSecretProperties() {
        return this.secretProperties;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setEnabledProperties(String[] names) {
        this.enabledProperties = names;
    }

    public String[] getEnabledProperties() {
        return this.enabledProperties;
    }

    public void setDisabledProperties(String[] names) {
        this.disabledProperties = names;
    }

    public String[] getDisabledProperties() {
        return this.disabledProperties;
    }

    public void setOutputKey(boolean isOutput) {
        this.isOutputKey = isOutput;
    }

    public boolean isOutputKey() {
        return this.isOutputKey;
    }

    protected void preStartService() throws Exception {
        int i;
        super.preStartService();
        if (this.secretProperties != null && this.secretProperties.length != 0) {
            this.secretPropertySet = new HashSet(this.secretProperties.length);
            for (i = 0; i < this.secretProperties.length; ++i) {
                this.secretPropertySet.add(this.secretProperties[i]);
            }
        }
        if (this.enabledProperties != null && this.enabledProperties.length != 0) {
            this.enabledPropertySet = new HashSet(this.enabledProperties.length);
            for (i = 0; i < this.enabledProperties.length; ++i) {
                this.enabledPropertySet.add(this.enabledProperties[i]);
            }
        }
        if (this.disabledProperties != null && this.disabledProperties.length != 0) {
            this.disabledPropertySet = new HashSet(this.disabledProperties.length);
            for (i = 0; i < this.disabledProperties.length; ++i) {
                this.disabledPropertySet.add(this.disabledProperties[i]);
            }
        }
    }

    protected StringBuffer appendName(StringBuffer buf, String name) {
        buf.append(STRING_ENCLOSURE);
        buf.append(this.escape(name));
        buf.append(STRING_ENCLOSURE);
        return buf;
    }

    protected StringBuffer appendValue(StringBuffer buf, EditorFinder finder, Class type, Object value) {
        if (type == null && value != null) {
            type = value.getClass();
        }
        if (value == null) {
            if (type == null) {
                buf.append(NULL_VALUE);
            } else if (Number.class.isAssignableFrom(type) || type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
                buf.append('0');
            } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                buf.append(BOOLEAN_VALUE_FALSE);
            } else {
                buf.append(NULL_VALUE);
            }
        } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            if (((Boolean)value).booleanValue()) {
                buf.append(BOOLEAN_VALUE_TRUE);
            } else {
                buf.append(BOOLEAN_VALUE_FALSE);
            }
        } else if (Number.class.isAssignableFrom(type) || type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
            buf.append(value);
        } else if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            if (this.isExpandArrayValue) {
                this.appendArray(buf, finder, value);
            } else {
                this.appendUnknownValue(buf, finder, type, value);
            }
        } else if (CharSequence.class.isAssignableFrom(type) || Character.class.equals(type) || Character.TYPE.equals(type)) {
            buf.append(STRING_ENCLOSURE);
            buf.append(this.escape(value.toString()));
            buf.append(STRING_ENCLOSURE);
        } else if (Map.class.isAssignableFrom(type)) {
            if (this.isExpandMapValue) {
                this.appendMap(buf, finder, (Map)value);
            } else {
                this.appendUnknownValue(buf, finder, type, value);
            }
        } else {
            this.appendUnknownValue(buf, finder, type, value);
        }
        return buf;
    }

    protected StringBuffer appendUnknownValue(StringBuffer buf, EditorFinder finder, Class type, Object value) {
        JournalEditor editor = finder.findEditor(value);
        if (editor != null && editor != this) {
            value = editor.toObject(finder, null, value);
            if (editor instanceof JSONJournalEditorService) {
                buf.append(value.toString());
            } else {
                buf.append(STRING_ENCLOSURE);
                buf.append(this.escape(value.toString()));
                buf.append(STRING_ENCLOSURE);
            }
        } else {
            buf.append(STRING_ENCLOSURE);
            buf.append(this.escape(value.toString()));
            buf.append(STRING_ENCLOSURE);
        }
        return buf;
    }

    protected StringBuffer appendMap(StringBuffer buf, EditorFinder finder, Map map) {
        buf.append(OBJECT_ENCLOSURE_START);
        Iterator itr = map.entrySet().iterator();
        boolean isOutput = false;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Object key = entry.getKey();
            String name = key == null ? null : key.toString();
            if (!this.isOutputProperty(name)) continue;
            if (isOutput) {
                buf.append(ARRAY_SEPARATOR);
            }
            isOutput = true;
            this.appendProperty(buf, finder, name, entry.getValue());
        }
        buf.append(OBJECT_ENCLOSURE_END);
        return buf;
    }

    protected boolean isOutputProperty(String name) {
        if (name != null && this.disabledPropertySet != null && this.disabledPropertySet.contains(name)) {
            return false;
        }
        return name == null || this.enabledPropertySet == null || this.enabledPropertySet.contains(name);
    }

    protected boolean isSecretProperty(String name) {
        return name != null && this.secretPropertySet != null && this.secretPropertySet.contains(name);
    }

    protected StringBuffer appendProperty(StringBuffer buf, EditorFinder finder, String name, Object value) {
        this.appendName(buf, name);
        buf.append(PROPERTY_SEPARATOR);
        if (this.isSecretProperty(name)) {
            this.appendValue(buf, finder, null, this.secretString);
        } else {
            this.appendValue(buf, finder, null, value);
        }
        return buf;
    }

    protected StringBuffer appendArray(StringBuffer buf, EditorFinder finder, Object array) {
        buf.append(ARRAY_ENCLOSURE_START);
        if (array.getClass().isArray()) {
            int imax = Array.getLength(array);
            for (int i = 0; i < imax; ++i) {
                if (this.maxArraySize >= 0 && i >= this.maxArraySize) {
                    buf.append("...");
                    break;
                }
                this.appendValue(buf, finder, null, Array.get(array, i));
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        } else if (List.class.isAssignableFrom(array.getClass())) {
            List list = (List)array;
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                if (this.maxArraySize >= 0 && i >= this.maxArraySize) {
                    buf.append("...");
                    break;
                }
                this.appendValue(buf, finder, null, list.get(i));
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        } else if (Collection.class.isAssignableFrom(array.getClass())) {
            Iterator itr = ((Collection)array).iterator();
            int i = 0;
            while (itr.hasNext()) {
                if (this.maxArraySize >= 0 && i >= this.maxArraySize) {
                    buf.append("...");
                    break;
                }
                this.appendValue(buf, finder, null, itr.next());
                if (itr.hasNext()) {
                    buf.append(ARRAY_SEPARATOR);
                }
                ++i;
            }
        } else if (Enumeration.class.isAssignableFrom(array.getClass())) {
            Enumeration enm = (Enumeration)array;
            int i = 0;
            while (enm.hasMoreElements()) {
                if (this.maxArraySize >= 0 && i >= this.maxArraySize) {
                    buf.append("...");
                    break;
                }
                this.appendValue(buf, finder, null, enm.nextElement());
                if (enm.hasMoreElements()) {
                    buf.append(ARRAY_SEPARATOR);
                }
                ++i;
            }
        }
        buf.append(ARRAY_ENCLOSURE_END);
        return buf;
    }

    protected String escape(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean isEscape = false;
        StringBuffer buf = new StringBuffer();
        int imax = str.length();
        block10: for (int i = 0; i < imax; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append(ESCAPE_QUOTE);
                    isEscape = true;
                    continue block10;
                }
                case '\\': {
                    buf.append(ESCAPE_BACK_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '/': {
                    buf.append(ESCAPE_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '\b': {
                    buf.append(ESCAPE_BACK_SPACE);
                    isEscape = true;
                    continue block10;
                }
                case '\f': {
                    buf.append(ESCAPE_CHANGE_PAGE);
                    isEscape = true;
                    continue block10;
                }
                case '\n': {
                    buf.append(ESCAPE_LF);
                    isEscape = true;
                    continue block10;
                }
                case '\r': {
                    buf.append(ESCAPE_CR);
                    isEscape = true;
                    continue block10;
                }
                case '\t': {
                    buf.append(ESCAPE_TAB);
                    isEscape = true;
                    continue block10;
                }
                default: {
                    if (!(c == ' ' || c == '!' || '#' <= c && c <= '[' || ']' <= c && c <= '~')) {
                        isEscape = true;
                        this.toUnicode(c, buf);
                        continue block10;
                    }
                    buf.append(c);
                }
            }
        }
        return isEscape ? buf.toString() : str;
    }

    protected StringBuffer toUnicode(char c, StringBuffer buf) {
        buf.append('\\');
        buf.append('u');
        int mask = 61440;
        block18: for (int i = 0; i < 4; ++i) {
            mask = 61440 >> i * 4;
            int val = c & mask;
            switch (val <<= i * 4) {
                case 0: {
                    buf.append('0');
                    continue block18;
                }
                case 4096: {
                    buf.append('1');
                    continue block18;
                }
                case 8192: {
                    buf.append('2');
                    continue block18;
                }
                case 12288: {
                    buf.append('3');
                    continue block18;
                }
                case 16384: {
                    buf.append('4');
                    continue block18;
                }
                case 20480: {
                    buf.append('5');
                    continue block18;
                }
                case 24576: {
                    buf.append('6');
                    continue block18;
                }
                case 28672: {
                    buf.append('7');
                    continue block18;
                }
                case 32768: {
                    buf.append('8');
                    continue block18;
                }
                case 36864: {
                    buf.append('9');
                    continue block18;
                }
                case 40960: {
                    buf.append('a');
                    continue block18;
                }
                case 45056: {
                    buf.append('b');
                    continue block18;
                }
                case 49152: {
                    buf.append('c');
                    continue block18;
                }
                case 53248: {
                    buf.append('d');
                    continue block18;
                }
                case 57344: {
                    buf.append('e');
                    continue block18;
                }
                case 61440: {
                    buf.append('f');
                    continue block18;
                }
            }
        }
        return buf;
    }

    public Object toObject(EditorFinder finder, Object key, Object value) {
        return this.toString(new StringBuffer(), finder, key == null ? null : key.toString(), value).toString();
    }

    protected StringBuffer toString(StringBuffer buf, EditorFinder finder, String key, Object value) {
        if (key == null || !this.isOutputKey()) {
            this.appendValue(buf, finder, null, value);
        } else {
            buf.append(OBJECT_ENCLOSURE_START);
            this.appendProperty(buf, finder, key, value);
            buf.append(OBJECT_ENCLOSURE_END);
        }
        return buf;
    }
}

