/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.rmi.RemoteException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.DistributedClientConnectionFactoryImpl;
import jp.ossc.nimbus.service.publish.DistributedConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.DistributedServerConnectionImpl;
import jp.ossc.nimbus.service.publish.RemoteClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.repository.Repository;

public class DistributedConnectionFactoryService
extends ServiceBase
implements ClientConnectionFactory,
ServerConnectionFactory,
DistributedConnectionFactoryServiceMBean {
    private static final long serialVersionUID = 8772125021331668413L;
    private int distributedSize = 1;
    private ServiceName connectionFactoryFactoryServiceName;
    private ServiceName jndiRepositoryServiceName;
    private String jndiName = "publish/ClientConnectionFactory";
    private int rmiPort;
    private Repository jndiRepository;
    private DistributedServerConnectionImpl serverConnection;
    private DistributedClientConnectionFactoryImpl clientConnectionFactory;

    public void setDistributedSize(int size) {
        this.distributedSize = size;
    }

    public int getDistributedSize() {
        return this.distributedSize;
    }

    public void setConnectionFactoryFactoryServiceName(ServiceName name) {
        this.connectionFactoryFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryFactoryServiceName() {
        return this.connectionFactoryFactoryServiceName;
    }

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public Repository getJndiRepository() {
        return this.jndiRepository;
    }

    public void setJndiRepository(Repository repository) {
        this.jndiRepository = repository;
    }

    public void startService() throws Exception {
        RemoteClientConnectionFactory remoteClientConnectionFactory;
        this.serverConnection = new DistributedServerConnectionImpl();
        this.clientConnectionFactory = new DistributedClientConnectionFactoryImpl();
        for (int i = 0; i < this.distributedSize; ++i) {
            Object connectionFactory = ServiceManagerFactory.getServiceObject(this.connectionFactoryFactoryServiceName);
            if (!(connectionFactory instanceof ClientConnectionFactory) || !(connectionFactory instanceof ServerConnectionFactory)) {
                throw new IllegalArgumentException("ConnectionFactory is not ClientConnectionFactory and ServerConnectionFactory." + this.connectionFactoryFactoryServiceName + " : " + connectionFactory);
            }
            this.serverConnection.addServerConnection(((ServerConnectionFactory)connectionFactory).getServerConnection());
            this.clientConnectionFactory.addClientConnectionFactory((ClientConnectionFactory)connectionFactory);
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        }
        if (this.jndiRepository != null && this.jndiName != null && !this.jndiRepository.register(this.jndiName, remoteClientConnectionFactory = new RemoteClientConnectionFactory(this, this.rmiPort))) {
            throw new Exception("Could not register in jndiRepository.");
        }
    }

    public void stopService() throws Exception {
        if (this.jndiRepository != null) {
            this.jndiRepository.unregister(this.jndiName);
        }
        this.serverConnection = null;
        this.clientConnectionFactory = null;
    }

    public ClientConnection getClientConnection() throws ConnectionCreateException, RemoteException {
        return this.clientConnectionFactory.getClientConnection();
    }

    public int getClientCount() throws RemoteException {
        return this.clientConnectionFactory.getClientCount();
    }

    public ServerConnection getServerConnection() throws ConnectionCreateException {
        return this.serverConnection;
    }
}

