/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.udp.MessageId;
import jp.ossc.nimbus.service.publish.udp.Window;

public class MessageImpl
extends MessageId
implements Message,
Comparable,
Cloneable,
Externalizable {
    private transient String subject;
    private Map subjectMap = new LinkedHashMap();
    private Object object;
    private boolean isFirst;
    private transient long sendTime;
    private transient long receiveTime;
    private transient List windows;
    private transient boolean isLost;
    private transient Set destinationIds;
    private transient byte[] serializedBytes;

    public void setFirst(boolean isFirst) {
        this.isFirst = isFirst;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setLost(boolean isLost) {
        this.isLost = isLost;
    }

    public boolean isLost() {
        return this.isLost;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public String getSubject() {
        Set subjects = this.getSubjects();
        if (subjects.size() == 0) {
            return null;
        }
        if (this.subject == null) {
            this.subject = (String)subjects.iterator().next();
        }
        return this.subject;
    }

    public Set getSubjects() {
        return this.subjectMap.keySet();
    }

    public void setSubject(String sbj, String key) {
        if (this.subjectMap.size() == 0) {
            this.subject = sbj;
        }
        this.subjectMap.put(sbj, key);
    }

    public String getKey(String sbj) {
        return (String)this.subjectMap.get(sbj);
    }

    public String getKey() {
        return this.getKey(this.getSubject());
    }

    public void setObject(Object obj) throws MessageException {
        this.object = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject() throws MessageException {
        if (this.object != null || this.serializedBytes == null) return this.object;
        byte[] byArray = this.serializedBytes;
        synchronized (this.serializedBytes) {
            if (this.object != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.object;
            }
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.serializedBytes));
                this.object = ois.readObject();
            }
            catch (IOException e) {
                throw new MessageException(e);
            }
            catch (ClassNotFoundException e) {
                throw new MessageException(e);
            }
            return this.object;
        }
    }

    public void setSerializedBytes(byte[] bytes) {
        this.serializedBytes = bytes;
    }

    public byte[] getSerializedBytes() {
        return this.serializedBytes;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(long time) {
        this.sendTime = time;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(long time) {
        this.receiveTime = time;
    }

    public synchronized List getWindows(int windowSize, Externalizer ext) throws IOException {
        if (this.windows == null) {
            this.windows = Window.toWindows(this, windowSize, ext);
        }
        return this.windows;
    }

    public Set getDestinationIds() {
        return this.destinationIds;
    }

    public void setDestinationIds(Set ids) {
        this.destinationIds = ids;
    }

    public void addDestinationId(Object id) {
        if (id == null) {
            return;
        }
        if (this.destinationIds == null) {
            this.destinationIds = new HashSet();
        }
        if (id instanceof Collection) {
            this.destinationIds.addAll((Collection)id);
        } else {
            this.destinationIds.add(id);
        }
    }

    public void removeDestinationId(Object id) {
        if (this.destinationIds == null) {
            return;
        }
        this.destinationIds.remove(id);
    }

    public void clearDestinationIds() {
        if (this.destinationIds == null) {
            return;
        }
        this.destinationIds.clear();
    }

    public boolean containsDestinationId(Object id) {
        if (this.destinationIds == null || this.destinationIds.size() == 0) {
            return true;
        }
        if (id instanceof Collection) {
            Iterator itr = ((Collection)id).iterator();
            while (itr.hasNext()) {
                if (!this.destinationIds.contains(itr.next())) continue;
                return true;
            }
            return false;
        }
        return this.destinationIds.contains(id);
    }

    public MessageId toMessageId() {
        return new MessageId(this.sequence);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isFirst);
        out.writeObject(this.subjectMap);
        if (this.serializedBytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.object);
            oos.flush();
            out.writeObject(baos.toByteArray());
        } else {
            out.writeObject(this.serializedBytes);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isFirst = in.readBoolean();
        this.subjectMap = (Map)in.readObject();
        this.serializedBytes = (byte[])in.readObject();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.deleteCharAt(buf.length() - 1);
        buf.append(", subjectMap=").append(this.subjectMap);
        buf.append(", object=").append(this.object);
        buf.append('}');
        return buf.toString();
    }

    public Object clone() {
        MessageImpl clone = null;
        try {
            clone = (MessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.windows = null;
        return clone;
    }
}

