/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.util.Date;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.queue.DistributedQueueSelector;
import jp.ossc.nimbus.service.queue.DistributedQueueServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class DistributedQueueService
extends ServiceBase
implements Queue,
DistributedQueueServiceMBean {
    private static final long serialVersionUID = -752202000609727763L;
    private ServiceName distributedQueueSelectorServiceName;
    private DistributedQueueSelector selector;
    protected long sleepTime = 10000L;
    protected int maxThresholdSize = -1;
    protected SynchronizeMonitor pushMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor getMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor peekMonitor = new WaitSynchronizeMonitor();
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;
    protected long maxDepth = 0L;
    protected boolean isSafeGetOrder = true;
    protected Class synchronizeMonitorClass = WaitSynchronizeMonitor.class;

    public void setSynchronizeMonitorClass(Class clazz) {
        this.synchronizeMonitorClass = clazz;
    }

    public Class getSynchronizeMonitorClass() {
        return this.synchronizeMonitorClass;
    }

    public void setDistributedQueueSelectorServiceName(ServiceName name) {
        this.distributedQueueSelectorServiceName = name;
    }

    public ServiceName getDistributedQueueSelectorServiceName() {
        return this.distributedQueueSelectorServiceName;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setMaxThresholdSize(int size) {
        this.maxThresholdSize = size;
    }

    public int getMaxThresholdSize() {
        return this.maxThresholdSize;
    }

    public boolean isSafeGetOrder() {
        return this.isSafeGetOrder;
    }

    public void setSafeGetOrder(boolean isSafe) {
        this.isSafeGetOrder = isSafe;
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    public long getDepth() {
        return this.size();
    }

    public long getDepthDelta() {
        long depth = this.size();
        long delta = depth - this.lastDepth;
        this.lastDepth = depth;
        return delta;
    }

    public long getMaxDepth() {
        return this.maxDepth;
    }

    public void startService() throws Exception {
        if (!WaitSynchronizeMonitor.class.equals(this.synchronizeMonitorClass)) {
            this.pushMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.getMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.peekMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
        }
        this.selector = (DistributedQueueSelector)ServiceManagerFactory.getServiceObject(this.distributedQueueSelectorServiceName);
        this.accept();
    }

    public void stopService() throws Exception {
        this.release();
    }

    protected Queue getPushQueue(Object item) {
        return this.selector.selectQueue(item);
    }

    protected Queue getGetQueue() {
        Queue[] queues = this.selector.getQueues();
        Queue queue = null;
        int max = 0;
        for (int i = 0; i < queues.length; ++i) {
            int current = queues[i].size();
            if (max >= current) continue;
            max = current;
            queue = queues[i];
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) {
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        Queue queue = this.getPushQueue(item);
        if (this.maxThresholdSize > 0 && (this.pushMonitor.isWait() || this.size() >= this.maxThresholdSize) && !this.fourceEndFlg) {
            try {
                this.pushMonitor.initAndWaitMonitor();
            }
            catch (InterruptedException e) {
                return;
            }
            finally {
                this.pushMonitor.releaseMonitor();
            }
        }
        queue.push(item);
        int size = this.size();
        if ((long)size > this.maxDepth) {
            this.maxDepth = size;
        }
        ++this.count;
        ++this.countDelta;
        this.lastPushedTime = System.currentTimeMillis();
        this.peekMonitor.notifyAllMonitor();
        if (this.isSafeGetOrder) {
            this.getMonitor.notifyMonitor();
        } else {
            this.getMonitor.notifyAllMonitor();
        }
        if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
            this.pushMonitor.notifyMonitor();
        }
    }

    public Object get() {
        return this.get(-1L);
    }

    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    public Object peek() {
        return this.peek(-1L);
    }

    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        Object var8_11;
        block32: {
            Object object;
            block31: {
                Object object2;
                block30: {
                    Object var8_8;
                    block29: {
                        Thread current = Thread.currentThread();
                        long processTime = 0L;
                        try {
                            if (isRemove) {
                                this.getMonitor.initMonitor();
                            } else {
                                this.peekMonitor.initMonitor();
                            }
                            Queue queue = null;
                            while (!this.fourceEndFlg) {
                                if (this.size() > 0) {
                                    if (!isRemove || !this.isSafeGetOrder || this.getMonitor.isFirst()) {
                                        queue = this.getGetQueue();
                                        Object ret = null;
                                        ret = isRemove ? queue.get(timeOutMs) : queue.peek(timeOutMs);
                                        this.getMonitor.releaseMonitor();
                                        if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                                            if (this.isSafeGetOrder) {
                                                this.getMonitor.notifyMonitor();
                                            } else {
                                                this.getMonitor.notifyAllMonitor();
                                            }
                                        }
                                        if (isRemove && this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
                                            this.pushMonitor.notifyMonitor();
                                        }
                                        Object object3 = ret;
                                        Object var13_15 = null;
                                        if (isRemove) {
                                            this.getMonitor.releaseMonitor();
                                            return object3;
                                        }
                                        this.peekMonitor.releaseMonitor();
                                        return object3;
                                    }
                                    if (this.getMonitor.isWait()) {
                                        this.getMonitor.notifyMonitor();
                                    }
                                }
                                if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                                long proc = 0L;
                                if (timeOutMs >= 0L) {
                                    proc = System.currentTimeMillis();
                                }
                                try {
                                    long curSleepTime;
                                    long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                                    if (curSleepTime > 0L && (this.size() == 0 || !isRemove || this.isSafeGetOrder && !this.getMonitor.isFirst())) {
                                        this.getMonitor.initAndWaitMonitor(curSleepTime);
                                    }
                                }
                                catch (InterruptedException e) {
                                    Object var11_22 = null;
                                    Object var13_16 = null;
                                    if (isRemove) {
                                        this.getMonitor.releaseMonitor();
                                        return var11_22;
                                    }
                                    this.peekMonitor.releaseMonitor();
                                    return var11_22;
                                }
                                if (timeOutMs < 0L) continue;
                                proc = System.currentTimeMillis() - proc;
                                processTime += proc;
                            }
                            if (this.fourceEndFlg) {
                                queue = this.getGetQueue();
                                if (queue == null) {
                                    var8_8 = null;
                                    break block29;
                                }
                                if (isRemove) {
                                    object2 = queue.get(timeOutMs);
                                    break block30;
                                }
                                object = queue.peek(timeOutMs);
                                break block31;
                            }
                            if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                                if (this.isSafeGetOrder) {
                                    this.getMonitor.notifyMonitor();
                                } else {
                                    this.getMonitor.notifyAllMonitor();
                                }
                            }
                            var8_11 = null;
                            break block32;
                        }
                        catch (Throwable throwable) {
                            Object var13_21 = null;
                            if (isRemove) {
                                this.getMonitor.releaseMonitor();
                                throw throwable;
                            }
                            this.peekMonitor.releaseMonitor();
                            throw throwable;
                        }
                    }
                    Object var13_17 = null;
                    if (isRemove) {
                        this.getMonitor.releaseMonitor();
                        return var8_8;
                    }
                    this.peekMonitor.releaseMonitor();
                    return var8_8;
                }
                Object var13_18 = null;
                if (isRemove) {
                    this.getMonitor.releaseMonitor();
                    return object2;
                }
                this.peekMonitor.releaseMonitor();
                return object2;
            }
            Object var13_19 = null;
            if (isRemove) {
                this.getMonitor.releaseMonitor();
                return object;
            }
            this.peekMonitor.releaseMonitor();
            return object;
        }
        Object var13_20 = null;
        if (isRemove) {
            this.getMonitor.releaseMonitor();
            return var8_11;
        }
        this.peekMonitor.releaseMonitor();
        return var8_11;
    }

    public void remove(Object item) {
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].remove(item);
        }
    }

    public void clear() {
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].clear();
        }
    }

    public int size() {
        if (this.selector == null) {
            return 0;
        }
        Queue[] queues = this.selector.getQueues();
        int size = 0;
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                size += queues[i].size();
            }
        }
        return size;
    }

    public void accept() {
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].accept();
        }
        this.fourceEndFlg = false;
    }

    public void release() {
        this.fourceEndFlg = true;
        while (this.getMonitor.isWait()) {
            this.getMonitor.notifyMonitor();
            Thread.yield();
        }
        this.peekMonitor.notifyAllMonitor();
        Thread.yield();
        while (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
            Thread.yield();
        }
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].release();
        }
    }
}

