/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.scheduler2.AbstractSchedulerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleExecutor;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;
import jp.ossc.nimbus.service.scheduler2.Scheduler;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.transaction.TransactionManagerFactory;

public abstract class AbstractSchedulerService
extends ServiceBase
implements AbstractSchedulerServiceMBean,
Scheduler {
    private static final long serialVersionUID = 6938915052580428501L;
    protected static final String TRANSACTION_MANAGER_JNDI_NAME = "java:/TransactionManager";
    protected long scheduleTickerInterval = 1000L;
    protected ServiceName scheduleManagerServiceName;
    protected ScheduleManager scheduleManager;
    protected ServiceName[] scheduleExecutorServiceNames;
    protected Map scheduleExecutors;
    protected Daemon scheduleTicker;
    protected boolean isTransactionControl;
    protected TransactionManager transactionManager;
    protected ServiceName transactionManagerFactoryServiceName;
    protected String executorKey;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName clusterServiceName;
    protected ClusterService cluster;
    protected ClusterListener clusterListener;

    public void setScheduleTickerInterval(long interval) {
        this.scheduleTickerInterval = interval;
    }

    public long getScheduleTickerInterval() {
        return this.scheduleTickerInterval;
    }

    public void setScheduleManagerServiceName(ServiceName name) {
        this.scheduleManagerServiceName = name;
    }

    public ServiceName getScheduleManagerServiceName() {
        return this.scheduleManagerServiceName;
    }

    public void setScheduleExecutorServiceName(ServiceName name) {
        ServiceName[] serviceNameArray;
        if (name == null) {
            serviceNameArray = null;
        } else {
            ServiceName[] serviceNameArray2 = new ServiceName[1];
            serviceNameArray = serviceNameArray2;
            serviceNameArray2[0] = name;
        }
        this.scheduleExecutorServiceNames = serviceNameArray;
    }

    public ServiceName getScheduleExecutorServiceName() {
        return this.scheduleExecutorServiceNames == null || this.scheduleExecutorServiceNames.length != 1 ? null : this.scheduleExecutorServiceNames[0];
    }

    public void setScheduleExecutorServiceNames(ServiceName[] names) {
        this.scheduleExecutorServiceNames = names;
    }

    public ServiceName[] getScheduleExecutorServiceNames() {
        return this.scheduleExecutorServiceNames;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setTransactionControl(boolean isControl) {
        this.isTransactionControl = isControl;
    }

    public boolean isTransactionControl() {
        return this.isTransactionControl;
    }

    public void setExecutorKey(String key) {
        this.executorKey = key;
    }

    public String getExecutorKey() {
        return this.executorKey;
    }

    public void setTransactionManagerFactoryServiceName(ServiceName name) {
        this.transactionManagerFactoryServiceName = name;
    }

    public ServiceName getTransactionManagerFactoryServiceName() {
        return this.transactionManagerFactoryServiceName;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void preCreateService() throws Exception {
        super.preCreateService();
    }

    public void preStartService() throws Exception {
        super.preStartService();
        if (this.isTransactionControl) {
            if (this.transactionManagerFactoryServiceName == null) {
                InitialContext context = new InitialContext();
                this.transactionManager = (TransactionManager)context.lookup(TRANSACTION_MANAGER_JNDI_NAME);
            } else {
                TransactionManagerFactory transactionManagerFactory = (TransactionManagerFactory)ServiceManagerFactory.getServiceObject(this.transactionManagerFactoryServiceName);
                this.transactionManager = transactionManagerFactory.getTransactionManager();
            }
        }
        if (this.scheduleExecutorServiceNames != null) {
            this.scheduleExecutors = new HashMap();
            for (int i = 0; i < this.scheduleExecutorServiceNames.length; ++i) {
                ScheduleExecutor executor = (ScheduleExecutor)ServiceManagerFactory.getServiceObject(this.scheduleExecutorServiceNames[i]);
                this.scheduleExecutors.put(executor.getType(), executor);
            }
        }
        if (this.scheduleExecutors == null || this.scheduleExecutors.size() == 0) {
            throw new IllegalArgumentException("ScheduleExecutor is null.");
        }
        if (this.scheduleManagerServiceName != null) {
            this.scheduleManager = (ScheduleManager)ServiceManagerFactory.getServiceObject(this.scheduleManagerServiceName);
        }
        if (this.scheduleManager == null) {
            throw new IllegalArgumentException("ScheduleManager is null.");
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
    }

    public void postStartService() throws Exception {
        this.scheduleManager.addScheduleControlListener(this);
        this.scheduleTicker = new Daemon(new ScheduleTicker());
        this.scheduleTicker.setName(this.getServiceNameObject() + " ScheduleTicker");
        this.scheduleTicker.suspend();
        this.scheduleTicker.start();
        if (this.clusterServiceName != null) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            if (this.cluster.isJoin()) {
                throw new IllegalArgumentException("ClusterService already join.");
            }
            this.clusterListener = new ClusterListener();
            this.cluster.addClusterListener(this.clusterListener);
            this.cluster.join();
        } else {
            this.scheduleTicker.resume();
        }
        super.postStartService();
    }

    public void preStopService() throws Exception {
        if (this.scheduleTicker != null) {
            this.scheduleTicker.stop();
        }
        this.scheduleManager.removeScheduleControlListener(this);
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this.clusterListener);
            this.clusterListener = null;
            this.cluster.leave();
            this.cluster = null;
        }
        super.preStopService();
    }

    public void postStopService() throws Exception {
        super.postStopService();
    }

    public void postDestroyService() throws Exception {
        this.scheduleTicker = null;
        super.postDestroyService();
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public void setScheduleManager(ScheduleManager manager) {
        this.scheduleManager = manager;
    }

    public ScheduleExecutor getScheduleExecutor(String type) {
        if (this.scheduleExecutors.size() == 1) {
            ScheduleExecutor executor = (ScheduleExecutor)this.scheduleExecutors.values().iterator().next();
            return type == null || type.equals(executor.getType()) ? executor : null;
        }
        return (ScheduleExecutor)this.scheduleExecutors.get(type);
    }

    public void setScheduleExecutor(ScheduleExecutor executor) {
        this.scheduleExecutors.put(executor.getType(), executor);
    }

    public Map getScheduleExecutors() {
        return this.scheduleExecutors;
    }

    public void startEntry() {
        if (this.scheduleTicker != null) {
            this.scheduleTicker.resume();
        }
    }

    public boolean isStartEntry() {
        return this.scheduleTicker == null ? false : this.scheduleTicker.isRunning() && !this.scheduleTicker.isSusupend();
    }

    public void stopEntry() {
        if (this.scheduleTicker != null) {
            this.scheduleTicker.suspend();
        }
    }

    public void changedControlState(String id, int state) throws ScheduleStateControlException {
        ScheduleExecutor[] executors = this.scheduleExecutors.values().toArray(new ScheduleExecutor[this.scheduleExecutors.size()]);
        for (int i = 0; i < executors.length && !executors[i].controlState(id, state); ++i) {
        }
    }

    protected abstract boolean isTransactableQueue();

    protected abstract void entrySchedule(ScheduleRequest var1) throws Throwable;

    protected void dispatchSchedule(ScheduleRequest request) {
        Schedule schedule;
        ScheduleExecutor scheduleExecutor;
        if (this.threadContext != null) {
            this.threadContext.clear();
        }
        if (this.threadContext != null && request.getRequestId() != null) {
            this.threadContext.put("REQUEST_ID", request.getRequestId());
        }
        if ((scheduleExecutor = this.getScheduleExecutor((schedule = request.getSchedule()).getExecutorType())) == null) {
            this.getLogger().write("AS___00008", new Object[]{schedule.getId(), schedule.getTaskName()});
            try {
                this.scheduleManager.changeState(schedule.getId(), 5);
            }
            catch (ScheduleStateControlException e) {
                this.getLogger().write("AS___00001", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(5)}, (Throwable)e);
            }
            return;
        }
        schedule.setRetry(false);
        schedule.setOutput(null);
        try {
            schedule = scheduleExecutor.execute(schedule);
        }
        catch (Throwable th) {
            this.getLogger().write("AS___00002", new Object[]{schedule.getId(), schedule.getTaskName()}, th);
            try {
                this.scheduleManager.changeState(schedule.getId(), 5);
            }
            catch (ScheduleStateControlException e) {
                this.getLogger().write("AS___00001", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(5)}, (Throwable)e);
            }
            return;
        }
    }

    protected static class ScheduleRequest
    implements Serializable {
        private static final long serialVersionUID = 8405850740460011444L;
        protected Schedule schedule;
        protected String requestId;

        public ScheduleRequest(Schedule schedule) {
            this.schedule = schedule;
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public void setSchedule(Schedule schedule) {
            this.schedule = schedule;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String id) {
            this.requestId = id;
        }
    }

    protected class ScheduleTicker
    implements DaemonRunnable {
        protected ScheduleTicker() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(AbstractSchedulerService.this.getScheduleTickerInterval());
            return null;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void consume(Object schedules, DaemonControl ctrl) throws Throwable {
            block33: {
                block32: {
                    block30: {
                        block31: {
                            rollbackMark = false;
                            scheduleList = null;
                            scheduleRequests = null;
                            try {
                                try {
                                    block36: {
                                        block35: {
                                            if (AbstractSchedulerService.this.isTransactionControl) {
                                                AbstractSchedulerService.this.transactionManager.begin();
                                            }
                                            try {
                                                executorTypes = AbstractSchedulerService.this.scheduleExecutors.keySet().toArray(new String[AbstractSchedulerService.this.scheduleExecutors.size()]);
                                                scheduleList = AbstractSchedulerService.this.executorKey == null ? AbstractSchedulerService.this.scheduleManager.findExecutableSchedules(new Date(), executorTypes) : AbstractSchedulerService.this.scheduleManager.findExecutableSchedules(new Date(), executorTypes, AbstractSchedulerService.this.executorKey);
                                            }
                                            catch (ScheduleManageException e) {
                                                AbstractSchedulerService.this.getLogger().write("AS___00004", e);
                                                rollbackMark = true;
                                                var12_10 = null;
                                                if (AbstractSchedulerService.this.isTransactionControl == false) return;
                                                if (rollbackMark) {
                                                    AbstractSchedulerService.this.transactionManager.rollback();
                                                    return;
                                                }
                                                AbstractSchedulerService.this.transactionManager.commit();
                                                return;
                                            }
                                            if (scheduleList == null) break block35;
                                            if (scheduleList.size() != 0) break block36;
                                        }
                                        var12_11 = null;
                                        if (AbstractSchedulerService.this.isTransactionControl == false) return;
                                        if (!rollbackMark) break block30;
                                        break block31;
                                    }
                                    scheduleRequests = new ArrayList<ScheduleRequest>();
                                    itr = scheduleList.iterator();
                                    while (itr.hasNext()) {
                                        block34: {
                                            schedule = (Schedule)itr.next();
                                            request = new ScheduleRequest(schedule);
                                            if (AbstractSchedulerService.this.sequence != null) {
                                                request.setRequestId(AbstractSchedulerService.this.sequence.increment());
                                                if (AbstractSchedulerService.this.threadContext != null) {
                                                    AbstractSchedulerService.this.threadContext.put("REQUEST_ID", request.getRequestId());
                                                }
                                            }
                                            scheduleRequests.add(request);
                                            try {
                                                nowState = AbstractSchedulerService.this.scheduleManager.getState(schedule.getId());
                                                switch (nowState) {
                                                    case 1: 
                                                    case 8: {
                                                        ** break;
                                                    }
                                                }
                                                AbstractSchedulerService.this.getLogger().write("AS___00006", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(nowState), new Integer(2)});
                                                break block32;
                                            }
                                            catch (ScheduleStateControlException e) {
                                                AbstractSchedulerService.this.getLogger().write("AS___00001", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(2)}, (Throwable)e);
                                                rollbackMark = true;
                                                break block33;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                isChanged = AbstractSchedulerService.this.scheduleManager.changeState(schedule.getId(), nowState, 2);
                                                if (isChanged) break block34;
                                                itr.remove();
                                                AbstractSchedulerService.this.getLogger().write("AS___00006", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(nowState), new Integer(2)});
                                                continue;
                                            }
                                        }
                                        if (AbstractSchedulerService.this.isTransactionControl && !AbstractSchedulerService.this.isTransactableQueue()) continue;
                                        AbstractSchedulerService.this.getLogger().write("AS___00003", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()});
                                        try {
                                            AbstractSchedulerService.this.entrySchedule(request);
                                        }
                                        catch (Throwable th) {
                                            AbstractSchedulerService.this.getLogger().write("AS___00007", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()}, th);
                                            rollbackMark = true;
                                            break block33;
                                        }
                                    }
                                    break block33;
                                }
                                catch (Throwable th) {
                                    AbstractSchedulerService.this.getLogger().write("AS___00005", th);
                                    if (AbstractSchedulerService.this.isTransactionControl == false) throw th;
                                    AbstractSchedulerService.this.transactionManager.rollback();
                                    throw th;
                                }
                            }
                            catch (Throwable var11_24) {
                                var12_14 = null;
                                if (AbstractSchedulerService.this.isTransactionControl == false) throw var11_24;
                                if (rollbackMark) {
                                    AbstractSchedulerService.this.transactionManager.rollback();
                                    throw var11_24;
                                }
                                AbstractSchedulerService.this.transactionManager.commit();
                                throw var11_24;
                            }
                        }
                        AbstractSchedulerService.this.transactionManager.rollback();
                        return;
                    }
                    AbstractSchedulerService.this.transactionManager.commit();
                    return;
                }
                var12_12 = null;
                if (AbstractSchedulerService.this.isTransactionControl == false) return;
                if (rollbackMark) {
                    AbstractSchedulerService.this.transactionManager.rollback();
                    return;
                }
                AbstractSchedulerService.this.transactionManager.commit();
                return;
            }
            var12_13 = null;
            if (AbstractSchedulerService.this.isTransactionControl) {
                if (rollbackMark) {
                    AbstractSchedulerService.this.transactionManager.rollback();
                } else {
                    AbstractSchedulerService.this.transactionManager.commit();
                }
            }
            if (scheduleRequests == null) return;
            if (scheduleRequests.size() == 0) return;
            if (AbstractSchedulerService.this.isTransactionControl == false) return;
            if (AbstractSchedulerService.this.isTransactableQueue() != false) return;
            if (rollbackMark != false) return;
            i = 0;
            imax = scheduleRequests.size();
            while (i < imax) {
                request = (ScheduleRequest)scheduleRequests.get(i);
                if (AbstractSchedulerService.this.threadContext != null && request.getRequestId() != null) {
                    AbstractSchedulerService.this.threadContext.put("REQUEST_ID", request.getRequestId());
                }
                schedule = request.getSchedule();
                AbstractSchedulerService.this.getLogger().write("AS___00003", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()});
                try {
                    AbstractSchedulerService.this.entrySchedule(request);
                }
                catch (Throwable th) {
                    AbstractSchedulerService.this.getLogger().write("AS___00007", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()}, th);
                }
                ++i;
            }
        }

        public void garbage() {
        }
    }

    protected class ClusterListener
    implements jp.ossc.nimbus.service.keepalive.ClusterListener {
        protected ClusterListener() {
        }

        public void memberInit(Object myId, List members) {
        }

        public void memberChange(List oldMembers, List newMembers) {
        }

        public void changeMain() throws Exception {
            AbstractSchedulerService.this.startEntry();
        }

        public void changeSub() {
            AbstractSchedulerService.this.stopEntry();
        }
    }
}

