/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sequence;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.service.sequence.SequenceVariable;

public class TimeSequenceVariable
implements SequenceVariable,
Serializable {
    private static final long serialVersionUID = -2245999458822210565L;
    public static final String FORMAT_KEY = "TIME_SEQ";
    private SimpleDateFormat timeFormat;
    private DecimalFormat numberFormat;
    private int digit;
    private long currentSequence;
    private String currentTime;
    private StringBuffer buf = new StringBuffer();
    private Date date;
    private String current;

    public TimeSequenceVariable(String format) {
        int index = format.indexOf(40);
        if (index == -1 || format.indexOf(41) != format.length() - 1) {
            throw new IllegalArgumentException("Illegal format : " + format);
        }
        String paramStr = format.substring(index + 1, format.length() - 1);
        String[] params = paramStr.split(",");
        if (params.length != 2) {
            throw new IllegalArgumentException("Illegal format : " + format);
        }
        this.timeFormat = new SimpleDateFormat(params[0]);
        int digit = 0;
        try {
            digit = Integer.parseInt(params[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal format : " + format);
        }
        if (digit <= 0 || digit > 18) {
            throw new IllegalArgumentException("Illegal format : " + format);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < digit; ++i) {
            buf.append('0');
        }
        this.digit = digit;
        this.numberFormat = new DecimalFormat(buf.toString());
        this.date = new Date();
        this.date.setTime(System.currentTimeMillis());
        this.currentTime = this.timeFormat.format(this.date);
        this.currentSequence = -1L;
        this.increment();
    }

    public TimeSequenceVariable(String timeFormat, int digit) {
    }

    public boolean increment() {
        boolean isOver = false;
        this.date.setTime(System.currentTimeMillis());
        String time = this.timeFormat.format(this.date);
        String seq = null;
        if (time.equals(this.currentTime)) {
            ++this.currentSequence;
            seq = this.numberFormat.format(this.currentSequence);
            if (seq.length() != this.digit) {
                this.currentSequence = 1L;
                seq = this.numberFormat.format(this.currentSequence);
                isOver = true;
            }
        } else {
            this.currentSequence = 1L;
            seq = this.numberFormat.format(this.currentSequence);
        }
        this.currentTime = time;
        this.buf.setLength(0);
        this.buf.append(time);
        this.buf.append(seq);
        this.current = this.buf.toString();
        return isOver;
    }

    public void clear() {
        this.currentSequence = -1L;
        this.increment();
    }

    public String getCurrent() {
        return this.current;
    }
}

