/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.server.BeanFlowInvokerCallQueueHandlerServiceMBean;
import jp.ossc.nimbus.service.server.RequestContext;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.StreamConverter;

public class BeanFlowInvokerCallQueueHandlerService
extends ServiceBase
implements QueueHandler,
BeanFlowInvokerCallQueueHandlerServiceMBean {
    private static final long serialVersionUID = 6110742740354448821L;
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected BeanFlowInvokerFactory beanFlowInvokerFactory;
    protected ServiceName requestStreamConverterServiceName;
    protected StreamConverter requestStreamConverter;
    protected ServiceName responseStreamConverterServiceName;
    protected StreamConverter responseStreamConverter;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected String actionFlowNamePrefix = "action/";
    protected String requestObjectFlowNamePrefix = "request/";
    protected int normalStatus = 200;
    protected int notFoundStatus = 404;
    protected int errorStatus = 500;
    protected String errorLogMessageId;
    protected String retryOverErrorLogMessageId;

    public void setRequestStreamConverterServiceName(ServiceName name) {
        this.requestStreamConverterServiceName = name;
    }

    public ServiceName getRequestStreamConverterServiceName() {
        return this.requestStreamConverterServiceName;
    }

    public void setResponseStreamConverterServiceName(ServiceName name) {
        this.responseStreamConverterServiceName = name;
    }

    public ServiceName getResponseStreamConverterServiceName() {
        return this.responseStreamConverterServiceName;
    }

    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setRequestObjectFlowNamePrefix(String prefix) {
        this.requestObjectFlowNamePrefix = prefix;
    }

    public String getRequestObjectFlowNamePrefix() {
        return this.requestObjectFlowNamePrefix;
    }

    public void setActionFlowNamePrefix(String prefix) {
        this.actionFlowNamePrefix = prefix;
    }

    public String getActionFlowNamePrefix() {
        return this.actionFlowNamePrefix;
    }

    public int getNormalStatus() {
        return this.normalStatus;
    }

    public void setNormalStatus(int status) {
        this.normalStatus = status;
    }

    public int getNotFoundStatus() {
        return this.notFoundStatus;
    }

    public void setNotFoundStatus(int status) {
        this.notFoundStatus = status;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public void setErrorStatus(int status) {
        this.errorStatus = status;
    }

    public String getErrorLogMessageId() {
        return this.errorLogMessageId;
    }

    public void setErrorLogMessageId(String id) {
        this.errorLogMessageId = id;
    }

    public String getRetryOverErrorLogMessageId() {
        return this.retryOverErrorLogMessageId;
    }

    public void setRetryOverErrorLogMessageId(String id) {
        this.retryOverErrorLogMessageId = id;
    }

    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvoker is null.");
        }
        if (this.requestStreamConverterServiceName == null && this.requestStreamConverter == null) {
            throw new IllegalArgumentException("It is necessary to specify RequestStreamConverterServiceName or RequestStreamConverter.");
        }
        if (this.requestStreamConverterServiceName != null) {
            this.requestStreamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.requestStreamConverterServiceName);
        }
        if (this.responseStreamConverterServiceName == null && this.responseStreamConverter == null) {
            throw new IllegalArgumentException("It is necessary to specify ResponseStreamConverterServiceName or ResponseStreamConverter.");
        }
        if (this.responseStreamConverterServiceName != null) {
            this.responseStreamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.responseStreamConverterServiceName);
        }
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
        return this.beanFlowInvokerFactory;
    }

    public void setRequestStreamConverter(StreamConverter conv) {
        this.requestStreamConverter = conv;
    }

    public StreamConverter getRequestStreamConverter() {
        return this.requestStreamConverter;
    }

    public void setResponseStreamConverter(StreamConverter conv) {
        this.responseStreamConverter = conv;
    }

    public StreamConverter getResponseStreamConverter() {
        return this.responseStreamConverter;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDequeuedObject(Object obj) throws Throwable {
        block30: {
            if (obj == null) {
                return;
            }
            RequestContext context = (RequestContext)obj;
            try {
                String requestObjectFlowName;
                String actionFlowName;
                String requestId;
                if (this.threadContext != null) {
                    this.threadContext.clear();
                }
                if ((requestId = context.getRequest().getRequestId()) != null && this.threadContext != null) {
                    this.threadContext.put("REQUEST_ID", requestId);
                }
                if (this.journal != null) {
                    this.journal.startJournal("Access");
                    if (requestId != null) {
                        this.journal.setRequestId(requestId);
                    }
                    this.journal.addInfo("Action", context.getRequest().getAction());
                    this.journal.addInfo("Date", context.getRequest().getDate());
                    this.journal.addInfo("RemoteHost", context.getRequest().getRemoteHost());
                    this.journal.addInfo("RemotePort", new Integer(context.getRequest().getRemotePort()));
                }
                if (!this.beanFlowInvokerFactory.containsFlow(actionFlowName = this.actionFlowNamePrefix + context.getRequest().getAction())) {
                    context.getResponse().setStatus(this.notFoundStatus);
                    try {
                        context.getResponse().response();
                    }
                    catch (IOException e) {
                    }
                    Object var13_7 = null;
                    if (this.journal != null) {
                        this.journal.endJournal();
                    }
                    if (this.threadContext != null) {
                        this.threadContext.clear();
                    }
                    return;
                }
                Object requestObj = null;
                InputStream requestStream = context.getRequest().getInputStream();
                if (this.journal != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    int readLen = 0;
                    while ((readLen = requestStream.read(bytes)) > 0) {
                        baos.write(bytes, 0, readLen);
                    }
                    bytes = baos.toByteArray();
                    this.journal.addInfo("RequestBody", bytes);
                    requestStream = new ByteArrayInputStream(bytes);
                }
                if (this.requestStreamConverter instanceof BindingStreamConverter && this.beanFlowInvokerFactory.containsFlow(requestObjectFlowName = this.requestObjectFlowNamePrefix + context.getRequest().getAction())) {
                    requestObj = this.beanFlowInvokerFactory.createFlow(requestObjectFlowName).invokeFlow(context);
                }
                requestObj = requestObj != null ? ((BindingStreamConverter)this.requestStreamConverter).convertToObject(requestStream, requestObj) : this.requestStreamConverter.convertToObject(requestStream);
                if (this.journal != null) {
                    this.journal.addInfo("RequestObject", requestObj);
                }
                Object responseObject = this.beanFlowInvokerFactory.createFlow(actionFlowName).invokeFlow(requestObj);
                if (this.journal != null) {
                    this.journal.addInfo("ResponseObject", responseObject);
                }
                if (responseObject == null) {
                    context.getResponse().setStatus(this.normalStatus);
                    if (this.journal != null) {
                        this.journal.addInfo("Status", new Integer(this.normalStatus));
                    }
                    try {
                        context.getResponse().response();
                    }
                    catch (IOException e) {}
                    break block30;
                }
                InputStream responseStream = this.responseStreamConverter.convertToStream(responseObject);
                if (this.journal != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    int readLen = 0;
                    while ((readLen = responseStream.read(bytes)) > 0) {
                        baos.write(bytes, 0, readLen);
                    }
                    bytes = baos.toByteArray();
                    this.journal.addInfo("ResponseBody", bytes);
                    responseStream = new ByteArrayInputStream(bytes);
                }
                context.getResponse().setStatus(this.normalStatus);
                if (this.journal != null) {
                    this.journal.addInfo("Status", new Integer(this.normalStatus));
                }
                try {
                    context.getResponse().response(responseStream);
                }
                catch (IOException e) {
                }
            }
            catch (Throwable throwable) {
                Object var13_9 = null;
                if (this.journal != null) {
                    this.journal.endJournal();
                }
                if (this.threadContext != null) {
                    this.threadContext.clear();
                }
                throw throwable;
            }
        }
        Object var13_8 = null;
        if (this.journal != null) {
            this.journal.endJournal();
        }
        if (this.threadContext != null) {
            this.threadContext.clear();
        }
    }

    public boolean handleError(Object obj, Throwable th) throws Throwable {
        RequestContext context = (RequestContext)obj;
        if (this.errorLogMessageId != null) {
            this.getLogger().write(this.errorLogMessageId, (Object)context.getRequest().getAction(), th);
        }
        return true;
    }

    public void handleRetryOver(Object obj, Throwable th) throws Throwable {
        RequestContext context = (RequestContext)obj;
        if (this.retryOverErrorLogMessageId != null) {
            this.getLogger().write(this.retryOverErrorLogMessageId, (Object)context.getRequest().getAction(), th);
        }
        context.getResponse().setStatus(this.errorStatus);
        if (this.journal != null) {
            this.journal.addInfo("Status", new Integer(this.errorStatus));
            this.journal.addInfo("Exception", th);
        }
        try {
            context.getResponse().response();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

