/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.util.converter.BindingConverter;
import jp.ossc.nimbus.util.converter.ConvertException;

public class BeanExchangeConverter
implements BindingConverter {
    private Object output;
    private Map propertyMapping;
    private PropertyAccess propertyAccess = new PropertyAccess();
    private boolean isCloneOutput = false;

    public BeanExchangeConverter() {
    }

    public BeanExchangeConverter(Map mapping) {
        this.setPropertyMappings(mapping);
    }

    public BeanExchangeConverter(Map mapping, Object output) {
        this.setPropertyMappings(mapping);
        this.setOutputObject(output);
    }

    public void setOutputObject(Object obj) {
        this.output = obj;
    }

    public Object getOutputObject() {
        return this.output;
    }

    public void setPropertyMapping(String inputProperty, String outputProperty) {
        Object outProp;
        if (this.propertyMapping == null) {
            this.propertyMapping = new HashMap();
        }
        if ((outProp = this.propertyMapping.get(inputProperty)) == null) {
            this.propertyMapping.put(inputProperty, outputProperty);
        } else {
            ArrayList<Object> outProps = null;
            if (outProp instanceof String) {
                outProps = new ArrayList<Object>();
                outProps.add(outProp);
            } else {
                outProps = (ArrayList<Object>)outProp;
            }
            outProps.add(outputProperty);
        }
    }

    public Object getPropertyMapping(String inputProperty) {
        if (this.propertyMapping == null) {
            return null;
        }
        return this.propertyMapping.get(inputProperty);
    }

    public void setPropertyMappings(Map mapping) {
        this.propertyMapping = mapping;
    }

    public Map getPropertyMappings() {
        return this.propertyMapping;
    }

    public void setCloneOutput(boolean isClone) {
        this.isCloneOutput = isClone;
    }

    public boolean isCloneOutput() {
        return this.isCloneOutput;
    }

    public Object convert(Object obj) throws ConvertException {
        return this.convert(obj, this.output);
    }

    public Object convert(Object input, Object output) throws ConvertException {
        return this.convert(input, output, this.isCloneOutput);
    }

    private Object convert(Object input, Object output, boolean isClone) throws ConvertException {
        if (output == null) {
            throw new ConvertException("Output is null.");
        }
        if (isClone) {
            if (!(output instanceof Cloneable)) {
                throw new ConvertException("Output is not cloneable.");
            }
            if (output instanceof DataSet) {
                output = ((DataSet)output).cloneSchema();
            } else if (output instanceof RecordList) {
                output = ((RecordList)output).cloneSchema();
            } else if (output instanceof Record) {
                output = ((Record)output).cloneSchema();
            } else {
                try {
                    output = output.getClass().getMethod("clone", null).invoke(output, (Object[])null);
                }
                catch (NoSuchMethodException e) {
                    throw new ConvertException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ConvertException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ConvertException(e);
                }
            }
        }
        if (input == null) {
            return output;
        }
        Object[] inputs = null;
        if (input instanceof Collection) {
            inputs = ((Collection)input).toArray();
        } else if (input.getClass().isArray()) {
            inputs = (Object[])input;
        }
        if (inputs != null) {
            if (inputs.length == 0) {
                return output;
            }
            if (output instanceof RecordList) {
                RecordList list = (RecordList)output;
                for (int i = 0; i < inputs.length; ++i) {
                    Record record = list.createRecord();
                    list.add(this.convert(inputs[i], record, false));
                }
                return list;
            }
            if (output instanceof Collection) {
                Object[] outputs = ((Collection)output).toArray();
                if (outputs.length == 0) {
                    throw new ConvertException("Size of collection is 0.");
                }
                int imax = Math.min(inputs.length, outputs.length);
                for (int i = 0; i < imax; ++i) {
                    outputs[i] = this.convert(inputs[i], outputs[i], false);
                }
                return outputs;
            }
            if (output.getClass().isArray()) {
                int i;
                Object[] outputs = (Object[])output;
                Class<?> componentType = output.getClass().getComponentType();
                if (outputs.length == 0) {
                    if (componentType.isInterface() || componentType.isPrimitive()) {
                        throw new ConvertException("Length of array is 0.");
                    }
                    outputs = (Object[])Array.newInstance(componentType, inputs.length);
                    try {
                        for (i = 0; i < outputs.length; ++i) {
                            outputs[i] = componentType.newInstance();
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new ConvertException("Length of array is 0.", e);
                    }
                    catch (InstantiationException e) {
                        throw new ConvertException("Length of array is 0.", e);
                    }
                }
                int imax = Math.min(inputs.length, outputs.length);
                for (i = 0; i < imax; ++i) {
                    if (outputs[i] == null) {
                        if (componentType.isInterface() || componentType.isPrimitive()) {
                            throw new ConvertException("Element of array is null.");
                        }
                        try {
                            outputs[i] = componentType.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            throw new ConvertException("Element of array is null.", e);
                        }
                        catch (InstantiationException e) {
                            throw new ConvertException("Element of array is null.", e);
                        }
                    }
                    outputs[i] = this.convert(inputs[i], outputs[i], false);
                }
                return outputs;
            }
        }
        HashMap<String, String> propMapping = this.propertyMapping;
        boolean isOutputAutoMapping = false;
        boolean isInputAutoMapping = false;
        if (propMapping == null || propMapping.size() == 0) {
            SimpleProperty[] props;
            int i;
            int imax;
            Record record;
            if (propMapping == null) {
                propMapping = new HashMap<String, String>();
            }
            if (output instanceof Record) {
                record = (Record)output;
                RecordSchema schema = record.getRecordSchema();
                if (schema != null) {
                    imax = schema.getPropertySize();
                    for (i = 0; i < imax; ++i) {
                        propMapping.put(schema.getPropertyName(i), schema.getPropertyName(i));
                    }
                }
                if (propMapping.size() != 0) {
                    isOutputAutoMapping = true;
                }
            } else {
                props = SimpleProperty.getProperties(output);
                for (int i2 = 0; i2 < props.length; ++i2) {
                    if (!props[i2].isWritable(output.getClass())) continue;
                    propMapping.put(props[i2].getPropertyName(), props[i2].getPropertyName());
                }
                if (propMapping.size() != 0) {
                    isOutputAutoMapping = true;
                }
            }
            if (!isOutputAutoMapping) {
                if (input instanceof Record) {
                    record = (Record)input;
                    RecordSchema schema = record.getRecordSchema();
                    if (schema != null) {
                        imax = schema.getPropertySize();
                        for (i = 0; i < imax; ++i) {
                            propMapping.put(schema.getPropertyName(i), schema.getPropertyName(i));
                        }
                    }
                    if (propMapping.size() != 0) {
                        isInputAutoMapping = true;
                    }
                } else {
                    props = SimpleProperty.getProperties(input);
                    for (int i3 = 0; i3 < props.length; ++i3) {
                        if (!props[i3].isReadable(input.getClass())) continue;
                        propMapping.put(props[i3].getPropertyName(), props[i3].getPropertyName());
                    }
                    if (propMapping.size() != 0) {
                        isInputAutoMapping = true;
                    }
                }
            }
            if (propMapping.size() == 0) {
                throw new ConvertException("PropertyMapping is null.");
            }
        }
        Iterator entries = propMapping.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String inputProp = (String)entry.getKey();
            Object value = null;
            try {
                value = this.propertyAccess.get(input, inputProp);
            }
            catch (IllegalArgumentException e) {
                throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
            }
            catch (NoSuchPropertyException e) {
                if (isOutputAutoMapping) continue;
                throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
            }
            catch (InvocationTargetException e) {
                throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
            }
            Object outputProp = entry.getValue();
            if (outputProp instanceof String) {
                try {
                    this.propertyAccess.set(output, (String)outputProp, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
                }
                catch (NoSuchPropertyException e) {
                    if (isInputAutoMapping) continue;
                    throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
                }
                catch (InvocationTargetException e) {
                    throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
                }
            }
            List outputProps = (List)outputProp;
            try {
                int imax = outputProps.size();
                for (int i = 0; i < imax; ++i) {
                    this.propertyAccess.set(output, (String)outputProps.get(i), value);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
            }
            catch (NoSuchPropertyException e) {
                if (isInputAutoMapping) continue;
                throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
            }
            catch (InvocationTargetException e) {
                throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
            }
        }
        return output;
    }
}

