/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerCreateException;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactoryServiceMBean;
import jp.ossc.nimbus.service.jms.JMSSessionCreateException;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class JMSMessageConsumerFactoryService
extends ServiceBase
implements JMSMessageConsumerFactory,
JMSMessageConsumerFactoryServiceMBean {
    private static final long serialVersionUID = 2488707181233003821L;
    protected ServiceName jmsSessionFactoryServiceName;
    protected JMSSessionFactory jmsSessionFactory;
    protected ServiceName destinationFinderServiceName;
    protected JndiFinder destinationFinder;
    protected String destinationName;
    protected Destination destination;
    protected String messageSelector;
    protected boolean isNoLocal;
    protected Session session;
    protected boolean isSessionCreate;
    protected boolean isCloseSession;

    @Override
    public void setJMSSessionFactoryServiceName(ServiceName name) {
        this.jmsSessionFactoryServiceName = name;
    }

    @Override
    public ServiceName getJMSSessionFactoryServiceName() {
        return this.jmsSessionFactoryServiceName;
    }

    @Override
    public void setDestinationFinderServiceName(ServiceName name) {
        this.destinationFinderServiceName = name;
    }

    @Override
    public ServiceName getDestinationFinderServiceName() {
        return this.destinationFinderServiceName;
    }

    @Override
    public void setDestinationName(String name) {
        this.destinationName = name;
    }

    @Override
    public String getDestinationName() {
        return this.destinationName;
    }

    @Override
    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    @Override
    public String getMessageSelector() {
        return this.messageSelector;
    }

    @Override
    public void setNoLocal(boolean isNoLocal) {
        this.isNoLocal = isNoLocal;
    }

    @Override
    public boolean isNoLocal() {
        return this.isNoLocal;
    }

    @Override
    public void setSessionCreate(boolean isCreate) {
        this.isSessionCreate = isCreate;
    }

    @Override
    public boolean isSessionCreate() {
        return this.isSessionCreate;
    }

    @Override
    public void setCloseSession(boolean isClose) {
        this.isCloseSession = isClose;
    }

    @Override
    public boolean isCloseSession() {
        return this.isCloseSession;
    }

    public void setJndiFinder(JndiFinder destinationFinder) {
        this.destinationFinder = destinationFinder;
    }

    public void setJMSSessionFactory(JMSSessionFactory jmsSessionFactory) {
        this.jmsSessionFactory = jmsSessionFactory;
    }

    @Override
    public void startService() throws Exception {
        if (this.jmsSessionFactoryServiceName != null) {
            this.jmsSessionFactory = (JMSSessionFactory)ServiceManagerFactory.getServiceObject(this.jmsSessionFactoryServiceName);
        }
        if (this.destinationFinderServiceName != null) {
            this.destinationFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.destinationFinderServiceName);
            this.destination = this.destinationName == null ? (Destination)this.destinationFinder.lookup() : (Destination)this.destinationFinder.lookup(this.destinationName);
        }
        if (this.isSessionCreate) {
            if (this.jmsSessionFactory == null) {
                throw new IllegalArgumentException("jmsSessionFactoryServiceName must be specified.");
            }
            this.session = this.jmsSessionFactory.getSession();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isCloseSession && this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.session = null;
        this.destination = null;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public JMSSessionFactory getSessionFactory() {
        return this.jmsSessionFactory;
    }

    @Override
    public MessageConsumer createConsumer() throws JMSMessageConsumerCreateException {
        return this.createConsumer(this.messageSelector);
    }

    @Override
    public MessageConsumer createConsumer(String messageSelector) throws JMSMessageConsumerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageConsumerCreateException(e);
            }
        }
        return this.createConsumer(session, messageSelector);
    }

    @Override
    public MessageConsumer createConsumer(String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageConsumerCreateException(e);
            }
        }
        return this.createConsumer(session, messageSelector, noLocal);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSMessageConsumerCreateException {
        return this.createConsumer(destination, this.messageSelector);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSMessageConsumerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageConsumerCreateException(e);
            }
        }
        return this.createConsumer(session, destination, messageSelector);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageConsumerCreateException(e);
            }
        }
        return this.createConsumer(session, destination, messageSelector, noLocal);
    }

    @Override
    public MessageConsumer createConsumer(Session session) throws JMSMessageConsumerCreateException {
        return this.createConsumer(session, this.destination);
    }

    @Override
    public MessageConsumer createConsumer(Session session, String messageSelector) throws JMSMessageConsumerCreateException {
        return this.createConsumer(session, this.destination, messageSelector);
    }

    @Override
    public MessageConsumer createConsumer(Session session, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        return this.createConsumer(session, this.destination, messageSelector, noLocal);
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination) throws JMSMessageConsumerCreateException {
        return this.createConsumer(session, destination, this.messageSelector);
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector) throws JMSMessageConsumerCreateException {
        if (session == null) {
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if (destination == null) {
            throw new JMSMessageConsumerCreateException("Destination is null.");
        }
        try {
            return session.createConsumer(destination, messageSelector);
        }
        catch (JMSException e) {
            throw new JMSMessageConsumerCreateException(e);
        }
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        if (session == null) {
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if (destination == null) {
            throw new JMSMessageConsumerCreateException("Destination is null.");
        }
        try {
            return session.createConsumer(destination, messageSelector, noLocal);
        }
        catch (JMSException e) {
            throw new JMSMessageConsumerCreateException(e);
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(String name) throws JMSMessageConsumerCreateException {
        return this.createDurableSubscriber(this.session, name);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSMessageConsumerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageConsumerCreateException(e);
            }
        }
        return this.createDurableSubscriber(session, topic, name);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Session session, String name) throws JMSMessageConsumerCreateException {
        if (this.destination == null) {
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        if (!(this.destination instanceof Topic)) {
            throw new JMSMessageConsumerCreateException("Destination is not topic.");
        }
        return this.createDurableSubscriber(session, (Topic)this.destination, name);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Session session, Topic topic, String name) throws JMSMessageConsumerCreateException {
        if (session == null) {
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if (topic == null) {
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        try {
            return session.createDurableSubscriber(topic, name);
        }
        catch (JMSException e) {
            throw new JMSMessageConsumerCreateException(e);
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(String name, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageConsumerCreateException(e);
            }
        }
        return this.createDurableSubscriber(session, name, messageSelector, noLocal);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageConsumerCreateException(e);
            }
        }
        return this.createDurableSubscriber(session, topic, name, messageSelector, noLocal);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Session session, String name, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        if (this.destination == null) {
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        if (!(this.destination instanceof Topic)) {
            throw new JMSMessageConsumerCreateException("Destination is not topic.");
        }
        return this.createDurableSubscriber(session, (Topic)this.destination, name, messageSelector, noLocal);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Session session, Topic topic, String name, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        if (session == null) {
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if (topic == null) {
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        try {
            return session.createDurableSubscriber(topic, name, messageSelector, noLocal);
        }
        catch (JMSException e) {
            throw new JMSMessageConsumerCreateException(e);
        }
    }
}

