/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.msgresource.MessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageResourceOperator;

public class MessageResourceImpl
implements MessageResourceOperator {
    private HashMap mBlFlowHash = new HashMap();
    private MessageFormat mSendMessageFormat = null;
    private MessageFormat mRecvMessageFormat = null;
    private String mDisplayStr = null;
    private String mKey = null;

    @Override
    public String getBLFlow(String pat) {
        return (String)this.mBlFlowHash.get(pat);
    }

    @Override
    public void setDisplayMessage(String msg) {
        this.mDisplayStr = msg;
    }

    @Override
    public void setKey(String key) {
        this.mKey = key;
    }

    @Override
    public String display() {
        return this.mDisplayStr;
    }

    @Override
    public String getKey() {
        return this.mKey;
    }

    @Override
    public Message makeMessage(QueueSession session) {
        return this.mSendMessageFormat.unMarshal(session);
    }

    @Override
    public String toString(Message msg, String kind) {
        String ret = null;
        if (kind.equals("send")) {
            try {
                if (msg instanceof BytesMessage) {
                    ((BytesMessage)msg).reset();
                } else if (msg instanceof StreamMessage) {
                    ((StreamMessage)msg).reset();
                }
            }
            catch (JMSException e) {
                throw new ServiceException("MESSAGERESOURCEFACTORY006", "Bytes(Stream)Message's reset() method failed.");
            }
            ret = this.mSendMessageFormat.marshal(msg);
        } else if (kind.equals("recv")) {
            ret = this.mRecvMessageFormat.marshal(msg);
        }
        return ret;
    }

    @Override
    public void addBLFlowKey(String key, String value) {
        this.mBlFlowHash.put(key, value);
    }

    @Override
    public void setMessageFormat(MessageFormat messageFormat, String kind) {
        if (kind.equals("send")) {
            this.mSendMessageFormat = messageFormat;
        } else if (kind.equals("recv")) {
            this.mRecvMessageFormat = messageFormat;
        }
    }
}

