/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCreateException;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;

public class GroupServerConnectionImpl
implements ServerConnection {
    private Map connctionMap = Collections.synchronizedMap(new LinkedHashMap());

    public void addServerConnection(String subject, Pattern keyPattern, ServerConnection connection) {
        ArrayList<ServerConnectionImpl> connections = (ArrayList<ServerConnectionImpl>)this.connctionMap.get(subject);
        if (connections == null) {
            connections = new ArrayList<ServerConnectionImpl>();
            this.connctionMap.put(subject, connections);
        }
        connections.add(new ServerConnectionImpl(subject, keyPattern, connection));
    }

    @Override
    public Message createMessage(String subject, String key) throws MessageCreateException {
        List connections = (List)this.connctionMap.get(subject);
        if (connections == null) {
            throw new MessageCreateException("ServerConnection not found. subject=" + subject + ", key=" + key);
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
            if (!connection.isMatch(subject, key)) continue;
            return connection.createMessage(subject, key);
        }
        throw new MessageCreateException("ServerConnection not found. subject=" + subject + ", key=" + key);
    }

    @Override
    public Message castMessage(Message message) throws MessageException {
        String subject = message.getSubject();
        String key = message.getKey();
        List connections = (List)this.connctionMap.get(subject);
        if (connections == null) {
            throw new MessageCreateException("ServerConnection not found. subject=" + subject + ", key=" + key);
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
            if (!connection.isMatch(subject, key)) continue;
            return connection.castMessage(message);
        }
        throw new MessageException("ServerConnection not found. subject=" + subject + ", key=" + key);
    }

    @Override
    public void send(Message message) throws MessageSendException {
        List connections = (List)this.connctionMap.get(message.getSubject());
        if (connections == null) {
            throw new MessageSendException("ServerConnection not found. subject=" + message.getSubject() + ", key=" + message.getKey());
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
            if (!connection.isMatch(message.getSubject(), message.getKey())) continue;
            connection.send(message);
            return;
        }
        throw new MessageSendException("ServerConnection not found. subject=" + message.getSubject() + ", key=" + message.getKey());
    }

    @Override
    public void sendAsynch(Message message) throws MessageSendException {
        List connections = (List)this.connctionMap.get(message.getSubject());
        if (connections == null) {
            throw new MessageSendException("ServerConnection not found. subject=" + message.getSubject() + ", key=" + message.getKey());
        }
        int imax = connections.size();
        for (int i = 0; i < imax; ++i) {
            ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
            if (!connection.isMatch(message.getSubject(), message.getKey())) continue;
            connection.sendAsynch(message);
            return;
        }
        throw new MessageSendException("ServerConnection not found. subject=" + message.getSubject() + ", key=" + message.getKey());
    }

    @Override
    public void addServerConnectionListener(ServerConnectionListener listener) {
        if (this.connctionMap != null) {
            for (List connections : this.connctionMap.values()) {
                if (connections == null) continue;
                int imax = connections.size();
                for (int i = 0; i < imax; ++i) {
                    ServerConnection connection = (ServerConnection)connections.get(i);
                    connection.addServerConnectionListener(listener);
                }
            }
        }
    }

    @Override
    public void removeServerConnectionListener(ServerConnectionListener listener) {
        if (this.connctionMap != null) {
            for (List connections : this.connctionMap.values()) {
                if (connections == null) continue;
                int imax = connections.size();
                for (int i = 0; i < imax; ++i) {
                    ServerConnection connection = (ServerConnection)connections.get(i);
                    connection.removeServerConnectionListener(listener);
                }
            }
        }
    }

    @Override
    public int getClientCount() {
        if (this.connctionMap.size() == 0) {
            return 0;
        }
        Iterator itr = this.connctionMap.values().iterator();
        int result = 0;
        while (itr.hasNext()) {
            List connections = (List)itr.next();
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
                result += connection.getClientCount();
            }
        }
        return result;
    }

    @Override
    public Set getClientIds() {
        HashSet result = new HashSet();
        for (List connections : this.connctionMap.values()) {
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
                result.addAll(connection.getClientIds());
            }
        }
        return result;
    }

    @Override
    public Set getReceiveClientIds(Message message) {
        HashSet result = new HashSet();
        for (List connections : this.connctionMap.values()) {
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
                result.addAll(connection.getReceiveClientIds(message));
            }
        }
        return result;
    }

    @Override
    public Set getSubjects(Object id) {
        HashSet result = null;
        for (List connections : this.connctionMap.values()) {
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
                Set subjects = connection.getSubjects(id);
                if (subjects == null) continue;
                if (result == null) {
                    result = new HashSet();
                }
                result.addAll(subjects);
            }
        }
        return result;
    }

    @Override
    public Set getKeys(Object id, String subject) {
        HashSet result = null;
        for (List connections : this.connctionMap.values()) {
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ServerConnectionImpl connection = (ServerConnectionImpl)connections.get(i);
                Set keys = connection.getKeys(id, subject);
                if (keys == null) continue;
                if (result == null) {
                    result = new HashSet();
                }
                result.addAll(keys);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("connctionMap=").append(this.connctionMap);
        buf.append('}');
        return buf.toString();
    }

    private static class ServerConnectionImpl
    implements ServerConnection {
        private String subject;
        private Pattern keyPattern;
        private ServerConnection connection;

        public ServerConnectionImpl(String subject, Pattern keyPattern, ServerConnection connection) {
            this.subject = subject;
            this.keyPattern = keyPattern;
            this.connection = connection;
        }

        public boolean isMatch(String subject, String key) {
            return !(this.subject == null && subject != null || this.subject != null && subject == null || this.subject != null && !this.subject.equals(subject) || this.keyPattern != null && key == null) && (this.keyPattern == null || this.keyPattern.matcher(key).matches());
        }

        @Override
        public Message createMessage(String subject, String key) throws MessageCreateException {
            return this.connection.createMessage(subject, key);
        }

        @Override
        public Message castMessage(Message message) throws MessageException {
            return this.connection.castMessage(message);
        }

        @Override
        public void send(Message message) throws MessageSendException {
            this.connection.send(message);
        }

        @Override
        public void sendAsynch(Message message) throws MessageSendException {
            this.connection.sendAsynch(message);
        }

        @Override
        public void addServerConnectionListener(ServerConnectionListener listener) {
            this.connection.addServerConnectionListener(listener);
        }

        @Override
        public void removeServerConnectionListener(ServerConnectionListener listener) {
            this.connection.removeServerConnectionListener(listener);
        }

        @Override
        public int getClientCount() {
            return this.connection.getClientCount();
        }

        @Override
        public Set getClientIds() {
            return this.connection.getClientIds();
        }

        @Override
        public Set getReceiveClientIds(Message message) {
            return this.connection.getReceiveClientIds(message);
        }

        @Override
        public Set getSubjects(Object id) {
            return this.connection.getSubjects(id);
        }

        @Override
        public Set getKeys(Object id, String subject) {
            return this.connection.getKeys(id, subject);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("subject=").append(this.subject);
            buf.append(", key=").append(this.keyPattern == null ? null : this.keyPattern.pattern());
            buf.append(", connection=").append(this.connection);
            buf.append('}');
            return buf.toString();
        }
    }
}

