/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.Serializable;

public class ConcentrateRequest
implements Serializable {
    private static final long serialVersionUID = -5534337631451607056L;
    public static final String PROCESS_TYPE_GET = "GET";
    public static final String PROCESS_TYPE_PUT = "PUT";
    public static final int PROCESS_TYPE_VALUE_GET = 1;
    public static final int PROCESS_TYPE_VALUE_PUT = 2;
    private String key;
    private String source;
    private String destination;
    private int processType;

    public ConcentrateRequest() {
    }

    public ConcentrateRequest(String key, int type, String src, String dest) {
        this.key = key;
        this.source = src;
        this.destination = dest;
        this.processType = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String src) {
        this.source = src;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public int getProcessType() {
        return this.processType;
    }

    public void setProcessType(int type) {
        this.processType = type;
    }

    public static String toProcessTypeString(int type) {
        switch (type) {
            case 1: {
                return PROCESS_TYPE_GET;
            }
            case 2: {
                return PROCESS_TYPE_PUT;
            }
        }
        return null;
    }

    public static int toProcessType(String type) {
        if (type == null) {
            return 0;
        }
        if (PROCESS_TYPE_GET.equals(type.toUpperCase())) {
            return 1;
        }
        if (PROCESS_TYPE_PUT.equals(type.toUpperCase())) {
            return 2;
        }
        return 0;
    }
}

