/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CodeMasterUpdateKey
implements Serializable {
    private static final long serialVersionUID = -4013884085932487915L;
    public static final int UPDATE_TYPE_ADD = 1;
    public static final int UPDATE_TYPE_UPDATE = 2;
    public static final int UPDATE_TYPE_REMOVE = 3;
    private Map keyMap;
    private int updateType = 2;
    private Object input;

    public Object getKey(int index) {
        if (index < 0 || this.keyMap == null || this.keyMap.size() <= index) {
            return null;
        }
        Iterator keys = this.keyMap.values().iterator();
        int i = 0;
        while (i++ < index) {
            keys.next();
        }
        return keys.next();
    }

    public Object getKey(String name) {
        if (this.keyMap == null) {
            return null;
        }
        return this.keyMap.get(name);
    }

    public Object[] getKeyArray() {
        if (this.keyMap == null || this.keyMap.size() == 0) {
            return new Object[0];
        }
        return this.keyMap.values().toArray();
    }

    public List getKeyList() {
        if (this.keyMap == null || this.keyMap.size() == 0) {
            return new ArrayList();
        }
        return new ArrayList(this.keyMap.values());
    }

    public Map getKeyMap() {
        if (this.keyMap == null || this.keyMap.size() == 0) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.keyMap);
    }

    public int getKeySize() {
        return this.keyMap == null ? 0 : this.keyMap.size();
    }

    public void setKeyArray(Object[] keys) {
        if (keys == null || keys.length == 0) {
            this.keyMap = null;
        } else {
            if (this.keyMap == null) {
                this.keyMap = new LinkedHashMap();
            } else {
                this.keyMap.clear();
            }
            for (int i = 0; i < keys.length; ++i) {
                this.addKey(keys[i]);
            }
        }
    }

    public void setKeyList(List keys) {
        if (keys == null || keys.size() == 0) {
            this.keyMap = null;
        } else {
            if (this.keyMap == null) {
                this.keyMap = new LinkedHashMap();
            } else {
                this.keyMap.clear();
            }
            int imax = keys.size();
            for (int i = 0; i < imax; ++i) {
                this.addKey(keys.get(i));
            }
        }
    }

    public void setKeyMap(Map keyMap) {
        if (keyMap == null) {
            this.keyMap = null;
        } else {
            if (this.keyMap == null) {
                this.keyMap = new LinkedHashMap();
            } else {
                keyMap.clear();
            }
            this.keyMap.putAll(keyMap);
        }
    }

    public void addKey(Object key) {
        if (this.keyMap == null) {
            this.keyMap = new LinkedHashMap();
        }
        this.keyMap.put(key, key);
    }

    public void removeKey(int index) {
        if (this.keyMap == null || this.keyMap.size() <= index) {
            return;
        }
        Iterator keies = this.keyMap.keySet().iterator();
        int i = 0;
        while (keies.hasNext() && i++ < index + 1) {
            keies.next();
        }
        keies.remove();
    }

    public void addKey(String name, Object key) {
        if (this.keyMap == null) {
            this.keyMap = new LinkedHashMap();
        }
        this.keyMap.put(name, key);
    }

    public void removeKey(String name) {
        if (this.keyMap == null) {
            return;
        }
        this.keyMap.remove(name);
    }

    public void add() {
        this.updateType = 1;
    }

    public void update() {
        this.updateType = 2;
    }

    public void remove() {
        this.updateType = 3;
    }

    public boolean isAdd() {
        return this.updateType == 1;
    }

    public boolean isUpdate() {
        return this.updateType == 2;
    }

    public boolean isRemove() {
        return this.updateType == 3;
    }

    public void setInput(Object in) {
        this.input = in;
    }

    public Object getInput() {
        return this.input;
    }

    public void setUpdateType(int type) {
        this.updateType = type;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public void clear() {
        if (this.keyMap != null) {
            this.keyMap.clear();
        }
        this.updateType = 2;
        this.input = null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CodeMasterUpdateKey)) {
            return false;
        }
        CodeMasterUpdateKey cmp = (CodeMasterUpdateKey)obj;
        if (this.keyMap == null) {
            return cmp.keyMap == null;
        }
        return this.keyMap.equals(cmp.keyMap);
    }

    public int hashCode() {
        return this.keyMap == null ? 0 : this.keyMap.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("keyMap=").append(this.keyMap);
        buf.append(", updateType=");
        switch (this.updateType) {
            case 1: {
                buf.append("ADD");
                break;
            }
            case 2: {
                buf.append("UPDATE");
                break;
            }
            case 3: {
                buf.append("REMOVE");
            }
        }
        buf.append('}');
        return buf.toString();
    }
}

