/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ejb;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.ejb.GroupEJBFactoryServiceMBean;

public class GroupEJBFactoryService
extends ServiceBase
implements EJBFactory,
GroupEJBFactoryServiceMBean {
    private static final long serialVersionUID = -7631019481698232485L;
    private Properties nameAndEJBFactoryServiceNameMapping;
    private Map nameAndEJBFactoryMap;
    private ServiceName defaultEJBFactoryServiceName;
    private EJBFactory defaultEJBFactory;

    @Override
    public void setNameAndEJBFactoryServiceNameMapping(Properties mapping) {
        this.nameAndEJBFactoryServiceNameMapping = mapping;
    }

    @Override
    public Properties getNameAndEJBFactoryServiceNameMapping() {
        return this.nameAndEJBFactoryServiceNameMapping;
    }

    @Override
    public void setDefaultEJBFactoryServiceName(ServiceName name) {
        this.defaultEJBFactoryServiceName = name;
    }

    @Override
    public ServiceName getDefaultEJBFactoryServiceName() {
        return this.defaultEJBFactoryServiceName;
    }

    @Override
    public void createService() throws Exception {
        this.nameAndEJBFactoryMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.nameAndEJBFactoryServiceNameMapping == null || this.nameAndEJBFactoryServiceNameMapping.size() == 0) {
            throw new IllegalArgumentException("nameAndEJBFactoryServiceNameMapping must be specified.");
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        for (String string : this.nameAndEJBFactoryServiceNameMapping.keySet()) {
            Pattern pattern = Pattern.compile(string);
            String serviceNameStr = this.nameAndEJBFactoryServiceNameMapping.getProperty(string);
            editor.setAsText(serviceNameStr);
            ServiceName serviceName = (ServiceName)editor.getValue();
            this.nameAndEJBFactoryMap.put(pattern, (EJBFactory)ServiceManagerFactory.getServiceObject(serviceName));
        }
        if (this.defaultEJBFactoryServiceName != null) {
            this.defaultEJBFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.defaultEJBFactoryServiceName);
        }
    }

    @Override
    public void stopService() throws Exception {
        this.nameAndEJBFactoryMap.clear();
        this.defaultEJBFactory = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.nameAndEJBFactoryMap = null;
    }

    @Override
    public EJBObject get(String name) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name);
    }

    @Override
    public EJBObject get(String name, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, params);
    }

    @Override
    public EJBObject get(String name, Class homeType) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, homeType);
    }

    @Override
    public EJBObject get(String name, Class homeType, Class[] paramTypes, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, homeType, paramTypes, params);
    }

    @Override
    public EJBObject get(String name, Class homeType, Class remoteType, Class[] paramTypes, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, homeType, remoteType, paramTypes, params);
    }

    @Override
    public void invalidate(String name) {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return;
        }
        factory.invalidate(name);
    }

    @Override
    public void invalidate() {
        if (this.nameAndEJBFactoryMap == null) {
            return;
        }
        for (EJBFactory factory : this.nameAndEJBFactoryMap.values()) {
            factory.invalidate();
        }
    }

    protected EJBFactory findEJBFactory(String name) {
        if (this.nameAndEJBFactoryMap == null) {
            return null;
        }
        for (Pattern namePattern : this.nameAndEJBFactoryMap.keySet()) {
            Matcher matcher = namePattern.matcher(name);
            if (!matcher.matches()) continue;
            return (EJBFactory)this.nameAndEJBFactoryMap.get(namePattern);
        }
        return this.defaultEJBFactory;
    }
}

