/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.performance;

import java.util.HashMap;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.performance.FileReportPerformanceStatisticsService;
import jp.ossc.nimbus.service.writer.WritableRecord;

public class WriterDaemonRunnable
implements DaemonRunnable {
    protected FileReportPerformanceStatisticsService mCallBack = null;

    public WriterDaemonRunnable(FileReportPerformanceStatisticsService inObj) {
        this.mCallBack = inObj;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) throws Exception {
        long tn = Long.parseLong(this.mCallBack.getWritableInterval()) * 1000L;
        Thread.sleep(tn);
        return new Object();
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        int sort = 0;
        String sortkey = this.mCallBack.getSortKey();
        if ("NAME".equalsIgnoreCase(sortkey)) {
            sort = 0;
        } else if ("BEST".equalsIgnoreCase(sortkey)) {
            sort = 1;
        } else if ("WORST".equalsIgnoreCase(sortkey)) {
            sort = 2;
        } else if ("AVERAGE".equalsIgnoreCase(sortkey)) {
            sort = 3;
        } else if ("COUNT".equalsIgnoreCase(sortkey)) {
            sort = 4;
        }
        String[] performance = this.mCallBack.toStringAry(sort, true);
        for (int i = 0; i < performance.length; ++i) {
            HashMap<String, String> elements = new HashMap<String, String>();
            elements.put("", performance[i]);
            WritableRecord rec = this.mCallBack.mWritableRecFac.createRecord(elements);
            this.mCallBack.mWriter.write(rec);
        }
    }

    @Override
    public void garbage() {
    }

    @Override
    public boolean onStart() {
        return true;
    }
}

