/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;

public class NullConverter
implements ReversibleConverter,
Serializable {
    private static final long serialVersionUID = -5603437969416832007L;
    public static final int NULL_FROM_OBJECT = 1;
    public static final int OBJECT_FROM_NULL = 2;
    protected int convertType;
    protected Object nullObject;

    public NullConverter() {
        this(1);
    }

    public NullConverter(int type) {
        this.setConvertType(type);
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
        switch (this.convertType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid convert type : " + type);
            }
        }
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setNullObject(Object obj) {
        this.nullObject = obj;
    }

    public Object getNullObject() {
        return this.nullObject;
    }

    public void setNullBoolean(Boolean na) {
        this.nullObject = na;
    }

    public void setNullChar(Character na) {
        this.nullObject = na;
    }

    public void setNullByte(Byte na) {
        this.nullObject = na;
    }

    public void setNullShort(Short na) {
        this.nullObject = na;
    }

    public void setNullInt(Integer na) {
        this.nullObject = na;
    }

    public void setNullLong(Long na) {
        this.nullObject = na;
    }

    public void setNullFloat(Float na) {
        this.nullObject = na;
    }

    public void setNullDouble(Double na) {
        this.nullObject = na;
    }

    public void setNullBigInteger(BigInteger na) {
        this.nullObject = na;
    }

    public void setNullBigDecimal(BigDecimal na) {
        this.nullObject = na;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        switch (this.convertType) {
            case 2: {
                if (obj == null && this.nullObject == null || this.nullObject == obj || this.nullObject != null && this.nullObject.equals(obj)) {
                    return null;
                }
                return obj;
            }
        }
        if (obj == null) {
            return this.nullObject;
        }
        return obj;
    }
}

