/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.MethodMappingInterceptorServiceMBean;
import jp.ossc.nimbus.service.context.Context;

public class MethodMappingInterceptorService
extends ServiceBase
implements Interceptor,
MethodMappingInterceptorServiceMBean {
    private static final long serialVersionUID = -4023805640790206233L;
    private Properties targetMethodMapping;
    private Map interceptorMapping;
    private Properties targetMethodReturnMapping;
    private Map contextMapping;
    private ServiceName contextServiceName;
    private Context context;

    @Override
    public void setTargetMethodMapping(Properties mapping) {
        this.targetMethodMapping = mapping;
    }

    @Override
    public Properties getTargetMethodMapping() {
        return this.targetMethodMapping;
    }

    @Override
    public void setTargetMethodReturnMapping(Properties mapping) {
        this.targetMethodReturnMapping = mapping;
    }

    @Override
    public Properties getTargetMethodReturnMapping() {
        return this.targetMethodReturnMapping;
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void createService() throws Exception {
        this.interceptorMapping = new HashMap();
        this.contextMapping = new HashMap();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void startService() throws Exception {
        if (this.targetMethodMapping != null) {
            Iterator<Object> methods = this.targetMethodMapping.keySet().iterator();
            ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
            serviceNameEditor.setServiceManagerName(this.getServiceManagerName());
            while (methods.hasNext()) {
                String method = (String)methods.next();
                MethodSignature sig = new MethodSignature(method);
                String interceptorName = this.targetMethodMapping.getProperty(method);
                serviceNameEditor.setAsText(interceptorName);
                this.interceptorMapping.put(sig, serviceNameEditor.getValue());
            }
        }
        if (this.targetMethodReturnMapping != null) {
            if (this.contextServiceName != null) {
                this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
            } else if (this.context != null) {
                throw new IllegalArgumentException("contextServiceName must be specified.");
            }
            for (String string : this.targetMethodReturnMapping.keySet()) {
                MethodSignature sig = new MethodSignature(string);
                String ctxName = this.targetMethodReturnMapping.getProperty(string);
                this.contextMapping.put(sig, ctxName);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.interceptorMapping.clear();
        this.contextMapping.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.interceptorMapping = null;
        this.contextMapping = null;
    }

    @Override
    public Object invoke(InvocationContext ctx, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            Method method = ((MethodInvocationContext)ctx).getTargetMethod();
            if (this.interceptorMapping != null && this.interceptorMapping.size() != 0) {
                ServiceName name = null;
                for (Map.Entry entry : this.interceptorMapping.entrySet()) {
                    if (!entry.getKey().equals(method)) continue;
                    name = (ServiceName)entry.getValue();
                    break;
                }
                Interceptor interceptor = null;
                if (name != null) {
                    try {
                        interceptor = (Interceptor)ServiceManagerFactory.getServiceObject(name);
                    }
                    catch (ServiceNotFoundException e) {
                        // empty catch block
                    }
                }
                if (interceptor != null) {
                    return interceptor.invoke(ctx, chain);
                }
            }
            if (this.contextMapping != null && this.contextMapping.size() != 0) {
                for (Map.Entry entry : this.contextMapping.entrySet()) {
                    if (!entry.getKey().equals(method)) continue;
                    String key = (String)entry.getValue();
                    return this.context.get(key);
                }
            }
            return chain.invokeNext(ctx);
        }
        return chain.invokeNext(ctx);
    }

    private static class MethodSignature
    implements Serializable {
        private static final long serialVersionUID = -4023805640790206233L;
        private String owner;
        private String methodName;
        private String[] paramTypes;
        private boolean isParamTypesCheck = true;

        public MethodSignature(String method) throws IllegalArgumentException {
            String tmp = method;
            int index = tmp.indexOf(35);
            if (index == -1 || index == 0 || index == tmp.length() - 1) {
                throw new IllegalArgumentException("Invalid method : " + method);
            }
            this.owner = tmp.substring(0, index);
            if ((index = (tmp = tmp.substring(index + 1)).indexOf(40)) == -1 || index == 0 || index == tmp.length() - 1) {
                throw new IllegalArgumentException("Invalid method : " + method);
            }
            this.methodName = tmp.substring(0, index);
            if ((index = (tmp = tmp.substring(index + 1)).indexOf(41)) == -1 || index != tmp.length() - 1) {
                throw new IllegalArgumentException("Invalid method : " + method);
            }
            if (index == 0) {
                this.paramTypes = new String[0];
            } else if ((tmp = tmp.substring(0, index)).equals("*")) {
                this.isParamTypesCheck = false;
            } else {
                StringTokenizer tokens = new StringTokenizer(tmp, ",");
                ArrayList<String> paramTypeList = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    String paramType = tokens.nextToken().trim();
                    if (paramType.length() == 0) {
                        throw new IllegalArgumentException("Invalid method : " + method);
                    }
                    paramTypeList.add(paramType);
                }
                this.paramTypes = paramTypeList.toArray(new String[paramTypeList.size()]);
            }
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof MethodSignature) {
                MethodSignature comp = (MethodSignature)o;
                if (!this.owner.equals(comp.owner)) {
                    return false;
                }
                if (!this.methodName.equals(comp.methodName)) {
                    return false;
                }
                if (this.isParamTypesCheck != comp.isParamTypesCheck) {
                    return false;
                }
                if (this.paramTypes == comp.paramTypes) {
                    return true;
                }
                if (this.paramTypes == null && comp.paramTypes != null || this.paramTypes != null && comp.paramTypes == null || this.paramTypes.length != comp.paramTypes.length) {
                    return false;
                }
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    if (this.paramTypes[i].equals(comp.paramTypes[i])) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof Method) {
                Method comp = (Method)o;
                if (!this.owner.equals(comp.getDeclaringClass().getName()) && !Pattern.matches(this.owner, comp.getDeclaringClass().getName())) {
                    return false;
                }
                if (!this.methodName.equals(comp.getName()) && !Pattern.matches(this.methodName, comp.getName())) {
                    return false;
                }
                if (!this.isParamTypesCheck) {
                    return true;
                }
                Class<?>[] compParamTypes = comp.getParameterTypes();
                if (this.paramTypes == null && compParamTypes == null) {
                    return true;
                }
                if (this.paramTypes == null && compParamTypes != null || this.paramTypes != null && compParamTypes == null || this.paramTypes.length != compParamTypes.length) {
                    return false;
                }
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    if (this.paramTypes[i].equals(compParamTypes[i].getName()) || Pattern.matches(this.paramTypes[i], compParamTypes[i].getName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.owner.hashCode() + this.methodName.hashCode();
            if (this.paramTypes != null) {
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    hashCode += this.paramTypes[i].hashCode();
                }
            }
            return hashCode;
        }
    }
}

