/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.util.Random;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.ga.ConvergenceCondition;
import jp.ossc.nimbus.service.ga.DefaultGeneration;
import jp.ossc.nimbus.service.ga.Generation;
import jp.ossc.nimbus.service.ga.GeneticAlgorithm;
import jp.ossc.nimbus.service.ga.Seed;
import jp.ossc.nimbus.service.ga.SeedMatchMaker;
import jp.ossc.nimbus.service.ga.SimpleGeneticAlgorithmServiceMBean;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;

public class SimpleGeneticAlgorithmService
extends ServiceBase
implements GeneticAlgorithm,
SimpleGeneticAlgorithmServiceMBean {
    private static final long serialVersionUID = -4322550471995044899L;
    protected ServiceName seedMatchMakerServiceName;
    protected SeedMatchMaker seedMatchMaker;
    protected ServiceName convergenceConditionServiceName;
    protected ConvergenceCondition convergenceCondition;
    protected ServiceName queueHandlerContainerServiceName;
    protected QueueHandlerContainer queueHandlerContainer;
    protected int parallelThreadNum;
    protected long parallelResponseTimout = -1L;

    @Override
    public void setSeedMatchMakerServiceName(ServiceName name) {
        this.seedMatchMakerServiceName = name;
    }

    @Override
    public ServiceName getSeedMatchMakerServiceName() {
        return this.seedMatchMakerServiceName;
    }

    public void setConvergenceConditionServiceName(ServiceName name) {
        this.convergenceConditionServiceName = name;
    }

    public ServiceName getConvergenceConditionServiceName() {
        return this.convergenceConditionServiceName;
    }

    @Override
    public void setQueueHandlerContainerServiceName(ServiceName name) {
        this.queueHandlerContainerServiceName = name;
    }

    @Override
    public ServiceName getQueueHandlerContainerServiceName() {
        return this.queueHandlerContainerServiceName;
    }

    @Override
    public void setParallelThreadNum(int num) {
        this.parallelThreadNum = num;
    }

    @Override
    public int getParallelThreadNum() {
        return this.parallelThreadNum;
    }

    @Override
    public void setParallelResponseTimout(long timeout) {
        this.parallelResponseTimout = timeout;
    }

    @Override
    public long getParallelResponseTimout() {
        return this.parallelResponseTimout;
    }

    public void setSeedMatchMaker(SeedMatchMaker matchMaker) {
        this.seedMatchMaker = matchMaker;
    }

    @Override
    public SeedMatchMaker getSeedMatchMaker() {
        return this.seedMatchMaker;
    }

    public void setConvergenceCondition(ConvergenceCondition condition) {
        this.convergenceCondition = condition;
    }

    @Override
    public ConvergenceCondition getConvergenceCondition() {
        return this.convergenceCondition;
    }

    public void setQueueHandlerContainer(QueueHandlerContainer qhc) {
        this.queueHandlerContainer = qhc;
    }

    public QueueHandlerContainer getQueueHandlerContainer() {
        return this.queueHandlerContainer;
    }

    @Override
    public void startService() throws Exception {
        if (this.seedMatchMakerServiceName != null) {
            this.seedMatchMaker = (SeedMatchMaker)ServiceManagerFactory.getServiceObject(this.seedMatchMakerServiceName);
        }
        if (this.seedMatchMaker == null) {
            throw new IllegalArgumentException("SeedMatchMaker is null.");
        }
        if (this.convergenceConditionServiceName != null) {
            this.convergenceCondition = (ConvergenceCondition)ServiceManagerFactory.getServiceObject(this.convergenceConditionServiceName);
        }
        if (this.convergenceCondition == null) {
            throw new IllegalArgumentException("ConvergenceCondition is null.");
        }
    }

    @Override
    public Generation createGeneration(Random random, Seed seed, int seedNum, boolean isAsc) {
        DefaultGeneration generation = new DefaultGeneration();
        generation.setFitnessOrder(isAsc);
        generation.setConvergenceCondition(this.convergenceCondition);
        generation.init(random, seed, seedNum);
        QueueHandlerContainer qhc = this.queueHandlerContainer;
        if (qhc == null && this.queueHandlerContainerServiceName != null) {
            qhc = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.queueHandlerContainerServiceName);
        }
        if (qhc != null) {
            generation.setQueueHandlerContainer(qhc);
        }
        return generation;
    }

    @Override
    public Generation compete(Random random, Generation generation) throws Exception {
        if (generation.getQueueHandlerContainer() == null && this.parallelThreadNum < 2) {
            generation.compete();
        } else {
            generation.compete(generation.getQueueHandlerContainer() == null ? this.parallelThreadNum : generation.getQueueHandlerContainer().getQueueHandlerSize(), this.parallelResponseTimout);
        }
        return generation.next(random, this.seedMatchMaker);
    }

    @Override
    public Seed compete(Random random, Seed seed, int seedNum, boolean isAsc) throws Exception {
        Generation generation = new DefaultGeneration();
        generation.setFitnessOrder(isAsc);
        generation.setConvergenceCondition(this.convergenceCondition);
        generation.init(random, seed, seedNum);
        QueueHandlerContainer qhc = this.queueHandlerContainer;
        if (qhc == null && this.queueHandlerContainerServiceName != null) {
            qhc = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.queueHandlerContainerServiceName);
        }
        if (qhc != null) {
            generation.setQueueHandlerContainer(qhc);
        }
        Generation nextGeneration = null;
        do {
            if (qhc == null && this.parallelThreadNum < 2) {
                generation.compete();
            } else {
                generation.compete(qhc == null ? this.parallelThreadNum : qhc.getQueueHandlerSize(), this.parallelResponseTimout);
            }
            nextGeneration = generation.next(random, this.seedMatchMaker);
            if (nextGeneration == null) continue;
            generation = nextGeneration;
        } while (nextGeneration != null);
        return generation.getSurvivor();
    }
}

