/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.rmi.RemoteException;
import jp.ossc.nimbus.service.beancontrol.BeanFlowAsynchInvokeCallback;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.Queue;

public class BeanFlowAsynchContext
extends AsynchContext {
    private static final long serialVersionUID = -634815787855558999L;
    protected String flowName;
    protected BeanFlowInvoker invoker;
    protected BeanFlowMonitor monitor;
    protected BeanFlowAsynchInvokeCallback callback;

    public BeanFlowAsynchContext() {
    }

    public BeanFlowAsynchContext(String flowName) {
        this.flowName = flowName;
    }

    public BeanFlowAsynchContext(String flowName, Object input) {
        super(input);
        this.flowName = flowName;
    }

    public BeanFlowAsynchContext(String flowName, Object input, Queue queue) {
        super(input, queue);
        this.flowName = flowName;
    }

    public BeanFlowAsynchContext(BeanFlowInvoker invoker, Object input, BeanFlowMonitor monitor) {
        this(invoker, input, monitor, (Queue)null);
    }

    public BeanFlowAsynchContext(BeanFlowInvoker invoker, Object input, BeanFlowMonitor monitor, Queue queue) {
        super(input, queue);
        this.invoker = invoker;
        this.monitor = monitor;
    }

    public BeanFlowAsynchContext(BeanFlowInvoker invoker, Object input, BeanFlowMonitor monitor, BeanFlowAsynchInvokeCallback callback) {
        super(input);
        this.invoker = invoker;
        this.monitor = monitor;
        this.callback = callback;
    }

    public void setFlowName(String name) {
        this.flowName = name;
    }

    public String getFlowName() {
        return this.invoker == null ? this.flowName : this.invoker.getFlowName();
    }

    public void setBeanFlowInvoker(BeanFlowInvoker invoker) {
        this.invoker = invoker;
    }

    public BeanFlowInvoker getBeanFlowInvoker() {
        return this.invoker;
    }

    public void setBeanFlowMonitor(BeanFlowMonitor monitor) {
        this.monitor = monitor;
    }

    public BeanFlowMonitor getBeanFlowMonitor() {
        return this.monitor;
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        if (this.callback != null && !this.isCancel()) {
            try {
                this.callback.reply(output, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setThrowable(Throwable th) {
        super.setThrowable(th);
        if (this.callback != null && !this.isCancel()) {
            try {
                this.callback.reply(null, th);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.deleteCharAt(buf.length() - 1);
        buf.append(", flowName=").append(this.getFlowName());
        buf.append('}');
        return buf.toString();
    }
}

