/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import jp.ossc.nimbus.util.StringOperator;

public class CsvArrayList
extends ArrayList
implements Serializable {
    private static final long serialVersionUID = -2858942004554521568L;
    private String mSeptData = ",";
    private String mEscapeString = "\\";
    private Object mObjSync = new String();
    private boolean mAddDemiliter = false;
    public static final String ESP_STR = "\u001c";
    protected static final String C_LINESEPT = "line.separator";
    protected static final String C_COMMMA = ",";
    protected static final String C_NONE = "";
    protected static final String C_ESCAPE = "\\";
    protected static final String CR = "\r";
    protected static final String LF = "\n";
    protected static final String CRLF = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddDelimitaFlg(boolean flgAddDelimita) {
        Object object = this.mObjSync;
        synchronized (object) {
            this.mAddDemiliter = flgAddDelimita;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEscapeString(String strEscape) {
        Object object = this.mObjSync;
        synchronized (object) {
            this.mEscapeString = strEscape;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int _splitString(String strInData) {
        super.clear();
        if (strInData != null && strInData.length() != 0) {
            int lngMindNum = 0;
            StringBuffer subStr1 = new StringBuffer(C_NONE);
            StringBuffer subStr2 = new StringBuffer(StringOperator.replaceString(strInData, this.mEscapeString + this.mEscapeString, ESP_STR));
            if (this.mAddDemiliter && subStr2.substring(subStr2.length() - this.mSeptData.length()).equals(this.mSeptData)) {
                subStr2 = new StringBuffer(subStr2.substring(0, subStr2.length() - this.mSeptData.length()));
            }
            while (true) {
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2;
                void var2_5;
                int lngFindNum = subStr2.toString().indexOf(this.mSeptData);
                lngMindNum += lngFindNum;
                if (lngFindNum == -1) {
                    if (subStr1.length() > 0) {
                        super.add(subStr1.toString());
                        break;
                    }
                    super.add(subStr2.toString());
                    break;
                }
                if (var2_5 >= 0) {
                    if (var2_5 > 0 && stringBuffer2.substring((int)(var2_5 - true), (int)var2_5).equals(this.mEscapeString)) {
                        stringBuffer = new StringBuffer(stringBuffer.append(stringBuffer2.substring(0, (int)(var2_5 - true)).toString()).toString());
                        stringBuffer.append(this.mSeptData);
                        String postStr = stringBuffer2.substring((int)(var2_5 + this.mSeptData.length()));
                        if (postStr.indexOf(this.mSeptData) != -1) {
                            stringBuffer2 = new StringBuffer(postStr);
                            continue;
                        }
                        stringBuffer.append(postStr);
                        stringBuffer2 = new StringBuffer(C_NONE);
                        continue;
                    }
                    stringBuffer.append(stringBuffer2.substring(0, (int)var2_5));
                } else {
                    stringBuffer = new StringBuffer(C_NONE);
                }
                String tmp = StringOperator.replaceString(stringBuffer.toString(), ESP_STR, this.mEscapeString);
                super.add(tmp);
                boolean bl = false;
                stringBuffer2 = new StringBuffer(stringBuffer2.substring((int)(var2_5 + this.mSeptData.length())));
                stringBuffer = new StringBuffer(C_NONE);
            }
        }
        return super.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int split(String strInData) {
        int ret = 0;
        Object object = this.mObjSync;
        synchronized (object) {
            this.mSeptData = C_COMMMA;
            ret = this._splitString(strInData);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int splitCL(String strInData) {
        int ret = 0;
        Object object = this.mObjSync;
        synchronized (object) {
            if (strInData.indexOf(CRLF) != -1) {
                this.mSeptData = CRLF;
            } else if (strInData.indexOf(LF) != -1) {
                this.mSeptData = LF;
            } else if (strInData.indexOf(CR) != -1) {
                this.mSeptData = CR;
            } else {
                this.clear();
                this.add(strInData);
                return 1;
            }
            ret = this._splitString(strInData);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int split(String strInData, String strSept) {
        int ret = 0;
        Object object = this.mObjSync;
        synchronized (object) {
            this.mSeptData = strSept;
            ret = this._splitString(strInData);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int splitExcelFile(String strInData) throws IOException {
        this.clear();
        Object object = this.mObjSync;
        synchronized (object) {
            int index = 0;
            while ((index = this.getData(strInData, index)) != -1) {
            }
        }
        return this.size();
    }

    protected int getData(String strInData, int index) {
        if (index > strInData.length()) {
            return -1;
        }
        if (index == strInData.length()) {
            this.add(C_NONE);
            return -1;
        }
        char c = strInData.charAt(index);
        if (c == ',') {
            this.add(C_NONE);
            return index + 1;
        }
        if (c == '\"') {
            return this._getQuotedData(strInData, index + 1);
        }
        int begin = index;
        if ((index = strInData.indexOf(44, index)) == -1) {
            this.add(strInData.substring(begin));
            return -1;
        }
        this.add(strInData.substring(begin, index));
        return index + 1;
    }

    private int _getQuotedData(String strInData, int index) {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int begin = index;
            if ((index = strInData.indexOf(34, index)) == -1) {
                buf.append(strInData.substring(begin));
                this.add(buf.toString());
                return -1;
            }
            if (index == strInData.length() - 1) {
                buf.append(strInData.substring(begin, index));
                this.add(buf.toString());
                return -1;
            }
            char c = strInData.charAt(index + 1);
            if (c == '\"') {
                buf.append(strInData.substring(begin, index + 1));
                index += 2;
                continue;
            }
            if (c == ',') {
                buf.append(strInData.substring(begin, index));
                this.add(buf.toString());
                return index + 2;
            }
            buf.append(strInData.substring(begin, index));
            index += 2;
        }
    }

    private String _joinString() {
        StringBuffer mngBuf = new StringBuffer();
        ListIterator iterator = super.listIterator();
        while (iterator.hasNext()) {
            String tmpBuf = (String)iterator.next();
            tmpBuf = StringOperator.replaceString(tmpBuf, this.mEscapeString, this.mEscapeString + this.mEscapeString);
            tmpBuf = StringOperator.replaceString(tmpBuf, this.mSeptData, this.mEscapeString + this.mSeptData);
            mngBuf.append(tmpBuf).append(this.mSeptData);
        }
        if (!this.mAddDemiliter && mngBuf.length() > this.mSeptData.length()) {
            mngBuf = new StringBuffer(mngBuf.toString().substring(0, mngBuf.length() - this.mSeptData.length()));
        }
        return mngBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String join() {
        Object object = this.mObjSync;
        synchronized (object) {
            this.mSeptData = C_COMMMA;
            return this._joinString();
        }
    }

    public String joinCL() {
        this.mSeptData = System.getProperty(C_LINESEPT);
        return this._joinString();
    }

    public String join(String strSept) {
        this.mSeptData = strSept;
        return this._joinString();
    }

    public String[] toStringAry() {
        String[] result = null;
        Object[] aryObj = null;
        aryObj = super.toArray();
        if (aryObj != null) {
            result = new String[aryObj.length];
            for (int rCnt = 0; rCnt < aryObj.length; ++rCnt) {
                result[rCnt] = (String)aryObj[rCnt];
            }
        }
        return result;
    }

    public void setStringAry(String[] inStrAry) {
        if (inStrAry != null) {
            for (int i = 0; i < inStrAry.length; ++i) {
                this.add(inStrAry[i]);
            }
        }
    }

    public String getStr(int index) {
        String result = (String)super.get(index);
        return result;
    }
}

