/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public abstract class AbstractStringConverter
implements StringConverter,
ReversibleConverter,
Serializable {
    private static final long serialVersionUID = -4121468203318618862L;
    protected int convertType;
    protected int from;
    protected int to;

    public AbstractStringConverter() {
        this(1);
    }

    public AbstractStringConverter(int type) {
        this.setConvertType(type);
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
        switch (this.convertType) {
            case 1: {
                this.from = 0;
                this.to = 1;
                break;
            }
            case 2: {
                this.from = 1;
                this.to = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid convert type : " + type);
            }
        }
    }

    public int getConvertType() {
        return this.convertType;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        return this.convert((String)(obj instanceof String ? obj : String.valueOf(obj)));
    }

    @Override
    public String convert(String str) throws ConvertException {
        String result = str;
        result = this.convertStrings(result);
        result = this.convertChars(result);
        return result;
    }

    protected String convertChars(String str) throws ConvertException {
        String result = str;
        char[][] convertChars = this.getConvertChars();
        if (convertChars != null) {
            char[] chars = null;
            int max = result.length();
            for (int i = 0; i < max; ++i) {
                char c = result.charAt(i);
                for (int j = 0; j < convertChars.length; ++j) {
                    if (c != convertChars[j][this.from]) continue;
                    if (chars == null) {
                        chars = str.toCharArray();
                    }
                    chars[i] = convertChars[j][this.to];
                }
            }
            if (chars != null) {
                result = new String(chars);
            }
        }
        return result;
    }

    protected String convertStrings(String str) throws ConvertException {
        String result = str;
        String[][] convertStrings = this.getConvertStrings();
        if (convertStrings != null) {
            StringBuffer buf = new StringBuffer(result);
            boolean isReplace = false;
            for (int i = 0; i < convertStrings.length; ++i) {
                int length = convertStrings[i][this.from].length();
                int index = buf.lastIndexOf(convertStrings[i][this.from]);
                if (index == -1) continue;
                isReplace = true;
                do {
                    buf.replace(index, index + length, convertStrings[i][this.to]);
                } while (index >= length && (index = buf.lastIndexOf(convertStrings[i][this.from], index - 1)) != -1);
            }
            if (isReplace) {
                result = buf.toString();
            }
        }
        return result;
    }

    protected abstract char[][] getConvertChars();

    protected abstract String[][] getConvertStrings();
}

