/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;

public class OrProperty
implements Property,
Serializable {
    private static final long serialVersionUID = 4557829281768367883L;
    private static final String MSG_00001 = "Illegal OrProperty : ";
    private static final String MSG_00002 = "Arguments is null.";
    protected Property firstProperty;
    protected Property secondProperty;
    protected boolean isIgnoreNullProperty;

    public OrProperty() {
    }

    public OrProperty(Property first, Property second) throws IllegalArgumentException {
        if (first == null || second == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.firstProperty = first;
        this.secondProperty = second;
    }

    public void setFirstProperty(Property prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.firstProperty = prop;
    }

    public Property getFirstProperty() {
        return this.firstProperty;
    }

    public Property getNestedFirstProperty() {
        if (this.firstProperty instanceof OrProperty) {
            return ((OrProperty)this.firstProperty).getNestedFirstProperty();
        }
        return this.firstProperty;
    }

    public void setSecondProperty(Property prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.secondProperty = prop;
    }

    public Property getSecondProperty() {
        return this.secondProperty;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int index = prop.indexOf(124);
        if (index == -1 || index == 0 || index == prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.firstProperty = PropertyFactory.createProperty(prop.substring(0, index).trim());
        this.secondProperty = PropertyFactory.createProperty(prop.substring(index + 1).trim());
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Object firstObj = null;
        try {
            firstObj = this.firstProperty.getProperty(obj);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (firstObj != null) {
            return this.firstProperty.getPropertyType(obj);
        }
        return this.secondProperty.getPropertyType(obj);
    }

    public boolean isReadable(Object obj) {
        try {
            this.firstProperty.getProperty(obj);
            this.secondProperty.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        return true;
    }

    public boolean isWritable(Object obj, Class clazz) {
        return false;
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Object firstObj = null;
        try {
            firstObj = this.firstProperty.getProperty(obj);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (firstObj == null) {
            return this.secondProperty.getProperty(obj);
        }
        return firstObj;
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public String getPropertyName() {
        return this.firstProperty.getPropertyName() + '|' + this.secondProperty.getPropertyName();
    }

    public void setIgnoreNullProperty(boolean isIgnore) {
        this.isIgnoreNullProperty = isIgnore;
        if (this.firstProperty != null) {
            this.firstProperty.setIgnoreNullProperty(this.isIgnoreNullProperty);
        }
        if (this.secondProperty != null) {
            this.secondProperty.setIgnoreNullProperty(this.isIgnoreNullProperty);
        }
    }

    public boolean isIgnoreNullProperty() {
        return this.isIgnoreNullProperty;
    }

    public String toString() {
        return "OrProperty{" + this.firstProperty.toString() + '|' + this.secondProperty.toString() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrProperty)) {
            return false;
        }
        OrProperty comp = (OrProperty)obj;
        if (this.firstProperty == null && comp.firstProperty != null || this.firstProperty != null && comp.firstProperty == null) {
            return false;
        }
        if (this.firstProperty != null && comp.firstProperty != null && !this.firstProperty.equals(comp.firstProperty)) {
            return false;
        }
        if (this.secondProperty == null && comp.secondProperty == null) {
            return true;
        }
        if (this.secondProperty == null) {
            return false;
        }
        return this.secondProperty.equals(comp.secondProperty);
    }

    public int hashCode() {
        return (this.firstProperty == null ? 0 : this.firstProperty.hashCode()) + (this.secondProperty == null ? 0 : this.secondProperty.hashCode()) + 3;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof OrProperty)) {
            return 1;
        }
        OrProperty comp = (OrProperty)obj;
        if (this.firstProperty == null && comp.firstProperty != null) {
            return -1;
        }
        if (this.firstProperty != null && comp.firstProperty == null) {
            return 1;
        }
        if (this.firstProperty != null && comp.firstProperty != null) {
            if (this.firstProperty instanceof Comparable) {
                int val = ((Comparable)((Object)this.firstProperty)).compareTo(comp.firstProperty);
                if (val != 0) {
                    return val;
                }
            } else {
                return -1;
            }
        }
        if (this.secondProperty == null && comp.secondProperty == null) {
            return 0;
        }
        if (this.secondProperty == null) {
            return -1;
        }
        if (this.secondProperty instanceof Comparable) {
            return ((Comparable)((Object)this.secondProperty)).compareTo(comp.secondProperty);
        }
        return -1;
    }
}

