/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.beancontrol.BeanFlowAsynchInvokeCallback;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerServer;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerServerServiceMBean;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.NoSuchBeanFlowIdException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.performance.ResourceUsage;
import jp.ossc.nimbus.service.proxy.invoker.KeepAliveCheckInvoker;
import jp.ossc.nimbus.service.queue.BeanFlowAsynchContext;
import jp.ossc.nimbus.service.repository.Repository;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.sequence.StringSequenceService;

public class BeanFlowInvokerServerService
extends ServiceBase
implements BeanFlowInvokerServerServiceMBean {
    private static final long serialVersionUID = 4150733833643322667L;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private ServiceName interceptorChainFactoryServiceName;
    private ServiceName jndiRepositoryServiceName;
    private ServiceName contextServiceName;
    private ServiceName resourceUsageServiceName;
    private Repository jndiRepository;
    private String jndiName = "nimbus/BeanFlowInvokerServer";
    private int rmiPort;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private StringSequenceService sequence;
    private String sequenceTimestampFormat = "HHmmssSSS";
    private int sequenceDigit = 3;
    private BeanFlowInvokerServerImpl server;
    private ResourceUsage resourceUsage;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$beancontrol$BeanFlowMonitor;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$beancontrol$interfaces$BeanFlowInvoker;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$beancontrol$BeanFlowAsynchInvokeCallback;

    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setInterceptorChainFactoryServiceName(ServiceName name) {
        this.interceptorChainFactoryServiceName = name;
    }

    public ServiceName getInterceptorChainFactoryServiceName() {
        return this.interceptorChainFactoryServiceName;
    }

    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    public void setResourceUsageServiceName(ServiceName name) {
        this.resourceUsageServiceName = name;
    }

    public ServiceName getResourceUsageServiceName() {
        return this.resourceUsageServiceName;
    }

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void setSequenceTimestampFormat(String format) {
        this.sequenceTimestampFormat = format;
    }

    public String getSequenceTimestampFormat() {
        return this.sequenceTimestampFormat;
    }

    public void setSequenceDigit(int digit) {
        this.sequenceDigit = digit;
    }

    public int getSequenceDigit() {
        return this.sequenceDigit;
    }

    public boolean isAcceptable() {
        return this.server == null ? false : this.server.isAcceptable();
    }

    public void setAcceptable(boolean isAcceptable) {
        if (this.server == null) {
            return;
        }
        this.server.setAcceptable(isAcceptable);
    }

    public int getCurrentFlowCount() {
        return this.server == null ? 0 : this.server.getCurrentFlowCount();
    }

    public Comparable getResourceUsage() {
        return this.server == null ? null : this.server.getResourceUsage();
    }

    public Set getCurrentFlowIdSet() {
        return this.server == null ? new HashSet() : this.server.getIdSet();
    }

    public Date getFlowStartTime(String id) {
        try {
            return this.server == null ? null : (this.server.getFlowStartTime(id) >= 0L ? new Date(this.server.getFlowStartTime(id)) : null);
        }
        catch (NoSuchBeanFlowIdException e) {
            return null;
        }
    }

    public long getFlowCurrentProcessTime(String id) {
        try {
            return this.server == null ? -1L : this.server.getFlowCurrentProcessTime(id);
        }
        catch (NoSuchBeanFlowIdException e) {
            return -1L;
        }
    }

    public void setResourceUsage(ResourceUsage usage) {
        this.resourceUsage = usage;
    }

    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName == null) {
            throw new IllegalArgumentException("BeanFlowInvokerFactoryServiceName must be specified.");
        }
        if (this.jndiRepositoryServiceName == null) {
            throw new IllegalArgumentException("JndiRepositoryServiceName must be specified.");
        }
        this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        this.sequence = new StringSequenceService();
        this.sequence.create();
        this.sequence.setFormat("TIME_SEQ(" + this.sequenceTimestampFormat + "," + this.sequenceDigit + ")");
        this.sequence.start();
        if (this.resourceUsage == null && this.resourceUsageServiceName != null) {
            this.resourceUsage = (ResourceUsage)ServiceManagerFactory.getServiceObject(this.resourceUsageServiceName);
        }
        this.server = new BeanFlowInvokerServerImpl(this.beanFlowInvokerFactoryServiceName, this.interceptorChainFactoryServiceName, this.contextServiceName, this.sequence, this.resourceUsage, this.rmiPort);
        if (!this.jndiRepository.register(this.jndiName, this.server)) {
            throw new Exception("Could not register in jndiRepository.");
        }
        if (this.clusterServiceName != null) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            if (this.cluster.isJoin()) {
                throw new IllegalArgumentException("ClusterService already join.");
            }
            this.cluster.setOption((Serializable)((Object)RemoteObject.toStub(this.server)));
            this.cluster.join();
        }
    }

    public void stopService() throws Exception {
        if (this.cluster != null) {
            this.cluster.leave();
            this.cluster = null;
        }
        if (this.sequence != null) {
            this.sequence.stop();
            this.sequence.destroy();
            this.sequence = null;
        }
        this.jndiRepository.unregister(this.jndiName);
    }

    public static class BeanFlowInvokerServerImpl
    extends UnicastRemoteObject
    implements BeanFlowInvokerServer,
    KeepAliveCheckInvoker {
        private static final long serialVersionUID = -2397154705661936441L;
        private static Method invokeFlowMethod;
        private static Method invokeAsynchFlowMethod;
        private final ServiceName beanFlowInvokerFactoryServiceName;
        private final ServiceName interceptorChainFactoryServiceName;
        private final ServiceName contextServiceName;
        private final Sequence sequence;
        private final ResourceUsage resourceUsage;
        private final Map flowMap = Collections.synchronizedMap(new HashMap());
        private final Map monitorMap = Collections.synchronizedMap(new HashMap());
        private final Map contextMap = Collections.synchronizedMap(new HashMap());
        private boolean isAcceptable = true;

        public BeanFlowInvokerServerImpl(ServiceName beanFlowInvokerFactoryServiceName, ServiceName interceptorChainFactoryServiceName, ServiceName contextServiceName, Sequence sequence, ResourceUsage resourceUsage, int port) throws RemoteException {
            super(port);
            this.beanFlowInvokerFactoryServiceName = beanFlowInvokerFactoryServiceName;
            this.interceptorChainFactoryServiceName = interceptorChainFactoryServiceName;
            this.contextServiceName = contextServiceName;
            this.sequence = sequence;
            this.resourceUsage = resourceUsage;
        }

        private BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
            return (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }

        private BeanFlowInvoker getBeanFlowInvoker(Object id) throws NoSuchBeanFlowIdException {
            BeanFlowInvoker invoker = (BeanFlowInvoker)this.flowMap.get(id);
            if (invoker == null) {
                throw new NoSuchBeanFlowIdException(id);
            }
            return invoker;
        }

        private BeanFlowMonitor getBeanFlowMonitor(Object id) throws NoSuchBeanFlowIdException {
            BeanFlowMonitor monitor = (BeanFlowMonitor)this.monitorMap.get(id);
            if (monitor == null) {
                throw new NoSuchBeanFlowIdException(id);
            }
            return monitor;
        }

        private BeanFlowAsynchContext getBeanFlowAsynchContext(Object id) {
            BeanFlowAsynchContext context = (BeanFlowAsynchContext)this.contextMap.get(id);
            return context;
        }

        private InterceptorChain getInterceptorChain(String flowName) {
            if (this.interceptorChainFactoryServiceName == null) {
                return null;
            }
            InterceptorChainFactory factory = (InterceptorChainFactory)ServiceManagerFactory.getServiceObject(this.interceptorChainFactoryServiceName);
            return factory.getInterceptorChain(flowName);
        }

        private Context getContext() {
            return this.contextServiceName == null ? null : (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }

        public boolean isAcceptable() {
            return this.isAcceptable;
        }

        public void setAcceptable(boolean isAcceptable) {
            this.isAcceptable = isAcceptable;
        }

        public Set getBeanFlowNameSet() {
            return this.getBeanFlowInvokerFactory().getBeanFlowKeySet();
        }

        public boolean containsFlow(String name) {
            return this.getBeanFlowInvokerFactory().containsFlow(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object createFlow(String flowName, String caller, boolean isOverwride) throws InvalidConfigurationException {
            String id = this.sequence.increment();
            BeanFlowInvoker invoker = this.getBeanFlowInvokerFactory().createFlow(flowName, caller, isOverwride);
            BeanFlowMonitor monitor = invoker.createMonitor();
            Map map = this.monitorMap;
            synchronized (map) {
                if (this.monitorMap.containsKey(id)) {
                    throw new InvalidConfigurationException("BeanFlow Id is duplicated. Please extends SequenceDigit.");
                }
                this.monitorMap.put(id, monitor);
                this.flowMap.put(id, invoker);
            }
            return id;
        }

        public String[] getOverwrideFlowNames(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowInvoker(id).getOverwrideFlowNames();
        }

        public int getCurrentFlowCount() {
            return this.flowMap.size();
        }

        public Comparable getResourceUsage() {
            return this.resourceUsage == null ? (this.getCurrentFlowCount() == 0 ? null : new Integer(this.getCurrentFlowCount())) : this.resourceUsage.getUsage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object invokeFlow(Object id, Object obj, Map ctx) throws Exception, NoSuchBeanFlowIdException {
            Map map;
            Object object;
            block13: {
                Context context;
                BeanFlowInvoker invoker = this.getBeanFlowInvoker(id);
                BeanFlowMonitor monitor = this.getBeanFlowMonitor(id);
                if (ctx != null && ctx.size() != 0 && (context = this.getContext()) != null) {
                    context.putAll(ctx);
                }
                InterceptorChain chain = this.getInterceptorChain(invoker.getFlowName());
                try {
                    if (chain == null) {
                        object = invoker.invokeFlow(obj, monitor);
                        Object var11_9 = null;
                        map = this.monitorMap;
                        break block13;
                    }
                    DefaultMethodInvocationContext context2 = new DefaultMethodInvocationContext(invoker, invokeFlowMethod, new Object[]{obj, monitor});
                    try {
                        chain.setCurrentInterceptorIndex(-1);
                        Object object2 = chain.invokeNext(context2);
                        return object2;
                    }
                    catch (Throwable e) {
                        if (!(e instanceof Exception)) throw (Error)e;
                        throw (Exception)e;
                    }
                    finally {
                        chain.setCurrentInterceptorIndex(-1);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    Map map2 = this.monitorMap;
                    synchronized (map2) {
                        this.flowMap.remove(id);
                        this.monitorMap.remove(id);
                        throw throwable;
                    }
                }
            }
            synchronized (map) {
                this.flowMap.remove(id);
                this.monitorMap.remove(id);
                return object;
            }
        }

        public void invokeAsynchFlow(Object id, Object input, Map ctx, BeanFlowAsynchInvokeCallback callback, int maxAsynchWait) throws NoSuchBeanFlowIdException, Exception {
            Context context;
            BeanFlowInvoker invoker = this.getBeanFlowInvoker(id);
            BeanFlowMonitor monitor = this.getBeanFlowMonitor(id);
            if (ctx != null && ctx.size() != 0 && (context = this.getContext()) != null) {
                context.putAll(ctx);
            }
            BeanFlowAsynchInvokeCallbackImpl callbackWrapper = callback == null ? null : new BeanFlowAsynchInvokeCallbackImpl(id, callback);
            InterceptorChain chain = this.getInterceptorChain(invoker.getFlowName());
            Object beanFlowAsynchContext = null;
            if (chain == null) {
                beanFlowAsynchContext = invoker.invokeAsynchFlow(input, monitor, callbackWrapper, maxAsynchWait);
            } else {
                DefaultMethodInvocationContext context2 = new DefaultMethodInvocationContext(invoker, invokeAsynchFlowMethod, new Object[]{input, monitor, callbackWrapper, new Integer(maxAsynchWait)});
                try {
                    chain.setCurrentInterceptorIndex(-1);
                    beanFlowAsynchContext = chain.invokeNext(context2);
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw (Error)e;
                }
                finally {
                    chain.setCurrentInterceptorIndex(-1);
                }
            }
            if (callback != null) {
                this.contextMap.put(id, beanFlowAsynchContext);
            }
        }

        public boolean isExistsFlow(Object id) {
            return this.flowMap.containsKey(id);
        }

        public void suspendFlow(Object id) throws NoSuchBeanFlowIdException {
            this.getBeanFlowMonitor(id).suspend();
        }

        public boolean isSuspendFlow(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).isSuspend();
        }

        public boolean isSuspendedFlow(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).isSuspended();
        }

        public void resumeFlow(Object id) throws NoSuchBeanFlowIdException {
            this.getBeanFlowMonitor(id).resume();
        }

        public void stopFlow(Object id) {
            BeanFlowAsynchContext context = this.getBeanFlowAsynchContext(id);
            if (context != null) {
                context.cancel();
                this.contextMap.remove(id);
            }
            try {
                this.getBeanFlowMonitor(id).stop();
            }
            catch (NoSuchBeanFlowIdException noSuchBeanFlowIdException) {
                // empty catch block
            }
        }

        public boolean isStopFlow(Object id) {
            try {
                return this.getBeanFlowMonitor(id).isStop();
            }
            catch (NoSuchBeanFlowIdException e) {
                return true;
            }
        }

        public boolean isStoppedFlow(Object id) {
            try {
                return this.getBeanFlowMonitor(id).isStopped();
            }
            catch (NoSuchBeanFlowIdException e) {
                return true;
            }
        }

        public String getFlowName(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getFlowName();
        }

        public String getCurrentFlowName(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getCurrentFlowName();
        }

        public String getCurrentStepName(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getCurrentStepName();
        }

        public long getFlowStartTime(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getStartTime();
        }

        public long getFlowCurrentProcessTime(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getCurrentProcessTime();
        }

        public void clearMonitor(Object id) throws NoSuchBeanFlowIdException {
            this.getBeanFlowMonitor(id).clear();
        }

        public void cancel(Object id) {
            BeanFlowAsynchContext context = this.getBeanFlowAsynchContext(id);
            if (context != null) {
                context.cancel();
                this.contextMap.remove(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(Object id) {
            try {
                this.stopFlow(id);
            }
            catch (NoSuchBeanFlowIdException e) {
                // empty catch block
            }
            BeanFlowInvoker invoker = null;
            Map map = this.monitorMap;
            synchronized (map) {
                invoker = (BeanFlowInvoker)this.flowMap.remove(id);
                this.monitorMap.remove(id);
                this.contextMap.remove(id);
            }
            if (invoker != null) {
                invoker.end();
            }
        }

        public Set getIdSet() {
            return this.flowMap.keySet();
        }

        public Object invoke(InvocationContext context) throws Throwable {
            MethodInvocationContext mic = (MethodInvocationContext)context;
            Method method = mic.getTargetMethod();
            Object[] params = mic.getParameters();
            return method.invoke((Object)this, params);
        }

        public boolean isAlive() {
            try {
                BeanFlowInvokerFactory factory = this.getBeanFlowInvokerFactory();
                if (factory instanceof Service) {
                    return ((Service)((Object)factory)).getState() == 3;
                }
                return true;
            }
            catch (ServiceNotFoundException e) {
                return false;
            }
        }

        public void addKeepAliveListener(KeepAliveListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeKeepAliveListener(KeepAliveListener listener) {
            throw new UnsupportedOperationException();
        }

        public void clearKeepAliveListener() {
            throw new UnsupportedOperationException();
        }

        static {
            try {
                invokeFlowMethod = (class$jp$ossc$nimbus$service$beancontrol$interfaces$BeanFlowInvoker == null ? (class$jp$ossc$nimbus$service$beancontrol$interfaces$BeanFlowInvoker = BeanFlowInvokerServerService.class$("jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker")) : class$jp$ossc$nimbus$service$beancontrol$interfaces$BeanFlowInvoker).getMethod("invokeFlow", class$java$lang$Object == null ? (class$java$lang$Object = BeanFlowInvokerServerService.class$("java.lang.Object")) : class$java$lang$Object, class$jp$ossc$nimbus$service$beancontrol$BeanFlowMonitor == null ? (class$jp$ossc$nimbus$service$beancontrol$BeanFlowMonitor = BeanFlowInvokerServerService.class$("jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor")) : class$jp$ossc$nimbus$service$beancontrol$BeanFlowMonitor);
            }
            catch (NoSuchMethodException e) {
                invokeFlowMethod = null;
            }
            try {
                invokeAsynchFlowMethod = (class$jp$ossc$nimbus$service$beancontrol$interfaces$BeanFlowInvoker == null ? (class$jp$ossc$nimbus$service$beancontrol$interfaces$BeanFlowInvoker = BeanFlowInvokerServerService.class$("jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker")) : class$jp$ossc$nimbus$service$beancontrol$interfaces$BeanFlowInvoker).getMethod("invokeAsynchFlow", class$java$lang$Object == null ? (class$java$lang$Object = BeanFlowInvokerServerService.class$("java.lang.Object")) : class$java$lang$Object, class$jp$ossc$nimbus$service$beancontrol$BeanFlowMonitor == null ? (class$jp$ossc$nimbus$service$beancontrol$BeanFlowMonitor = BeanFlowInvokerServerService.class$("jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor")) : class$jp$ossc$nimbus$service$beancontrol$BeanFlowMonitor, class$jp$ossc$nimbus$service$beancontrol$BeanFlowAsynchInvokeCallback == null ? (class$jp$ossc$nimbus$service$beancontrol$BeanFlowAsynchInvokeCallback = BeanFlowInvokerServerService.class$("jp.ossc.nimbus.service.beancontrol.BeanFlowAsynchInvokeCallback")) : class$jp$ossc$nimbus$service$beancontrol$BeanFlowAsynchInvokeCallback, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                invokeAsynchFlowMethod = null;
            }
        }

        protected class BeanFlowAsynchInvokeCallbackImpl
        implements BeanFlowAsynchInvokeCallback {
            protected Object id;
            protected BeanFlowAsynchInvokeCallback callback;

            public BeanFlowAsynchInvokeCallbackImpl(Object id, BeanFlowAsynchInvokeCallback callback) {
                this.id = id;
                this.callback = callback;
            }

            public void reply(Object output, Throwable th) throws RemoteException {
                BeanFlowInvokerServerImpl.this.end(this.id);
                if (this.callback != null) {
                    this.callback.reply(output, th);
                }
            }
        }
    }
}

