/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jndi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.jndi.CachedJndiFinderServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;

public class CachedJndiFinderService
extends ServiceBase
implements JndiFinder,
DaemonRunnable,
KeepAliveChecker,
CachedJndiFinderServiceMBean {
    private static final long serialVersionUID = 2361330897642105726L;
    private static final String C_NONE = "";
    private static final String ROOT_CONTEXT = "/";
    private Properties contextEnv;
    private InitialContext initialCtx;
    private ServiceName remoteObjCacheServiceName;
    private CacheMap remoteObjCache;
    private String jndiPrefix = "";
    private int lookupRetryCount = 0;
    private long retryInterval = 1000L;
    private String[] retryExceptionClassNames = DEFAULT_RETRY_EXCXEPTION_NAME;
    private Class[] retryExceptionClasses;
    private boolean isAliveCheckJNDIServer;
    private boolean isAliveJNDIServer;
    private long aliveCheckJNDIServerInterval = 60000L;
    private Daemon daemon;
    private boolean isLoggingDeadJNDIServer = true;
    private boolean isLoggingRecoverJNDIServer = true;
    private String deadJNDIServerLogMessageId = "CJF__00001";
    private String recoverJNDIServerLogMessageId = "CJF__00002";
    private List keepAliveListeners;

    public void createService() throws Exception {
        this.daemon = new Daemon(this);
        this.daemon.setName("Nimbus JndiCheckDaemon " + this.getServiceNameObject());
        this.keepAliveListeners = new ArrayList();
    }

    public void setCacheMap(CacheMap remoteObjCache) {
        this.remoteObjCache = remoteObjCache;
    }

    public void startService() throws Exception {
        if (this.retryExceptionClassNames != null && this.retryExceptionClassNames.length != 0) {
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            this.retryExceptionClasses = new Class[this.retryExceptionClassNames.length];
            for (int i = 0; i < this.retryExceptionClassNames.length; ++i) {
                this.retryExceptionClasses[i] = Class.forName(this.retryExceptionClassNames[i], true, loader);
            }
        }
        if (this.remoteObjCacheServiceName != null) {
            this.remoteObjCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.remoteObjCacheServiceName);
        }
        this.initialCtx = this.contextEnv == null ? new InitialContext() : new InitialContext(this.contextEnv);
        this.isAliveJNDIServer = true;
        if (this.isAliveCheckJNDIServer) {
            this.daemon.start();
        }
    }

    public void stopService() throws Exception {
        this.daemon.stop();
        this.initialCtx.close();
    }

    public void destory() throws Exception {
        this.initialCtx = null;
        this.remoteObjCache = null;
        this.contextEnv = null;
        this.remoteObjCacheServiceName = null;
        this.retryExceptionClasses = null;
        this.daemon = null;
        this.keepAliveListeners = null;
    }

    public Object lookup() throws NamingException {
        return this.lookup(C_NONE);
    }

    private boolean isRetryException(NamingException e) {
        if (this.retryExceptionClasses != null && this.retryExceptionClasses.length != 0) {
            for (int i = 0; i < this.retryExceptionClasses.length; ++i) {
                if (!this.retryExceptionClasses[i].isInstance(e)) continue;
                return true;
            }
        }
        return false;
    }

    public Object lookup(String name) throws NamingException {
        Object result = null;
        String key = this.jndiPrefix + name;
        if (this.remoteObjCache != null && (result = this.remoteObjCache.get(key)) != null) {
            return result;
        }
        result = this.lookupInternal(key);
        if (result != null && this.remoteObjCache != null) {
            this.remoteObjCache.put(key, result);
        }
        return result;
    }

    private Object lookupInternal(String key) throws NamingException {
        Object result;
        block8: {
            result = null;
            try {
                result = this.initialCtx.lookup(key);
            }
            catch (NamingException e) {
                if (this.lookupRetryCount > 0 && this.isRetryException(e)) break block8;
                throw e;
            }
        }
        if (result == null) {
            for (int rcont = 0; rcont < this.lookupRetryCount; ++rcont) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    result = this.initialCtx.lookup(key);
                    break;
                }
                catch (NamingException e) {
                    if (rcont != this.lookupRetryCount - 1 && this.isRetryException(e)) continue;
                    throw e;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeepAliveListener(KeepAliveListener listener) {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeepAliveListener() {
        List list = this.keepAliveListeners;
        synchronized (list) {
            this.keepAliveListeners.clear();
        }
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) {
        try {
            Thread.sleep(this.aliveCheckJNDIServerInterval);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (this.isAliveCheckJNDIServer) {
            try {
                return this.lookupInternal(ROOT_CONTEXT);
            }
            catch (NamingException e) {
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Object lookupedObj, DaemonControl ctrl) {
        if (!this.isAliveCheckJNDIServer) {
            return;
        }
        if (this.isAliveJNDIServer) {
            if (lookupedObj instanceof NamingException) {
                this.isAliveJNDIServer = false;
                this.clearCache();
                List list = this.keepAliveListeners;
                synchronized (list) {
                    Iterator itr = this.keepAliveListeners.iterator();
                    while (itr.hasNext()) {
                        KeepAliveListener keepAliveListener = (KeepAliveListener)itr.next();
                        keepAliveListener.onDead(this);
                    }
                }
                if (this.isLoggingDeadJNDIServer) {
                    this.getLogger().write(this.deadJNDIServerLogMessageId, this.getJNDIServerInfo(), (Throwable)((NamingException)lookupedObj));
                }
            }
        } else if (!(lookupedObj instanceof NamingException)) {
            this.isAliveJNDIServer = true;
            List list = this.keepAliveListeners;
            synchronized (list) {
                Iterator itr = this.keepAliveListeners.iterator();
                while (itr.hasNext()) {
                    KeepAliveListener keepAliveListener = (KeepAliveListener)itr.next();
                    keepAliveListener.onRecover(this);
                }
            }
            if (this.isLoggingRecoverJNDIServer) {
                this.getLogger().write(this.recoverJNDIServerLogMessageId, this.getJNDIServerInfo());
            }
        }
    }

    private Object getJNDIServerInfo() {
        Object result = null;
        try {
            result = this.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (result == null) {
            result = "localhost";
        }
        return result;
    }

    public void garbage() {
    }

    public void setEnvironment(Properties prop) {
        this.contextEnv = prop;
    }

    public Properties getEnvironment() throws NamingException {
        if (this.contextEnv != null) {
            return this.contextEnv;
        }
        if (this.initialCtx != null) {
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)this.initialCtx.getEnvironment());
            return prop;
        }
        return null;
    }

    public void setCacheMapServiceName(ServiceName name) {
        this.remoteObjCacheServiceName = name;
    }

    public ServiceName getCacheMapServiceName() {
        return this.remoteObjCacheServiceName;
    }

    public void setPrefix(String prefix) {
        this.jndiPrefix = prefix;
    }

    public String getPrefix() {
        return this.jndiPrefix;
    }

    public void setRetryCount(int num) {
        this.lookupRetryCount = num;
    }

    public int getRetryCount() {
        return this.lookupRetryCount;
    }

    public void setRetryInterval(long interval) {
        this.retryInterval = interval;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryExceptionClassNames(String[] classNames) {
        this.retryExceptionClassNames = classNames;
    }

    public String[] getRetryExceptionClassNames() {
        return this.retryExceptionClassNames;
    }

    public void setAliveCheckJNDIServer(boolean isCheck) {
        this.isAliveCheckJNDIServer = isCheck;
        if (isCheck && this.getState() == 3 && !this.daemon.isRunning()) {
            this.daemon.start();
        }
    }

    public boolean isAliveCheckJNDIServer() {
        return this.isAliveCheckJNDIServer;
    }

    public void setAliveCheckJNDIServerInterval(long interval) {
        this.aliveCheckJNDIServerInterval = interval;
    }

    public long getAliveCheckJNDIServerInterval() {
        return this.aliveCheckJNDIServerInterval;
    }

    public boolean isAliveJNDIServer() {
        if (this.getState() != 3) {
            return false;
        }
        if (this.isAliveCheckJNDIServer) {
            return this.isAliveJNDIServer;
        }
        try {
            this.lookupInternal(ROOT_CONTEXT);
            return true;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public boolean isAlive() {
        return this.isAliveJNDIServer();
    }

    public void setLoggingDeadJNDIServer(boolean isOutput) {
        this.isLoggingDeadJNDIServer = isOutput;
    }

    public boolean isLoggingDeadJNDIServer() {
        return this.isLoggingDeadJNDIServer;
    }

    public void setLoggingRecoverJNDIServer(boolean isOutput) {
        this.isLoggingRecoverJNDIServer = isOutput;
    }

    public boolean isLoggingRecoverJNDIServer() {
        return this.isLoggingRecoverJNDIServer;
    }

    public void setDeadJNDIServerLogMessageId(String id) {
        this.deadJNDIServerLogMessageId = id;
    }

    public String getDeadJNDIServerLogMessageId() {
        return this.deadJNDIServerLogMessageId;
    }

    public void setRecoverJNDIServerLogMessageId(String id) {
        this.recoverJNDIServerLogMessageId = id;
    }

    public String getRecoverJNDIServerLogMessageId() {
        return this.recoverJNDIServerLogMessageId;
    }

    public void clearCache() {
        if (this.remoteObjCache != null) {
            this.remoteObjCache.clear();
        }
    }

    public void clearCache(String name) {
        if (this.remoteObjCache != null) {
            this.remoteObjCache.remove(name);
        }
    }

    public String listContext() throws NamingException {
        if (this.initialCtx == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<pre>");
        this.listContext(pw, this.initialCtx, "\u3000");
        pw.println("</pre>");
        return sw.toString();
    }

    private void listContext(PrintWriter pw, Context context, String indent) throws NamingException {
        NamingEnumeration<Binding> list = context.listBindings(C_NONE);
        while (list.hasMore()) {
            Binding item = list.next();
            String className = item.getClassName();
            String name = item.getName();
            pw.println(indent + className + "\u3000" + name);
            Object o = item.getObject();
            if (!(o instanceof Context)) continue;
            this.listContext(pw, (Context)o, indent + "\u3000");
        }
    }
}

