/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBaseMBean;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public abstract class CSVJournalEditorServiceBase
extends ImmutableJournalEditorServiceBase
implements CSVJournalEditorServiceBaseMBean,
Serializable {
    private static final long serialVersionUID = -1461229603659333648L;
    protected static final String CSV_SEPARATOR = ",";
    private static final String LINE_FEED_STRING = "\\n";
    private static final String CARRIAGE_RETURN_STRING = "\\r";
    private static final String CSV_ENCLOSE_STRING = "\"\"";
    protected static final char CSV_ENCLOSE_CHAR = '\"';
    protected ThreadLocal csvElements;
    private String csvSeparator = ",";

    protected void preCreateService() throws Exception {
        super.preCreateService();
        this.csvElements = new ThreadLocal();
    }

    protected void postDestroyService() throws Exception {
        super.postDestroyService();
        this.csvElements = null;
    }

    public void setCSVSeparator(String separator) {
        this.csvSeparator = separator;
    }

    public String getCSVSeparator() {
        return this.csvSeparator;
    }

    protected void addElements(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            this.addElement(objs[i]);
        }
    }

    protected void addElement(Object obj) {
        ArrayList<Object> elements = (ArrayList<Object>)this.csvElements.get();
        if (elements == null) {
            elements = new ArrayList<Object>();
            this.csvElements.set(elements);
        }
        elements.add(obj);
    }

    protected List replaceNewCSVElements() {
        ArrayList elements = (ArrayList)this.csvElements.get();
        if (elements != null) {
            this.csvElements.set(new ArrayList());
            return elements;
        }
        elements = new ArrayList();
        this.csvElements.set(elements);
        return null;
    }

    protected void setCSVElements(List elements) {
        this.csvElements.set(elements);
    }

    protected String toString(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        List oldElements = this.replaceNewCSVElements();
        this.processCSV(finder, key, value);
        this.makeCSVFormat(finder, key, value, buf);
        this.setCSVElements(oldElements);
        return buf.toString();
    }

    protected void processCSV(EditorFinder finder, Object key, Object value) {
    }

    protected void makeCSVFormat(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        List elements = (List)this.csvElements.get();
        if (elements != null) {
            StringBuffer tmpBuf = new StringBuffer();
            Iterator values = elements.iterator();
            while (values.hasNext()) {
                Object val = values.next();
                JournalEditor editor = finder.findEditor(key, val);
                tmpBuf.setLength(0);
                this.makeObjectFormat(finder, key, val, tmpBuf);
                this.escape(editor, tmpBuf);
                this.enclose(editor, tmpBuf);
                buf.append(tmpBuf);
                if (!values.hasNext()) continue;
                buf.append(this.getCSVSeparator());
            }
            elements.clear();
        }
    }

    protected StringBuffer enclose(JournalEditor editor, StringBuffer buf) {
        if (buf == null) {
            return null;
        }
        if (editor != null && editor instanceof CSVJournalEditorServiceBase) {
            return buf;
        }
        buf.insert(0, '\"');
        buf.append('\"');
        return buf;
    }

    protected String enclose(JournalEditor editor, String str) {
        if (editor != null && editor instanceof CSVJournalEditorServiceBase) {
            return str;
        }
        return '\"' + str + '\"';
    }

    protected StringBuffer escape(JournalEditor editor, StringBuffer buf) {
        if (buf == null) {
            return null;
        }
        if (buf.length() == 0) {
            return buf;
        }
        if (editor != null && editor instanceof CSVJournalEditorServiceBase) {
            return buf;
        }
        String result = this.escape(editor, buf.toString());
        buf.setLength(0);
        return buf.append(result);
    }

    protected String escape(JournalEditor editor, String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        if (editor != null && editor instanceof CSVJournalEditorServiceBase) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    buf.append(CARRIAGE_RETURN_STRING);
                    continue block5;
                }
                case '\n': {
                    buf.append(LINE_FEED_STRING);
                    continue block5;
                }
                case '\"': {
                    buf.append(CSV_ENCLOSE_STRING);
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

