/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.util.List;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.keepalive.DefaultClusterListenerServiceMBean;

public class DefaultClusterListenerService
extends ServiceBase
implements ClusterListener,
ServiceStateListener,
DefaultClusterListenerServiceMBean {
    private static final long serialVersionUID = -1602329265459610639L;
    protected ServiceName targetServiceName;
    protected Service targetService;
    protected ServiceName clusterServiceName;
    protected ClusterService clusterService;

    public void setTargetServiceName(ServiceName name) {
        this.targetServiceName = name;
    }

    public ServiceName getTargetServiceName() {
        return this.targetServiceName;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void setTargetService(Service service) {
        this.targetService = service;
    }

    public Service getTargetService() {
        return this.targetService;
    }

    public void setClusterService(ClusterService service) {
        this.clusterService = service;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public void startService() throws Exception {
        if (this.targetServiceName != null) {
            ServiceManagerFactory.addServiceStateListener(this.targetServiceName, (ServiceStateListener)this);
        } else if (this.targetService != null) {
            ServiceManagerFactory.addServiceStateListener(this.targetService.getServiceNameObject(), (ServiceStateListener)this);
        }
    }

    public void stopService() throws Exception {
        if (this.targetServiceName != null) {
            ServiceManagerFactory.removeServiceStateListener(this.targetServiceName, (ServiceStateListener)this);
        } else if (this.targetService != null) {
            ServiceManagerFactory.removeServiceStateListener(this.targetService.getServiceNameObject(), (ServiceStateListener)this);
        }
    }

    public void memberInit(Object myId, List members) {
    }

    public void memberChange(List oldMembers, List newMembers) {
    }

    public void changeMain() throws Exception {
        Service service = this.targetService;
        if (service == null && this.targetServiceName != null) {
            service = ServiceManagerFactory.getService(this.targetServiceName);
        }
        if (service != null) {
            service.start();
        }
    }

    public void changeSub() {
        Service service = this.targetService;
        if (service == null && this.targetServiceName != null) {
            service = ServiceManagerFactory.getService(this.targetServiceName);
        }
        if (service != null) {
            service.stop();
        }
    }

    public void stateChanged(ServiceStateChangeEvent e) throws Exception {
        ClusterService cluster = this.clusterService;
        if (cluster == null && this.clusterServiceName != null) {
            try {
                cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            }
            catch (ServiceNotFoundException ex) {
                // empty catch block
            }
        }
        if (cluster != null) {
            switch (e.getService().getState()) {
                case 3: {
                    if (cluster.getState() != 5) break;
                    try {
                        cluster.start();
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 4: {
                    if (cluster.getState() != 3) break;
                    cluster.stop();
                    break;
                }
            }
        }
    }

    public boolean isEnabledState(int state) {
        return state == 3 || state == 4;
    }
}

