/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import jp.ossc.nimbus.util.converter.AbstractStringConverter;

public class CustomStringConverter
extends AbstractStringConverter {
    private static final long serialVersionUID = 2598748283194585459L;
    protected char[][] convertChars;
    protected String[][] convertStrings;

    public CustomStringConverter() {
        this(1);
    }

    public CustomStringConverter(int type) {
        super(type);
    }

    public CustomStringConverter(int type, String[] fromStrs, String[] toStrs) {
        super(type);
        this.setConvertStrings(fromStrs, toStrs);
    }

    public CustomStringConverter(int type, char[] fromChars, char[] toChars) {
        super(type);
        this.setConvertChars(fromChars, toChars);
    }

    public CustomStringConverter(int type, String[] fromStrs, String[] toStrs, char[] fromChars, char[] toChars) {
        super(type);
        this.setConvertStrings(fromStrs, toStrs);
        this.setConvertChars(fromChars, toChars);
    }

    public void setConvertStrings(String[] fromStrs, String[] toStrs) {
        if (toStrs == null && fromStrs == null) {
            this.convertStrings = null;
        } else {
            if (toStrs == null || fromStrs == null || toStrs.length != fromStrs.length) {
                throw new IllegalArgumentException("Invalid ConvertStrings.");
            }
            String[][] convStrs = new String[toStrs.length][];
            for (int i = 0; i < toStrs.length; ++i) {
                if (fromStrs[i] == null || toStrs[i] == null) {
                    throw new IllegalArgumentException("Invalid ConvertStrings.");
                }
                convStrs[i] = new String[]{fromStrs[i], toStrs[i]};
            }
            this.convertStrings = convStrs;
        }
    }

    public void setConvertChars(char[] fromChars, char[] toChars) {
        if (toChars == null && fromChars == null) {
            this.convertChars = null;
        } else {
            if (toChars == null || fromChars == null || toChars.length != fromChars.length) {
                throw new IllegalArgumentException("Invalid ConvertChars.");
            }
            char[][] convChars = new char[toChars.length][];
            for (int i = 0; i < toChars.length; ++i) {
                convChars[i] = new char[]{fromChars[i], toChars[i]};
            }
            this.convertChars = convChars;
        }
    }

    protected char[][] getConvertChars() {
        return this.convertChars;
    }

    protected String[][] getConvertStrings() {
        return this.convertStrings;
    }
}

