/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NoSuchReadablePropertyException;
import jp.ossc.nimbus.beans.NoSuchWritablePropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class SimpleProperty
implements Property,
Serializable,
Comparable {
    private static final long serialVersionUID = 5346194284290420718L;
    private static final String MSG_00001 = "Length of property literal must be more than 1.";
    protected static final Object[] NULL_ARGS = new Object[0];
    protected static final Class[] NULL_METHOD_PARAMS = new Class[0];
    protected static final String GET_METHOD_PREFIX = "get";
    protected static final String SET_METHOD_PREFIX = "set";
    protected static final String MAP_GET_METHOD_NAME = "get";
    protected static final Class[] MAP_GET_METHOD_ARGS = new Class[]{Object.class};
    protected static final String MAP_SET_METHOD_NAME = "put";
    protected static final Class[] MAP_SET_METHOD_ARGS = new Class[]{Object.class, Object.class};
    protected static final String ARRAY_LENGTH_METHOD_NAME = "length";
    protected String property;
    protected transient Map getMethodCache = new HashMap();
    protected transient Map setMethodCache = new HashMap();
    protected boolean isIgnoreNullProperty;

    public SimpleProperty() {
    }

    public SimpleProperty(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    @Override
    public void parse(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null || prop.length() == 0) {
            throw new IllegalArgumentException(MSG_00001);
        }
        this.property = prop;
    }

    @Override
    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        Class type;
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.property)) != null && (type = propSchema.getType()) != null) {
            return type;
        }
        return this.getPropertyType(obj.getClass());
    }

    public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        try {
            Method readMethod = this.getReadMethod(clazz);
            return readMethod.getReturnType();
        }
        catch (InvocationTargetException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (NoSuchPropertyException e) {
            try {
                Object methodObj;
                Method writeMethod = this.getWriteMethod(clazz);
                if (this.setMethodCache.containsKey(clazz) && !((methodObj = this.setMethodCache.get(clazz)) instanceof Method)) {
                    return null;
                }
                return writeMethod.getParameterTypes()[0];
            }
            catch (InvocationTargetException e2) {
                throw e;
            }
            catch (NoSuchPropertyException e2) {
                throw e2;
            }
        }
    }

    private String createGetterName() {
        StringBuffer result = new StringBuffer(this.property);
        int len = result.length();
        if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
            char capital = Character.toUpperCase(result.charAt(0));
            result.deleteCharAt(0).insert(0, capital);
        }
        return result.insert(0, "get").toString();
    }

    private String createSetterName() {
        StringBuffer result = new StringBuffer(this.property);
        int len = result.length();
        if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
            char capital = Character.toUpperCase(result.charAt(0));
            result.deleteCharAt(0).insert(0, capital);
        }
        return result.insert(0, SET_METHOD_PREFIX).toString();
    }

    @Override
    public boolean isReadable(Object obj) {
        Record record;
        RecordSchema recSchema;
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null) {
            PropertySchema propSchema = recSchema.getPropertySchema(this.property);
            if (propSchema != null) {
                return true;
            }
            try {
                this.getReadMethod(record.getClass());
                return true;
            }
            catch (NoSuchPropertyException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        }
        return this.isReadable(obj.getClass());
    }

    public boolean isReadable(Class clazz) {
        if (this.property == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            this.getReadMethod(clazz);
            return true;
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public boolean isWritable(Object obj, Object value) {
        if (value == null) {
            return this.isWritable(obj.getClass());
        }
        return this.isWritable(obj, value.getClass());
    }

    @Override
    public boolean isWritable(Object obj, Class clazz) {
        Record record;
        RecordSchema recSchema;
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null) {
            PropertySchema propSchema = recSchema.getPropertySchema(this.property);
            if (propSchema != null) {
                return propSchema.getType() == null || propSchema.getType().isAssignableFrom(clazz);
            }
            try {
                this.getWriteMethod(record.getClass());
                return true;
            }
            catch (NoSuchPropertyException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        }
        return this.isWritable(obj.getClass());
    }

    public boolean isWritable(Class clazz) {
        if (this.property == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            this.getWriteMethod(clazz);
            return true;
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        if (obj == null && this.isIgnoreNullProperty) {
            return null;
        }
        try {
            Class<?> clazz = obj.getClass();
            if (clazz.isArray() && ARRAY_LENGTH_METHOD_NAME.equals(this.property)) {
                return new Integer(Array.getLength(obj));
            }
            Method readMethod = this.getReadMethod(clazz);
            try {
                if (readMethod.getParameterTypes().length == 0) {
                    return readMethod.invoke(obj, NULL_ARGS);
                }
                return readMethod.invoke(obj, this.property);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
        }
        catch (NoSuchPropertyException e) {
            if (obj instanceof Map) {
                return ((Map)obj).get(this.property);
            }
            throw e;
        }
    }

    @Override
    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        this.setProperty(obj, value == null ? null : value.getClass(), value);
    }

    @Override
    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        if (type == null) {
            if (value == null) {
                PropertySchema propSchema;
                Record record;
                RecordSchema recSchema;
                if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.property)) != null) {
                    type = propSchema.getType();
                }
            } else {
                type = value.getClass();
            }
        }
        writeMethod = type == null ? this.getWriteMethod(clazz) : this.getWriteMethod(clazz, type);
        try {
            if (writeMethod.getParameterTypes().length == 1) {
                Class<?> paramType = writeMethod.getParameterTypes()[0];
                if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                    value = this.castPrimitiveWrapper(paramType, (Number)value);
                }
                writeMethod.invoke(obj, value);
            } else {
                writeMethod.invoke(obj, this.property, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    public Method getReadMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        return this.getReadMethod(obj.getClass());
    }

    public Method getReadMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            if (readMethod == null) {
                throw new NoSuchReadablePropertyException(clazz, this.property);
            }
        } else {
            if (!SimpleProperty.isAccessableClass(clazz) || Proxy.isProxyClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    try {
                        return this.getReadMethod(interfaces[i]);
                    }
                    catch (NoSuchPropertyException e) {
                        continue;
                    }
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.getReadMethod(superClass);
                }
                throw new NoSuchReadablePropertyException(clazz, this.property);
            }
            PropertyDescriptor descriptor = null;
            try {
                descriptor = this.getPropertyDescriptor(clazz);
                readMethod = descriptor.getReadMethod();
                if (readMethod != null && readMethod.getParameterTypes().length != 0) {
                    readMethod = null;
                }
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            if (readMethod == null) {
                try {
                    readMethod = clazz.getMethod(this.createGetterName(), NULL_METHOD_PARAMS);
                    if (Void.TYPE.equals(readMethod.getReturnType())) {
                        readMethod = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (readMethod == null) {
                block26: {
                    try {
                        readMethod = clazz.getMethod(this.property, NULL_METHOD_PARAMS);
                    }
                    catch (NoSuchMethodException e) {
                        if (this.property == null || this.property.length() == 0 || !Character.isUpperCase(this.property.charAt(0))) break block26;
                        StringBuffer methodName = new StringBuffer(this.property);
                        char capital = Character.toLowerCase(methodName.charAt(0));
                        methodName.deleteCharAt(0).insert(0, capital);
                        try {
                            readMethod = clazz.getMethod(methodName.toString(), NULL_METHOD_PARAMS);
                        }
                        catch (NoSuchMethodException e2) {
                            // empty catch block
                        }
                    }
                }
                if (readMethod != null && Void.TYPE.equals(readMethod.getReturnType())) {
                    readMethod = null;
                }
            }
            if (readMethod == null && Map.class.isAssignableFrom(clazz)) {
                try {
                    readMethod = Map.class.getMethod("get", MAP_GET_METHOD_ARGS);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (readMethod == null) {
                this.getMethodCache.put(clazz, null);
                throw new NoSuchReadablePropertyException(clazz, this.property);
            }
            this.getMethodCache.put(clazz, readMethod);
        }
        return readMethod;
    }

    public Method getWriteMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(obj.getClass());
    }

    public Method getWriteMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(clazz, null);
    }

    public Method getWriteMethod(Class clazz, Class valClazz) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchWritablePropertyException(clazz, this.property);
        }
        if (this.setMethodCache.containsKey(clazz)) {
            Object methodObj = this.setMethodCache.get(clazz);
            if (methodObj instanceof Method) {
                return (Method)methodObj;
            }
            if (valClazz == null) {
                throw new NoSuchWritablePropertyException(clazz, this.property, "The method cannot be specified, because the method of the overload exists.");
            }
            Map overloadMap = (Map)methodObj;
            if (overloadMap.containsKey(valClazz)) {
                return (Method)overloadMap.get(valClazz);
            }
        }
        if (!SimpleProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                try {
                    return this.getWriteMethod(interfaces[i], valClazz);
                }
                catch (NoSuchPropertyException e) {
                    continue;
                }
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getWriteMethod(superClass, valClazz);
            }
            throw new NoSuchWritablePropertyException(clazz, this.property);
        }
        Method writeMethod = null;
        String setterName = this.createSetterName();
        Class primitiveClazz = this.toPrimitive(valClazz);
        String lowerCaseProperty = null;
        if (this.property != null && this.property.length() != 0 && Character.isUpperCase(this.property.charAt(0))) {
            StringBuffer methodName = new StringBuffer(this.property);
            char capital = Character.toLowerCase(methodName.charAt(0));
            methodName.deleteCharAt(0).insert(0, capital);
            lowerCaseProperty = methodName.toString();
        }
        Method[] methods = clazz.getMethods();
        HashMap overloadMap = new HashMap();
        boolean isMatch = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != 1 || !setterName.equals(methods[i].getName()) && !this.property.equals(methods[i].getName()) && !methods[i].getName().equals(lowerCaseProperty) || overloadMap.containsKey(paramTypes[0]) && setterName.equals(((Method)overloadMap.get(paramTypes[0])).getName())) continue;
            overloadMap.put(paramTypes[0], methods[i]);
            if (isMatch) continue;
            if (writeMethod == null) {
                if (valClazz == null) {
                    writeMethod = methods[i];
                    continue;
                }
                if (!this.isAssignableFrom(paramTypes[0], valClazz) && !paramTypes[0].equals(primitiveClazz)) continue;
                writeMethod = methods[i];
                if (!valClazz.equals(paramTypes[0]) && !paramTypes[0].equals(primitiveClazz)) continue;
                isMatch = true;
                continue;
            }
            if (valClazz == null || !this.isAssignableFrom(paramTypes[0], valClazz) && !paramTypes[0].equals(primitiveClazz)) continue;
            if (valClazz.equals(paramTypes[0]) || paramTypes[0].equals(primitiveClazz)) {
                writeMethod = methods[i];
                isMatch = true;
                continue;
            }
            if (!this.isAssignableFrom(writeMethod.getParameterTypes()[0], paramTypes[0])) continue;
            writeMethod = methods[i];
        }
        if (writeMethod != null) {
            if (overloadMap.size() > 1) {
                if (valClazz == null) {
                    throw new NoSuchWritablePropertyException(clazz, this.property, "The method cannot be specified, because the method of the overload exists.");
                }
                this.setMethodCache.put(clazz, overloadMap);
            } else {
                this.setMethodCache.put(clazz, writeMethod);
            }
            return writeMethod;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            try {
                writeMethod = Map.class.getMethod(MAP_SET_METHOD_NAME, MAP_SET_METHOD_ARGS);
                this.setMethodCache.put(clazz, writeMethod);
                return writeMethod;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        throw new NoSuchWritablePropertyException(clazz, this.property);
    }

    protected boolean isAssignableFrom(Class thisClass, Class thatClass) {
        if (thatClass == null) {
            return !thisClass.isPrimitive();
        }
        if (this.isNumber(thisClass) && this.isNumber(thatClass)) {
            if (Byte.TYPE.equals(thisClass) || Byte.class.equals((Object)thisClass)) {
                return Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Short.TYPE.equals(thisClass) || Short.class.equals((Object)thisClass)) {
                return Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Integer.TYPE.equals(thisClass) || Integer.class.equals((Object)thisClass)) {
                return Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Long.TYPE.equals(thisClass) || Long.class.equals((Object)thisClass)) {
                return Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (BigInteger.class.equals((Object)thisClass)) {
                return BigInteger.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Float.TYPE.equals(thisClass) || Float.class.equals((Object)thisClass)) {
                return Float.TYPE.equals(thatClass) || Float.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (Double.TYPE.equals(thisClass) || Double.class.equals((Object)thisClass)) {
                return Double.TYPE.equals(thatClass) || Double.class.equals((Object)thatClass) || Float.TYPE.equals(thatClass) || Float.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            if (BigDecimal.class.equals((Object)thisClass)) {
                return BigDecimal.class.equals((Object)thatClass) || Double.TYPE.equals(thatClass) || Double.class.equals((Object)thatClass) || Float.TYPE.equals(thatClass) || Float.class.equals((Object)thatClass) || BigInteger.class.equals((Object)thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals((Object)thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals((Object)thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals((Object)thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals((Object)thatClass);
            }
            return true;
        }
        return thisClass.isAssignableFrom(thatClass);
    }

    protected boolean isNumber(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
        }
        return Number.class.isAssignableFrom(clazz);
    }

    protected Class toPrimitive(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (Boolean.class.equals((Object)clazz)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals((Object)clazz)) {
            return Byte.TYPE;
        }
        if (Short.class.equals((Object)clazz)) {
            return Short.TYPE;
        }
        if (Character.class.equals((Object)clazz)) {
            return Character.TYPE;
        }
        if (Integer.class.equals((Object)clazz)) {
            return Integer.TYPE;
        }
        if (Long.class.equals((Object)clazz)) {
            return Long.TYPE;
        }
        if (Float.class.equals((Object)clazz)) {
            return Float.TYPE;
        }
        if (Double.class.equals((Object)clazz)) {
            return Double.TYPE;
        }
        return null;
    }

    protected Number castPrimitiveWrapper(Class clazz, Number val) {
        if (Byte.class.equals((Object)clazz)) {
            return new Byte(val.byteValue());
        }
        if (Short.class.equals((Object)clazz)) {
            return new Short(val.shortValue());
        }
        if (Integer.class.equals((Object)clazz)) {
            return new Integer(val.intValue());
        }
        if (Long.class.equals((Object)clazz)) {
            return new Long(val.longValue());
        }
        if (BigInteger.class.equals((Object)clazz)) {
            return BigInteger.valueOf(val.longValue());
        }
        if (Float.class.equals((Object)clazz)) {
            return new Float(val.floatValue());
        }
        if (Double.class.equals((Object)clazz)) {
            return new Double(val.doubleValue());
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            if (val instanceof BigInteger) {
                return new BigDecimal((BigInteger)val);
            }
            return new BigDecimal(val.doubleValue());
        }
        return val;
    }

    public static SimpleProperty[] getProperties(Object bean) {
        return SimpleProperty.getProperties(bean.getClass());
    }

    public static SimpleProperty[] getProperties(Class clazz) {
        Set props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getProperties(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getProperties(interfaces[i], props);
                break;
            }
        }
        Object[] result = props.toArray(new SimpleProperty[props.size()]);
        Arrays.sort(result);
        return result;
    }

    public static Set getPropertyNames(Object bean) {
        return SimpleProperty.getPropertyNames(bean.getClass());
    }

    public static Set getPropertyNames(Class clazz) {
        Set props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getPropertyNames(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getPropertyNames(interfaces[i], props);
                break;
            }
        }
        return props;
    }

    private static Set getPropertyNames(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            props.add(descriptors[i].getName());
        }
        return props;
    }

    private static Set getProperties(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            props.add(new IntrospectSimpleProperty(clazz, descriptors[i]));
        }
        return props;
    }

    protected PropertyDescriptor getPropertyDescriptor(Object obj) throws NoSuchPropertyException {
        return this.getPropertyDescriptor(obj.getClass());
    }

    protected static boolean isAccessableClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isPublic(modifier) || (Modifier.isProtected(modifier) || !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier)) && SimpleProperty.class.getPackage().equals(clazz.getPackage());
    }

    protected PropertyDescriptor getPropertyDescriptor(Class clazz) throws NoSuchPropertyException {
        if (!SimpleProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                try {
                    return this.getPropertyDescriptor(interfaces[i]);
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getPropertyDescriptor(superClass);
            }
            throw new NoSuchPropertyException(clazz, this.property);
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        String prop = this.property;
        int len = prop.length();
        if (len != 0 && Character.isUpperCase(prop.charAt(0))) {
            prop = len > 1 ? Character.toLowerCase(prop.charAt(0)) + prop.substring(1) : prop.toLowerCase();
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (!prop.equals(descriptors[i].getName()) && !this.property.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        throw new NoSuchPropertyException(clazz, this.property);
    }

    @Override
    public void setIgnoreNullProperty(boolean isIgnore) {
        this.isIgnoreNullProperty = isIgnore;
    }

    @Override
    public boolean isIgnoreNullProperty() {
        return this.isIgnoreNullProperty;
    }

    public String toString() {
        return "SimpleProperty{" + this.property + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleProperty)) {
            return false;
        }
        SimpleProperty comp = (SimpleProperty)obj;
        if (this.property == null && comp.property == null) {
            return true;
        }
        if (this.property == null) {
            return false;
        }
        return this.property.equals(comp.property);
    }

    public int hashCode() {
        return this.property == null ? 0 : this.property.hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof SimpleProperty)) {
            return 1;
        }
        SimpleProperty comp = (SimpleProperty)obj;
        if (this.property == null && comp.property == null) {
            return 0;
        }
        if (this.property == null) {
            return -1;
        }
        return this.property.compareTo(comp.property);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
    }

    private static class IntrospectSimpleProperty
    extends SimpleProperty {
        private static final long serialVersionUID = 883129830207417832L;
        private Class target;
        private Class propertyType;
        private Method readMethod;
        private Method writeMethod;

        public IntrospectSimpleProperty(Class target, PropertyDescriptor desc) throws IllegalArgumentException {
            super(desc.getName());
            this.target = target;
            this.propertyType = desc.getPropertyType();
            this.readMethod = desc.getReadMethod();
            this.writeMethod = desc.getWriteMethod();
        }

        @Override
        public Class getPropertyType(Object obj) throws NoSuchPropertyException {
            if (this.target.equals(obj.getClass())) {
                return this.propertyType;
            }
            return super.getPropertyType(obj);
        }

        @Override
        public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
            if (this.target.equals(clazz)) {
                return this.propertyType;
            }
            return super.getPropertyType(clazz);
        }

        @Override
        public boolean isReadable(Object obj) {
            if (this.target.equals(obj.getClass())) {
                return this.readMethod != null;
            }
            return super.isReadable(obj);
        }

        @Override
        public boolean isReadable(Class clazz) {
            if (this.target.equals(clazz)) {
                return this.readMethod != null;
            }
            return super.isReadable(clazz);
        }

        @Override
        public boolean isWritable(Object obj, Object value) {
            if (this.target.equals(obj.getClass())) {
                if (value == null) {
                    return this.writeMethod != null;
                }
                return this.writeMethod != null && this.writeMethod.getParameterTypes()[0].isAssignableFrom(value.getClass());
            }
            return super.isWritable(obj, value);
        }

        @Override
        public boolean isWritable(Object obj, Class clazz) {
            if (this.target.equals(obj.getClass())) {
                return this.writeMethod != null && this.writeMethod.getParameterTypes()[0].isAssignableFrom(clazz);
            }
            return super.isWritable(obj, clazz);
        }

        @Override
        public boolean isWritable(Class clazz) {
            if (this.target.equals(clazz)) {
                return this.writeMethod != null;
            }
            return super.isWritable(clazz);
        }

        @Override
        public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(obj.getClass())) {
                if (this.readMethod == null) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property);
                }
                try {
                    return this.readMethod.invoke(obj, NULL_ARGS);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
            }
            return super.getProperty(obj);
        }

        @Override
        public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(obj.getClass())) {
                if (this.writeMethod == null) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property);
                }
                try {
                    Class<?> paramType = this.writeMethod.getParameterTypes()[0];
                    if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                        value = this.castPrimitiveWrapper(paramType, (Number)value);
                    }
                    this.writeMethod.invoke(obj, value);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
            }
            super.setProperty(obj, type, value);
        }

        @Override
        public Method getReadMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(clazz)) {
                return this.readMethod;
            }
            return super.getReadMethod(clazz);
        }

        @Override
        public Method getWriteMethod(Class clazz, Class valClazz) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(clazz)) {
                if (this.writeMethod == null) {
                    throw new NoSuchPropertyException(clazz, this.property);
                }
                if (valClazz == null) {
                    return this.writeMethod;
                }
                if (this.writeMethod.getParameterTypes()[0].isAssignableFrom(valClazz)) {
                    return this.writeMethod;
                }
                throw new NoSuchPropertyException(clazz, this.property);
            }
            return super.getWriteMethod(clazz, valClazz);
        }
    }
}

