/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.IndexedProperty;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordListPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.context.ContextStore;
import jp.ossc.nimbus.service.context.DatabaseContextStoreServiceMBean;
import jp.ossc.nimbus.service.context.DistributedSharedContext;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextRecord;
import jp.ossc.nimbus.service.context.SharedContextRecordList;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;

public class DatabaseContextStoreService
extends ServiceBase
implements ContextStore,
DatabaseContextStoreServiceMBean {
    private static final long serialVersionUID = 5260610052471948594L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private ServiceName persistentManagerServiceName;
    private PersistentManager persistentManager;
    private List databaseMappings;

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    @Override
    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setPersistentManager(PersistentManager pm) {
        this.persistentManager = pm;
    }

    public void addDatabaseMapping(DatabaseMapping mapping) {
        this.databaseMappings.add(mapping);
    }

    @Override
    public void createService() throws Exception {
        this.databaseMappings = new ArrayList();
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.persistentManagerServiceName != null) {
            this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
        }
        if (this.persistentManager == null) {
            throw new IllegalArgumentException("PersistentManager is null.");
        }
    }

    @Override
    public synchronized void clear() throws Exception {
        for (int i = 0; i < this.databaseMappings.size(); ++i) {
            ((DatabaseMapping)this.databaseMappings.get(i)).clear(this.connectionFactory, this.persistentManager);
        }
    }

    @Override
    public synchronized void save(Context context) throws Exception {
        for (int i = 0; i < this.databaseMappings.size(); ++i) {
            ((DatabaseMapping)this.databaseMappings.get(i)).save(context, this.connectionFactory, this.persistentManager);
        }
    }

    @Override
    public void save(Context context, Object key) throws Exception {
        for (int i = 0; i < this.databaseMappings.size(); ++i) {
            ((DatabaseMapping)this.databaseMappings.get(i)).save(context, this.connectionFactory, this.persistentManager, key);
        }
    }

    @Override
    public synchronized void load(Context context) throws Exception {
        for (int i = 0; i < this.databaseMappings.size(); ++i) {
            ((DatabaseMapping)this.databaseMappings.get(i)).load(context, this.connectionFactory, this.persistentManager);
        }
    }

    @Override
    public void loadKey(Context context) throws Exception {
        for (int i = 0; i < this.databaseMappings.size(); ++i) {
            ((DatabaseMapping)this.databaseMappings.get(i)).loadKey(context, this.connectionFactory, this.persistentManager);
        }
    }

    @Override
    public void load(Context context, Object key) throws Exception {
        for (int i = 0; i < this.databaseMappings.size(); ++i) {
            ((DatabaseMapping)this.databaseMappings.get(i)).load(context, this.connectionFactory, this.persistentManager, key);
        }
    }

    public static class DatabaseSubMapping
    implements Serializable {
        private static final long serialVersionUID = -8734674911693127987L;
        public static final String QUERY_KEY_PARENT = "parent";
        public static final String QUERY_KEY_THIS = "this";
        protected String selectQuery;
        protected String selectWhereQuery;
        protected String insertQuery;
        protected String deleteQuery;
        protected String deleteWhereQuery;
        protected Record databaseRecord;
        protected Map loadPropertyMappings;
        protected Map savePropertyMappings;
        protected Map keyPropertyMappings;
        protected String indexProperty;
        protected int fetchSize;
        protected int batchPersistCount;
        protected boolean isBatchCommitOnPersist = true;
        protected Class beanClass;
        protected String loadBeanPropertyOfParent;
        protected Map nestedRecordListMap;
        protected String saveBeanPropertyOfParent;
        protected PropertyAccess propertyAccess;

        public void setSelectQuery(String query) {
            this.selectQuery = query;
        }

        public void setSelectWhereQuery(String query) {
            this.selectWhereQuery = query;
        }

        public void setInsertQuery(String query) {
            this.insertQuery = query;
        }

        public String getInsertQuery() {
            return this.insertQuery;
        }

        public void setDeleteQuery(String query) {
            this.deleteQuery = query;
        }

        public String getDeleteQuery() {
            return this.deleteQuery;
        }

        public void setDeleteWhereQuery(String query) {
            this.deleteWhereQuery = query;
        }

        public String getDeleteWhereQuery() {
            return this.deleteWhereQuery;
        }

        public void setDatabaseRecord(Record record) {
            this.databaseRecord = record;
        }

        public void setLoadPropertyMapping(String recordProperty, String setProperty) {
            this.setLoadPropertyMapping(recordProperty, recordProperty, setProperty);
        }

        public void setLoadPropertyMapping(String recordProperty, String getProperty, String setProperty) {
            ArrayList<String> setProperties;
            HashMap<String, ArrayList<String>> propMapping;
            if (this.loadPropertyMappings == null) {
                this.loadPropertyMappings = new HashMap();
            }
            if ((propMapping = (HashMap<String, ArrayList<String>>)this.loadPropertyMappings.get(recordProperty)) == null) {
                propMapping = new HashMap<String, ArrayList<String>>();
                this.loadPropertyMappings.put(recordProperty, propMapping);
            }
            if ((setProperties = (ArrayList<String>)propMapping.get(getProperty)) == null) {
                setProperties = new ArrayList<String>();
                propMapping.put(getProperty, setProperties);
            }
            if (setProperty != null) {
                setProperties.add(setProperty);
            }
        }

        public void setSavePropertyMapping(String recordProperty, String setProperty) {
            this.setSavePropertyMapping(recordProperty, recordProperty, setProperty);
        }

        public void setSavePropertyMapping(String recordProperty, String getProperty, String setProperty) {
            ArrayList<String> setProperties;
            HashMap<String, ArrayList<String>> propMapping;
            if (this.savePropertyMappings == null) {
                this.savePropertyMappings = new HashMap();
            }
            if ((propMapping = (HashMap<String, ArrayList<String>>)this.savePropertyMappings.get(recordProperty)) == null) {
                propMapping = new HashMap<String, ArrayList<String>>();
                this.savePropertyMappings.put(recordProperty, propMapping);
            }
            if ((setProperties = (ArrayList<String>)propMapping.get(getProperty)) == null) {
                setProperties = new ArrayList<String>();
                propMapping.put(getProperty, setProperties);
            }
            if (setProperty != null) {
                setProperties.add(setProperty);
            }
        }

        public void setKeyPropertyMappings(Map mappings) {
            this.keyPropertyMappings = mappings;
        }

        public void setKeyPropertyMapping(String beanProperty, String recordProperty) {
            if (this.keyPropertyMappings == null) {
                this.keyPropertyMappings = new HashMap();
            }
            this.keyPropertyMappings.put(beanProperty, recordProperty);
        }

        public void setIndexProperty(String recordProperty) {
            this.indexProperty = recordProperty;
        }

        public boolean isCursorAvailable() {
            return this.keyPropertyMappings != null && this.keyPropertyMappings.size() != 0;
        }

        public void setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        public void setBatchPersistCount(int count) {
            this.batchPersistCount = count;
        }

        public void setBeanClass(Class clazz) {
            this.beanClass = clazz;
        }

        public void setLoadBeanPropertyOfParent(String property) {
            this.loadBeanPropertyOfParent = property;
        }

        public void setNestedRecordList(String schemaName, RecordList list) {
            if (this.nestedRecordListMap == null) {
                this.nestedRecordListMap = new HashMap();
            }
            this.nestedRecordListMap.put(schemaName, list);
        }

        public void setSaveBeanPropertyOfParent(String property) {
            this.saveBeanPropertyOfParent = property;
        }

        public PersistentManager.Cursor createCursor(Connection con, PersistentManager pm) throws Exception {
            HashMap<String, Integer> statementProps = null;
            if (this.fetchSize != 0) {
                statementProps = new HashMap<String, Integer>();
                statementProps.put("FetchSize", new Integer(this.fetchSize));
            }
            return pm.createQueryCursor(con, this.selectQuery, null, statementProps, null);
        }

        public boolean load(PersistentManager.Cursor cursor, Object parent, Object keyObject) throws Exception {
            if (this.propertyAccess == null) {
                this.propertyAccess = new PropertyAccess();
            }
            HashMap keyValueMap = null;
            if (this.keyPropertyMappings != null) {
                for (Map.Entry entry : this.keyPropertyMappings.entrySet()) {
                    if (keyValueMap == null) {
                        keyValueMap = new HashMap();
                    }
                    keyValueMap.put(entry.getValue(), this.propertyAccess.get(keyObject, (String)entry.getKey()));
                }
            }
            Record record = null;
            do {
                PropertySchema propSchema;
                Record parentRecord;
                RecordSchema schema;
                if (record == null) {
                    record = this.databaseRecord == null ? new Record() : this.databaseRecord.cloneSchema();
                } else {
                    record.clear();
                }
                cursor.load(record);
                if (keyValueMap != null) {
                    for (Map.Entry entry : keyValueMap.entrySet()) {
                        Object val = this.propertyAccess.get(record, (String)entry.getKey());
                        if (!(val == null && entry.getValue() != null || val != null && entry.getValue() == null) && (val == null || val.equals(entry.getValue()))) continue;
                        return true;
                    }
                }
                int index = 0;
                if (this.indexProperty != null) {
                    index = record.getIntProperty(this.indexProperty);
                }
                Object loadBean = parent;
                RecordList recList = null;
                if (this.beanClass != null) {
                    loadBean = this.beanClass.newInstance();
                } else if (parent instanceof Record && (schema = (parentRecord = (Record)parent).getRecordSchema()) != null && (propSchema = schema.getPropertySchema(this.loadBeanPropertyOfParent)) != null && propSchema instanceof RecordListPropertySchema) {
                    recList = (RecordList)parentRecord.getProperty(this.loadBeanPropertyOfParent);
                    if (recList == null && this.nestedRecordListMap != null) {
                        recList = (RecordList)this.nestedRecordListMap.get(((RecordListPropertySchema)propSchema).getRecordListName());
                        if (recList != null) {
                            recList = recList.cloneSchema();
                        }
                        parentRecord.setProperty(this.loadBeanPropertyOfParent, (Object)recList);
                    }
                    if (recList != null) {
                        loadBean = recList.createRecord();
                    }
                }
                if (this.loadPropertyMappings == null) {
                    cursor.load(loadBean);
                } else {
                    PropertySchema[] propSchemata = record.getRecordSchema().getPropertySchemata();
                    for (int i = 0; i < propSchemata.length; ++i) {
                        Map propMappings = (Map)this.loadPropertyMappings.get(propSchemata[i].getName());
                        if (propMappings == null) continue;
                        for (Map.Entry propMapping : propMappings.entrySet()) {
                            Object value = this.propertyAccess.get(record, (String)propMapping.getKey());
                            List beanProperties = (List)propMapping.getValue();
                            for (int j = 0; j < beanProperties.size(); ++j) {
                                if (this.indexProperty == null) {
                                    this.propertyAccess.set(loadBean, (String)beanProperties.get(j), value);
                                    continue;
                                }
                                Property prop = this.propertyAccess.getProperty((String)beanProperties.get(j));
                                if (prop instanceof IndexedProperty) {
                                    IndexedProperty indexedProp = (IndexedProperty)prop;
                                    indexedProp.setIndex(index);
                                }
                                prop.setProperty(loadBean, value);
                            }
                        }
                    }
                }
                if (this.beanClass != null) {
                    if (this.indexProperty == null) {
                        this.propertyAccess.set(parent, this.loadBeanPropertyOfParent, loadBean);
                    } else {
                        Property prop = this.propertyAccess.getProperty(this.loadBeanPropertyOfParent);
                        if (prop instanceof IndexedProperty) {
                            IndexedProperty indexedProp = (IndexedProperty)prop;
                            indexedProp.setIndex(index);
                        }
                        prop.setProperty(parent, loadBean);
                    }
                    this.propertyAccess.set(parent, this.loadBeanPropertyOfParent, loadBean);
                    continue;
                }
                if (recList == null) continue;
                recList.add(loadBean);
            } while (cursor.next());
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object load(Connection con, PersistentManager pm, Object parent, Object keyObject) throws Exception {
            HashMap<String, Integer> statementProps = null;
            if (this.fetchSize != 0) {
                statementProps = new HashMap<String, Integer>();
                statementProps.put("FetchSize", new Integer(this.fetchSize));
            }
            PersistentManager.Cursor cursor = null;
            try {
                cursor = pm.createQueryCursor(con, this.selectWhereQuery, keyObject, statementProps, null);
                Object output = null;
                Record record = null;
                while (cursor.next()) {
                    PropertySchema propSchema;
                    Record parentRecord;
                    RecordSchema schema;
                    if (this.databaseRecord == null) {
                        output = parent;
                    } else {
                        if (record == null) {
                            record = this.databaseRecord.cloneSchema();
                        } else {
                            record.clear();
                        }
                        output = record;
                    }
                    output = cursor.load(output);
                    if (record == null || this.loadPropertyMappings == null) continue;
                    if (this.propertyAccess == null) {
                        this.propertyAccess = new PropertyAccess();
                    }
                    int index = 0;
                    if (this.indexProperty != null) {
                        index = record.getIntProperty(this.indexProperty);
                    }
                    Object loadBean = parent;
                    RecordList recList = null;
                    if (this.beanClass != null) {
                        loadBean = this.beanClass.newInstance();
                    } else if (parent instanceof Record && (schema = (parentRecord = (Record)parent).getRecordSchema()) != null && (propSchema = schema.getPropertySchema(this.loadBeanPropertyOfParent)) != null && propSchema instanceof RecordListPropertySchema) {
                        recList = (RecordList)parentRecord.getProperty(this.loadBeanPropertyOfParent);
                        if (recList == null && this.nestedRecordListMap != null) {
                            recList = (RecordList)this.nestedRecordListMap.get(((RecordListPropertySchema)propSchema).getRecordListName());
                            if (recList != null) {
                                recList = recList.cloneSchema();
                            }
                            parentRecord.setProperty(this.loadBeanPropertyOfParent, (Object)recList);
                        }
                        if (recList != null) {
                            loadBean = recList.createRecord();
                        }
                    }
                    PropertySchema[] propSchemata = record.getRecordSchema().getPropertySchemata();
                    for (int i = 0; i < propSchemata.length; ++i) {
                        Map propMappings = (Map)this.loadPropertyMappings.get(propSchemata[i].getName());
                        if (propMappings == null) continue;
                        for (Map.Entry propMapping : propMappings.entrySet()) {
                            Object value = this.propertyAccess.get(record, (String)propMapping.getKey());
                            List beanProperties = (List)propMapping.getValue();
                            for (int j = 0; j < beanProperties.size(); ++j) {
                                if (this.indexProperty == null) {
                                    this.propertyAccess.set(loadBean, (String)beanProperties.get(j), value);
                                    continue;
                                }
                                Property prop = this.propertyAccess.getProperty((String)beanProperties.get(j));
                                if (prop instanceof IndexedProperty) {
                                    IndexedProperty indexedProp = (IndexedProperty)prop;
                                    indexedProp.setIndex(index);
                                }
                                prop.setProperty(loadBean, value);
                            }
                        }
                    }
                    if (this.beanClass != null) {
                        if (this.indexProperty == null) {
                            this.propertyAccess.set(parent, this.loadBeanPropertyOfParent, loadBean);
                        } else {
                            Property prop = this.propertyAccess.getProperty(this.loadBeanPropertyOfParent);
                            if (prop instanceof IndexedProperty) {
                                IndexedProperty indexedProp = (IndexedProperty)prop;
                                indexedProp.setIndex(index);
                            }
                            prop.setProperty(parent, loadBean);
                        }
                        this.propertyAccess.set(parent, this.loadBeanPropertyOfParent, loadBean);
                        continue;
                    }
                    if (recList == null) continue;
                    recList.add(loadBean);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return parent;
        }

        public int delete(Connection con, PersistentManager pm) throws Exception {
            if (this.deleteQuery == null) {
                return 0;
            }
            return pm.persistQuery(con, this.deleteQuery, null);
        }

        private int getArrayLength(Object value) {
            if (value == null) {
                return -1;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size();
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value);
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public int insert(Connection con, PersistentManager pm, Object parentRecord, Object parent) throws Exception {
            if (this.insertQuery == null) {
                return 0;
            }
            if (parent == null) {
                return 0;
            }
            PersistentManager.BatchExecutor executor = null;
            try {
                executor = pm.createQueryBatchExecutor(con, this.insertQuery);
                if (this.batchPersistCount > 0) {
                    executor.setAutoBatchPersistCount(this.batchPersistCount);
                    executor.setAutoCommitOnPersist(this.isBatchCommitOnPersist);
                }
                HashMap<String, Object> inputMap = new HashMap<String, Object>();
                inputMap.put(QUERY_KEY_PARENT, parentRecord);
                Record record = null;
                int persistCount = 0;
                if (this.databaseRecord == null) {
                    inputMap.put(QUERY_KEY_THIS, null);
                    persistCount += executor.addBatch(inputMap);
                    persistCount += executor.persist();
                } else {
                    if (this.propertyAccess == null) {
                        this.propertyAccess = new PropertyAccess();
                    }
                    record = this.databaseRecord.cloneSchema();
                    int maxLength = -1;
                    PropertySchema[] propSchemata = record.getRecordSchema().getPropertySchemata();
                    if (this.savePropertyMappings == null) {
                        Object value;
                        int i;
                        Object persistBean = parent;
                        if (this.saveBeanPropertyOfParent != null) {
                            persistBean = this.propertyAccess.get(parent, this.saveBeanPropertyOfParent);
                            maxLength = this.getArrayLength(persistBean);
                        } else {
                            for (i = 0; i < propSchemata.length; ++i) {
                                int arrayLength;
                                if (this.indexProperty != null && this.indexProperty.equals(propSchemata[i].getName()) || (arrayLength = this.getArrayLength(value = this.propertyAccess.get(parent, propSchemata[i].getName()))) == -1 || maxLength >= arrayLength) continue;
                                maxLength = arrayLength;
                            }
                        }
                        if (maxLength == -1) {
                            record.clear();
                            for (i = 0; i < propSchemata.length; ++i) {
                                value = this.propertyAccess.get(persistBean, propSchemata[i].getName());
                                this.propertyAccess.set(record, propSchemata[i].getName(), value);
                            }
                            inputMap.put(QUERY_KEY_THIS, record);
                            persistCount += executor.addBatch(inputMap);
                            persistCount += executor.persist();
                        } else {
                            for (i = 0; i < maxLength; ++i) {
                                record.clear();
                                if (this.indexProperty != null) {
                                    this.propertyAccess.set(record, this.indexProperty, new Integer(i));
                                }
                                if (this.saveBeanPropertyOfParent != null) {
                                    Object bean = null;
                                    if (persistBean instanceof List) {
                                        bean = ((List)persistBean).get(i);
                                    } else if (persistBean instanceof Collection) {
                                        bean = ((Collection)persistBean).toArray()[i];
                                    } else if (persistBean.getClass().isArray()) {
                                        bean = Array.get(persistBean, i);
                                    }
                                    if (bean == null) continue;
                                    for (int j = 0; j < propSchemata.length; ++j) {
                                        Object object = this.propertyAccess.get(bean, propSchemata[j].getName());
                                        this.propertyAccess.set(record, propSchemata[j].getName(), object);
                                    }
                                } else {
                                    for (int j = 0; j < propSchemata.length; ++j) {
                                        void var15_32;
                                        Object value3 = this.propertyAccess.get(persistBean, propSchemata[j].getName());
                                        if (value3 == null) {
                                            this.propertyAccess.set(record, propSchemata[j].getName(), null);
                                            continue;
                                        }
                                        Object var15_28 = null;
                                        if (value3 instanceof Collection) {
                                            if (((Collection)value3).size() > i) {
                                                if (value3 instanceof List) {
                                                    Object e = ((List)value3).get(i);
                                                } else {
                                                    Object object = Array.get(((Collection)value3).toArray(), i);
                                                }
                                            }
                                        } else if (value3.getClass().isArray()) {
                                            if (Array.getLength(value3) > i) {
                                                Object object = Array.get(value3, i);
                                            }
                                        } else {
                                            this.propertyAccess.set(record, propSchemata[j].getName(), value3);
                                            continue;
                                        }
                                        this.propertyAccess.set(record, propSchemata[j].getName(), var15_32);
                                    }
                                }
                                inputMap.put(QUERY_KEY_THIS, record);
                                persistCount += executor.addBatch(inputMap);
                            }
                            persistCount += executor.persist();
                        }
                    } else {
                        Object value;
                        Map propMappings;
                        int i;
                        Object persistBean = parent;
                        if (this.saveBeanPropertyOfParent != null) {
                            persistBean = this.propertyAccess.get(parent, this.saveBeanPropertyOfParent);
                            maxLength = this.getArrayLength(persistBean);
                        } else {
                            for (i = 0; i < propSchemata.length; ++i) {
                                if (this.indexProperty != null && this.indexProperty.equals(propSchemata[i].getName()) || (propMappings = (Map)this.savePropertyMappings.get(propSchemata[i].getName())) == null) continue;
                                for (String string : propMappings.keySet()) {
                                    value = this.propertyAccess.get(parent, string);
                                    int arrayLength = this.getArrayLength(value);
                                    if (arrayLength == -1 || maxLength >= arrayLength) continue;
                                    maxLength = arrayLength;
                                }
                            }
                        }
                        if (maxLength == -1) {
                            record = this.databaseRecord.cloneSchema();
                            for (i = 0; i < propSchemata.length; ++i) {
                                propMappings = (Map)this.savePropertyMappings.get(propSchemata[i].getName());
                                if (propMappings == null) continue;
                                for (Map.Entry entry : propMappings.entrySet()) {
                                    value = this.propertyAccess.get(persistBean, (String)entry.getKey());
                                    List recordProperties = (List)entry.getValue();
                                    for (int j = 0; j < recordProperties.size(); ++j) {
                                        this.propertyAccess.set(record, (String)recordProperties.get(j), value);
                                    }
                                }
                            }
                            inputMap.put(QUERY_KEY_THIS, record);
                            persistCount += executor.addBatch(inputMap);
                            persistCount += executor.persist();
                        } else {
                            for (i = 0; i < maxLength; ++i) {
                                int k;
                                if (record == null) {
                                    record = this.databaseRecord.cloneSchema();
                                } else {
                                    record.clear();
                                }
                                if (this.indexProperty != null) {
                                    this.propertyAccess.set(record, this.indexProperty, new Integer(i));
                                }
                                if (this.saveBeanPropertyOfParent != null) {
                                    Object bean = null;
                                    if (persistBean instanceof List) {
                                        bean = ((List)persistBean).get(i);
                                    } else if (persistBean instanceof Collection) {
                                        bean = ((Collection)persistBean).toArray()[i];
                                    } else if (persistBean.getClass().isArray()) {
                                        bean = Array.get(persistBean, i);
                                    }
                                    if (bean == null) continue;
                                    for (int j = 0; j < propSchemata.length; ++j) {
                                        Map map = (Map)this.savePropertyMappings.get(propSchemata[j].getName());
                                        if (map == null) continue;
                                        for (Map.Entry propMapping : map.entrySet()) {
                                            Object value4 = this.propertyAccess.get(bean, (String)propMapping.getKey());
                                            List recordProperties = (List)propMapping.getValue();
                                            for (k = 0; k < recordProperties.size(); ++k) {
                                                this.propertyAccess.set(record, (String)recordProperties.get(k), value4);
                                            }
                                        }
                                    }
                                    continue;
                                }
                                for (int j = 0; j < propSchemata.length; ++j) {
                                    Map propMappings3 = (Map)this.savePropertyMappings.get(propSchemata[j].getName());
                                    if (propMappings3 == null) continue;
                                    for (Map.Entry propMapping : propMappings3.entrySet()) {
                                        Object value5 = this.propertyAccess.get(persistBean, (String)propMapping.getKey());
                                        if (value5 == null) {
                                            List recordProperties = (List)propMapping.getValue();
                                            for (int k2 = 0; k2 < recordProperties.size(); ++k2) {
                                                this.propertyAccess.set(record, (String)recordProperties.get(k2), null);
                                            }
                                            continue;
                                        }
                                        Object element = null;
                                        if (value5 instanceof Collection) {
                                            if (((Collection)value5).size() > i) {
                                                element = value5 instanceof List ? ((List)value5).get(i) : Array.get(((Collection)value5).toArray(), i);
                                            }
                                        } else if (value5.getClass().isArray()) {
                                            if (Array.getLength(value5) > i) {
                                                element = Array.get(value5, i);
                                            }
                                        } else {
                                            element = value5;
                                        }
                                        List recordProperties = (List)propMapping.getValue();
                                        for (k = 0; k < recordProperties.size(); ++k) {
                                            this.propertyAccess.set(record, (String)recordProperties.get(k), element);
                                        }
                                    }
                                }
                                inputMap.put(QUERY_KEY_THIS, record);
                                persistCount += executor.addBatch(inputMap);
                            }
                            persistCount += executor.persist();
                        }
                    }
                }
                int n = persistCount;
                return n;
            }
            finally {
                if (executor != null) {
                    executor.close();
                }
            }
        }

        public int delete(Connection con, PersistentManager pm, Object keyObject) throws Exception {
            if (this.deleteWhereQuery == null) {
                return 0;
            }
            if (keyObject == null) {
                return 0;
            }
            return pm.persistQuery(con, this.deleteWhereQuery, keyObject);
        }
    }

    public static class DatabaseMapping
    implements Serializable {
        private static final long serialVersionUID = 4632610348315541284L;
        protected String selectQuery;
        protected String keySelectQuery;
        protected String parallelSelectQuery;
        protected String selectWhereQuery;
        protected String insertQuery;
        protected String insertKeySelectQuery;
        protected String updateQuery;
        protected String deleteWhereQuery;
        protected String deleteQuery;
        protected String keyLoadPropertyName;
        protected String keySavePropertyName;
        protected Class keyClass;
        protected Map keyLoadPropertyMappings;
        protected Map keySavePropertyMappings;
        protected Record keyDatabaseRecord;
        protected Record databaseRecord;
        protected RecordList databaseRecordList;
        protected Map loadPropertyMappings;
        protected Map savePropertyMappings;
        protected List subMappings;
        protected int fetchSize;
        protected int keyFetchSize;
        protected int batchPersistCount;
        protected boolean isBatchCommitOnPersist = true;
        protected boolean isUseSubCursor = true;
        protected boolean isUseSubConnection = false;
        protected int parallelSize = 0;
        protected Class valueClass;
        protected RecordList valueRecordList;
        protected Record valueRecord;
        protected PropertyAccess propertyAccess;
        protected boolean isUniqueKey = true;
        protected boolean isSort;
        protected String[] sortPropertyNames;
        protected boolean[] isAsc;
        protected boolean isSynchronizedRecordList = true;

        public void setUniqueKey(boolean isUnique) {
            this.isUniqueKey = isUnique;
        }

        public void setSelectQuery(String query) {
            this.selectQuery = query;
        }

        public void setKeySelectQuery(String query) {
            this.keySelectQuery = query;
        }

        public void setParallelSelectQuery(String query) {
            this.parallelSelectQuery = query;
        }

        public void setSelectWhereQuery(String query) {
            this.selectWhereQuery = query;
        }

        public void setParallelSize(int size) {
            this.parallelSize = size;
        }

        public void setInsertQuery(String query) {
            this.insertQuery = query;
        }

        public void setInsertKeySelectQuery(String query) {
            this.insertKeySelectQuery = query;
        }

        public void setUpdateQuery(String query) {
            this.updateQuery = query;
        }

        public void setDeleteQuery(String query) {
            this.deleteQuery = query;
        }

        public void setDeleteWhereQuery(String query) {
            this.deleteWhereQuery = query;
        }

        public void setKeyDatabaseRecord(Record record) {
            this.keyDatabaseRecord = record;
        }

        public void setDatabaseRecord(Record record) {
            this.databaseRecord = record;
            if (this.keyDatabaseRecord == null) {
                this.keyDatabaseRecord = record;
            }
        }

        public void setDatabaseRecordList(RecordList list) {
            this.databaseRecordList = list;
            this.setDatabaseRecord(list == null ? null : list.createRecord());
        }

        public void setKeyLoadPropertyName(String name) {
            this.keyLoadPropertyName = name;
        }

        public void setKeySavePropertyName(String name) {
            this.keySavePropertyName = name;
        }

        public void setKeyClass(Class clazz) {
            this.keyClass = clazz;
        }

        public void setKeyLoadPropertyMapping(String getProperty, String setProperty) {
            if (this.keyLoadPropertyMappings == null) {
                this.keyLoadPropertyMappings = new HashMap();
            }
            this.keyLoadPropertyMappings.put(getProperty, setProperty);
        }

        public void setKeySavePropertyMapping(String getProperty, String setProperty) {
            if (this.keySavePropertyMappings == null) {
                this.keySavePropertyMappings = new HashMap();
            }
            this.keySavePropertyMappings.put(getProperty, setProperty);
        }

        public void setValueClass(Class clazz) {
            this.valueClass = clazz;
        }

        public void setValueRecord(Record record) {
            this.valueRecord = record;
        }

        public void setValueRecordList(RecordList list) {
            this.valueRecordList = list;
            this.valueRecord = list.createRecord();
        }

        public void setLoadPropertyMapping(String recordProperty, String setProperty) {
            this.setLoadPropertyMapping(recordProperty, recordProperty, setProperty);
        }

        public void setLoadPropertyMapping(String recordProperty, String getProperty, String setProperty) {
            ArrayList<String> setProperties;
            HashMap<String, ArrayList<String>> propMapping;
            if (this.loadPropertyMappings == null) {
                this.loadPropertyMappings = new HashMap();
            }
            if ((propMapping = (HashMap<String, ArrayList<String>>)this.loadPropertyMappings.get(recordProperty)) == null) {
                propMapping = new HashMap<String, ArrayList<String>>();
                this.loadPropertyMappings.put(recordProperty, propMapping);
            }
            if ((setProperties = (ArrayList<String>)propMapping.get(getProperty)) == null) {
                setProperties = new ArrayList<String>();
                propMapping.put(getProperty, setProperties);
            }
            setProperties.add(setProperty);
        }

        public void setSavePropertyMapping(String recordProperty, String setProperty) {
            this.setSavePropertyMapping(recordProperty, recordProperty, setProperty);
        }

        public void setSavePropertyMapping(String recordProperty, String getProperty, String setProperty) {
            ArrayList<String> setProperties;
            HashMap<String, ArrayList<String>> propMapping;
            if (this.savePropertyMappings == null) {
                this.savePropertyMappings = new HashMap();
            }
            if ((propMapping = (HashMap<String, ArrayList<String>>)this.savePropertyMappings.get(recordProperty)) == null) {
                propMapping = new HashMap<String, ArrayList<String>>();
                this.savePropertyMappings.put(recordProperty, propMapping);
            }
            if ((setProperties = (ArrayList<String>)propMapping.get(getProperty)) == null) {
                setProperties = new ArrayList<String>();
                propMapping.put(getProperty, setProperties);
            }
            setProperties.add(setProperty);
        }

        public void addSubMapping(DatabaseSubMapping mapping) {
            if (this.subMappings == null) {
                this.subMappings = new ArrayList();
            }
            this.subMappings.add(mapping);
        }

        public void setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        public void setKeyFetchSize(int fetchSize) {
            this.keyFetchSize = fetchSize;
        }

        public void setUseSubCursor(boolean isUse) {
            this.isUseSubCursor = isUse;
        }

        public void setUseSubConnection(boolean isUse) {
            this.isUseSubConnection = isUse;
        }

        public void setBatchPersistCount(int count) {
            this.batchPersistCount = count;
        }

        public void setBatchCommitOnPersist(boolean isCommit) {
            this.isBatchCommitOnPersist = isCommit;
        }

        public void setValueSort(boolean isSort) {
            this.isSort = isSort;
        }

        public void setValueRecordListSort(String[] propNames, boolean[] isAsc) {
            this.isSort = true;
            this.sortPropertyNames = propNames;
            this.isAsc = isAsc;
        }

        public void setSynchronizedRecordList(boolean isSynch) {
            this.isSynchronizedRecordList = isSynch;
        }

        public void load(Context context, ConnectionFactory factory, PersistentManager pm) throws Exception {
            if (this.parallelSelectQuery != null && this.keySelectQuery != null) {
                this.loadParallel(context, factory, pm);
            } else if (this.selectQuery != null) {
                this.load(context, factory, pm, this.selectQuery, null, false);
            } else {
                throw new UnsupportedOperationException("selectQuery is null.");
            }
        }

        public void load(Context context, ConnectionFactory factory, PersistentManager pm, Object key) throws Exception {
            if (this.selectWhereQuery == null) {
                throw new UnsupportedOperationException("selectWhereQuery is null.");
            }
            this.load(context, factory, pm, this.selectWhereQuery, key, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadParallel(Context context, ConnectionFactory factory, PersistentManager pm) throws Exception {
            Connection con = null;
            RecordList inputList = null;
            HashMap<String, Integer> statementProps = null;
            if (this.keyFetchSize != 0) {
                statementProps = new HashMap<String, Integer>();
                statementProps.put("FetchSize", new Integer(this.keyFetchSize));
            }
            try {
                con = factory.getConnection();
                inputList = this.keyDatabaseRecord == null ? new RecordList() : new RecordList(null, this.keyDatabaseRecord.getRecordSchema());
                pm.loadQuery(con, this.keySelectQuery, null, inputList, statementProps, null);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
            if (inputList.size() == 0) {
                return;
            }
            if (this.parallelSize <= 1) {
                for (int i = 0; i < inputList.size(); ++i) {
                    this.load(context, factory, pm, this.parallelSelectQuery, inputList.get(i), false);
                }
            } else {
                QueueHandlerContainerService qhc = new QueueHandlerContainerService();
                DefaultQueueService requestQueue = new DefaultQueueService();
                DefaultQueueService responseQueue = new DefaultQueueService();
                requestQueue.create();
                requestQueue.start();
                responseQueue.create();
                responseQueue.start();
                qhc.create();
                qhc.setQueueService(requestQueue);
                qhc.setDaemonQueueHandler(true);
                qhc.setQueueHandlerSize(this.parallelSize);
                qhc.setQueueHandler(new LoadQueueHandler());
                qhc.start();
                try {
                    int i;
                    for (i = 0; i < inputList.size(); ++i) {
                        AsynchContext ac = new AsynchContext(new Object[]{context, factory, pm, inputList.get(i)}, responseQueue);
                        qhc.push(ac);
                    }
                    int imax = inputList.size();
                    for (i = 0; i < imax; ++i) {
                        AsynchContext ac = (AsynchContext)responseQueue.get();
                        if (ac == null) {
                            throw new Exception("Break parallel load.");
                        }
                        try {
                            ac.checkError();
                            continue;
                        }
                        catch (Throwable th) {
                            if (th instanceof Exception) {
                                throw (Exception)th;
                            }
                            throw (Error)th;
                        }
                    }
                }
                finally {
                    qhc.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadKey(Context context, ConnectionFactory factory, PersistentManager pm) throws Exception {
            if (this.keySelectQuery == null) {
                throw new UnsupportedOperationException("keySelectQuery is null");
            }
            if (this.keyClass == null && this.keyLoadPropertyName == null) {
                throw new UnsupportedOperationException("keyLoadPropertyName is null");
            }
            if (this.keyClass != null && this.keyLoadPropertyMappings == null) {
                throw new UnsupportedOperationException("keyLoadPropertyMappings is null");
            }
            HashMap<String, Integer> statementProps = null;
            if (this.keyFetchSize != 0) {
                statementProps = new HashMap<String, Integer>();
                statementProps.put("FetchSize", new Integer(this.keyFetchSize));
            }
            Connection con = null;
            RecordList keyList = null;
            try {
                con = factory.getConnection();
                keyList = this.keyDatabaseRecord == null ? new RecordList() : new RecordList(null, this.keyDatabaseRecord.getRecordSchema());
                pm.loadQuery(con, this.keySelectQuery, null, keyList, statementProps, null);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
            if (keyList.size() == 0) {
                return;
            }
            if (this.propertyAccess == null) {
                this.propertyAccess = new PropertyAccess();
            }
            HashMap tmpContext = new HashMap();
            for (int i = 0; i < keyList.size(); ++i) {
                Object keyRecord = keyList.get(i);
                Object key = null;
                if (this.keyClass == null) {
                    key = this.propertyAccess.get(keyRecord, this.keyLoadPropertyName);
                } else {
                    key = this.keyClass.newInstance();
                    for (Map.Entry propMapping : this.keyLoadPropertyMappings.entrySet()) {
                        this.propertyAccess.set(key, (String)propMapping.getValue(), this.propertyAccess.get(keyRecord, (String)propMapping.getKey()));
                    }
                }
                tmpContext.put(key, null);
            }
            if (tmpContext.size() != 0) {
                context.putAll((Map)tmpContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void load(Context context, ConnectionFactory factory, PersistentManager pm, String query, Object input, boolean isAsynch) throws Exception {
            HashMap<String, Integer> statementProps = null;
            if (this.fetchSize != 0) {
                statementProps = new HashMap<String, Integer>();
                statementProps.put("FetchSize", new Integer(this.fetchSize));
            }
            PersistentManager.Cursor cursor = null;
            ArrayList<Connection> subConnections = null;
            HashSet<Connection> subConnectionSet = null;
            ArrayList<PersistentManager.Cursor> subCursors = null;
            Connection con = null;
            boolean isDist = context instanceof DistributedSharedContext;
            HashMap<Object, Object> tmpContext = null;
            if (!isDist) {
                tmpContext = new HashMap<Object, Object>();
            }
            try {
                con = factory.getConnection();
                cursor = pm.createQueryCursor(con, query, input, statementProps, null);
                Object output = null;
                Record record = null;
                List<Object> list = null;
                Object key = null;
                Object preKey = null;
                if (this.subMappings != null && (this.isUseSubCursor || this.isUseSubConnection)) {
                    if (input == null && this.isUseSubCursor) {
                        subCursors = new ArrayList<PersistentManager.Cursor>();
                    }
                    for (DatabaseSubMapping databaseSubMapping : this.subMappings) {
                        Connection subCon = con;
                        if (this.isUseSubConnection) {
                            if (subConnections == null) {
                                subConnections = new ArrayList<Connection>();
                                subConnectionSet = new HashSet<Connection>();
                            }
                            subCon = factory.getConnection();
                            subConnections.add(subCon);
                            subConnectionSet.add(subCon);
                        }
                        if (input != null || !this.isUseSubCursor) continue;
                        if (databaseSubMapping.isCursorAvailable()) {
                            subCursors.add(databaseSubMapping.createCursor(subCon, pm));
                            continue;
                        }
                        subCursors.add(null);
                    }
                }
                while (cursor.next()) {
                    if (record == null) {
                        if (this.databaseRecord == null) {
                            if (this.valueClass != null) {
                                output = this.valueClass.newInstance();
                            } else if (this.valueRecord != null) {
                                output = this.valueRecord.cloneSchema();
                            } else {
                                record = new SharedContextRecord();
                                output = record;
                            }
                        } else {
                            record = this.databaseRecord.cloneSchema();
                            output = record;
                        }
                    } else {
                        if (this.valueClass != null || this.valueRecord != null) {
                            record.clear();
                        } else {
                            record = this.databaseRecord == null ? new SharedContextRecord() : this.databaseRecord.cloneSchema();
                        }
                        output = record;
                    }
                    output = cursor.load(output);
                    if (this.propertyAccess == null) {
                        this.propertyAccess = new PropertyAccess();
                    }
                    if (this.keyClass == null) {
                        key = this.propertyAccess.get(output, this.keyLoadPropertyName);
                    } else {
                        key = this.keyClass.newInstance();
                        for (Map.Entry entry : this.keyLoadPropertyMappings.entrySet()) {
                            this.propertyAccess.set(key, (String)entry.getValue(), this.propertyAccess.get(output, (String)entry.getKey()));
                        }
                    }
                    if (record != null && (this.valueClass != null || this.valueRecord != null)) {
                        int i;
                        Record outputBean = null;
                        if (this.valueClass != null) {
                            outputBean = (Record)this.valueClass.newInstance();
                        } else if (this.valueRecord != null) {
                            outputBean = this.valueRecord.cloneSchema();
                        }
                        if (this.loadPropertyMappings == null) {
                            PropertySchema[] propertySchemaArray = record.getRecordSchema().getPropertySchemata();
                            for (i = 0; i < propertySchemaArray.length; ++i) {
                                Object value = record.getProperty(propertySchemaArray[i].getName());
                                this.propertyAccess.set(outputBean, propertySchemaArray[i].getName(), value);
                            }
                        } else {
                            PropertySchema[] propertySchemaArray = record.getRecordSchema().getPropertySchemata();
                            for (i = 0; i < propertySchemaArray.length; ++i) {
                                Map propMappings = (Map)this.loadPropertyMappings.get(propertySchemaArray[i].getName());
                                if (propMappings == null) continue;
                                for (Map.Entry propMapping : propMappings.entrySet()) {
                                    Object value = this.propertyAccess.get(output, (String)propMapping.getKey());
                                    List beanProperties = (List)propMapping.getValue();
                                    for (int j = 0; j < beanProperties.size(); ++j) {
                                        this.propertyAccess.set(outputBean, (String)beanProperties.get(j), value);
                                    }
                                }
                            }
                        }
                        output = outputBean;
                    }
                    if (this.subMappings != null) {
                        for (int i = 0; i < this.subMappings.size(); ++i) {
                            DatabaseSubMapping databaseSubMapping = (DatabaseSubMapping)this.subMappings.get(i);
                            Connection subCon = con;
                            if (this.isUseSubConnection) {
                                subCon = (Connection)subConnections.get(i);
                            }
                            if (input == null && this.isUseSubCursor) {
                                PersistentManager.Cursor subCursor = (PersistentManager.Cursor)subCursors.get(i);
                                if (subCursor == null) {
                                    databaseSubMapping.load(subCon, pm, output, record == null ? output : record);
                                    continue;
                                }
                                if (subCursor.isClosed()) continue;
                                if (subConnectionSet.contains(subCon)) {
                                    subConnectionSet.remove(subCon);
                                    if (!subCursor.next()) {
                                        subCursor.close();
                                        try {
                                            subCon.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                        subConnections.set(i, null);
                                        continue;
                                    }
                                }
                                if (databaseSubMapping.load(subCursor, output, record == null ? output : record)) continue;
                                subCursor.close();
                                try {
                                    subCon.close();
                                }
                                catch (SQLException e) {
                                    // empty catch block
                                }
                                subConnections.set(i, null);
                                continue;
                            }
                            databaseSubMapping.load(subCon, pm, output, record == null ? output : record);
                        }
                    }
                    if (this.isUniqueKey) {
                        if (isAsynch && !isDist) {
                            ((SharedContext)context).putAsynch(key, output);
                            continue;
                        }
                        if (isDist) {
                            context.put(key, output);
                            continue;
                        }
                        tmpContext.put(key, output);
                        continue;
                    }
                    if (preKey == null || key.equals(preKey)) {
                        if (list == null) {
                            list = this.valueClass != null ? new ArrayList<Object>() : (this.valueRecordList != null ? this.valueRecordList.cloneSchema() : (this.valueRecord != null ? new SharedContextRecordList(null, this.valueRecord.getRecordSchema(), this.isSynchronizedRecordList) : (this.databaseRecord == null ? new SharedContextRecordList(null, record.getRecordSchema(), this.isSynchronizedRecordList) : (this.databaseRecordList == null ? new RecordList(null, this.databaseRecord.getRecordSchema(), this.isSynchronizedRecordList) : this.databaseRecordList.cloneSchema()))));
                        }
                    } else {
                        if (this.isSort) {
                            if (this.valueClass != null) {
                                Collections.sort(list);
                            } else {
                                ((RecordList)list).sort(this.sortPropertyNames, this.isAsc);
                            }
                        }
                        if (isAsynch && !isDist) {
                            ((SharedContext)context).putAsynch(preKey, list);
                        } else if (isDist) {
                            context.put(preKey, list);
                        } else {
                            tmpContext.put(preKey, list);
                        }
                        list = this.valueClass != null ? new ArrayList() : (this.valueRecordList != null ? this.valueRecordList.cloneSchema() : (this.valueRecord != null ? new SharedContextRecordList(null, this.valueRecord.getRecordSchema(), this.isSynchronizedRecordList) : (this.databaseRecord == null ? new SharedContextRecordList(null, record.getRecordSchema(), this.isSynchronizedRecordList) : (this.databaseRecordList == null ? new RecordList(null, this.databaseRecord.getRecordSchema(), this.isSynchronizedRecordList) : this.databaseRecordList.cloneSchema()))));
                    }
                    list.add(output);
                    preKey = key;
                }
                if (!this.isUniqueKey && list != null && list.size() != 0) {
                    if (this.isSort) {
                        if (this.valueClass != null) {
                            Collections.sort(list);
                        } else {
                            ((RecordList)list).sort(this.sortPropertyNames, this.isAsc);
                        }
                    }
                    if (isAsynch && !isDist) {
                        ((SharedContext)context).putAsynch(key, list);
                    } else if (isDist) {
                        context.put(key, list);
                    } else {
                        tmpContext.put(key, list);
                    }
                }
                if (tmpContext != null && tmpContext.size() != 0) {
                    context.putAll(tmpContext);
                }
            }
            finally {
                if (subCursors != null) {
                    int i;
                    for (i = 0; i < subCursors.size(); ++i) {
                        ((PersistentManager.Cursor)subCursors.get(i)).close();
                    }
                    if (subConnections != null) {
                        for (i = 0; i < subConnections.size(); ++i) {
                            Connection subCon = (Connection)subConnections.get(i);
                            if (subCon == null) continue;
                            try {
                                subCon.close();
                                continue;
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
                if (cursor != null) {
                    cursor.close();
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(ConnectionFactory factory, PersistentManager pm) throws Exception {
            if (this.deleteQuery == null) {
                throw new UnsupportedOperationException("deleteQuery is null.");
            }
            Connection con = null;
            try {
                con = factory.getConnection();
                if (this.deleteQuery != null) {
                    pm.persistQuery(con, this.deleteQuery, null);
                    if (this.subMappings != null) {
                        for (int i = 0; i < this.subMappings.size(); ++i) {
                            DatabaseSubMapping subMapping = (DatabaseSubMapping)this.subMappings.get(i);
                            if (subMapping.getDeleteQuery() == null) continue;
                            subMapping.delete(con, pm);
                        }
                    }
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(Context context, ConnectionFactory factory, PersistentManager pm) throws Exception {
            if (this.insertQuery == null) {
                throw new UnsupportedOperationException("insertQuery is null.");
            }
            if (this.insertKeySelectQuery != null) {
                if (this.keyClass == null && this.keyLoadPropertyName == null) {
                    throw new UnsupportedOperationException("keyLoadPropertyName is null");
                }
                if (this.keyClass != null && this.keyLoadPropertyMappings == null) {
                    throw new UnsupportedOperationException("keyLoadPropertyMappings is null");
                }
            }
            if (context.size() == 0) {
                return;
            }
            Connection con = null;
            PersistentManager.BatchExecutor executor = null;
            try {
                Object[] keys = null;
                con = factory.getConnection();
                if (this.insertKeySelectQuery != null) {
                    RecordList keyList = null;
                    if (this.keyDatabaseRecord == null) {
                        if (this.keyClass == null) {
                            keyList = new RecordList();
                        }
                    } else {
                        keyList = new RecordList(null, this.keyDatabaseRecord.getRecordSchema());
                    }
                    Object[] keyRecords = null;
                    if (keyList == null) {
                        keyRecords = (Object[])pm.loadQuery(con, this.insertKeySelectQuery, null, Array.newInstance(this.keyClass, 0).getClass());
                    } else {
                        pm.loadQuery(con, this.insertKeySelectQuery, null, keyList);
                        keyRecords = keyList.toArray();
                    }
                    if (keyRecords == null || keyRecords.length == 0) {
                        return;
                    }
                    if (keyList == null) {
                        keys = keyRecords;
                    } else {
                        keys = new Object[keyRecords.length];
                        for (int i = 0; i < keyRecords.length; ++i) {
                            if (this.keyClass == null) {
                                keys[i] = this.propertyAccess.get(keyRecords[i], this.keyLoadPropertyName);
                                continue;
                            }
                            keys[i] = this.keyClass.newInstance();
                            for (Map.Entry propMapping : this.keyLoadPropertyMappings.entrySet()) {
                                this.propertyAccess.set(keys[i], (String)propMapping.getValue(), this.propertyAccess.get(keyRecords[i], (String)propMapping.getKey()));
                            }
                        }
                    }
                } else {
                    keys = context.keySet().toArray();
                }
                executor = pm.createQueryBatchExecutor(con, this.insertQuery);
                if (this.batchPersistCount > 0) {
                    executor.setAutoBatchPersistCount(this.batchPersistCount);
                    executor.setAutoCommitOnPersist(this.isBatchCommitOnPersist);
                }
                Record record = null;
                for (int i = 0; i < keys.length; ++i) {
                    Object bean = context.get(keys[i]);
                    if (this.isUniqueKey) {
                        record = this.save(con, pm, executor, keys[i], bean, record);
                        continue;
                    }
                    if (bean == null) continue;
                    List list = (List)bean;
                    for (int j = 0; j < list.size(); ++j) {
                        record = this.save(con, pm, executor, keys[i], list.get(j), record);
                    }
                }
                executor.persist();
            }
            finally {
                if (executor != null) {
                    executor.close();
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }

        private Record save(Connection con, PersistentManager pm, PersistentManager.BatchExecutor executor, Object key, Object bean, Record record) throws Exception {
            Object input = null;
            if (this.databaseRecord == null) {
                input = bean;
            } else {
                int j;
                if (this.propertyAccess == null) {
                    this.propertyAccess = new PropertyAccess();
                }
                if (record == null) {
                    record = this.databaseRecord.cloneSchema();
                } else {
                    record.clear();
                }
                PropertySchema[] propSchemata = record.getRecordSchema().getPropertySchemata();
                if (this.keyClass == null) {
                    this.propertyAccess.set(record, this.keySavePropertyName, key);
                } else {
                    for (Map.Entry propMapping : this.keySavePropertyMappings.entrySet()) {
                        this.propertyAccess.set(record, (String)propMapping.getValue(), this.propertyAccess.get(key, (String)propMapping.getKey()));
                    }
                }
                if (this.savePropertyMappings == null) {
                    for (j = 0; j < propSchemata.length; ++j) {
                        Object value = this.propertyAccess.get(bean, propSchemata[j].getName());
                        record.setProperty(propSchemata[j].getName(), value);
                    }
                } else {
                    for (j = 0; j < propSchemata.length; ++j) {
                        Map propMappings = (Map)this.savePropertyMappings.get(propSchemata[j].getName());
                        if (propMappings == null) continue;
                        for (Map.Entry propMapping : propMappings.entrySet()) {
                            Object value = this.propertyAccess.get(bean, (String)propMapping.getKey());
                            List recordProperties = (List)propMapping.getValue();
                            for (int k = 0; k < recordProperties.size(); ++k) {
                                this.propertyAccess.set(record, (String)recordProperties.get(k), value);
                            }
                        }
                    }
                }
                input = record;
            }
            executor.addBatch(input);
            if (this.subMappings != null) {
                for (int j = 0; j < this.subMappings.size(); ++j) {
                    DatabaseSubMapping subMapping = (DatabaseSubMapping)this.subMappings.get(j);
                    if (subMapping.getInsertQuery() == null) continue;
                    subMapping.insert(con, pm, input, bean);
                }
            }
            return record;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(Context context, ConnectionFactory factory, PersistentManager pm, Object key) throws Exception {
            block45: {
                if (this.deleteWhereQuery == null) {
                    throw new UnsupportedOperationException("deleteWhereQuery is null");
                }
                if (this.updateQuery == null) {
                    throw new UnsupportedOperationException("updateQuery is null");
                }
                if (this.insertQuery == null) {
                    throw new UnsupportedOperationException("insertQuery is null");
                }
                Object bean = context.get(key);
                Connection con = null;
                try {
                    DatabaseSubMapping subMapping;
                    con = factory.getConnection();
                    if (bean == null || !this.isUniqueKey) {
                        Object input = null;
                        if (this.databaseRecord == null) {
                            input = key;
                        } else {
                            if (this.propertyAccess == null) {
                                this.propertyAccess = new PropertyAccess();
                            }
                            Record record = this.databaseRecord.cloneSchema();
                            if (this.keyClass == null) {
                                this.propertyAccess.set(record, this.keySavePropertyName, key);
                            } else {
                                for (Map.Entry propMapping : this.keySavePropertyMappings.entrySet()) {
                                    this.propertyAccess.set(record, (String)propMapping.getValue(), this.propertyAccess.get(key, (String)propMapping.getKey()));
                                }
                            }
                            input = record;
                        }
                        if (this.subMappings != null) {
                            for (int j = 0; j < this.subMappings.size(); ++j) {
                                DatabaseSubMapping subMapping2 = (DatabaseSubMapping)this.subMappings.get(j);
                                if (subMapping2.getDeleteWhereQuery() == null) continue;
                                subMapping2.delete(con, pm, input);
                            }
                        }
                        pm.persistQuery(con, this.deleteWhereQuery, input);
                        if (bean == null) break block45;
                        List list = (List)bean;
                        PersistentManager.BatchExecutor executor = null;
                        try {
                            executor = pm.createQueryBatchExecutor(con, this.insertQuery);
                            if (this.batchPersistCount > 0) {
                                executor.setAutoBatchPersistCount(this.batchPersistCount);
                                executor.setAutoCommitOnPersist(this.isBatchCommitOnPersist);
                            }
                            Record record = null;
                            int imax = list.size();
                            for (int i = 0; i < imax; ++i) {
                                record = this.save(con, pm, executor, key, list.get(i), record);
                            }
                            executor.persist();
                        }
                        finally {
                            if (executor != null) {
                                executor.close();
                            }
                        }
                        if (this.subMappings != null) {
                            for (int j = 0; j < this.subMappings.size(); ++j) {
                                DatabaseSubMapping subMapping3 = (DatabaseSubMapping)this.subMappings.get(j);
                                if (subMapping3.getInsertQuery() == null) continue;
                                subMapping3.insert(con, pm, input, bean);
                            }
                        }
                        break block45;
                    }
                    Object input = null;
                    if (this.databaseRecord == null) {
                        input = bean;
                    } else {
                        int j;
                        if (this.propertyAccess == null) {
                            this.propertyAccess = new PropertyAccess();
                        }
                        Record record = this.databaseRecord.cloneSchema();
                        PropertySchema[] propSchemata = record.getRecordSchema().getPropertySchemata();
                        if (this.keyClass == null) {
                            this.propertyAccess.set(record, this.keySavePropertyName, key);
                        } else {
                            for (Map.Entry propMapping : this.keySavePropertyMappings.entrySet()) {
                                this.propertyAccess.set(record, (String)propMapping.getValue(), this.propertyAccess.get(key, (String)propMapping.getKey()));
                            }
                        }
                        if (this.savePropertyMappings == null) {
                            for (j = 0; j < propSchemata.length; ++j) {
                                Object value = this.propertyAccess.get(bean, propSchemata[j].getName());
                                record.setProperty(propSchemata[j].getName(), value);
                            }
                        } else {
                            for (j = 0; j < propSchemata.length; ++j) {
                                Map propMappings = (Map)this.savePropertyMappings.get(propSchemata[j].getName());
                                if (propMappings == null) continue;
                                for (Map.Entry propMapping : propMappings.entrySet()) {
                                    Object value = this.propertyAccess.get(bean, (String)propMapping.getKey());
                                    List recordProperties = (List)propMapping.getValue();
                                    for (int k = 0; k < recordProperties.size(); ++k) {
                                        this.propertyAccess.set(record, (String)recordProperties.get(k), value);
                                    }
                                }
                            }
                        }
                        input = record;
                    }
                    if (this.subMappings != null) {
                        for (int j = 0; j < this.subMappings.size(); ++j) {
                            subMapping = (DatabaseSubMapping)this.subMappings.get(j);
                            if (subMapping.getDeleteWhereQuery() == null) continue;
                            subMapping.delete(con, pm, input);
                        }
                    }
                    if (pm.persistQuery(con, this.updateQuery, input) == 0) {
                        pm.persistQuery(con, this.insertQuery, input);
                    }
                    if (this.subMappings != null) {
                        for (int j = 0; j < this.subMappings.size(); ++j) {
                            subMapping = (DatabaseSubMapping)this.subMappings.get(j);
                            if (subMapping.getInsertQuery() == null) continue;
                            subMapping.insert(con, pm, input, bean);
                        }
                    }
                }
                finally {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }

        private class LoadQueueHandler
        implements QueueHandler {
            private LoadQueueHandler() {
            }

            @Override
            public void handleDequeuedObject(Object obj) throws Throwable {
                AsynchContext ac = (AsynchContext)obj;
                if (ac == null) {
                    return;
                }
                Object[] params = (Object[])ac.getInput();
                DatabaseMapping.this.load((Context)params[0], (ConnectionFactory)params[1], (PersistentManager)params[2], DatabaseMapping.this.parallelSelectQuery, params[3], false);
                ac.getResponseQueue().push(ac);
            }

            @Override
            public boolean handleError(Object obj, Throwable th) throws Throwable {
                return false;
            }

            @Override
            public void handleRetryOver(Object obj, Throwable th) throws Throwable {
                AsynchContext ac = (AsynchContext)obj;
                ac.setThrowable(th);
                ac.getResponseQueue().push(ac);
            }
        }
    }
}

