/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.context.ThreadContextServiceMBean;

public class ThreadContextService
extends ServiceBase
implements Context,
ThreadContextServiceMBean {
    private static final long serialVersionUID = -7304455455493489289L;
    protected ThreadLocal threadLocal;
    protected Map defaultMap;

    @Override
    public void createService() throws Exception {
        this.defaultMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.threadLocal == null) {
            this.clearAllThreadContext();
        }
    }

    @Override
    public void stopService() throws Exception {
        this.clearAllThreadContext();
    }

    @Override
    public void destroyService() throws Exception {
        this.defaultMap = null;
    }

    @Override
    public void clear() {
        Map map = (Map)this.threadLocal.get();
        this.init(map);
    }

    private void init(Map map) {
        if (map != null) {
            map.clear();
            map.putAll(this.defaultMap);
            for (Map.Entry entry : map.entrySet()) {
                Object val = entry.getValue();
                if (val == null) continue;
                if (val instanceof ServiceName) {
                    ServiceName name = (ServiceName)val;
                    Object service = null;
                    try {
                        service = ServiceManagerFactory.getServiceObject(name);
                    }
                    catch (ServiceNotFoundException e) {
                        // empty catch block
                    }
                    entry.setValue(service);
                    continue;
                }
                if (!(val instanceof ServiceName[])) continue;
                ServiceName[] names = (ServiceName[])val;
                Object[] services = new Object[names.length];
                for (int i = 0; i < names.length; ++i) {
                    try {
                        services[i] = ServiceManagerFactory.getServiceObject(names[i]);
                        continue;
                    }
                    catch (ServiceNotFoundException e) {
                        // empty catch block
                    }
                }
                entry.setValue(services);
            }
        }
    }

    @Override
    public int size() {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.isEmpty();
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.containsValue(value);
        }
        return false;
    }

    @Override
    public Set entrySet() {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.entrySet();
        }
        return new HashSet();
    }

    @Override
    public Object get(Object key) {
        Map map = (Map)this.threadLocal.get();
        return map.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.threadLocal == null) {
            return this.defaultMap.put(key, value);
        }
        Map map = (Map)this.threadLocal.get();
        return map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.remove(key);
        }
        return null;
    }

    @Override
    public void putAll(Map t) {
        Map map = (Map)this.threadLocal.get();
        map.putAll(t);
    }

    @Override
    public Set keySet() {
        Map map = (Map)this.threadLocal.get();
        return map.keySet();
    }

    @Override
    public Collection values() {
        Map map = (Map)this.threadLocal.get();
        return map.values();
    }

    @Override
    public Map all() {
        Map map = (Map)this.threadLocal.get();
        return new HashMap(map);
    }

    public Map getDefaultMap() {
        return this.defaultMap;
    }

    @Override
    public void clearAllThreadContext() {
        this.threadLocal = new ThreadLocal(){

            protected synchronized Object initialValue() {
                Map map = Collections.synchronizedMap(new HashMap());
                ThreadContextService.this.init(map);
                return map;
            }
        };
    }

    @Override
    public void load() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadKey() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(Object key) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(Object key) throws Exception {
        throw new UnsupportedOperationException();
    }
}

