/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.httpclient;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.http.HttpException;
import jp.ossc.nimbus.service.http.HttpRequest;
import jp.ossc.nimbus.service.http.HttpRequestCreateException;
import jp.ossc.nimbus.service.http.HttpResponse;
import jp.ossc.nimbus.service.http.httpclient.HttpClientConnectTimeoutException;
import jp.ossc.nimbus.service.http.httpclient.HttpClientCreateTimeoutException;
import jp.ossc.nimbus.service.http.httpclient.HttpClientFactoryServiceMBean;
import jp.ossc.nimbus.service.http.httpclient.HttpClientSocketTimeoutException;
import jp.ossc.nimbus.service.http.httpclient.HttpRequestImpl;
import jp.ossc.nimbus.service.http.httpclient.HttpResponseImpl;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.converter.StreamConverter;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;

public class HttpClientFactoryService
extends ServiceBase
implements HttpClientFactory,
HttpClientFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = 4729444860053132964L;
    protected int connectionTimeout = -1;
    protected int linger = -1;
    protected int receiveBufferSize = -1;
    protected int sendBufferSize = -1;
    protected int soTimeout = -1;
    protected Map actionRequestMap = new HashMap();
    protected Map actionResponseMap = new HashMap();
    protected Map credentialsMap = new HashMap();
    protected Map proxyCredentialsMap = new HashMap();
    protected Map requestHeaders = new HashMap();
    protected String proxy;
    protected String proxyHost;
    protected int proxyPort;
    protected InetAddress localAddress;
    protected String localAddressStr;
    protected Map httpClientParamMap = new HashMap();
    protected ServiceName requestStreamConverterServiceName;
    protected StreamConverter requestStreamConverter;
    protected ServiceName responseStreamConverterServiceName;
    protected StreamConverter responseStreamConverter;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected String requestContentType;
    protected String requestCharacterEncoding;
    protected int requestDeflateLength = -1;
    protected ServiceName semaphoreServiceName;
    protected Semaphore semaphore;
    protected String httpVersion;
    protected Class httpConnectionManagerClass;
    protected HttpConnectionManager httpConnectionManager;
    protected boolean isOutputJournalResponseObject = true;
    protected long idleConnectionTimeout;
    protected long idleConnectionCheckInterval;
    protected IdleConnectionTimeoutThread idleConnectionTimeoutThread;

    @Override
    public void setConnectionTimeout(int millis) {
        this.connectionTimeout = millis;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setLinger(int millis) {
        this.linger = millis;
    }

    @Override
    public int getLinger() {
        return this.linger;
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    @Override
    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public void setSoTimeout(int millis) {
        this.soTimeout = millis;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public String getRequestContentType() {
        return this.requestContentType;
    }

    @Override
    public void setRequestContentType(String type) {
        this.requestContentType = type;
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding;
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) {
        this.requestCharacterEncoding = encoding;
    }

    @Override
    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public void setHttpVersion(String version) {
        this.httpVersion = version;
    }

    @Override
    public void setRequestHeaders(String name, String[] values) {
        this.requestHeaders.put(name, values);
    }

    @Override
    public String[] getRequestHeaders(String name) {
        return (String[])this.requestHeaders.get(name);
    }

    @Override
    public void setProxy(String proxy) {
        if (proxy == null) {
            this.proxyHost = null;
            this.proxyPort = 0;
        } else {
            int index = proxy.indexOf(58);
            if (index <= 0 || index == proxy.length() - 1) {
                throw new IllegalArgumentException("Illegal proxy : " + proxy);
            }
            this.proxyHost = proxy.substring(0, index);
            try {
                this.proxyPort = Integer.parseInt(proxy.substring(index + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal proxy port : " + proxy);
            }
        }
        this.proxy = proxy;
    }

    @Override
    public String getProxy() {
        return this.proxy;
    }

    @Override
    public void setLocalAddress(String address) throws UnknownHostException {
        if (address == null) {
            this.localAddress = null;
            this.localAddressStr = null;
        } else {
            this.localAddress = InetAddress.getByName(address);
            this.localAddressStr = address;
        }
    }

    @Override
    public String getLocalAddress() {
        return this.localAddressStr;
    }

    @Override
    public void setHttpClientParam(String name, Object value) {
        this.httpClientParamMap.put(name, value);
    }

    @Override
    public Object getHttpClientParam(String name) {
        return this.httpClientParamMap.get(name);
    }

    @Override
    public Map getHttpClientParamMap() {
        return this.httpClientParamMap;
    }

    @Override
    public void setRequestDeflateLength(int length) {
        this.requestDeflateLength = length;
    }

    @Override
    public int getRequestDeflateLength() {
        return this.requestDeflateLength;
    }

    @Override
    public void setRequestStreamConverterServiceName(ServiceName name) {
        this.requestStreamConverterServiceName = name;
    }

    @Override
    public ServiceName getRequestStreamConverterServiceName() {
        return this.requestStreamConverterServiceName;
    }

    @Override
    public void setResponseStreamConverterServiceName(ServiceName name) {
        this.responseStreamConverterServiceName = name;
    }

    @Override
    public ServiceName getResponseStreamConverterServiceName() {
        return this.responseStreamConverterServiceName;
    }

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setSemaphoreServiceName(ServiceName name) {
        this.semaphoreServiceName = name;
    }

    @Override
    public ServiceName getSemaphoreServiceName() {
        return this.semaphoreServiceName;
    }

    @Override
    public void setHttpConnectionManagerClass(Class clazz) {
        this.httpConnectionManagerClass = clazz;
    }

    @Override
    public Class getHttpConnectionManagerClass() {
        return this.httpConnectionManagerClass;
    }

    @Override
    public boolean isOutputJournalResponseObject() {
        return this.isOutputJournalResponseObject;
    }

    @Override
    public void setOutputJournalResponseObject(boolean isOutput) {
        this.isOutputJournalResponseObject = isOutput;
    }

    @Override
    public void setIdleConnectionTimeout(long timeout) {
        this.idleConnectionTimeout = timeout;
    }

    @Override
    public long getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Override
    public void setIdleConnectionCheckInterval(long interval) {
        this.idleConnectionCheckInterval = interval;
    }

    @Override
    public long getIdleConnectionCheckInterval() {
        return this.idleConnectionCheckInterval;
    }

    @Override
    public int getConnectionsInPool() {
        if (this.httpConnectionManager != null && this.httpConnectionManager instanceof MultiThreadedHttpConnectionManager) {
            return ((MultiThreadedHttpConnectionManager)this.httpConnectionManager).getConnectionsInPool();
        }
        return -1;
    }

    @Override
    public int getConnectionsInUse() {
        if (this.httpConnectionManager != null && this.httpConnectionManager instanceof MultiThreadedHttpConnectionManager) {
            return ((MultiThreadedHttpConnectionManager)this.httpConnectionManager).getConnectionsInUse();
        }
        return -1;
    }

    public void setRequestStreamConverter(StreamConverter converter) {
        this.requestStreamConverter = converter;
    }

    public StreamConverter getRequestStreamConverter() {
        return this.requestStreamConverter;
    }

    public void setResponseStreamConverter(StreamConverter converter) {
        this.responseStreamConverter = converter;
    }

    public StreamConverter getResponseStreamConverter() {
        return this.responseStreamConverter;
    }

    public void setRequest(String action, HttpRequestImpl request) {
        if (this.actionRequestMap == null) {
            this.actionRequestMap = new HashMap();
        }
        request.setActionName(action);
        this.actionRequestMap.put(action, request);
    }

    public HttpRequestImpl getRequest(String action) {
        if (this.actionRequestMap == null) {
            return null;
        }
        return (HttpRequestImpl)this.actionRequestMap.get(action);
    }

    public void setResponse(String action, HttpResponseImpl response) {
        if (this.actionResponseMap == null) {
            this.actionResponseMap = new HashMap();
        }
        this.actionResponseMap.put(action, response);
    }

    public HttpResponseImpl getResponse(String action) {
        if (this.actionResponseMap == null) {
            return null;
        }
        return (HttpResponseImpl)this.actionResponseMap.get(action);
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.credentialsMap.put(authscope, credentials);
    }

    public void setProxyCredentials(AuthScope authscope, Credentials credentials) {
        this.proxyCredentialsMap.put(authscope, credentials);
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.semaphoreServiceName != null) {
            this.semaphore = (Semaphore)ServiceManagerFactory.getServiceObject(this.semaphoreServiceName);
            this.semaphore.accept();
        }
        if (this.httpConnectionManagerClass != null) {
            this.httpConnectionManager = (HttpConnectionManager)this.httpConnectionManagerClass.newInstance();
            if (this.idleConnectionTimeout > 0L) {
                this.idleConnectionTimeoutThread = new IdleConnectionTimeoutThread();
                this.idleConnectionTimeoutThread.addConnectionManager(this.httpConnectionManager);
                this.idleConnectionTimeoutThread.setConnectionTimeout(this.idleConnectionTimeout);
                if (this.idleConnectionCheckInterval > 0L) {
                    this.idleConnectionTimeoutThread.setTimeoutInterval(this.idleConnectionCheckInterval);
                }
                this.idleConnectionTimeoutThread.start();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
        if (this.idleConnectionTimeoutThread != null) {
            this.idleConnectionTimeoutThread.shutdown();
            this.idleConnectionTimeoutThread = null;
        }
        if (this.httpConnectionManager != null) {
            if (this.httpConnectionManager instanceof MultiThreadedHttpConnectionManager) {
                ((MultiThreadedHttpConnectionManager)this.httpConnectionManager).shutdown();
            } else if (this.httpConnectionManager instanceof SimpleHttpConnectionManager) {
                ((SimpleHttpConnectionManager)this.httpConnectionManager).shutdown();
            }
            this.httpConnectionManager = null;
        }
    }

    @Override
    public HttpRequest createRequest(String action) throws HttpRequestCreateException {
        HttpRequestImpl request = (HttpRequestImpl)this.actionRequestMap.get(action);
        if (request == null) {
            throw new HttpRequestCreateException("No action.");
        }
        try {
            request = (HttpRequestImpl)request.clone();
            if (request.getContentType() == null && this.requestContentType != null) {
                request.setContentType(this.requestContentType);
            }
            if (request.getCharacterEncoding() == null && this.requestCharacterEncoding != null) {
                request.setCharacterEncoding(this.requestCharacterEncoding);
            }
            if (request.getHttpVersion() == null && this.httpVersion != null) {
                request.setHttpVersion(this.httpVersion);
            }
            if (request.getStreamConverter() == null && request.getStreamConverterServiceName() == null) {
                if (this.requestStreamConverter != null) {
                    request.setStreamConverter(this.requestStreamConverter);
                } else if (this.requestStreamConverterServiceName != null) {
                    request.setStreamConverterServiceName(this.requestStreamConverterServiceName);
                }
            }
            if (this.requestHeaders.size() != 0) {
                Set headerNameSet = request.getHeaderNameSet();
                for (String headerName : this.requestHeaders.keySet()) {
                    if (headerNameSet.contains(headerName)) continue;
                    request.setHeaders(headerName, (String[])this.requestHeaders.get(headerName));
                }
            }
            if (request.getDeflateLength() <= 0 && this.requestDeflateLength != -1) {
                request.setDeflateLength(this.requestDeflateLength);
            }
            return request;
        }
        catch (CloneNotSupportedException e) {
            throw new HttpRequestCreateException(e);
        }
    }

    @Override
    public HttpClient createHttpClient() throws HttpException {
        if (this.semaphore == null) {
            return new HttpClientImpl();
        }
        if (this.semaphore.getResource()) {
            try {
                return new HttpClientImpl();
            }
            catch (HttpException e) {
                this.semaphore.freeResource();
                throw e;
            }
            catch (Throwable th) {
                this.semaphore.freeResource();
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw (Error)th;
            }
        }
        throw new HttpClientCreateTimeoutException();
    }

    public static class CookieImpl
    extends javax.servlet.http.Cookie {
        private Cookie cookie;

        public CookieImpl(Cookie cookie) {
            super(cookie.getName(), cookie.getValue());
            this.cookie = cookie;
            if (cookie.getComment() != null) {
                super.setComment(cookie.getComment());
            }
            if (cookie.getDomain() != null) {
                super.setDomain(cookie.getDomain());
            }
            if (cookie.getExpiryDate() == null) {
                super.setMaxAge(-1);
            } else {
                long expiry = cookie.getExpiryDate().getTime();
                super.setMaxAge((int)(expiry - System.currentTimeMillis()));
            }
            if (cookie.getPath() != null) {
                super.setPath(cookie.getPath());
            }
            super.setSecure(cookie.getSecure());
            super.setVersion(cookie.getVersion());
        }

        public void setComment(String purpose) {
            super.setComment(purpose);
            this.cookie.setComment(purpose);
        }

        public void setDomain(String pattern) {
            super.setDomain(pattern);
            this.cookie.setDomain(pattern);
        }

        public void setMaxAge(int expiry) {
            super.setMaxAge(expiry);
            this.cookie.setExpiryDate(new Date((long)expiry + System.currentTimeMillis()));
        }

        public void setPath(String uri) {
            super.setPath(uri);
            this.cookie.setPath(uri);
        }

        public void setSecure(boolean flag) {
            super.setSecure(flag);
            this.cookie.setSecure(flag);
        }

        public void setValue(String newValue) {
            super.setValue(newValue);
            this.cookie.setValue(newValue);
        }

        public void setVersion(int v) {
            super.setVersion(v);
            this.cookie.setVersion(v);
        }
    }

    public class HttpClientImpl
    implements HttpClient {
        protected org.apache.commons.httpclient.HttpClient client;
        protected HttpMethodBase method;

        public HttpClientImpl() {
            HttpClientParams params = new HttpClientParams();
            for (String name : HttpClientFactoryService.this.httpClientParamMap.keySet()) {
                Object value = HttpClientFactoryService.this.httpClientParamMap.get(name);
                params.setParameter(name, value);
            }
            this.client = HttpClientFactoryService.this.httpConnectionManager == null ? new org.apache.commons.httpclient.HttpClient(params) : new org.apache.commons.httpclient.HttpClient(params, HttpClientFactoryService.this.httpConnectionManager);
            HostConfiguration hostConfig = this.client.getHostConfiguration();
            if (HttpClientFactoryService.this.proxy != null) {
                hostConfig.setProxy(HttpClientFactoryService.this.proxyHost, HttpClientFactoryService.this.proxyPort);
            }
            if (HttpClientFactoryService.this.localAddress != null) {
                hostConfig.setLocalAddress(HttpClientFactoryService.this.localAddress);
            }
            HttpConnectionManagerParams conParams = this.client.getHttpConnectionManager().getParams();
            if (HttpClientFactoryService.this.connectionTimeout != -1) {
                conParams.setConnectionTimeout(HttpClientFactoryService.this.connectionTimeout);
            }
            if (HttpClientFactoryService.this.linger != -1) {
                conParams.setLinger(HttpClientFactoryService.this.linger);
            }
            if (HttpClientFactoryService.this.receiveBufferSize != -1) {
                conParams.setReceiveBufferSize(HttpClientFactoryService.this.receiveBufferSize);
            }
            if (HttpClientFactoryService.this.sendBufferSize != -1) {
                conParams.setSendBufferSize(HttpClientFactoryService.this.sendBufferSize);
            }
            if (HttpClientFactoryService.this.soTimeout != -1) {
                conParams.setSoTimeout(HttpClientFactoryService.this.soTimeout);
            }
            for (Map.Entry entry : HttpClientFactoryService.this.credentialsMap.entrySet()) {
                this.client.getState().setCredentials((AuthScope)entry.getKey(), (Credentials)entry.getValue());
            }
            for (Map.Entry entry : HttpClientFactoryService.this.proxyCredentialsMap.entrySet()) {
                this.client.getState().setProxyCredentials((AuthScope)entry.getKey(), (Credentials)entry.getValue());
            }
        }

        @Override
        public void addCookie(javax.servlet.http.Cookie cookie) {
            if (this.client == null) {
                return;
            }
            Cookie result = new Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue());
            result.setComment(cookie.getComment());
            if (cookie.getMaxAge() > 0) {
                result.setExpiryDate(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge()));
            }
            result.setPath(cookie.getPath());
            result.setSecure(cookie.getSecure());
            result.setVersion(cookie.getVersion());
            this.client.getState().addCookie(result);
        }

        @Override
        public javax.servlet.http.Cookie[] getCookies() {
            if (this.client == null) {
                return new javax.servlet.http.Cookie[0];
            }
            Cookie[] cookies = this.client.getState().getCookies();
            if (cookies == null || cookies.length == 0) {
                return new javax.servlet.http.Cookie[0];
            }
            javax.servlet.http.Cookie[] result = new javax.servlet.http.Cookie[cookies.length];
            for (int i = 0; i < cookies.length; ++i) {
                result[i] = new CookieImpl(cookies[i]);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpResponse executeRequest(HttpRequest request) throws HttpException {
            if (this.client == null) {
                throw new HttpException("Closed.");
            }
            HttpResponseImpl response = null;
            try {
                if (HttpClientFactoryService.this.journal != null) {
                    HttpClientFactoryService.this.journal.startJournal("Access");
                    String requestId = null;
                    if (HttpClientFactoryService.this.sequence != null) {
                        requestId = HttpClientFactoryService.this.sequence.increment();
                    } else if (HttpClientFactoryService.this.threadContext != null) {
                        requestId = (String)HttpClientFactoryService.this.threadContext.get("REQUEST_ID");
                    }
                    if (requestId != null) {
                        HttpClientFactoryService.this.journal.setRequestId(requestId);
                    }
                }
                int status = 0;
                try {
                    if (HttpClientFactoryService.this.journal != null) {
                        HttpClientFactoryService.this.journal.addStartStep("Request");
                    }
                    HttpRequestImpl req = (HttpRequestImpl)request;
                    if (HttpClientFactoryService.this.journal != null) {
                        HttpClientFactoryService.this.journal.addInfo("Action", req.getActionName());
                        HttpClientFactoryService.this.journal.addInfo("URI", req.getURL());
                        HttpClientFactoryService.this.journal.addInfo("Cookies", this.getCookies());
                        if (req.getHeaderMap() != null) {
                            HttpClientFactoryService.this.journal.addInfo("Headers", req.getHeaderMap());
                        }
                        if (req.getParameterMap() != null) {
                            HttpClientFactoryService.this.journal.addInfo("Parameters", req.getParameterMap());
                        }
                        if (req.getObject() != null) {
                            HttpClientFactoryService.this.journal.addInfo("InputObject", req.getObject());
                        }
                    }
                    if (this.method != null) {
                        this.method.releaseConnection();
                        this.method = null;
                    }
                    this.method = req.createHttpMethod();
                    if (HttpClientFactoryService.this.journal != null && req.getInputBytes() != null) {
                        String body = null;
                        body = req.getCharacterEncoding() == null ? new String(req.getInputBytes()) : new String(req.getInputBytes(), req.getCharacterEncoding());
                        HttpClientFactoryService.this.journal.addInfo("Body", body);
                    }
                    status = this.client.executeMethod((HttpMethod)this.method);
                }
                finally {
                    if (HttpClientFactoryService.this.journal != null) {
                        HttpClientFactoryService.this.journal.addEndStep();
                    }
                }
                try {
                    if (HttpClientFactoryService.this.journal != null) {
                        HttpClientFactoryService.this.journal.addStartStep("Response");
                        HttpClientFactoryService.this.journal.addInfo("Status", new Integer(status));
                    }
                    if ((response = (response = (HttpResponseImpl)HttpClientFactoryService.this.actionResponseMap.get(request.getActionName())) == null ? new HttpResponseImpl() : (HttpResponseImpl)response.clone()).getStreamConverter() == null && response.getStreamConverterServiceName() == null) {
                        if (HttpClientFactoryService.this.responseStreamConverter != null) {
                            response.setStreamConverter(HttpClientFactoryService.this.responseStreamConverter);
                        } else if (HttpClientFactoryService.this.responseStreamConverterServiceName != null) {
                            response.setStreamConverterServiceName(HttpClientFactoryService.this.responseStreamConverterServiceName);
                        }
                    }
                    response.setStatusCode(status);
                    response.setHttpMethod(this.method);
                    if (HttpClientFactoryService.this.journal != null) {
                        if (response.getHeaderMap() != null) {
                            HttpClientFactoryService.this.journal.addInfo("Headers", response.getHeaderMap());
                        }
                        if (response.getOutputBytes() != null) {
                            String body = null;
                            String encoding = response.getCharacterEncoding();
                            body = encoding == null ? new String(response.getOutputBytes()) : new String(response.getOutputBytes(), encoding);
                            HttpClientFactoryService.this.journal.addInfo("Body", body);
                        }
                        if (HttpClientFactoryService.this.isOutputJournalResponseObject) {
                            try {
                                if (response.getObject() != null) {
                                    HttpClientFactoryService.this.journal.addInfo("OutputObject", response.getObject());
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    HttpResponseImpl httpResponseImpl = response;
                    if (HttpClientFactoryService.this.journal != null) {
                        HttpClientFactoryService.this.journal.addEndStep();
                    }
                    return httpResponseImpl;
                }
                catch (Throwable throwable) {
                    try {
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.addEndStep();
                        }
                        throw throwable;
                    }
                    catch (ConnectTimeoutException e) {
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.addInfo("Exception", (Object)e);
                        }
                        throw new HttpClientConnectTimeoutException(e);
                    }
                    catch (CloneNotSupportedException e) {
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        }
                        throw new HttpException(e);
                    }
                    catch (SocketTimeoutException e) {
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        }
                        throw new HttpClientSocketTimeoutException(e);
                    }
                    catch (IOException e) {
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        }
                        throw new HttpException(e);
                    }
                    catch (RuntimeException e) {
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        }
                        throw e;
                    }
                    catch (Error e) {
                        if (HttpClientFactoryService.this.journal != null) {
                            HttpClientFactoryService.this.journal.addInfo("Exception", e);
                        }
                        throw e;
                    }
                }
            }
            finally {
                if (response != null && response.isConnectionClose() && response.getContentLength() > 0) {
                    response.close();
                }
                if (HttpClientFactoryService.this.journal != null) {
                    HttpClientFactoryService.this.journal.endJournal();
                }
            }
        }

        @Override
        public void close() throws HttpException {
            HttpConnectionManager connectionManager;
            if (HttpClientFactoryService.this.semaphore != null) {
                HttpClientFactoryService.this.semaphore.freeResource();
            }
            if (this.method != null) {
                this.method.releaseConnection();
                this.method = null;
            }
            if (this.client != null && (connectionManager = this.client.getHttpConnectionManager()) instanceof SimpleHttpConnectionManager) {
                try {
                    ((SimpleHttpConnectionManager)connectionManager).shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.client = null;
        }

        public org.apache.commons.httpclient.HttpClient getHttpClient() {
            return this.client;
        }
    }
}

