/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.MutableObjectJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class MutableObjectJournalEditorService
extends ServiceBase
implements MutableObjectJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -2158326775826244589L;

    @Override
    public Object toObject(EditorFinder finder, Object key, Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return this.toArrayObject(finder, key, value);
        }
        JournalEditor editor = finder.findEditor(key, value.getClass());
        if (editor != null && editor != this) {
            Object obj = editor.toObject(finder, key, value);
            return obj;
        }
        return value;
    }

    protected Object toArrayObject(EditorFinder finder, Object key, Object values) {
        int i;
        if (values == null) {
            return null;
        }
        int length = Array.getLength(values);
        if (length == 0) {
            return values;
        }
        Object[] objs = new Object[length];
        boolean isNullArray = true;
        for (i = 0; i < length; ++i) {
            objs[i] = Array.get(values, i);
            if (objs[i] == null) continue;
            isNullArray = false;
        }
        if (isNullArray) {
            return values;
        }
        for (i = 0; i < length; ++i) {
            objs[i] = this.toObject(finder, null, objs[i]);
        }
        Class sharedClass = this.getSharedSuperClass(objs);
        if (sharedClass.equals(Object.class)) {
            return objs;
        }
        Object array = Array.newInstance(sharedClass, length);
        for (int i2 = 0; i2 < length; ++i2) {
            Array.set(array, i2, objs[i2]);
        }
        return array;
    }

    protected Class getSharedSuperClass(Object[] array) {
        int length = array.length;
        if (length == 0) {
            return array.getClass().getComponentType();
        }
        boolean equalsAll = true;
        Class<?> tmpClass = null;
        Set shared = null;
        HashSet<Set> impls = new HashSet<Set>();
        for (int i = 0; i < length; ++i) {
            Set set;
            if (array[i] != null) {
                if (tmpClass == null) {
                    tmpClass = array[i].getClass();
                } else if (equalsAll) {
                    equalsAll &= tmpClass.equals(array[i].getClass());
                }
            }
            if ((set = this.getImplementsClassSet(array[i])) == null) continue;
            impls.add(set);
            if (shared == null) {
                shared = set;
                continue;
            }
            shared.retainAll(set);
        }
        if (equalsAll && tmpClass != null) {
            return tmpClass;
        }
        if (shared == null || shared.size() == 0) {
            return array.getClass().getComponentType();
        }
        if (shared.size() == 1) {
            return (Class)shared.iterator().next();
        }
        return this.getLastChildClass(shared, impls);
    }

    private Set getImplementsClassSet(Object obj) {
        if (obj == null) {
            return null;
        }
        HashSet set = new HashSet();
        Class<?> clazz = obj.getClass();
        set.add(clazz);
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (set.contains(interfaces[i])) continue;
            set.add(interfaces[i]);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !set.contains(superClass)) {
            set.add(superClass);
        }
        return set;
    }

    private Class getLastChildClass(Set shared, Set impls) {
        if (shared.size() == 0) {
            return Object.class;
        }
        if (shared.size() == 1) {
            return (Class)shared.iterator().next();
        }
        Iterator implsSets = impls.iterator();
        class Counter {
            int count = 1;

            Counter() {
            }

            public void increment() {
                ++this.count;
            }
        }
        HashMap<Class, Counter> counts = new HashMap<Class, Counter>();
        while (implsSets.hasNext()) {
            Set implsSet = (Set)implsSets.next();
            implsSet.retainAll(shared);
            for (Class cls : implsSet) {
                if (counts.containsKey(cls)) {
                    ((Counter)counts.get(cls)).increment();
                    continue;
                }
                counts.put(cls, new Counter());
            }
        }
        Iterator<Object> classes = counts.keySet().iterator();
        HashSet<Class> maxCounters = new HashSet<Class>();
        int max = 0;
        while (classes.hasNext()) {
            Class cls = (Class)classes.next();
            Counter counter = (Counter)counts.get(cls);
            if (max == 0) {
                max = counter.count;
                maxCounters.add(cls);
                continue;
            }
            if (max < counter.count) {
                max = counter.count;
                maxCounters.clear();
                maxCounters.add(cls);
                continue;
            }
            if (max != counter.count) continue;
            maxCounters.add(cls);
        }
        if (maxCounters.size() == 1) {
            return (Class)maxCounters.iterator().next();
        }
        classes = maxCounters.iterator();
        Class clazz = Object.class;
        while (classes.hasNext()) {
            Class cls = (Class)classes.next();
            if (clazz.isAssignableFrom(cls)) {
                clazz = cls;
                continue;
            }
            if (!clazz.isInterface() || cls.isInterface()) continue;
            clazz = cls;
        }
        return clazz;
    }
}

