/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.PrintStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.writer.ConsoleWriterServiceMBean;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.WritableRecord;

public class ConsoleWriterService
extends ServiceBase
implements ConsoleWriterServiceMBean,
MessageWriter {
    private static final long serialVersionUID = 4209363683339544273L;
    private String mOutputKind = "STDOUT";
    private PrintStream mOutputStream;

    @Override
    public void setOutput(String kind) {
        if (!"STDOUT".equals(kind) && !"STDERR".equals(kind)) {
            throw new IllegalArgumentException(kind);
        }
        this.mOutputKind = kind;
    }

    @Override
    public String getOutput() {
        return this.mOutputKind;
    }

    @Override
    public void startService() {
        this.mOutputStream = this.mOutputKind.equals("STDERR") ? System.err : System.out;
    }

    @Override
    public void stopService() {
        this.mOutputStream = null;
    }

    @Override
    public void write(WritableRecord rec) {
        this.mOutputStream.println(rec.toString());
    }
}

