/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.validator;

import java.io.Serializable;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;

public abstract class AbstractStringValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = -468946068283281754L;
    protected boolean isAllowNull = true;
    protected boolean isAllowEmpty;
    protected boolean isAllowObject;
    protected boolean isTrim;
    protected char[] whiteSpaceCharacters;

    public void setAllowNull(boolean isAllow) {
        this.isAllowNull = isAllow;
    }

    public boolean isAllowNull() {
        return this.isAllowNull;
    }

    public void setAllowEmpty(boolean isAllow) {
        this.isAllowEmpty = isAllow;
    }

    public boolean isAllowEmpty() {
        return this.isAllowEmpty;
    }

    public void setAllowObject(boolean isAllow) {
        this.isAllowObject = isAllow;
    }

    public boolean isAllowObject() {
        return this.isAllowObject;
    }

    public void setTrim(boolean trim) {
        this.isTrim = trim;
    }

    public boolean isTrim() {
        return this.isTrim;
    }

    public void setWhiteSpaceCharacters(char[] chars) {
        this.whiteSpaceCharacters = chars;
    }

    public char[] getWhiteSpaceCharacters() {
        return this.whiteSpaceCharacters;
    }

    @Override
    public boolean validate(Object obj) throws ValidateException {
        if (obj == null) {
            return this.isAllowNull;
        }
        String str = null;
        if (obj instanceof String) {
            str = (String)obj;
        } else {
            if (!this.isAllowObject) {
                return false;
            }
            str = obj.toString();
        }
        if (this.isTrim) {
            str = this.trim(str);
        }
        if (str.length() == 0 && this.isAllowEmpty) {
            return true;
        }
        return this.validateString(str);
    }

    protected abstract boolean validateString(String var1) throws ValidateException;

    protected String trim(String str) {
        int i;
        String result = str;
        int max = result.length();
        for (i = 0; i < max; ++i) {
            char c = result.charAt(i);
            if (this.isWhitespace(c)) continue;
            result = result.substring(i);
            break;
        }
        i = result.length();
        while (--i >= 0) {
            char c = result.charAt(i);
            if (this.isWhitespace(c)) continue;
            result = result.substring(0, i + 1);
            break;
        }
        return result;
    }

    protected boolean isWhitespace(char c) {
        if (this.whiteSpaceCharacters == null || this.whiteSpaceCharacters.length == 0) {
            return Character.isWhitespace(c);
        }
        for (int i = 0; i < this.whiteSpaceCharacters.length; ++i) {
            if (c != this.whiteSpaceCharacters[i]) continue;
            return true;
        }
        return false;
    }
}

