/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.io.CSVReader;

public class CSVRecordReader
extends CSVReader {
    private RecordSchema schema;
    private List workList;

    public CSVRecordReader() {
    }

    public CSVRecordReader(Reader reader) {
        super(reader);
    }

    public CSVRecordReader(Reader reader, RecordSchema schema) {
        super(reader);
        this.setRecordSchema(schema);
    }

    public CSVRecordReader(int size) {
        super(size);
    }

    public CSVRecordReader(Reader reader, int size) {
        super(reader, size);
    }

    public CSVRecordReader(Reader reader, RecordSchema schema, int size) {
        super(reader, size);
        this.setRecordSchema(schema);
    }

    public void setRecordSchema(RecordSchema schema) {
        this.schema = schema;
        this.workList = new ArrayList(schema.getPropertySize());
    }

    public RecordSchema getRecordSchema() {
        return this.schema;
    }

    public Record readRecord() throws IOException, PropertySetException {
        return this.readRecord(null);
    }

    public Record readRecord(Record record) throws IOException, PropertySetException {
        List csv;
        if (this.workList == null) {
            this.workList = new ArrayList();
        }
        if ((csv = this.readCSVLineList(this.workList)) == null) {
            return null;
        }
        if (record == null) {
            record = new Record(this.getRecordSchema());
        } else {
            record.clear();
        }
        int imax = Math.min(csv.size(), record.size());
        for (int i = 0; i < imax; ++i) {
            String element = (String)csv.get(i);
            record.setParseProperty(i, (Object)element);
        }
        return record;
    }

    @Override
    public CSVReader cloneReader() {
        return this.cloneReader(new CSVRecordReader());
    }

    @Override
    protected CSVReader cloneReader(CSVReader clone) {
        super.cloneReader(clone);
        ((CSVRecordReader)clone).schema = this.schema;
        return clone;
    }
}

