/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ClusterConnectionFactoryService;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCommunicateException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageSendException;

public class ClusterClientConnectionImpl
implements ClientConnection,
ClusterListener,
MessageListener,
Serializable {
    private static final long serialVersionUID = 4277728721026624133L;
    private transient Object uid;
    private transient ClusterService cluster;
    private String connectErrorMessageId;
    private String reconnectMessageId;
    private String noConnectErrorMessageId;
    private long failoverBufferTime;
    private transient boolean isConnected;
    private transient boolean isConnecting;
    private transient List members;
    private transient Map connectionMap;
    private transient Map subjects;
    private transient MessageListener messageListener;
    private transient Object id;
    private transient String serviceManagerName;
    private boolean isDistribute;
    private boolean isMultiple;
    private boolean isReceiveOwnMessage;
    private boolean isFlexibleConnect;
    private transient Object currentUID;
    private transient boolean isStartReceive;
    private transient long fromTime;
    private transient Message latestMessage;

    public ClusterClientConnectionImpl(ClusterService cluster) {
        this.setCluster(cluster);
    }

    public void setCluster(ClusterService cluster) {
        this.cluster = cluster;
        this.uid = this.cluster == null ? null : this.cluster.getUID();
    }

    public void setConnectErrorMessageId(String id) {
        this.connectErrorMessageId = id;
    }

    public void setReconnectMessageId(String id) {
        this.reconnectMessageId = id;
    }

    public void setNoConnectErrorMessageId(String id) {
        this.noConnectErrorMessageId = id;
    }

    @Override
    public void setServiceManagerName(String name) {
        this.serviceManagerName = name;
    }

    public void setDistribute(boolean isDistribute) {
        this.isDistribute = isDistribute;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public void setFailoverBufferTime(long time) {
        this.failoverBufferTime = time;
    }

    public void setReceiveOwnMessage(boolean isReceive) {
        this.isReceiveOwnMessage = isReceive;
    }

    public void setFlexibleConnect(boolean isFlexible) {
        this.isFlexibleConnect = isFlexible;
    }

    @Override
    public synchronized void connect() throws ConnectException {
        this.connect((Object)null);
    }

    @Override
    public synchronized void connect(Object id) throws ConnectException {
        if (this.isConnected) {
            return;
        }
        this.isConnecting = true;
        try {
            if (this.cluster.getState() != 3) {
                try {
                    this.cluster.create();
                    this.cluster.setClient(true);
                    this.cluster.addClusterListener(this);
                    this.cluster.start();
                    this.id = id == null ? this.cluster.getUID() : id;
                    this.cluster.join();
                }
                catch (Exception e) {
                    this.cluster.stop();
                    this.cluster.destroy();
                    throw new ConnectException(e);
                }
            } else {
                this.id = id == null ? this.cluster.getUID() : id;
                this.cluster.addClusterListener(this);
            }
            if (!(this.isFlexibleConnect || this.connectionMap != null && this.connectionMap.size() != 0)) {
                throw new ConnectException("No cluster member.");
            }
            this.isConnected = true;
        }
        finally {
            this.isConnecting = false;
        }
    }

    public List getClusterMembers() {
        return this.members;
    }

    public ClientConnection getClusterClientConnection(ClusterService.GlobalUID member) {
        if (this.uid != null && this.uid.equals(member)) {
            return this;
        }
        ClusterConnectionFactoryService.ClusterOption clusterOption = (ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get(member);
        return clusterOption == null ? null : clusterOption.clientConnection;
    }

    private void updateConnectionList() {
        List memberList = this.cluster.getMembers();
        ArrayList<ClusterService.GlobalUID> tmpMembers = new ArrayList<ClusterService.GlobalUID>();
        LinkedHashMap<ClusterService.GlobalUID, ClusterConnectionFactoryService.ClusterOption> tmpConnectionMap = new LinkedHashMap<ClusterService.GlobalUID, ClusterConnectionFactoryService.ClusterOption>();
        ClusterService.GlobalUID[] members = memberList.toArray(new ClusterService.GlobalUID[memberList.size()]);
        for (int i = 0; i < members.length; ++i) {
            ClusterConnectionFactoryService.ClusterOption clusterOption = null;
            clusterOption = this.connectionMap != null && this.connectionMap.containsKey(members[i]) ? (ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get(members[i]) : (ClusterConnectionFactoryService.ClusterOption)members[i].getOption();
            if (clusterOption == null) continue;
            if (this.messageListener != null && (this.isReceiveOwnMessage || !this.isReceiveOwnMessage && this.uid != null && !this.uid.equals(members[i]))) {
                clusterOption.clientConnection.setMessageListener(this);
            }
            tmpMembers.add(members[i]);
            if (this.uid == null || this.uid.equals(members[i])) continue;
            tmpConnectionMap.put(members[i], clusterOption);
        }
        this.connectionMap = tmpConnectionMap;
        this.members = tmpMembers;
    }

    @Override
    public synchronized void addSubject(String subject) throws MessageSendException {
        this.addSubject(subject, null);
    }

    @Override
    public synchronized void addSubject(String subject, String[] keys) throws MessageSendException {
        Set<Object> keySet;
        if (!this.isConnected) {
            throw new MessageSendException("Not connected.");
        }
        if (this.subjects == null) {
            this.subjects = Collections.synchronizedMap(new HashMap());
        }
        if ((keySet = (Set<Object>)this.subjects.get(subject)) == null) {
            keySet = Collections.synchronizedSet(new HashSet());
            this.subjects.put(subject, keySet);
        }
        if (keys == null) {
            keySet.add(null);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                keySet.add(keys[i]);
            }
        }
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    connection.addSubject(subject, keys);
                }
            } else if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                connection.addSubject(subject, keys);
            }
        }
    }

    @Override
    public synchronized void removeSubject(String subject) throws MessageSendException {
        this.removeSubject(subject, null);
    }

    @Override
    public synchronized void removeSubject(String subject, String[] keys) throws MessageSendException {
        Set keySet;
        if (!this.isConnected) {
            throw new MessageSendException("Not connected.");
        }
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    connection.removeSubject(subject, keys);
                }
            } else if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                connection.removeSubject(subject, keys);
            }
        }
        if (this.subjects != null && (keySet = (Set)this.subjects.get(subject)) != null) {
            if (keys == null) {
                keySet.remove(null);
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    keySet.remove(keys[i]);
                }
            }
            if (keySet.size() == 0) {
                this.subjects.remove(subject);
            }
        }
    }

    @Override
    public synchronized void startReceive() throws MessageSendException {
        this.startReceive(-1L);
    }

    @Override
    public synchronized void startReceive(long from) throws MessageSendException {
        if (!this.isConnected) {
            throw new MessageSendException("Not connected.");
        }
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    connection.startReceive(from);
                }
            } else if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                connection.startReceive(from);
            }
        }
        this.isStartReceive = true;
        this.fromTime = from;
    }

    @Override
    public boolean isStartReceive() {
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                if (this.connectionMap.size() == 0) {
                    return false;
                }
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    if (connection.isStartReceive()) continue;
                    return false;
                }
                return true;
            }
            if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                return connection.isStartReceive();
            }
        }
        return false;
    }

    @Override
    public synchronized void stopReceive() throws MessageSendException {
        if (!this.isConnected) {
            throw new MessageSendException("Not connected.");
        }
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    connection.stopReceive();
                }
            } else if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                connection.stopReceive();
            }
        }
    }

    @Override
    public Set getSubjects() {
        HashSet result = new HashSet();
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                Iterator connections = this.connectionMap.values().iterator();
                if (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    result.addAll(connection.getSubjects());
                }
            } else if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                result.addAll(connection.getSubjects());
            }
        }
        return result;
    }

    @Override
    public Set getKeys(String subject) {
        HashSet result = new HashSet();
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                Iterator connections = this.connectionMap.values().iterator();
                if (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    result.addAll(connection.getKeys(subject));
                }
            } else if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                result.addAll(connection.getKeys(subject));
            }
        }
        return result;
    }

    @Override
    public synchronized void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    connection.setMessageListener(this);
                }
            } else if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                connection.setMessageListener(this);
            }
        }
    }

    @Override
    public synchronized boolean isConnected() {
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                if (this.connectionMap.size() == 0) {
                    return false;
                }
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    if (connection.isConnected()) continue;
                    return false;
                }
                return true;
            }
            if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                return connection.isConnected();
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isServerClosed() {
        if (this.connectionMap != null) {
            if (this.isMultiple) {
                if (this.connectionMap.size() == 0) {
                    return false;
                }
                Iterator connections = this.connectionMap.values().iterator();
                while (connections.hasNext()) {
                    ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                    if (connection.isServerClosed()) continue;
                    return false;
                }
                return true;
            }
            if (this.currentUID != null) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
                return connection.isServerClosed();
            }
        }
        return false;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public synchronized void close() {
        if (!this.isConnected) {
            return;
        }
        this.id = null;
        this.currentUID = null;
        this.cluster.removeClusterListener(this);
        this.cluster.stop();
        if (this.connectionMap != null) {
            ArrayList connections = new ArrayList(this.connectionMap.values());
            int imax = connections.size();
            for (int i = 0; i < imax; ++i) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.get((int)i)).clientConnection;
                connection.close();
            }
            this.connectionMap = null;
        }
        this.isConnected = false;
    }

    @Override
    public void onMessage(Message message) {
        if (this.messageListener != null) {
            this.latestMessage = message;
            this.messageListener.onMessage(message);
        }
    }

    private synchronized boolean connect(ClientConnection connection) throws MessageCommunicateException {
        connection.setServiceManagerName(this.serviceManagerName);
        if (!connection.isConnected()) {
            connection.connect(this.id);
            return true;
        }
        return false;
    }

    private synchronized void addSubject(ClientConnection connection) throws MessageCommunicateException {
        if (this.subjects != null) {
            Object[] subjectArray = this.subjects.keySet().toArray();
            for (int j = 0; j < subjectArray.length; ++j) {
                Object subject = subjectArray[j];
                Set keySet = (Set)this.subjects.get(subject);
                if (keySet == null) continue;
                String[] keys = keySet.toArray(new String[keySet.size()]);
                boolean containsNull = false;
                ArrayList<String> keyList = new ArrayList<String>();
                for (int k = 0; k < keys.length; ++k) {
                    if (keys[k] == null) {
                        containsNull = true;
                        continue;
                    }
                    keyList.add(keys[k]);
                }
                if (containsNull) {
                    connection.addSubject((String)subject);
                    keys = keyList.toArray(new String[keyList.size()]);
                }
                if (keys == null || keys.length == 0) continue;
                connection.addSubject((String)subject, keys);
            }
        }
    }

    private synchronized void startReceive(ClientConnection connection) throws MessageCommunicateException {
        if (this.isStartReceive && !connection.isStartReceive()) {
            if (this.isMultiple) {
                connection.startReceive(-1L);
            } else {
                long time = this.fromTime;
                if (this.latestMessage != null) {
                    time = this.latestMessage.getReceiveTime() - this.failoverBufferTime;
                }
                connection.startReceive(time);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void memberInit(Object myId, List members) {
        this.updateConnectionList();
        Object member = null;
        if (!this.isConnected && !this.isConnecting) {
            return;
        }
        if (this.isMultiple) {
            Iterator connections = this.connectionMap.values().iterator();
            while (connections.hasNext()) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                if (connection.isServerClosed()) continue;
                try {
                    boolean isReconnect = false;
                    if (!connection.isConnected() && this.connect(connection) && this.isConnected) {
                        isReconnect = true;
                    }
                    this.addSubject(connection);
                    this.startReceive(connection);
                    if (!isReconnect || this.reconnectMessageId == null) continue;
                    ServiceManagerFactory.getLogger().write(this.reconnectMessageId, new Object[]{null, connection});
                }
                catch (MessageCommunicateException e) {
                    if (this.connectErrorMessageId == null) continue;
                    ServiceManagerFactory.getLogger().write(this.connectErrorMessageId, new Object[]{connection}, (Throwable)e);
                }
            }
            return;
        }
        if (this.isDistribute) {
            Iterator entries = this.connectionMap.entrySet().iterator();
            int cilentCount = 0;
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (((ClusterConnectionFactoryService.ClusterOption)entry.getValue()).clientConnection.isServerClosed()) continue;
                ClientConnectionFactory factory = ((ClusterConnectionFactoryService.ClusterOption)entry.getValue()).clusterClientConnectionFactory;
                int count = 0;
                try {
                    count = factory.getClientCount();
                }
                catch (RemoteException e) {
                    continue;
                }
                if (member != null && cilentCount <= count) continue;
                cilentCount = count;
                member = entry.getKey();
            }
        } else if (this.connectionMap.size() != 0) {
            for (Map.Entry entry : this.connectionMap.entrySet()) {
                if (((ClusterConnectionFactoryService.ClusterOption)entry.getValue()).clientConnection.isServerClosed()) continue;
                member = entry.getKey();
                break;
            }
        }
        if (member == null) return;
        ClusterConnectionFactoryService.ClusterOption option = (ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get(member);
        ClientConnection connection = option.clientConnection;
        try {
            boolean isReconnect = false;
            if (!connection.isConnected() && this.connect(connection) && this.isConnected) {
                isReconnect = true;
            }
            this.id = connection.getId();
            this.addSubject(connection);
            this.startReceive(connection);
            this.currentUID = member;
            if (!isReconnect || this.reconnectMessageId == null) return;
            ServiceManagerFactory.getLogger().write(this.reconnectMessageId, new Object[]{null, connection});
            return;
        }
        catch (MessageCommunicateException e) {
            if (this.connectErrorMessageId == null) return;
            ServiceManagerFactory.getLogger().write(this.connectErrorMessageId, new Object[]{connection}, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void memberChange(List oldMembers, List newMembers) {
        HashSet removedMembers = new HashSet(oldMembers);
        removedMembers.removeAll(newMembers);
        for (ClusterService.GlobalUID rmMember : removedMembers) {
            ClusterConnectionFactoryService.ClusterOption option = (ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get(rmMember);
            if (option == null) continue;
            option.clientConnection.close();
        }
        if (this.isMultiple) {
            this.updateConnectionList();
            Iterator connections = this.connectionMap.values().iterator();
            while (connections.hasNext()) {
                ClientConnection connection = ((ClusterConnectionFactoryService.ClusterOption)connections.next()).clientConnection;
                if (connection.isServerClosed()) continue;
                try {
                    boolean isReconnect = false;
                    if (!connection.isConnected() && this.connect(connection)) {
                        isReconnect = true;
                    }
                    this.addSubject(connection);
                    this.startReceive(connection);
                    if (!isReconnect || this.reconnectMessageId == null) continue;
                    ServiceManagerFactory.getLogger().write(this.reconnectMessageId, new Object[]{null, connection});
                }
                catch (MessageCommunicateException e) {
                    if (this.connectErrorMessageId == null) continue;
                    ServiceManagerFactory.getLogger().write(this.connectErrorMessageId, new Object[]{connection}, (Throwable)e);
                }
            }
            return;
        }
        ClientConnection currentConnection = null;
        if (this.currentUID != null && this.connectionMap.containsKey(this.currentUID)) {
            currentConnection = ((ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get((Object)this.currentUID)).clientConnection;
        }
        this.updateConnectionList();
        if (this.connectionMap.size() == 0) {
            if ((this.isConnected || this.isConnecting) && this.noConnectErrorMessageId != null) {
                ServiceManagerFactory.getLogger().write(this.noConnectErrorMessageId, new Object[]{this});
            }
            if (currentConnection != null) {
                currentConnection.close();
            }
            this.id = null;
            this.currentUID = null;
            return;
        }
        if (!this.isConnected && !this.isConnecting) {
            return;
        }
        Object member = null;
        if (this.isDistribute) {
            if (this.currentUID == null || !this.connectionMap.containsKey(this.currentUID)) {
                int cilentCount = 0;
                for (Map.Entry entry : this.connectionMap.entrySet()) {
                    if (((ClusterConnectionFactoryService.ClusterOption)entry.getValue()).clientConnection.isServerClosed()) continue;
                    ClientConnectionFactory factory = ((ClusterConnectionFactoryService.ClusterOption)entry.getValue()).clusterClientConnectionFactory;
                    int count = 0;
                    try {
                        count = factory.getClientCount();
                    }
                    catch (RemoteException e) {
                        continue;
                    }
                    if (member != null && cilentCount <= count) continue;
                    cilentCount = count;
                    member = entry.getKey();
                }
            } else if (currentConnection != null && !currentConnection.isConnected()) {
                member = this.currentUID;
            }
        } else {
            Object firstMember = null;
            if (this.connectionMap.size() != 0) {
                for (Map.Entry entry : this.connectionMap.entrySet()) {
                    if (((ClusterConnectionFactoryService.ClusterOption)entry.getValue()).clientConnection.isServerClosed()) continue;
                    firstMember = entry.getKey();
                    break;
                }
            }
            if (this.currentUID == null || !this.currentUID.equals(firstMember)) {
                member = firstMember;
            } else if (currentConnection != null && !currentConnection.isConnected()) {
                member = this.currentUID;
            }
        }
        if (member == null || member.equals(this.currentUID)) return;
        ClusterConnectionFactoryService.ClusterOption option = (ClusterConnectionFactoryService.ClusterOption)this.connectionMap.get(member);
        ClientConnection connection = option.clientConnection;
        String currentConnectionStr = null;
        if (currentConnection != null) {
            currentConnectionStr = currentConnection.toString();
            currentConnection.close();
        }
        try {
            boolean isReconnect = false;
            if (!connection.isConnected() && this.connect(connection)) {
                isReconnect = true;
            }
            this.id = connection.getId();
            this.addSubject(connection);
            this.startReceive(connection);
            this.currentUID = member;
            if (!isReconnect || this.reconnectMessageId == null) return;
            ServiceManagerFactory.getLogger().write(this.reconnectMessageId, new Object[]{currentConnectionStr, connection});
            return;
        }
        catch (MessageCommunicateException e) {
            if (this.connectErrorMessageId == null) return;
            ServiceManagerFactory.getLogger().write(this.connectErrorMessageId, new Object[]{connection}, (Throwable)e);
        }
    }

    @Override
    public void changeMain() throws Exception {
    }

    @Override
    public void changeSub() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(", connectionMap=").append(this.connectionMap);
        buf.append(", subjects=").append(this.subjects);
        buf.append('}');
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.cluster != null ? this.cluster.createClient() : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cluster = (ClusterService)in.readObject();
    }
}

