/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import jp.ossc.nimbus.util.converter.StringConverter;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

public class BASE64StringConverter
extends StringStreamConverter
implements StringConverter,
ReversibleConverter,
Serializable {
    private static final long serialVersionUID = 1193510073044683299L;
    public static final int ENCODE = 1;
    public static final int DECODE = 2;
    public static final int ENCODE_STRING_FROM_STREAM = 3;
    public static final int DECODE_STRING_FROM_STREAM = 4;
    public static final int ENCODE_STREAM_FROM_STRING = 5;
    public static final int DECODE_STREAM_FROM_STRING = 6;
    private int convertType = 1;
    private String characterEncoding;
    private String characterEncodingToStream;
    private String characterEncodingToObject;

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
    }

    @Override
    public int getConvertType() {
        return this.convertType;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    @Override
    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    @Override
    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    @Override
    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: 
            case 2: {
                return this.convert(obj.toString());
            }
            case 3: 
            case 4: {
                return this.convertToStream(obj);
            }
            case 5: 
            case 6: {
                return this.convertToObject((InputStream)obj);
            }
        }
        throw new ConvertException("Illegal convert type : " + this.convertType);
    }

    @Override
    public String convert(String str) throws ConvertException {
        if (str == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.encode(str);
            }
            case 2: {
                return this.decode(str);
            }
        }
        throw new ConvertException("Illegal convert type : " + this.convertType);
    }

    @Override
    protected byte[] convertToByteArray(Object obj) throws ConvertException {
        switch (this.convertType) {
            case 1: 
            case 3: {
                return BASE64StringConverter.encodeBytes(super.convertToByteArray(obj));
            }
            case 2: 
            case 4: {
                return BASE64StringConverter.decodeBytes(super.convertToByteArray(obj));
            }
        }
        throw new ConvertException("Illegal convert type : " + this.convertType);
    }

    @Override
    public Object convertToObject(InputStream is) throws ConvertException {
        byte[] bytes = this.toBytes(is);
        switch (this.convertType) {
            case 1: 
            case 5: {
                return this.toString(BASE64StringConverter.encodeBytes(bytes));
            }
            case 2: 
            case 6: {
                return this.toString(BASE64StringConverter.decodeBytes(bytes));
            }
        }
        throw new ConvertException("Illegal convert type : " + this.convertType);
    }

    public String encode(String str) throws ConvertException {
        return BASE64StringConverter.encode(str, this.characterEncoding);
    }

    public static String encode(String str, String encoding) throws ConvertException {
        byte[] bytes = null;
        if (encoding == null) {
            bytes = str.getBytes();
        } else {
            try {
                bytes = str.getBytes(encoding);
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
        }
        return new String(BASE64StringConverter.encodeBytes(bytes));
    }

    public static byte[] encodeBytes(byte[] bytes) throws ConvertException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = null;
        try {
            os = MimeUtility.encode((OutputStream)baos, (String)"base64");
            os.write(bytes);
        }
        catch (MessagingException e) {
            throw new ConvertException(e);
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    public String decode(String str) throws ConvertException {
        return BASE64StringConverter.decode(str, this.characterEncoding);
    }

    public static String decode(String str, String encoding) throws ConvertException {
        byte[] bytes = BASE64StringConverter.decodeBytes(str.getBytes());
        if (encoding == null) {
            return new String(bytes);
        }
        try {
            return new String(bytes, encoding);
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    public static byte[] decodeBytes(byte[] bytes) throws ConvertException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        byte[] outBytes = null;
        InputStream is = null;
        try {
            is = MimeUtility.decode((InputStream)bais, (String)"base64");
            byte[] tmpBytes = new byte[bytes.length];
            int length = is.read(tmpBytes);
            outBytes = new byte[length];
            System.arraycopy(tmpBytes, 0, outBytes, 0, length);
        }
        catch (MessagingException e) {
            throw new ConvertException(e);
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return outBytes;
    }
}

