/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullKeyPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class MappedProperty
extends SimpleProperty
implements Serializable {
    private static final long serialVersionUID = 8407662267357861189L;
    private static final String RECORD_PROP_NAME = "Property";
    protected static final String GET_METHOD_NAME = "get";
    protected static final String IS_METHOD_NAME = "is";
    protected static final Class[] GET_METHOD_ARGS = new Class[]{String.class};
    protected static final String SET_METHOD_NAME = "set";
    protected String key;
    protected transient Map mappedReadMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map mappedWriteMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map mappedObjReadMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map mappedObjWriteMethodCache = Collections.synchronizedMap(new HashMap());

    public MappedProperty() {
    }

    public MappedProperty(String name) throws IllegalArgumentException {
        super(name);
    }

    public MappedProperty(String name, String key) throws IllegalArgumentException {
        super(name);
        this.key = key;
    }

    public String getPropertyName() {
        return (super.getPropertyName() == null ? "" : super.getPropertyName()) + '(' + this.key + ')';
    }

    protected void setPropertyName(String prop) {
        this.property = prop;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int startMappedDelim = prop.indexOf(40);
        int endMappedDelim = prop.indexOf(41);
        if (startMappedDelim == -1 || endMappedDelim == -1 || endMappedDelim - startMappedDelim < 1 || endMappedDelim != prop.length() - 1) {
            throw new IllegalArgumentException("Illegal MappedProperty : " + prop);
        }
        this.key = prop.substring(startMappedDelim + 1, endMappedDelim);
        this.setPropertyName(prop.substring(0, startMappedDelim));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        return this.getMappedPropertyType(obj);
    }

    public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
        return this.getMappedPropertyType(clazz);
    }

    protected Class getMappedPropertyType(Object obj) throws NoSuchPropertyException {
        if (obj instanceof Record && this.getKey() != null) {
            boolean isGet;
            boolean isGetProperty = RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName());
            boolean bl = isGet = super.getPropertyName() == null || super.getPropertyName().length() == 0;
            if (isGetProperty || isGet) {
                Class type;
                PropertySchema propSchema;
                Record record = (Record)obj;
                RecordSchema recSchema = record.getRecordSchema();
                if (recSchema != null && (propSchema = recSchema.getPropertySchema(this.getKey())) != null && (type = propSchema.getType()) != null) {
                    return type;
                }
                throw new NoSuchPropertyException(obj.getClass(), this.getPropertyName());
            }
        }
        return this.getMappedPropertyType(obj.getClass());
    }

    protected Class getMappedPropertyType(Class clazz) throws NoSuchPropertyException {
        Method readMethod = null;
        if (this.property == null || this.property.length() == 0) {
            return this.getMappedObjectPropertyType(clazz);
        }
        readMethod = this.getReadMappedMethod(clazz);
        if (readMethod == null) {
            Method setMethod = this.getWriteMappedMethod(clazz, null);
            if (setMethod != null) {
                Map overloadMap;
                Object methodObj;
                if (this.mappedWriteMethodCache.containsKey(clazz) && !((methodObj = this.mappedWriteMethodCache.get(clazz)) instanceof Method) && ((overloadMap = (Map)methodObj).size() > 2 || overloadMap.size() == 2 && !overloadMap.containsKey(null))) {
                    return null;
                }
                return setMethod.getParameterTypes()[1];
            }
            Class retClass = null;
            try {
                retClass = super.getPropertyType(clazz);
            }
            catch (NoSuchPropertyException e) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            return this.getMappedObjectPropertyType(retClass);
        }
        return readMethod.getReturnType();
    }

    public boolean isReadable(Object obj) {
        if (obj instanceof Record && this.getKey() != null) {
            boolean isGet;
            boolean isGetProperty = RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName());
            boolean bl = isGet = super.getPropertyName() == null || super.getPropertyName().length() == 0;
            if (isGetProperty || isGet) {
                Record record = (Record)obj;
                RecordSchema recSchema = record.getRecordSchema();
                if (recSchema == null) {
                    return false;
                }
                PropertySchema propSchema = recSchema.getPropertySchema(this.getKey());
                return propSchema != null;
            }
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.isReadableNoMappedProperty(obj, readMethod);
        }
        if (this.mappedReadMethodCache.get(clazz) != null) {
            return true;
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isReadableMappedObjectProperty(clazz, obj);
        }
        readMethod = this.getReadMappedMethod(clazz);
        if (readMethod != null) {
            return true;
        }
        Object prop = null;
        try {
            prop = super.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (prop == null) {
            return false;
        }
        return this.isReadableMappedObjectProperty(prop.getClass(), prop);
    }

    public boolean isReadable(Class clazz) {
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.isReadableNoMappedProperty(readMethod);
        }
        if (this.mappedReadMethodCache.get(clazz) != null) {
            return true;
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isReadableMappedObjectProperty(clazz);
        }
        readMethod = this.getReadMappedMethod(clazz);
        if (readMethod != null) {
            return true;
        }
        try {
            readMethod = super.getReadMethod(clazz, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (readMethod != null) {
            return this.isReadableMappedObjectProperty(readMethod.getReturnType());
        }
        Field field = null;
        try {
            field = super.getField(clazz, false);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (field == null) {
            return false;
        }
        return this.isReadableMappedObjectProperty(field.getType());
    }

    public boolean isWritable(Object obj, Class clazz) {
        if (obj instanceof Record && this.getKey() != null) {
            boolean isGet;
            boolean isGetProperty = RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName());
            boolean bl = isGet = super.getPropertyName() == null || super.getPropertyName().length() == 0;
            if (isGetProperty || isGet) {
                Record record = (Record)obj;
                RecordSchema recSchema = record.getRecordSchema();
                if (recSchema == null) {
                    return false;
                }
                PropertySchema propSchema = recSchema.getPropertySchema(this.getKey());
                if (propSchema == null) {
                    return false;
                }
                if (clazz == null) {
                    return true;
                }
                return propSchema.getType() == null ? true : this.isAssignableFrom(propSchema.getType(), clazz);
            }
        }
        Class<?> objClazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(objClazz) && this.getMethodCache.get(objClazz) != null) {
            readMethod = (Method)this.getMethodCache.get(objClazz);
            return this.isWritableNoMappedProperty(obj, readMethod, clazz);
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isWritableMappedObjectProperty(obj, clazz);
        }
        writeMethod = this.getWriteMappedMethod(objClazz, clazz);
        if (writeMethod != null) {
            return true;
        }
        Object prop = null;
        try {
            prop = super.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (prop == null) {
            return false;
        }
        return this.isWritableMappedObjectProperty(obj, clazz);
    }

    public boolean isWritable(Class targetClass, Class clazz) {
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(targetClass) && this.getMethodCache.get(targetClass) != null) {
            readMethod = (Method)this.getMethodCache.get(targetClass);
            return this.isWritableMappedObjectProperty(readMethod.getReturnType(), clazz);
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isWritableMappedObjectProperty(targetClass, clazz);
        }
        writeMethod = this.getWriteMappedMethod(targetClass, clazz);
        if (writeMethod != null) {
            return true;
        }
        try {
            readMethod = super.getReadMethod(targetClass, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (readMethod != null) {
            return this.isWritableMappedObjectProperty(readMethod.getReturnType(), clazz);
        }
        Field field = null;
        try {
            field = super.getField(targetClass, false);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (field == null) {
            return false;
        }
        return this.isWritableMappedObjectProperty(field.getType(), clazz);
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (obj == null && this.isIgnoreNullProperty) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.getNoMappedProperty(obj, readMethod);
        }
        if (this.mappedReadMethodCache.get(clazz) != null) {
            readMethod = (Method)this.mappedReadMethodCache.get(clazz);
            return this.getMappedProperty(obj, readMethod);
        }
        if (this.property == null || this.property.length() == 0) {
            return this.getMappedObjectProperty(clazz, obj);
        }
        readMethod = this.getReadMappedMethod(clazz);
        if (readMethod != null) {
            return this.getMappedProperty(obj, readMethod);
        }
        Object prop = super.getProperty(obj);
        if (prop == null) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName());
        }
        return this.getMappedObjectProperty(prop.getClass(), prop);
    }

    protected Method getReadMappedMethod(Class clazz) {
        if (this.mappedReadMethodCache.containsKey(clazz)) {
            return (Method)this.mappedReadMethodCache.get(clazz);
        }
        if (!MappedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getReadMappedMethod(interfaces[i]);
                if (method == null) continue;
                this.mappedReadMethodCache.put(clazz, method);
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getReadMappedMethod(superClass);
            }
            this.mappedReadMethodCache.put(clazz, null);
            return null;
        }
        StringBuffer methodName = new StringBuffer(GET_METHOD_NAME);
        if (this.property != null && this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        try {
            Method method = clazz.getMethod(methodName.toString(), GET_METHOD_ARGS);
            this.mappedReadMethodCache.put(clazz, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            if (this.property == null || this.property.length() == 0) {
                this.mappedReadMethodCache.put(clazz, null);
                return null;
            }
            try {
                Method method = clazz.getMethod(this.property, GET_METHOD_ARGS);
                this.mappedReadMethodCache.put(clazz, method);
                return method;
            }
            catch (NoSuchMethodException e2) {
                this.mappedReadMethodCache.put(clazz, null);
                return null;
            }
        }
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        this.setProperty(obj, value == null ? null : value.getClass(), value);
    }

    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            this.setNoMappedProperty(obj, readMethod, value);
        } else if (this.property == null || this.property.length() == 0) {
            this.setMappedObjectProperty(clazz, obj, value);
        } else {
            if (obj instanceof Record && this.getKey() != null) {
                Record record;
                RecordSchema recSchema;
                boolean isGet;
                boolean isGetProperty = RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName());
                boolean bl = isGet = super.getPropertyName() == null || super.getPropertyName().length() == 0;
                if ((isGetProperty || isGet) && (recSchema = (record = (Record)obj).getRecordSchema()) != null) {
                    PropertySchema propSchema = recSchema.getPropertySchema(this.getKey());
                    if (propSchema == null) {
                        throw new NoSuchPropertyException(clazz, this.getPropertyName());
                    }
                    try {
                        record.setProperty(this.getKey(), value);
                    }
                    catch (PropertySetException e) {
                        throw new InvocationTargetException(e);
                    }
                    return;
                }
            }
            if (type == null && value != null) {
                type = value.getClass();
            }
            if ((writeMethod = this.getWriteMappedMethod(clazz, type)) != null) {
                this.setMappedProperty(obj, writeMethod, value);
                return;
            }
            Object prop = super.getProperty(obj);
            if (prop == null) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            this.setMappedObjectProperty(prop.getClass(), prop, value);
        }
    }

    protected Method getWriteMappedMethod(Class clazz, Class param) {
        if (this.mappedWriteMethodCache.containsKey(clazz)) {
            Object methodObj = this.mappedWriteMethodCache.get(clazz);
            if (methodObj instanceof Method) {
                return (Method)methodObj;
            }
            Map overloadMap = (Map)methodObj;
            if (param == null) {
                if (overloadMap.size() == 1) {
                    return (Method)overloadMap.values().iterator().next();
                }
                Method setMethod = (Method)overloadMap.get(null);
                if (setMethod != null) {
                    return setMethod;
                }
                Object[] classes = overloadMap.keySet().toArray();
                for (int i = 0; i < classes.length; ++i) {
                    Object key = classes[i];
                    Method method = (Method)overloadMap.get(key);
                    Class<?>[] params = method.getParameterTypes();
                    if (setMethod == null) {
                        if (params[1].isPrimitive()) continue;
                        setMethod = method;
                        continue;
                    }
                    if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                    setMethod = method;
                }
                Map<Object, Method> tmpOverloadMap = Collections.synchronizedMap(new HashMap(overloadMap));
                tmpOverloadMap.put(null, setMethod);
                this.mappedWriteMethodCache.put(clazz, tmpOverloadMap);
                return setMethod;
            }
            if (overloadMap.containsKey(param)) {
                return (Method)overloadMap.get(param);
            }
            Method setMethod = (Method)overloadMap.get(null);
            if (setMethod != null) {
                return setMethod;
            }
            Object[] classes = overloadMap.keySet().toArray();
            Class primitiveClazz = this.toPrimitive(param);
            for (int i = 0; i < classes.length; ++i) {
                Object key = classes[i];
                Method method = (Method)overloadMap.get(key);
                Class<?>[] params = method.getParameterTypes();
                if (setMethod == null) {
                    if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                    setMethod = method;
                    if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                    break;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                    setMethod = method;
                    break;
                }
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            Map<Class, Method> tmpOverloadMap = Collections.synchronizedMap(new HashMap(overloadMap));
            tmpOverloadMap.put(param, setMethod);
            this.mappedWriteMethodCache.put(clazz, tmpOverloadMap);
            return setMethod;
        }
        if (!MappedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getWriteMappedMethod(interfaces[i], param);
                if (method == null) continue;
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getWriteMappedMethod(superClass, param);
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(SET_METHOD_NAME);
        if (this.property != null && this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        Method setMethod = null;
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return null;
        }
        Class primitiveClazz = this.toPrimitive(param);
        Map<Class<?>, Method> overloadMap = Collections.synchronizedMap(new HashMap());
        boolean isMatch = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method method = methods[i];
            if (!methodName.toString().equals(method.getName()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String)) continue;
            overloadMap.put(params[1], method);
            if (isMatch) continue;
            if (setMethod == null) {
                if (param == null) {
                    setMethod = method;
                    continue;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                setMethod = method;
                if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                isMatch = true;
                continue;
            }
            if (param == null) {
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
            if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                isMatch = true;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
            setMethod = method;
        }
        if (param == null) {
            overloadMap.put(null, setMethod);
        }
        if (setMethod != null) {
            if (overloadMap.size() > 1) {
                this.mappedWriteMethodCache.put(clazz, overloadMap);
            } else {
                this.mappedWriteMethodCache.put(clazz, setMethod);
            }
        }
        return setMethod;
    }

    protected Object getMappedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            return readMethod.invoke(obj, this.getKey());
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
    }

    protected void setMappedProperty(Object obj, Method writeMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            Class<?> paramType = writeMethod.getParameterTypes()[1];
            if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                value = this.castPrimitiveWrapper(paramType, (Number)value);
            }
            writeMethod.invoke(obj, this.getKey(), value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
    }

    protected Object getMappedObject(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        return this.getMappedObject(obj, readMethod, true);
    }

    protected Object getMappedObject(Object obj, Method readMethod, boolean isThrow) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            if (readMethod.getParameterTypes().length == 0) {
                return readMethod.invoke(obj, NULL_ARGS);
            }
            return readMethod.invoke(obj, super.getPropertyName());
        }
        catch (IllegalAccessException e) {
            if (isThrow) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (isThrow) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
            }
            return null;
        }
    }

    protected Object getNoMappedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object mappedObj = this.getMappedObject(obj, readMethod);
        if (mappedObj == null) {
            if (this.isIgnoreNullProperty) {
                return null;
            }
            throw new NullKeyPropertyException(clazz, this.getPropertyName());
        }
        return this.getMappedObjectProperty(mappedObj.getClass(), mappedObj);
    }

    protected void setNoMappedProperty(Object obj, Method readMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object mappedObj = this.getMappedObject(obj, readMethod);
        if (mappedObj == null) {
            throw new NullKeyPropertyException(clazz, this.getPropertyName());
        }
        this.setMappedObjectProperty(mappedObj.getClass(), mappedObj, value);
    }

    protected boolean isReadableNoMappedProperty(Object obj, Method readMethod) {
        Object mappedObj = null;
        try {
            mappedObj = this.getMappedObject(obj, readMethod, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (mappedObj == null) {
            return false;
        }
        return this.isReadableMappedObjectProperty(mappedObj.getClass(), mappedObj);
    }

    protected boolean isReadableNoMappedProperty(Method readMethod) {
        Class<?> mappedClass = readMethod.getReturnType();
        if (mappedClass == null) {
            return false;
        }
        return this.isReadableMappedObjectProperty(mappedClass);
    }

    protected boolean isReadableMappedObjectProperty(Class clazz, Object obj) {
        Map map;
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.getKey())) != null) {
            return true;
        }
        if (obj instanceof Map && (map = (Map)obj).containsKey(this.getKey())) {
            return true;
        }
        Method getMethod = null;
        if (this.mappedObjReadMethodCache.containsKey(clazz) && (getMethod = (Method)this.mappedObjReadMethodCache.get(clazz)) == null) {
            return false;
        }
        if (getMethod == null) {
            if (!MappedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                    return this.isReadableMappedObjectProperty(interfaces[i], obj);
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.isReadableMappedObjectProperty(superClass, obj);
                }
                return false;
            }
            try {
                getMethod = clazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (Modifier.isPublic(getMethod.getModifiers())) {
                this.mappedObjReadMethodCache.put(clazz, getMethod);
                return true;
            }
            this.mappedObjReadMethodCache.put(clazz, null);
            return false;
        }
        return true;
    }

    protected boolean isReadableMappedObjectProperty(Class clazz) {
        Method getMethod = null;
        if (this.mappedObjReadMethodCache.containsKey(clazz) && (getMethod = (Method)this.mappedObjReadMethodCache.get(clazz)) == null) {
            return Map.class.isAssignableFrom(clazz);
        }
        if (getMethod == null) {
            if (!MappedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!MappedProperty.isAccessableClass(interfaces[i]) || !this.isReadableMappedObjectProperty(interfaces[i])) continue;
                    return true;
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.isReadableMappedObjectProperty(superClass) ? true : Map.class.isAssignableFrom(clazz);
                }
                return Map.class.isAssignableFrom(clazz);
            }
            try {
                getMethod = clazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e) {
                return Map.class.isAssignableFrom(clazz);
            }
            if (Modifier.isPublic(getMethod.getModifiers())) {
                this.mappedObjReadMethodCache.put(clazz, getMethod);
                return true;
            }
            this.mappedObjReadMethodCache.put(clazz, null);
            return Map.class.isAssignableFrom(clazz);
        }
        return true;
    }

    protected boolean isWritableNoMappedProperty(Object obj, Method readMethod, Class clazz) {
        Object mappedObj = null;
        try {
            mappedObj = this.getMappedObject(obj, readMethod, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (mappedObj == null) {
            return false;
        }
        return this.isWritableMappedObjectProperty(mappedObj, clazz);
    }

    protected boolean isWritableMappedObjectProperty(Object obj, Class clazz) {
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        Class<?> mappedClazz = obj.getClass();
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.getKey())) != null && (clazz == null || propSchema.getType() == null || this.isAssignableFrom(propSchema.getType(), clazz))) {
            return true;
        }
        if (obj instanceof Map) {
            return true;
        }
        Method setMethod = null;
        if (this.mappedObjWriteMethodCache.containsKey(mappedClazz)) {
            setMethod = (Method)this.mappedObjWriteMethodCache.get(mappedClazz);
            if (setMethod == null) {
                return false;
            }
        } else {
            Method[] methods = mappedClazz.getMethods();
            if (methods == null || methods.length == 0) {
                this.mappedObjWriteMethodCache.put(mappedClazz, null);
                return false;
            }
            Class valueClass = clazz == null ? null : clazz;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] params;
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                this.mappedObjWriteMethodCache.put(mappedClazz, null);
                return false;
            }
            this.mappedObjWriteMethodCache.put(mappedClazz, setMethod);
        }
        return true;
    }

    protected boolean isWritableMappedObjectProperty(Class mappedClazz, Class clazz) {
        Method setMethod = null;
        if (this.mappedObjWriteMethodCache.containsKey(mappedClazz)) {
            setMethod = (Method)this.mappedObjWriteMethodCache.get(mappedClazz);
            if (setMethod == null) {
                return Map.class.isAssignableFrom(mappedClazz);
            }
        } else {
            Method[] methods = mappedClazz.getMethods();
            if (methods == null || methods.length == 0) {
                this.mappedObjWriteMethodCache.put(mappedClazz, null);
                return Map.class.isAssignableFrom(mappedClazz);
            }
            Class valueClass = clazz == null ? null : clazz;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] params;
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                this.mappedObjWriteMethodCache.put(mappedClazz, null);
                return Map.class.isAssignableFrom(mappedClazz);
            }
            this.mappedObjWriteMethodCache.put(mappedClazz, setMethod);
        }
        return true;
    }

    protected Object getMappedObjectProperty(Class clazz, Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Map map;
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.getKey())) != null) {
            return record.getProperty(this.getKey());
        }
        Method getMethod = null;
        if (this.mappedObjReadMethodCache.containsKey(clazz)) {
            getMethod = (Method)this.mappedObjReadMethodCache.get(clazz);
            if (getMethod == null) {
                if (obj instanceof Map) {
                    map = (Map)obj;
                    return map.get(this.getKey());
                }
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
        } else {
            if (!MappedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                    try {
                        return this.getMappedObjectProperty(interfaces[i], obj);
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.getMappedObjectProperty(superClass, obj);
                }
                this.mappedObjReadMethodCache.put(clazz, null);
                if (obj instanceof Map) {
                    Map map2 = (Map)obj;
                    return map2.get(this.getKey());
                }
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            try {
                getMethod = clazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e) {
                if (obj instanceof Map) {
                    Map map3 = (Map)obj;
                    return map3.get(this.getKey());
                }
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            if (Modifier.isPublic(getMethod.getModifiers())) {
                this.mappedObjReadMethodCache.put(clazz, getMethod);
            } else {
                this.mappedObjReadMethodCache.put(clazz, null);
                if (obj instanceof Map) {
                    map = (Map)obj;
                    return map.get(this.getKey());
                }
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
        }
        try {
            return getMethod.invoke(obj, this.getKey());
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
    }

    protected Class getMappedObjectPropertyType(Class mappedClazz) throws NoSuchPropertyException {
        return this.getMappedObjectPropertyType(mappedClazz, true);
    }

    protected Class getMappedObjectPropertyType(Class mappedClazz, boolean isThrow) throws NoSuchPropertyException {
        try {
            Method getMethod = null;
            if (this.mappedObjReadMethodCache.containsKey(mappedClazz)) {
                getMethod = (Method)this.mappedObjReadMethodCache.get(mappedClazz);
                if (getMethod == null) {
                    if (Map.class.isAssignableFrom(mappedClazz)) {
                        return Object.class;
                    }
                    if (isThrow) {
                        throw new NoSuchPropertyException(mappedClazz, this.getPropertyName());
                    }
                    return null;
                }
            } else {
                getMethod = mappedClazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
                if (!Modifier.isPublic(getMethod.getModifiers())) {
                    this.mappedObjReadMethodCache.put(mappedClazz, null);
                    if (Map.class.isAssignableFrom(mappedClazz)) {
                        return Object.class;
                    }
                    if (isThrow) {
                        throw new NoSuchPropertyException(mappedClazz, this.getPropertyName());
                    }
                    return null;
                }
                this.mappedObjReadMethodCache.put(mappedClazz, getMethod);
            }
            return getMethod.getReturnType();
        }
        catch (NoSuchMethodException e) {
            Method setMethod = null;
            if (this.mappedObjWriteMethodCache.containsKey(mappedClazz)) {
                setMethod = (Method)this.mappedObjWriteMethodCache.get(mappedClazz);
                if (setMethod == null) {
                    if (Map.class.isAssignableFrom(mappedClazz)) {
                        return Object.class;
                    }
                    if (isThrow) {
                        throw new NoSuchPropertyException(mappedClazz, this.getPropertyName());
                    }
                    return null;
                }
            } else {
                Method[] methods = mappedClazz.getMethods();
                if (methods == null || methods.length == 0) {
                    this.mappedObjWriteMethodCache.put(mappedClazz, null);
                    if (Map.class.isAssignableFrom(mappedClazz)) {
                        return Object.class;
                    }
                    if (isThrow) {
                        throw new NoSuchPropertyException(mappedClazz, this.getPropertyName());
                    }
                    return null;
                }
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] params;
                    Method method = methods[i];
                    if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String)) continue;
                    if (setMethod == null) {
                        setMethod = method;
                        continue;
                    }
                    this.mappedObjWriteMethodCache.put(mappedClazz, null);
                    if (Map.class.isAssignableFrom(mappedClazz)) {
                        return Object.class;
                    }
                    if (isThrow) {
                        throw new NoSuchPropertyException(mappedClazz, this.getPropertyName());
                    }
                    return null;
                }
                if (setMethod == null) {
                    this.mappedObjWriteMethodCache.put(mappedClazz, null);
                    if (Map.class.isAssignableFrom(mappedClazz)) {
                        return Object.class;
                    }
                    if (isThrow) {
                        throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
                    }
                    return null;
                }
                this.mappedObjWriteMethodCache.put(mappedClazz, setMethod);
            }
            return setMethod.getParameterTypes()[1];
        }
    }

    protected void setMappedObjectProperty(Class clazz, Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.getKey())) != null) {
            record.setProperty(this.getKey(), value);
            return;
        }
        Method setMethod = null;
        if (this.mappedObjWriteMethodCache.containsKey(clazz)) {
            setMethod = (Method)this.mappedObjWriteMethodCache.get(clazz);
            if (setMethod == null) {
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    map.put(this.key, value);
                    return;
                }
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
        } else {
            if (!MappedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                    try {
                        this.setMappedObjectProperty(interfaces[i], obj, value);
                        return;
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    this.setMappedObjectProperty(superClass, obj, value);
                    return;
                }
                this.mappedObjWriteMethodCache.put(clazz, null);
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            Class<?> valueClass = value == null ? null : value.getClass();
            Method[] methods = clazz.getMethods();
            if (methods == null || methods.length == 0) {
                this.mappedObjWriteMethodCache.put(clazz, null);
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] params;
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                this.mappedObjWriteMethodCache.put(clazz, null);
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    map.put(this.getKey(), value);
                    return;
                }
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
        }
        this.mappedObjWriteMethodCache.put(clazz, setMethod);
        try {
            setMethod.invoke(obj, this.getKey(), value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
    }

    public static MappedProperty[] getMappedProperties(Object bean) {
        return MappedProperty.getMappedProperties(bean.getClass());
    }

    public static MappedProperty[] getMappedProperties(Class clazz) {
        Set props = new HashSet();
        if (MappedProperty.isAccessableClass(clazz)) {
            props = MappedProperty.getMappedProperties(clazz, null, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                props = MappedProperty.getMappedProperties(interfaces[i], null, props);
                break;
            }
        }
        Object[] result = props.toArray(new MappedProperty[props.size()]);
        Arrays.sort(result);
        return result;
    }

    private static Set getMappedProperties(Class clazz, String prop, Set props) {
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return props;
        }
        String getMethodName = null;
        String setMethodName = null;
        String isMethodName = null;
        if (prop != null) {
            StringBuffer methodName = new StringBuffer();
            if (prop.length() != 0) {
                char capital = prop.charAt(0);
                if (Character.isUpperCase(capital)) {
                    methodName.append(prop);
                } else {
                    capital = Character.toUpperCase(capital);
                    methodName.append(capital);
                    if (prop.length() > 1) {
                        methodName.append(prop.substring(1));
                    }
                }
            }
            getMethodName = methodName.insert(0, GET_METHOD_NAME).toString();
            methodName.delete(0, GET_METHOD_NAME.length());
            setMethodName = methodName.insert(0, SET_METHOD_NAME).toString();
            methodName.delete(0, SET_METHOD_NAME.length());
            isMethodName = methodName.insert(0, IS_METHOD_NAME).toString();
        }
        for (int i = 0; i < methods.length; ++i) {
            Class<?> retType;
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (getMethodName != null && getMethodName.equals(method.getName()) || getMethodName == null && method.getName().startsWith(GET_METHOD_NAME)) {
                retType = method.getReturnType();
                if (Void.TYPE.equals(retType)) continue;
                if (params == null || params.length == 0) {
                    if ((class$java$util$Map == null ? MappedProperty.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(retType)) {
                        props.add(new MappedProperty(method.getName().substring(3)));
                        continue;
                    }
                    try {
                        retType.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
                        props.add(new MappedProperty(method.getName().substring(3)));
                    }
                    catch (NoSuchMethodException e) {
                        Method[] nestedMethods = retType.getMethods();
                        boolean isFound = false;
                        for (int j = 0; j < nestedMethods.length; ++j) {
                            Class<?>[] nestedParams = nestedMethods[j].getParameterTypes();
                            if (!SET_METHOD_NAME.equals(nestedMethods[j].getName()) || nestedParams.length != 2 || !(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String).equals(nestedParams[0])) continue;
                            isFound = true;
                            break;
                        }
                        if (!isFound) continue;
                        props.add(new MappedProperty(method.getName().substring(3)));
                    }
                    continue;
                }
                if (params.length != 1 || !(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String).equals(params[0])) continue;
                props.add(new MappedProperty(method.getName().substring(3)));
                continue;
            }
            if (isMethodName != null && isMethodName.equals(method.getName()) || isMethodName == null && method.getName().startsWith(IS_METHOD_NAME)) {
                retType = method.getReturnType();
                if (!Boolean.TYPE.equals(retType) || params == null || params.length != 1 || !(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String).equals(params[0])) continue;
                props.add(new MappedProperty(method.getName().substring(2)));
                continue;
            }
            if ((setMethodName == null || !setMethodName.equals(method.getName())) && (setMethodName != null || !method.getName().startsWith(SET_METHOD_NAME)) || params == null || params.length != 2 || !(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String).equals(params[0])) continue;
            props.add(new MappedProperty(method.getName().substring(3)));
        }
        return props;
    }

    public static MappedProperty[] getMappedProperties(Class clazz, String prop) {
        Set props = new HashSet();
        if (MappedProperty.isAccessableClass(clazz)) {
            props = MappedProperty.getMappedProperties(clazz, prop, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                props = MappedProperty.getMappedProperties(interfaces[i], prop, props);
                break;
            }
        }
        Object[] result = props.toArray(new MappedProperty[props.size()]);
        Arrays.sort(result);
        return result;
    }

    public String toString() {
        return "MappedProperty{" + this.property + '(' + this.getKey() + ")}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappedProperty)) {
            return false;
        }
        MappedProperty comp = (MappedProperty)obj;
        if (this.property == null && comp.property != null || this.property != null && comp.property == null) {
            return false;
        }
        if (this.property != null && comp.property != null && !this.property.equals(comp.property)) {
            return false;
        }
        if (this.key == null && comp.key == null) {
            return true;
        }
        if (this.key == null) {
            return false;
        }
        return this.key.equals(comp.key);
    }

    public int hashCode() {
        return (this.property == null ? 0 : this.property.hashCode()) + (this.key == null ? 0 : this.key.hashCode()) + 1;
    }

    public int compareTo(Object obj) {
        int val;
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof MappedProperty)) {
            return 1;
        }
        MappedProperty comp = (MappedProperty)obj;
        if (this.property == null && comp.property != null) {
            return -1;
        }
        if (this.property != null && comp.property == null) {
            return 1;
        }
        if (this.property != null && comp.property != null && (val = this.property.compareTo(comp.property)) != 0) {
            return val;
        }
        if (this.key == null && comp.key == null) {
            return 0;
        }
        if (this.key == null) {
            return -1;
        }
        return this.key.compareTo(comp.key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = Collections.synchronizedMap(new HashMap());
        this.setMethodCache = Collections.synchronizedMap(new HashMap());
        this.fieldCache = Collections.synchronizedMap(new HashMap());
        this.mappedReadMethodCache = Collections.synchronizedMap(new HashMap());
        this.mappedWriteMethodCache = Collections.synchronizedMap(new HashMap());
        this.mappedObjReadMethodCache = Collections.synchronizedMap(new HashMap());
        this.mappedObjWriteMethodCache = Collections.synchronizedMap(new HashMap());
    }
}

