/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NoSuchReadablePropertyException;
import jp.ossc.nimbus.beans.NoSuchWritablePropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class SimpleProperty
implements Property,
Serializable,
Comparable {
    private static final long serialVersionUID = 5346194284290420718L;
    private static final String MSG_00001 = "Length of property literal must be more than 1.";
    protected static final Object[] NULL_ARGS = new Object[0];
    protected static final Class[] NULL_METHOD_PARAMS = new Class[0];
    protected static final String GET_METHOD_PREFIX = "get";
    protected static final String SET_METHOD_PREFIX = "set";
    protected static final String MAP_GET_METHOD_NAME = "get";
    protected static final Class[] MAP_GET_METHOD_ARGS = new Class[]{Object.class};
    protected static final String MAP_SET_METHOD_NAME = "put";
    protected static final Class[] MAP_SET_METHOD_ARGS = new Class[]{Object.class, Object.class};
    protected static final String ARRAY_LENGTH_METHOD_NAME = "length";
    protected static Method RECORD_GET_PROPERTY_METHOD;
    protected static Method RECORD_SET_PROPERTY_METHOD;
    protected String property;
    protected transient Map getMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map setMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map fieldCache = Collections.synchronizedMap(new HashMap());
    protected boolean isIgnoreNullProperty;

    public SimpleProperty() {
    }

    public SimpleProperty(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public void parse(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public String getPropertyName() {
        return this.property;
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null || prop.length() == 0) {
            throw new IllegalArgumentException(MSG_00001);
        }
        this.property = prop;
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        Class type;
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.property)) != null && (type = propSchema.getType()) != null) {
            return type;
        }
        return this.getPropertyType(obj.getClass());
    }

    public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
        if (this.property == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        Method readMethod = null;
        try {
            readMethod = this.getReadMethod(clazz, false);
        }
        catch (InvocationTargetException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (readMethod != null) {
            return readMethod.getReturnType();
        }
        Method writeMethod = null;
        try {
            writeMethod = this.getWriteMethod(clazz, null, false);
        }
        catch (InvocationTargetException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (writeMethod != null) {
            Object methodObj;
            if (this.setMethodCache.containsKey(clazz) && !((methodObj = this.setMethodCache.get(clazz)) instanceof Method)) {
                return null;
            }
            return writeMethod.getParameterTypes()[0];
        }
        Field field = this.getField(clazz);
        return field.getType();
    }

    private String createGetterName() {
        StringBuffer result = new StringBuffer(this.property);
        int len = result.length();
        if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
            char capital = Character.toUpperCase(result.charAt(0));
            result.deleteCharAt(0).insert(0, capital);
        }
        return result.insert(0, "get").toString();
    }

    private String createSetterName() {
        StringBuffer result = new StringBuffer(this.property);
        int len = result.length();
        if (len != 0 && !Character.isUpperCase(result.charAt(0))) {
            char capital = Character.toUpperCase(result.charAt(0));
            result.deleteCharAt(0).insert(0, capital);
        }
        return result.insert(0, SET_METHOD_PREFIX).toString();
    }

    public boolean isReadable(Object obj) {
        if (obj instanceof Record) {
            Record record = (Record)obj;
            RecordSchema recSchema = record.getRecordSchema();
            if (recSchema != null) {
                PropertySchema propSchema = recSchema.getPropertySchema(this.property);
                if (propSchema != null) {
                    return true;
                }
                Method readMethod = null;
                try {
                    readMethod = this.getReadMethod(record.getClass(), false);
                }
                catch (InvocationTargetException e) {
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
                if (readMethod != null) {
                    return true;
                }
                Field field = null;
                try {
                    field = this.getField(record.getClass(), false);
                }
                catch (NoSuchPropertyException e2) {
                    // empty catch block
                }
                return field != null;
            }
            return this.isReadable(obj.getClass(), true);
        }
        return this.isReadable(obj.getClass());
    }

    public boolean isReadable(Class clazz) {
        return this.isReadable(clazz, false);
    }

    protected boolean isReadable(Class clazz, boolean isRecordObj) {
        if (this.property == null) {
            return false;
        }
        Method readMethod = null;
        try {
            readMethod = this.getReadMethod(clazz, false, isRecordObj);
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (readMethod != null) {
            return true;
        }
        Field field = null;
        try {
            field = this.getField(clazz, false);
        }
        catch (NoSuchPropertyException e2) {
            // empty catch block
        }
        if (field != null) {
            return true;
        }
        return !isRecordObj && Map.class.isAssignableFrom(clazz);
    }

    public boolean isWritable(Object obj) {
        return this.isWritable(obj, (Class)null);
    }

    public boolean isWritable(Object obj, Object value) {
        return this.isWritable(obj, value == null ? null : value.getClass());
    }

    public boolean isWritable(Class clazz) {
        return this.isWritable(clazz, null);
    }

    public boolean isWritable(Object obj, Class clazz) {
        if (this.property == null) {
            return false;
        }
        if (obj instanceof Record) {
            PropertySchema propSchema;
            Record record = (Record)obj;
            RecordSchema recSchema = record.getRecordSchema();
            if (recSchema != null && (propSchema = recSchema.getPropertySchema(this.property)) != null) {
                return propSchema.getType() == null || clazz == null || this.isAssignableFrom(propSchema.getType(), clazz);
            }
            return this.isWritable(obj.getClass(), clazz, true);
        }
        return this.isWritable(obj.getClass(), clazz);
    }

    public boolean isWritable(Class targetClass, Class clazz) {
        return this.isWritable(targetClass, clazz, false);
    }

    protected boolean isWritable(Class targetClass, Class clazz, boolean isRecordObj) {
        if (this.property == null) {
            return false;
        }
        Method writeMethod = null;
        try {
            writeMethod = this.getWriteMethod(targetClass, clazz, false, isRecordObj);
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (writeMethod != null) {
            return true;
        }
        Field field = null;
        try {
            field = this.getField(targetClass, false);
        }
        catch (NoSuchPropertyException e2) {
            // empty catch block
        }
        if (field != null) {
            return !Modifier.isFinal(field.getModifiers()) && (clazz == null || this.isAssignableFrom(field.getType(), clazz));
        }
        return !isRecordObj && Map.class.isAssignableFrom(targetClass);
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        if (obj == null && this.isIgnoreNullProperty) {
            return null;
        }
        if (obj instanceof Record && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.property)) != null) {
            return record.getProperty(this.property);
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        try {
            if (clazz.isArray() && ARRAY_LENGTH_METHOD_NAME.equals(this.property)) {
                return new Integer(Array.getLength(obj));
            }
            readMethod = this.getReadMethod(clazz, false);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (readMethod != null) {
            try {
                if (readMethod.getParameterTypes().length == 0) {
                    return readMethod.invoke(obj, NULL_ARGS);
                }
                return readMethod.invoke(obj, this.property);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
        }
        Field field = this.getField(clazz, false);
        if (field != null) {
            try {
                return field.get(obj);
            }
            catch (IllegalAccessException e2) {
                throw new NoSuchPropertyException(clazz, this.property, e2);
            }
            catch (IllegalArgumentException e2) {
                throw new NoSuchPropertyException(clazz, this.property, e2);
            }
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(this.property);
        }
        throw new NoSuchPropertyException(clazz, this.property);
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        this.setProperty(obj, value == null ? null : value.getClass(), value);
    }

    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        boolean isRecordObj;
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        if (type == null) {
            if (value == null) {
                PropertySchema propSchema2;
                Record record2;
                RecordSchema recSchema2;
                if (obj instanceof Record && (recSchema2 = (record2 = (Record)obj).getRecordSchema()) != null && (propSchema2 = recSchema2.getPropertySchema(this.property)) != null) {
                    type = propSchema2.getType();
                }
            } else {
                type = value.getClass();
            }
        }
        if ((isRecordObj = obj instanceof Record) && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.property)) != null) {
            record.setProperty(this.property, value);
            return;
        }
        try {
            writeMethod = this.getWriteMethod(clazz, type, false, isRecordObj);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (writeMethod != null) {
            try {
                if (writeMethod.getParameterTypes().length == 1) {
                    Class<?> paramType = writeMethod.getParameterTypes()[0];
                    if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                        value = this.castPrimitiveWrapper(paramType, (Number)value);
                    }
                    writeMethod.invoke(obj, value);
                }
                writeMethod.invoke(obj, this.property, value);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
        } else {
            Field field = this.getField(clazz);
            if (!Modifier.isFinal(field.getModifiers())) {
                try {
                    field.set(obj, value);
                    return;
                }
                catch (IllegalAccessException e2) {
                    throw new NoSuchPropertyException(clazz, this.property, e2);
                }
                catch (IllegalArgumentException e2) {
                    throw new NoSuchPropertyException(clazz, this.property, e2);
                }
            }
        }
    }

    public Method getReadMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (obj instanceof Record) {
            PropertySchema propSchema;
            Record record = (Record)obj;
            RecordSchema recSchema = record.getRecordSchema();
            if (recSchema != null && (propSchema = recSchema.getPropertySchema(this.property)) != null) {
                Method readMethod = this.getReadMethod(obj.getClass(), false, true);
                if (readMethod != null) {
                    return readMethod;
                }
                return RECORD_GET_PROPERTY_METHOD;
            }
            return this.getReadMethod(obj.getClass(), true, true);
        }
        return this.getReadMethod(obj.getClass());
    }

    public Method getReadMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        return this.getReadMethod(clazz, true);
    }

    protected Method getReadMethod(Class clazz, boolean isThrow) throws NoSuchPropertyException, InvocationTargetException {
        return this.getReadMethod(clazz, isThrow, false);
    }

    protected Method getReadMethod(Class clazz, boolean isThrow, boolean isRecordObj) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            if (isThrow) {
                throw new NoSuchPropertyException(clazz, this.property);
            }
            return null;
        }
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            if (readMethod == null) {
                if (isThrow) {
                    throw new NoSuchReadablePropertyException(clazz, this.property);
                }
                return null;
            }
        } else {
            if (!SimpleProperty.isAccessableClass(clazz) || Proxy.isProxyClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    try {
                        readMethod = this.getReadMethod(interfaces[i], isThrow);
                        if (readMethod == null) continue;
                        return readMethod;
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.getReadMethod(superClass, isThrow);
                }
                if (isThrow) {
                    throw new NoSuchReadablePropertyException(clazz, this.property);
                }
                return null;
            }
            PropertyDescriptor descriptor = this.getPropertyDescriptor(clazz);
            if (descriptor != null && (readMethod = descriptor.getReadMethod()) != null && readMethod.getParameterTypes().length != 0) {
                readMethod = null;
            }
            if (readMethod == null) {
                try {
                    readMethod = clazz.getMethod(this.createGetterName(), NULL_METHOD_PARAMS);
                    if (Void.TYPE.equals(readMethod.getReturnType())) {
                        readMethod = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (readMethod == null) {
                block28: {
                    try {
                        readMethod = clazz.getMethod(this.property, NULL_METHOD_PARAMS);
                    }
                    catch (NoSuchMethodException e) {
                        if (this.property == null || this.property.length() == 0 || !Character.isUpperCase(this.property.charAt(0))) break block28;
                        StringBuffer methodName = new StringBuffer(this.property);
                        char capital = Character.toLowerCase(methodName.charAt(0));
                        methodName.deleteCharAt(0).insert(0, capital);
                        try {
                            readMethod = clazz.getMethod(methodName.toString(), NULL_METHOD_PARAMS);
                        }
                        catch (NoSuchMethodException e2) {
                            // empty catch block
                        }
                    }
                }
                if (readMethod != null && Void.TYPE.equals(readMethod.getReturnType())) {
                    readMethod = null;
                }
            }
            if (readMethod == null && !isRecordObj && Map.class.isAssignableFrom(clazz)) {
                try {
                    readMethod = Map.class.getMethod("get", MAP_GET_METHOD_ARGS);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (readMethod == null) {
                this.getMethodCache.put(clazz, null);
                if (isThrow) {
                    throw new NoSuchReadablePropertyException(clazz, this.property);
                }
                return null;
            }
            this.getMethodCache.put(clazz, readMethod);
        }
        return readMethod;
    }

    public Field getField(Class clazz) throws NoSuchPropertyException {
        return this.getField(clazz, true);
    }

    protected Field getField(Class clazz, boolean isThrow) throws NoSuchPropertyException {
        Field field;
        block10: {
            field = null;
            if (this.fieldCache.containsKey(clazz)) {
                field = (Field)this.fieldCache.get(clazz);
                if (field == null && isThrow) {
                    throw new NoSuchPropertyException(clazz, this.property);
                }
                return field;
            }
            try {
                field = clazz.getField(this.property);
            }
            catch (NoSuchFieldException e) {
                char firstChar = this.property.charAt(0);
                String otherProperty = null;
                if (Character.isUpperCase(firstChar)) {
                    otherProperty = Character.toLowerCase(firstChar) + this.property.substring(1);
                } else if (Character.isLowerCase(firstChar)) {
                    otherProperty = Character.toUpperCase(firstChar) + this.property.substring(1);
                }
                if (otherProperty == null) break block10;
                try {
                    field = clazz.getField(otherProperty);
                }
                catch (NoSuchFieldException e2) {
                    // empty catch block
                }
            }
        }
        this.fieldCache.put(clazz, field);
        if (field == null && isThrow) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        return field;
    }

    public Method getWriteMethod(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (obj instanceof Record) {
            PropertySchema propSchema;
            Record record = (Record)obj;
            RecordSchema recSchema = record.getRecordSchema();
            if (recSchema != null && (propSchema = recSchema.getPropertySchema(this.property)) != null) {
                Method writeMethod = this.getWriteMethod(obj.getClass(), null, false, true);
                if (writeMethod != null) {
                    return writeMethod;
                }
                return RECORD_SET_PROPERTY_METHOD;
            }
            return this.getWriteMethod(obj.getClass(), null, true, true);
        }
        return this.getWriteMethod(obj.getClass());
    }

    public Method getWriteMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(clazz, null);
    }

    public Method getWriteMethod(Class clazz, Class valClazz) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(clazz, valClazz, true);
    }

    protected Method getWriteMethod(Class clazz, Class valClazz, boolean isThrow) throws NoSuchPropertyException, InvocationTargetException {
        return this.getWriteMethod(clazz, valClazz, isThrow, false);
    }

    protected Method getWriteMethod(Class clazz, Class valClazz, boolean isThrow, boolean isRecordObj) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            if (isThrow) {
                throw new NoSuchWritablePropertyException(clazz, this.property);
            }
            return null;
        }
        if (this.setMethodCache.containsKey(clazz)) {
            Object methodObj = this.setMethodCache.get(clazz);
            if (methodObj instanceof Method) {
                return (Method)methodObj;
            }
            if (valClazz == null) {
                if (isThrow) {
                    throw new NoSuchWritablePropertyException(clazz, this.property, "The method cannot be specified, because the method of the overload exists.");
                }
                return null;
            }
            Map overloadMap = (Map)methodObj;
            if (overloadMap.containsKey(valClazz)) {
                return (Method)overloadMap.get(valClazz);
            }
        }
        if (!SimpleProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method writeMethod = null;
                try {
                    writeMethod = this.getWriteMethod(interfaces[i], valClazz, isThrow);
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
                if (writeMethod == null) continue;
                return writeMethod;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getWriteMethod(superClass, valClazz, isThrow);
            }
            if (isThrow) {
                throw new NoSuchWritablePropertyException(clazz, this.property);
            }
            return null;
        }
        Method writeMethod = null;
        String setterName = this.createSetterName();
        Class primitiveClazz = this.toPrimitive(valClazz);
        String lowerCaseProperty = null;
        if (this.property != null && this.property.length() != 0 && Character.isUpperCase(this.property.charAt(0))) {
            StringBuffer methodName = new StringBuffer(this.property);
            char capital = Character.toLowerCase(methodName.charAt(0));
            methodName.deleteCharAt(0).insert(0, capital);
            lowerCaseProperty = methodName.toString();
        }
        Method[] methods = clazz.getMethods();
        Map<Class<?>, Method> overloadMap = Collections.synchronizedMap(new HashMap());
        boolean isMatch = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != 1 || !setterName.equals(methods[i].getName()) && !this.property.equals(methods[i].getName()) && !methods[i].getName().equals(lowerCaseProperty) || overloadMap.containsKey(paramTypes[0]) && setterName.equals(((Method)overloadMap.get(paramTypes[0])).getName())) continue;
            overloadMap.put(paramTypes[0], methods[i]);
            if (isMatch) continue;
            if (writeMethod == null) {
                if (valClazz == null) {
                    writeMethod = methods[i];
                    continue;
                }
                if (!this.isAssignableFrom(paramTypes[0], valClazz) && !paramTypes[0].equals(primitiveClazz)) continue;
                writeMethod = methods[i];
                if (!valClazz.equals(paramTypes[0]) && !paramTypes[0].equals(primitiveClazz)) continue;
                isMatch = true;
                continue;
            }
            if (valClazz == null || !this.isAssignableFrom(paramTypes[0], valClazz) && !paramTypes[0].equals(primitiveClazz)) continue;
            if (valClazz.equals(paramTypes[0]) || paramTypes[0].equals(primitiveClazz)) {
                writeMethod = methods[i];
                isMatch = true;
                continue;
            }
            if (!this.isAssignableFrom(writeMethod.getParameterTypes()[0], paramTypes[0])) continue;
            writeMethod = methods[i];
        }
        if (writeMethod != null) {
            if (overloadMap.size() > 1) {
                if (valClazz == null) {
                    if (isThrow) {
                        throw new NoSuchWritablePropertyException(clazz, this.property, "The method cannot be specified, because the method of the overload exists.");
                    }
                    return null;
                }
                this.setMethodCache.put(clazz, overloadMap);
            } else {
                this.setMethodCache.put(clazz, writeMethod);
            }
            return writeMethod;
        }
        if (!isRecordObj && Map.class.isAssignableFrom(clazz)) {
            try {
                writeMethod = Map.class.getMethod(MAP_SET_METHOD_NAME, MAP_SET_METHOD_ARGS);
                this.setMethodCache.put(clazz, writeMethod);
                return writeMethod;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (isThrow) {
            throw new NoSuchWritablePropertyException(clazz, this.property);
        }
        return null;
    }

    protected boolean isAssignableFrom(Class thisClass, Class thatClass) {
        if (thatClass == null) {
            return !thisClass.isPrimitive();
        }
        if (this.isNumber(thisClass) && this.isNumber(thatClass)) {
            if (Byte.TYPE.equals(thisClass) || Byte.class.equals(thisClass)) {
                return Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (Short.TYPE.equals(thisClass) || Short.class.equals(thisClass)) {
                return Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (Integer.TYPE.equals(thisClass) || Integer.class.equals(thisClass)) {
                return Integer.TYPE.equals(thatClass) || Integer.class.equals(thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (Long.TYPE.equals(thisClass) || Long.class.equals(thisClass)) {
                return Long.TYPE.equals(thatClass) || Long.class.equals(thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals(thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (BigInteger.class.equals(thisClass)) {
                return BigInteger.class.equals(thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals(thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals(thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (Float.TYPE.equals(thisClass) || Float.class.equals(thisClass)) {
                return Float.TYPE.equals(thatClass) || Float.class.equals(thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals(thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals(thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (Double.TYPE.equals(thisClass) || Double.class.equals(thisClass)) {
                return Double.TYPE.equals(thatClass) || Double.class.equals(thatClass) || Float.TYPE.equals(thatClass) || Float.class.equals(thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals(thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals(thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            if (BigDecimal.class.equals(thisClass)) {
                return BigDecimal.class.equals(thatClass) || Double.TYPE.equals(thatClass) || Double.class.equals(thatClass) || Float.TYPE.equals(thatClass) || Float.class.equals(thatClass) || BigInteger.class.equals(thatClass) || Long.TYPE.equals(thatClass) || Long.class.equals(thatClass) || Integer.TYPE.equals(thatClass) || Integer.class.equals(thatClass) || Short.TYPE.equals(thatClass) || Short.class.equals(thatClass) || Byte.TYPE.equals(thatClass) || Byte.class.equals(thatClass);
            }
            return true;
        }
        return thisClass.isAssignableFrom(thatClass);
    }

    protected boolean isNumber(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
        }
        return Number.class.isAssignableFrom(clazz);
    }

    protected Class toPrimitive(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (Boolean.class.equals(clazz)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(clazz)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(clazz)) {
            return Short.TYPE;
        }
        if (Character.class.equals(clazz)) {
            return Character.TYPE;
        }
        if (Integer.class.equals(clazz)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(clazz)) {
            return Long.TYPE;
        }
        if (Float.class.equals(clazz)) {
            return Float.TYPE;
        }
        if (Double.class.equals(clazz)) {
            return Double.TYPE;
        }
        return null;
    }

    protected Number castPrimitiveWrapper(Class clazz, Number val) {
        if (Byte.class.equals(clazz)) {
            return new Byte(val.byteValue());
        }
        if (Short.class.equals(clazz)) {
            return new Short(val.shortValue());
        }
        if (Integer.class.equals(clazz)) {
            return new Integer(val.intValue());
        }
        if (Long.class.equals(clazz)) {
            return new Long(val.longValue());
        }
        if (BigInteger.class.equals(clazz)) {
            return BigInteger.valueOf(val.longValue());
        }
        if (Float.class.equals(clazz)) {
            return new Float(val.floatValue());
        }
        if (Double.class.equals(clazz)) {
            return new Double(val.doubleValue());
        }
        if (BigDecimal.class.equals(clazz)) {
            if (val instanceof BigInteger) {
                return new BigDecimal((BigInteger)val);
            }
            return new BigDecimal(val.doubleValue());
        }
        return val;
    }

    public static SimpleProperty[] getProperties(Object bean) {
        return SimpleProperty.getProperties(bean.getClass());
    }

    public static SimpleProperty[] getProperties(Class clazz) {
        return SimpleProperty.getProperties(clazz, false);
    }

    public static SimpleProperty[] getProperties(Object bean, boolean containsField) {
        return SimpleProperty.getProperties(bean.getClass(), containsField);
    }

    public static SimpleProperty[] getProperties(Class clazz, boolean containsField) {
        int i;
        Set<FieldSimpleProperty> props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getProperties(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getProperties(interfaces[i], props);
                break;
            }
        }
        if (containsField && !clazz.isInterface()) {
            Field[] fields = clazz.getFields();
            for (i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                props.add(new FieldSimpleProperty(clazz, fields[i]));
            }
        }
        Object[] result = props.toArray(new SimpleProperty[props.size()]);
        Arrays.sort(result);
        return result;
    }

    public static SimpleProperty[] getFieldProperties(Object bean) {
        return SimpleProperty.getFieldProperties(bean.getClass());
    }

    public static SimpleProperty[] getFieldProperties(Class clazz) {
        HashSet<FieldSimpleProperty> props = new HashSet<FieldSimpleProperty>();
        if (!clazz.isInterface()) {
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                props.add(new FieldSimpleProperty(clazz, fields[i]));
            }
        }
        Object[] result = props.toArray(new SimpleProperty[props.size()]);
        Arrays.sort(result);
        return result;
    }

    public static Set getPropertyNames(Object bean) {
        return SimpleProperty.getPropertyNames(bean.getClass());
    }

    public static Set getPropertyNames(Class clazz) {
        return SimpleProperty.getPropertyNames(clazz, false);
    }

    public static Set getPropertyNames(Object bean, boolean containsField) {
        return SimpleProperty.getPropertyNames(bean.getClass(), containsField);
    }

    public static Set getPropertyNames(Class clazz, boolean containsField) {
        int i;
        Set<String> props = new HashSet();
        if (SimpleProperty.isAccessableClass(clazz)) {
            props = SimpleProperty.getPropertyNames(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (i = 0; i < interfaces.length; ++i) {
                if (!SimpleProperty.isAccessableClass(interfaces[i])) continue;
                props = SimpleProperty.getPropertyNames(interfaces[i], props);
                break;
            }
        }
        if (containsField && !clazz.isInterface()) {
            Field[] fields = clazz.getFields();
            for (i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                props.add(fields[i].getName());
            }
        }
        return props;
    }

    public static Set getFieldPropertyNames(Object bean) {
        return SimpleProperty.getFieldPropertyNames(bean.getClass());
    }

    public static Set getFieldPropertyNames(Class clazz) {
        HashSet<String> props = new HashSet<String>();
        if (!clazz.isInterface()) {
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                props.add(fields[i].getName());
            }
        }
        return props;
    }

    private static Set getPropertyNames(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] instanceof IndexedPropertyDescriptor) continue;
            props.add(descriptors[i].getName());
        }
        return props;
    }

    private static Set getProperties(Class clazz, Set props) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return props;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return props;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] instanceof IndexedPropertyDescriptor) continue;
            props.add(new IntrospectSimpleProperty(clazz, descriptors[i]));
        }
        return props;
    }

    protected PropertyDescriptor getPropertyDescriptor(Object obj) {
        return this.getPropertyDescriptor(obj.getClass());
    }

    protected static boolean isAccessableClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isPublic(modifier) || (Modifier.isProtected(modifier) || !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier)) && SimpleProperty.class.getPackage().equals(clazz.getPackage());
    }

    protected PropertyDescriptor getPropertyDescriptor(Class clazz) {
        if (!SimpleProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                PropertyDescriptor pd;
                if (!SimpleProperty.isAccessableClass(interfaces[i]) || (pd = this.getPropertyDescriptor(interfaces[i])) == null) continue;
                return pd;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getPropertyDescriptor(superClass);
            }
            return null;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return null;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            return null;
        }
        String prop = this.property;
        int len = prop.length();
        if (len != 0 && Character.isUpperCase(prop.charAt(0))) {
            prop = len > 1 ? Character.toLowerCase(prop.charAt(0)) + prop.substring(1) : prop.toLowerCase();
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] instanceof IndexedPropertyDescriptor || !prop.equals(descriptors[i].getName()) && !this.property.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        return null;
    }

    public void setIgnoreNullProperty(boolean isIgnore) {
        this.isIgnoreNullProperty = isIgnore;
    }

    public boolean isIgnoreNullProperty() {
        return this.isIgnoreNullProperty;
    }

    public String toString() {
        return "SimpleProperty{" + this.property + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleProperty)) {
            return false;
        }
        SimpleProperty comp = (SimpleProperty)obj;
        if (this.property == null && comp.property == null) {
            return true;
        }
        if (this.property == null) {
            return false;
        }
        return this.property.equals(comp.property);
    }

    public int hashCode() {
        return this.property == null ? 0 : this.property.hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof SimpleProperty)) {
            return 1;
        }
        SimpleProperty comp = (SimpleProperty)obj;
        if (this.property == null && comp.property == null) {
            return 0;
        }
        if (this.property == null) {
            return -1;
        }
        if (comp.property == null) {
            return 1;
        }
        return this.property.compareTo(comp.property);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = Collections.synchronizedMap(new HashMap());
        this.setMethodCache = Collections.synchronizedMap(new HashMap());
        this.fieldCache = Collections.synchronizedMap(new HashMap());
    }

    static {
        try {
            RECORD_GET_PROPERTY_METHOD = Record.class.getMethod("getProperty", String.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            RECORD_SET_PROPERTY_METHOD = Record.class.getMethod("setProperty", String.class, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static class FieldSimpleProperty
    extends SimpleProperty {
        private static final long serialVersionUID = -3886846434853050103L;
        private Class target;
        private Field field;

        public FieldSimpleProperty(Class target, Field field) throws IllegalArgumentException {
            super(field.getName());
            this.target = target;
            this.field = field;
        }

        public Class getPropertyType(Object obj) throws NoSuchPropertyException {
            if (this.target.equals(obj.getClass())) {
                return this.field.getType();
            }
            return super.getPropertyType(obj);
        }

        public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
            if (this.target.equals(clazz)) {
                return this.field.getType();
            }
            return super.getPropertyType(clazz);
        }

        public boolean isReadable(Object obj) {
            if (this.target.equals(obj.getClass())) {
                return true;
            }
            return super.isReadable(obj);
        }

        public boolean isReadable(Class clazz) {
            if (this.target.equals(clazz)) {
                return true;
            }
            return super.isReadable(clazz);
        }

        public boolean isWritable(Object obj, Object value) {
            if (this.target.equals(obj.getClass())) {
                return !Modifier.isFinal(this.field.getModifiers()) && (value == null || this.isAssignableFrom(this.field.getType(), value.getClass()));
            }
            return super.isWritable(obj, value);
        }

        public boolean isWritable(Object obj, Class clazz) {
            if (this.target.equals(obj.getClass())) {
                return !Modifier.isFinal(this.field.getModifiers()) && (clazz == null || this.isAssignableFrom(this.field.getType(), clazz));
            }
            return super.isWritable(obj, clazz);
        }

        public boolean isWritable(Class targetClass, Class clazz) {
            if (this.target.equals(targetClass)) {
                return !Modifier.isFinal(this.field.getModifiers()) && (clazz == null || this.isAssignableFrom(this.field.getType(), clazz));
            }
            return super.isWritable(targetClass, clazz);
        }

        public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
            Class<?> clazz = obj.getClass();
            if (this.target.equals(clazz)) {
                Field field = this.getField(clazz);
                try {
                    return field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(clazz, this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(clazz, this.property, e);
                }
            }
            return super.getProperty(obj);
        }

        public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(obj.getClass())) {
                int modifiers = this.field.getModifiers();
                if (value == null ? Modifier.isFinal(modifiers) : Modifier.isFinal(modifiers) || type != null && !this.isAssignableFrom(this.field.getType(), type) || value != null && !this.isAssignableFrom(this.field.getType(), value.getClass())) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property);
                }
                try {
                    this.field.set(obj, value);
                    return;
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
            }
            super.setProperty(obj, type, value);
        }

        public Method getReadMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(clazz)) {
                throw new NoSuchReadablePropertyException(clazz, this.property);
            }
            return super.getReadMethod(clazz);
        }

        public Method getWriteMethod(Class clazz, Class valClazz) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(clazz)) {
                throw new NoSuchWritablePropertyException(clazz, this.property);
            }
            return super.getWriteMethod(clazz, valClazz);
        }
    }

    private static class IntrospectSimpleProperty
    extends SimpleProperty {
        private static final long serialVersionUID = 883129830207417832L;
        private Class target;
        private Class propertyType;
        private Method readMethod;
        private Method writeMethod;

        public IntrospectSimpleProperty(Class target, PropertyDescriptor desc) throws IllegalArgumentException {
            super(desc.getName());
            this.target = target;
            this.propertyType = desc.getPropertyType();
            this.readMethod = desc.getReadMethod();
            this.writeMethod = desc.getWriteMethod();
        }

        public Class getPropertyType(Object obj) throws NoSuchPropertyException {
            if (this.target.equals(obj.getClass())) {
                return this.propertyType;
            }
            return super.getPropertyType(obj);
        }

        public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
            if (this.target.equals(clazz)) {
                return this.propertyType;
            }
            return super.getPropertyType(clazz);
        }

        public boolean isReadable(Object obj) {
            if (this.target.equals(obj.getClass())) {
                return this.readMethod != null;
            }
            return super.isReadable(obj);
        }

        public boolean isReadable(Class clazz) {
            if (this.target.equals(clazz)) {
                return this.readMethod != null;
            }
            return super.isReadable(clazz);
        }

        public boolean isWritable(Object obj, Object value) {
            if (this.target.equals(obj.getClass())) {
                return this.writeMethod != null && (value == null || this.isAssignableFrom(this.writeMethod.getParameterTypes()[0], value.getClass()));
            }
            return super.isWritable(obj, value);
        }

        public boolean isWritable(Object obj, Class clazz) {
            if (this.target.equals(obj.getClass())) {
                return this.writeMethod != null && (clazz == null || this.isAssignableFrom(this.writeMethod.getParameterTypes()[0], clazz));
            }
            return super.isWritable(obj, clazz);
        }

        public boolean isWritable(Class targetClass, Class clazz) {
            if (this.target.equals(targetClass)) {
                return this.writeMethod != null && (clazz == null || this.isAssignableFrom(this.writeMethod.getParameterTypes()[0], clazz));
            }
            return super.isWritable(targetClass, clazz);
        }

        public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(obj.getClass())) {
                if (this.readMethod == null) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property);
                }
                try {
                    return this.readMethod.invoke(obj, NULL_ARGS);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
            }
            return super.getProperty(obj);
        }

        public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(obj.getClass())) {
                if (this.writeMethod == null) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property);
                }
                try {
                    Class<?> paramType = this.writeMethod.getParameterTypes()[0];
                    if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                        value = this.castPrimitiveWrapper(paramType, (Number)value);
                    }
                    this.writeMethod.invoke(obj, value);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(obj.getClass(), this.property, e);
                }
            }
            super.setProperty(obj, type, value);
        }

        public Method getReadMethod(Class clazz) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(clazz)) {
                return this.readMethod;
            }
            return super.getReadMethod(clazz);
        }

        public Method getWriteMethod(Class clazz, Class valClazz) throws NoSuchPropertyException, InvocationTargetException {
            if (this.target.equals(clazz)) {
                if (this.writeMethod == null) {
                    throw new NoSuchPropertyException(clazz, this.property);
                }
                if (valClazz == null) {
                    return this.writeMethod;
                }
                if (this.isAssignableFrom(this.writeMethod.getParameterTypes()[0], valClazz)) {
                    return this.writeMethod;
                }
                throw new NoSuchPropertyException(clazz, this.property);
            }
            return super.getWriteMethod(clazz, valClazz);
        }
    }
}

